/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.plaf.unify;

import com.huawei.ism.ui.swing.RolloverButton;
import com.huawei.ism.ui.swing.border.ImageBorder;
import com.huawei.ism.ui.swing.control.ToolBarButton;
import com.huawei.ism.ui.swing.plaf.IsmBorders;
import com.huawei.ism.ui.swing.plaf.IsmButtonStyle;
import com.huawei.ism.ui.swing.plaf.IsmPlafUtils;
import com.huawei.ism.ui.swing.table.KeywordFilterField;
import com.huawei.ism.ui.swing.text.IPAddressField;
import com.huawei.ism.ui.swing.text.IsmPasswordField;
import com.huawei.ism.ui.swing.text.IsmTextArea;
import com.huawei.ism.ui.swing.text.IsmTextField;
import com.huawei.ism.util.CommonUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.text.JTextComponent;

public class UnifyBorders {
    private static Border popupMenuBorder;

    public static Border getTableHeaderBorder() {
        return new TableHeaderBorder(null);
    }

    public static Border getTableHeaderBorder(Insets insert) {
        return new TableHeaderBorder(insert);
    }

    public static Border getButtonBorder(boolean isRound) {
        return new BorderUIResource.CompoundBorderUIResource(new ButtonBorder(isRound), new IsmBorders.MarginBorder());
    }

    public static Border getToolBarButtonBorder() {
        return new BorderUIResource.CompoundBorderUIResource(new ButtonBorder(true), new EmptyBorder(2, 2, 2, 2));
    }

    public static Border getScrollPaneBorder() {
        return new ScrollPaneBorder();
    }

    public static Border getComboBoxButtonBorder() {
        return new BorderUIResource.CompoundBorderUIResource(new ComboBoxButtonBorder(), new EmptyBorder(2, 1, 2, 2));
    }

    public static Border getTextComponentBorder() {
        return new BorderUIResource.CompoundBorderUIResource(new TextComponentBorder(), new EmptyBorder(0, 5, 0, 0));
    }

    public static Border getToolTipBorder() {
        return new BorderUIResource.CompoundBorderUIResource(new ToolTipBorder(), new EmptyBorder(0, 5, 2, 0));
    }

    public static Border getTextAreaBorder() {
        return new TextComponentBorder();
    }

    public static Border getIPAddressFieldBorder(Color color) {
        return new IPAddressFieldBorder(color);
    }

    public static Border getComboBoxBorder() {
        return new BorderUIResource.CompoundBorderUIResource(new TextComponentBorder(), new EmptyBorder(0, 1, 0, 0));
    }

    public static Border getPopupMenuBorder() {
        if (popupMenuBorder == null) {
            popupMenuBorder = new BorderUIResource.CompoundBorderUIResource(new ImageBorder(), new PopupMenuBorder());
        }
        return popupMenuBorder;
    }

    public static Border getRolloverButtonBorder(boolean drawArrow) {
        if (drawArrow) {
            return new BorderUIResource.CompoundBorderUIResource(new ButtonBorder(true), new EmptyBorder(0, 7, 0, 15));
        }
        return new BorderUIResource.CompoundBorderUIResource(new ButtonBorder(true), new EmptyBorder(0, 7, 0, 7));
    }

    public static Border getToolBarButtonBorder(boolean isRound) {
        return new BorderUIResource.CompoundBorderUIResource(new ButtonBorder(isRound), new EmptyBorder(0, 2, 0, 2));
    }

    public static Border getToolBarBorder() {
        return new ArmorToolBarBorder();
    }

    public static Border getDialogBorder() {
        return new BorderUIResource(new WindowBorder());
    }

    private static class WindowBorder
    extends AbstractBorder
    implements UIResource {
        private static final long serialVersionUID = -5759662583826912139L;
        private static Insets insets1 = new Insets(1, 1, 1, 1);

        private WindowBorder() {
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int xx, int yy, int width, int height) {
            Color backgroundColor = UIManager.getColor("TitleBar.dialogBorderColor");
            IsmPlafUtils.drawBorderStyle(graphics, backgroundColor, backgroundColor, new Rectangle(xx, yy, width, height), true);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return insets1;
        }

        @Override
        public Insets getBorderInsets(Component c, Insets insets2) {
            insets2.top = WindowBorder.insets1.top;
            insets2.left = WindowBorder.insets1.left;
            insets2.bottom = WindowBorder.insets1.bottom;
            insets2.right = WindowBorder.insets1.right;
            return insets2;
        }
    }

    private static class ArmorToolBarBorder
    extends AbstractBorder
    implements UIResource {
        private static final long serialVersionUID = 8343966141200657215L;

        private ArmorToolBarBorder() {
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return UIManager.getInsets("IsmToolBar.Insets");
        }

        @Override
        public Insets getBorderInsets(Component component, Insets newInsets) {
            Insets inset = this.getBorderInsets(component);
            newInsets.top = inset.top;
            newInsets.left = inset.left;
            newInsets.bottom = inset.bottom;
            newInsets.right = inset.right;
            return newInsets;
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int xx, int yy, int width, int height) {
            if (!(component instanceof JToolBar)) {
                return;
            }
            graphics.setColor(UIManager.getColor("IsmToolBar.TopBorderColor"));
            graphics.fillRect(xx, yy, width, 1);
            graphics.setColor(UIManager.getColor("IsmToolBar.bottomBorderColor"));
            graphics.fillRect(xx + 1, yy + 1, width, 1);
        }
    }

    public static class ScrollPaneBorder
    extends AbstractBorder
    implements UIResource {
        private static final long serialVersionUID = 8717593739747385358L;
        private static final Insets INSETS = new Insets(2, 2, 2, 2);

        @Override
        public void paintBorder(Component component1, Graphics graphics, int xx, int yy, int width, int height) {
            if (component1 instanceof JScrollPane) {
                JScrollPane scrollPane = (JScrollPane)component1;
                Component component = scrollPane.getViewport().getView();
                boolean needDrawBorder = this.drawDefaultBorder(component);
                if (!needDrawBorder) {
                    return;
                }
                if (null != component && component instanceof IsmTextArea && component1.isEnabled()) {
                    IsmTextArea textArea = (IsmTextArea)component;
                    Color color = UIManager.getColor("TextField.normalBorderColor");
                    if (textArea.isEditable() && textArea.hasFocus()) {
                        color = UIManager.getColor("TextField.rdFocusOuterColor");
                    }
                    Color outterColor = IsmPlafUtils.mixAlpha(color, 50);
                    if (textArea.isShowErrorToolTip()) {
                        outterColor = color = UIManager.getColor("TextComponent.errTooltipBorderColor");
                    }
                    IsmPlafUtils.drawBorderStyle(graphics, color, color, new Rectangle(xx + 1, yy + 1, width - 2, height - 2), true);
                    IsmPlafUtils.drawBorderStyle(graphics, outterColor, outterColor, new Rectangle(xx, yy, width, height), true);
                    return;
                }
            }
            Color color = UIManager.getColor("Table.scrollPaneBorderColor");
            IsmPlafUtils.drawBorderStyle(graphics, color, color, new Rectangle(xx + 1, yy + 1, width - 2, height - 2), true);
            Color outterColor = IsmPlafUtils.mixAlpha(Color.BLACK, 15);
            IsmPlafUtils.drawBorderStyle(graphics, outterColor, outterColor, new Rectangle(xx, yy, width, height), true);
        }

        private boolean drawDefaultBorder(Component component) {
            return (component instanceof JTextComponent || component instanceof JTable || component instanceof JList || component instanceof JComboBox) && !(component instanceof JTree);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return INSETS;
        }

        @Override
        public Insets getBorderInsets(Component c, Insets insets) {
            insets.right = insets.bottom = ScrollPaneBorder.INSETS.left;
            insets.top = insets.bottom;
            insets.left = insets.bottom;
            return insets;
        }
    }

    private static class ComboBoxButtonBorder
    extends AbstractBorder
    implements UIResource {
        private static final long serialVersionUID = 1L;
        private static final Insets INSETS = new Insets(2, 2, 2, 2);

        private ComboBoxButtonBorder() {
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int xx, int yy, int width, int height) {
            if (!(component instanceof AbstractButton)) {
                return;
            }
            AbstractButton button = (AbstractButton)component;
            IsmButtonStyle.ButtonState buttonState = IsmPlafUtils.getButtonState(button);
            if (buttonState == IsmButtonStyle.ButtonState.NONE) {
                return;
            }
            Color outterColor = null;
            Color innerColor = null;
            if (buttonState == IsmButtonStyle.ButtonState.DISABLED) {
                outterColor = UIManager.getColor("ComboxButton.outterBorderDisabled");
                innerColor = UIManager.getColor("ComboxButton.innerBorderDisabled");
            } else {
                outterColor = UIManager.getColor("ComboxButton.outterBorderNormal");
                innerColor = UIManager.getColor("ComboxButton.innerBorderNormal");
            }
            IsmPlafUtils.drawBorderStyle(graphics, innerColor, innerColor, new Rectangle(xx + 1, yy + 1, width - 2, height - 2), true);
            IsmPlafUtils.drawBorderStyle(graphics, outterColor, outterColor, new Rectangle(xx, yy, width, height), true);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return INSETS;
        }

        @Override
        public Insets getBorderInsets(Component component, Insets newInsets) {
            Insets insets = this.getBorderInsets(component);
            newInsets.top = insets.top;
            newInsets.left = insets.left;
            newInsets.bottom = insets.bottom;
            newInsets.right = insets.right;
            return newInsets;
        }
    }

    private static class PopupMenuBorder
    extends AbstractBorder
    implements UIResource {
        private static final long serialVersionUID = -1836877694853581803L;
        private static final Insets INSETS = new Insets(1, 1, 1, 1);

        private PopupMenuBorder() {
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int xx, int yy, int width, int height) {
            if (!(component instanceof JPopupMenu)) {
                return;
            }
            IsmPlafUtils.drawBorderStyle(graphics, Color.WHITE, Color.WHITE, new Rectangle(xx, yy, width, height), true);
        }

        @Override
        public Insets getBorderInsets(Component x) {
            return INSETS;
        }

        @Override
        public Insets getBorderInsets(Component component, Insets newInsets) {
            Insets borderInsets = this.getBorderInsets(component);
            newInsets.top = borderInsets.top;
            newInsets.left = borderInsets.left;
            newInsets.bottom = borderInsets.bottom;
            newInsets.right = borderInsets.right;
            return newInsets;
        }
    }

    private static class TextComponentBorder
    extends AbstractBorder
    implements UIResource {
        private static final long serialVersionUID = 1L;
        private static final Insets INSETS = new Insets(2, 2, 2, 2);
        private static final Insets TEXT_AREA_INSET = new Insets(1, 5, 0, 1);
        private static final Insets SCROLLPANE_TEXT_AREA_INSET = new Insets(1, 1, 1, 1);

        private TextComponentBorder() {
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int xx, int yy, int width, int height) {
            if (component instanceof JTextArea) {
                return;
            }
            Color color = UIManager.getColor("TextField.disabledBorderColor");
            if (component.isEnabled()) {
                KeywordFilterField textField;
                color = UIManager.getColor("TextField.normalBorderColor");
                if (component instanceof JTextComponent) {
                    JTextComponent textComponent = CommonUtil.convertObject(component, JTextComponent.class);
                    if (textComponent.isEditable() && textComponent.isFocusOwner()) {
                        color = UIManager.getColor("TextField.rdFocusOuterColor");
                    }
                } else if (component instanceof KeywordFilterField && (textField = CommonUtil.convertObject(component, KeywordFilterField.class)).isFocusOwner()) {
                    color = UIManager.getColor("TextField.rdFocusOuterColor");
                }
            }
            this.paintBoldBorder(component, graphics, color, xx, yy, width, height);
        }

        private void paintBoldBorder(Component component, Graphics graphics, Color color, int xx, int yy, int width, int height) {
            JTextField textField;
            Color actualColor = color;
            if (component instanceof IsmTextField && ((IsmTextField)(textField = (IsmTextField)component)).isShowErrorToolTip() && textField.isEnabled()) {
                actualColor = UIManager.getColor("TextComponent.errTooltipBorderColor");
                IsmPlafUtils.drawBorderStyle(graphics, actualColor, actualColor, new Rectangle(xx + 1, yy + 1, width - 2, height - 2), true);
            }
            if (component instanceof IsmPasswordField && ((IsmPasswordField)(textField = (IsmPasswordField)component)).isShowErrorToolTip() && textField.isEnabled()) {
                actualColor = UIManager.getColor("TextComponent.errTooltipBorderColor");
                IsmPlafUtils.drawBorderStyle(graphics, actualColor, actualColor, new Rectangle(xx + 1, yy + 1, width - 2, height - 2), true);
            }
            IsmPlafUtils.drawBorderStyle(graphics, actualColor, actualColor, new Rectangle(xx, yy, width, height), true);
        }

        @Override
        public Insets getBorderInsets(Component component) {
            if (component instanceof JTextArea) {
                Container parent = SwingUtilities.getAncestorOfClass(JScrollPane.class, component);
                if (null != parent) {
                    return TEXT_AREA_INSET;
                }
                return SCROLLPANE_TEXT_AREA_INSET;
            }
            return INSETS;
        }

        @Override
        public Insets getBorderInsets(Component component, Insets newInsets) {
            Insets insets = this.getBorderInsets(component);
            newInsets.top = insets.top;
            newInsets.left = insets.left;
            newInsets.bottom = insets.bottom;
            newInsets.right = insets.right;
            return newInsets;
        }
    }

    private static class IPAddressFieldBorder
    extends TextComponentBorder {
        private static final long serialVersionUID = 4795205136794383280L;
        private Color fixColor = null;

        public IPAddressFieldBorder(Color fixColor) {
            this.fixColor = fixColor;
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int xx, int yy, int wdith, int htight) {
            this.paintBoldBorder(component, graphics, this.fixColor, xx, yy, wdith, htight);
        }

        private void paintBoldBorder(Component component, Graphics graphics, Color color, int xx, int yy, int width, int height) {
            IPAddressField textField;
            Color actualColor = color;
            if (component instanceof IPAddressField && (textField = (IPAddressField)component).isShowErrorToolTip() && textField.isEnabled()) {
                actualColor = UIManager.getColor("TextComponent.errTooltipBorderColor");
                IsmPlafUtils.drawBorderStyle(graphics, actualColor, actualColor, new Rectangle(xx + 1, yy + 1, width - 2, height - 2), true);
            }
            IsmPlafUtils.drawBorderStyle(graphics, actualColor, actualColor, new Rectangle(xx, yy, width, height), true);
        }
    }

    private static class ToolTipBorder
    extends AbstractBorder
    implements UIResource {
        private static final long serialVersionUID = 1L;
        private static final Insets INSETS = new Insets(2, 2, 2, 2);

        private ToolTipBorder() {
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int xaixs, int yaxis, int width, int height) {
            Color color = UIManager.getColor("TextField.disabledBorderColor");
            IsmPlafUtils.drawBorderStyle(graphics, color, color, new Rectangle(xaixs, yaxis, width, height), true);
        }

        @Override
        public Insets getBorderInsets(Component jc) {
            return INSETS;
        }

        @Override
        public Insets getBorderInsets(Component jc, Insets newInsets) {
            Insets insets = this.getBorderInsets(jc);
            newInsets.top = insets.top;
            newInsets.left = insets.left;
            newInsets.bottom = insets.bottom;
            newInsets.right = insets.right;
            return newInsets;
        }
    }

    private static class ButtonBorder
    extends AbstractBorder
    implements UIResource {
        private static final long serialVersionUID = 1L;
        private static final Insets TOOLBAR_BUTTON_INSETS = new Insets(1, 1, 1, 1);
        private static final Insets BUTTON_INSETS = new Insets(0, 3, 0, 3);
        private boolean isRound;

        public ButtonBorder(boolean isRound) {
            this.isRound = isRound;
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int xaxis, int yaxis, int width, int height) {
            if (!(component instanceof AbstractButton)) {
                return;
            }
            AbstractButton button = (AbstractButton)component;
            IsmButtonStyle.ButtonState buttonState = IsmPlafUtils.getButtonState(button);
            if (button instanceof RolloverButton) {
                buttonState = IsmPlafUtils.getRolloverButtonState(button);
            }
            if (buttonState == IsmButtonStyle.ButtonState.NONE) {
                return;
            }
            Color color = null;
            Color outterColor = IsmPlafUtils.mixAlpha(Color.BLACK, 15);
            if (buttonState == IsmButtonStyle.ButtonState.DEFAULT || buttonState == IsmButtonStyle.ButtonState.PRESSED) {
                color = UIManager.getColor("IsmButton.defaultBorderColor");
                outterColor = IsmPlafUtils.mixAlpha(UIManager.getColor("IsmButton.defaultBorderColor"), 200);
            } else {
                color = buttonState == IsmButtonStyle.ButtonState.DISABLED ? UIManager.getColor("IsmButton.disabledBorderColor") : (buttonState == IsmButtonStyle.ButtonState.ROLLOVER ? UIManager.getColor("IsmButton.defaultBorderColor") : UIManager.getColor("IsmButton.normalBorderColor"));
            }
            IsmPlafUtils.drawBorderStyle(graphics, color, color, new Rectangle(xaxis + 1, yaxis + 1, width - 2, height - 2), this.isRound);
            IsmPlafUtils.drawBorderStyle(graphics, outterColor, outterColor, new Rectangle(xaxis, yaxis, width, height), this.isRound);
        }

        @Override
        public Insets getBorderInsets(Component component) {
            if (component instanceof ToolBarButton) {
                return TOOLBAR_BUTTON_INSETS;
            }
            return BUTTON_INSETS;
        }

        @Override
        public Insets getBorderInsets(Component component, Insets newInsets) {
            Insets insets = this.getBorderInsets(component);
            newInsets.top = insets.top;
            newInsets.left = insets.left;
            newInsets.bottom = insets.bottom;
            newInsets.right = insets.right;
            return newInsets;
        }
    }

    private static class TableHeaderBorder
    extends AbstractBorder {
        private static final Color SEPARATOR_LEFT_UP_START_COLOR = new Color(0xE7E7E9);
        private static final Color SEPARATOR_LEFT_BOTTOM_END_COLOR = new Color(0xE8E8E8);
        private static final Color SEPARATOR_RIGHT_UP_START_COLOR = new Color(0xE7E7E9);
        private static final Color SEPARATOR_RIGHT_BOTTOM_END_COLOR = new Color(0x97999B);
        private static final Color BOTTOM_HIGHTLIGHT = new Color(0xFFFFFF);
        private static final Color UP_HIGHLIGHT = new Color(0xF5F5F6);
        private static final long serialVersionUID = 1L;
        private Insets tableCellBorder;

        public TableHeaderBorder(Insets insert) {
            this.tableCellBorder = null != insert ? insert : new Insets(1, 6, 1, 6);
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int xAxis, int yaxis, int width, int height) {
            graphics.translate(xAxis, yaxis);
            graphics.setColor(UP_HIGHLIGHT);
            graphics.drawLine(0, 0, width - 1, 0);
            graphics.setColor(BOTTOM_HIGHTLIGHT);
            graphics.drawLine(0, height - 1, width - 1, height - 1);
            Graphics2D g2d = CommonUtil.convertObject(graphics, Graphics2D.class);
            g2d.setPaint(new GradientPaint(width - 2, 1.0f, SEPARATOR_LEFT_UP_START_COLOR, width - 2, height - 3, SEPARATOR_LEFT_BOTTOM_END_COLOR, false));
            g2d.drawLine(width - 2, 1, width - 2, height - 3);
            g2d.setPaint(new GradientPaint(width - 1, 1.0f, SEPARATOR_RIGHT_UP_START_COLOR, width - 1, height - 3, SEPARATOR_RIGHT_BOTTOM_END_COLOR, false));
            g2d.drawLine(width - 1, 1, width - 1, height - 3);
            graphics.translate(-xAxis, -yaxis);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return this.tableCellBorder;
        }

        @Override
        public Insets getBorderInsets(Component c, Insets insets) {
            insets.left = this.tableCellBorder.left;
            insets.top = this.tableCellBorder.top;
            insets.right = this.tableCellBorder.right;
            insets.bottom = this.tableCellBorder.bottom;
            return insets;
        }
    }
}

