/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.table;

import com.huawei.ism.ui.swing.plaf.IsmPlafUtils;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.IsmTableCell;
import com.huawei.ism.util.UCD;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableCellRenderer;

public class IsmTableCellRenderer
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = 1L;
    private static Border inserts = new EmptyBorder(0, 4, 0, 4);
    private boolean rollover = false;
    private String tipText = null;

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        int alignment;
        JComponent comp = (JComponent)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (!(table instanceof IsmTable)) {
            this.setTooltipText(table, column);
            return comp;
        }
        IsmTable ismTable = (IsmTable)table;
        this.setBackGround(ismTable, isSelected, row, comp);
        this.setTooltipText(table, column);
        if (value instanceof IsmTableCell.TextCell && (alignment = ((IsmTableCell.TextCell)value).getHorizontalAlignment()) >= 0) {
            ((JLabel)comp).setHorizontalAlignment(alignment);
        }
        return comp;
    }

    protected void setBackGround(JTable table, boolean isSelected, int row, JComponent comp) {
        if (!(table instanceof IsmTable)) {
            return;
        }
        IsmTable ismTable = (IsmTable)table;
        comp.setBorder(inserts);
        if (!isSelected) {
            this.setRollover(ismTable.getCurRolloverRow() == row);
            if (!ismTable.isEnabled()) {
                comp.setBackground(UIManager.getColor("Table.disabledBackgound"));
            } else if (this.rollover) {
                comp.setBackground(UIManager.getColor("Table.rolloverColor"));
                if (IsmPlafUtils.isUnifyStyle()) {
                    comp.setBackground(null);
                }
            } else if (row % 2 != 0) {
                comp.setBackground(UIManager.getColor("Table.alternateRowColor"));
            } else {
                comp.setBackground(UIManager.getColor("Table.backgound"));
            }
        }
    }

    protected void setTooltipText(JTable table, int column) {
        int availableWidth = this.getAvailableWidth(table, column);
        String cellText = this.tipText == null ? this.getText() : this.tipText;
        FontMetrics fm = this.getFontMetrics(this.getFont());
        if (null == cellText) {
            this.setToolTipText(null);
            return;
        }
        if (fm.stringWidth(cellText) > availableWidth) {
            this.setToolTipText(UCD.wrapTextWithHTML(fm, cellText, 300));
        } else {
            this.setToolTipText(null);
        }
    }

    protected int getAvailableWidth(JTable table, int column) {
        int availableWidth = table.getColumnModel().getColumn(column).getWidth();
        availableWidth = (int)((double)availableWidth - table.getIntercellSpacing().getWidth());
        Insets borderInsets = this.getBorder().getBorderInsets(this);
        return availableWidth -= borderInsets.left + borderInsets.right;
    }

    public boolean isRollover() {
        return this.rollover;
    }

    public void setRollover(boolean rollover) {
        this.rollover = rollover;
    }

    @Override
    public void paint(Graphics graphics) {
        if (IsmPlafUtils.isUnifyStyle() && this.rollover) {
            IsmPlafUtils.drawGradient((Component)this, graphics, "Table.rolloverGradient", new Rectangle(0, 0, this.getWidth(), this.getHeight()), true);
        }
        super.paint(graphics);
    }

    public String getTipText() {
        return this.tipText;
    }

    public void setTipText(String tipText) {
        this.tipText = tipText;
    }
}

