/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.table;

import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.ui.swing.table.IndexTableModel;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.TableCornerButton;
import com.huawei.ism.ui.swing.table.TernaryCheckBoxRender;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.RowSorter;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.RowSorterEvent;
import javax.swing.event.RowSorterListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class IsmTableScrollPane
extends JScrollPane {
    private static final long serialVersionUID = 1137156933314189987L;
    private static final int CHECKBOX_WIDTH = 22;
    private static final int INDEX_COL_WIDTH = 38;
    private JTable indexTable;
    private IndexTableModel indexTableModel = null;
    private TernaryCheckBoxRender headerCheckBox;
    private IsmTable ismTable;
    private boolean multiSelection = false;
    private JButton cornerButton;

    public IsmTableScrollPane(IsmTable table, boolean multiSelection) {
        super(table);
        this.multiSelection = multiSelection;
        this.ismTable = table;
        this.cornerButton = new TableCornerButton(this.ismTable);
        this.setVerticalScrollBarPolicy(22);
        this.setCorner("UPPER_RIGHT_CORNER", this.cornerButton);
        this.initMultiSelection();
    }

    public boolean isMultiSelection() {
        return this.multiSelection;
    }

    public void setMultiSelection(boolean multiSelection) {
        this.multiSelection = multiSelection;
    }

    public void initMultiSelection() {
        if (!this.multiSelection) {
            return;
        }
        this.indexTableModel = new IndexTableModel(this.ismTable);
        this.ismTable.setSelectionMode(2);
        this.indexTable = new IsmTable((TableModel)this.indexTableModel, true);
        this.indexTable.setRowSelectionAllowed(false);
        this.indexTable.setCellSelectionEnabled(false);
        this.indexTable.setColumnSelectionAllowed(false);
        this.indexTable.setFocusable(false);
        this.indexTable.setAutoscrolls(false);
        int rowHeight = UIManager.getInt("IsmTable.rowHeight");
        this.setRowHeaderView(this.indexTable);
        this.getRowHeader().setPreferredSize(new Dimension(38, rowHeight));
        this.getRowHeader().setPreferredSize(new Dimension(22, UIManager.getInt("IsmTableHeader.rowHeight")));
        this.headerCheckBox = new TernaryCheckBoxRender();
        this.headerCheckBox.setName("_TernaryCheckBoxRender_headerCheckBox");
        this.setCorner("UPPER_LEFT_CORNER", this.headerCheckBox);
        this.addHandler();
        this.updateIndexTable();
    }

    public void disableTableExceptColumns(int[] exceptColumns) {
        if (null != this.headerCheckBox) {
            this.headerCheckBox.setEnabled(false);
        }
        ApplicationContext.getInstance().setEdit(false);
        if (null != this.headerCheckBox) {
            this.headerCheckBox.addMouseListener(new EptMouseAdapter());
        }
        this.setEnabled(false);
        for (int columnIndex : exceptColumns) {
            this.ismTable.setEditingColumn(columnIndex);
        }
        this.ismTable.setEnabled(false);
        if (null != this.headerCheckBox) {
            this.headerCheckBox.setStateEnabled(TernaryCheckBoxRender.State.DISABLED_UNSELECTED);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.ismTable.setEnabled(enabled);
        this.cornerButton.setEnabled(enabled);
        if (this.multiSelection) {
            this.headerCheckBox.setEnabled(enabled);
            this.indexTable.setEnabled(enabled);
        }
    }

    public void updateIndexTable() {
        this.indexTableModel.fireTableStructureChanged();
        int rowCount = this.ismTable.getRowCount();
        int selRowCount = this.ismTable.getSelectedRowCount();
        if (0 == selRowCount) {
            this.headerCheckBox.setStateEnabled(TernaryCheckBoxRender.State.UNSELECTED);
        } else if (selRowCount < rowCount) {
            this.headerCheckBox.setStateEnabled(TernaryCheckBoxRender.State.PARTIAL_SELECTED);
        } else {
            this.headerCheckBox.setStateEnabled(TernaryCheckBoxRender.State.SELECTED);
        }
    }

    private void addHandler() {
        this.headerCheckBoxListener();
        ListSelectionModel selectionModel = this.ismTable.getSelectionModel();
        this.selectionListener(selectionModel);
        this.indexTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (!IsmTableScrollPane.this.indexTable.isEnabled()) {
                    return;
                }
                int curRow = IsmTableScrollPane.this.indexTable.rowAtPoint(mouseEvent.getPoint());
                if (curRow >= 0) {
                    boolean preSelState = IsmTableScrollPane.this.ismTable.isRowSelected(curRow);
                    if (preSelState) {
                        IsmTableScrollPane.this.ismTable.getSelectionModel().removeSelectionInterval(curRow, curRow);
                    } else {
                        IsmTableScrollPane.this.ismTable.getSelectionModel().addSelectionInterval(curRow, curRow);
                    }
                }
            }
        });
    }

    private void selectionListener(ListSelectionModel selectionModel) {
        selectionModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                IsmTableScrollPane.this.updateIndexTable();
            }
        });
        TableModel tableModel = this.ismTable.getModel();
        tableModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                IsmTableScrollPane.this.updateIndexTable();
            }
        });
        RowSorter<? extends TableModel> sorter = this.ismTable.getRowSorter();
        if (null != sorter) {
            sorter.addRowSorterListener(new RowSorterListener(){

                @Override
                public void sorterChanged(RowSorterEvent e) {
                    IsmTableScrollPane.this.updateIndexTable();
                }
            });
        }
    }

    private void headerCheckBoxListener() {
        this.headerCheckBox.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int selRowCount;
                IsmTableScrollPane.this.headerCheckBox.setRecovered(false);
                if (!IsmTableScrollPane.this.headerCheckBox.isEnabled()) {
                    return;
                }
                int rowCount = IsmTableScrollPane.this.ismTable.getRowCount();
                if (rowCount == (selRowCount = IsmTableScrollPane.this.ismTable.getSelectedRowCount())) {
                    IsmTableScrollPane.this.headerCheckBox.setStateEnabled(TernaryCheckBoxRender.State.UNSELECTED);
                    IsmTableScrollPane.this.ismTable.clearSelection();
                } else {
                    IsmTableScrollPane.this.headerCheckBox.setStateEnabled(TernaryCheckBoxRender.State.SELECTED);
                    IsmTableScrollPane.this.ismTable.selectAll();
                }
                IsmTableScrollPane.this.headerCheckBox.repaint();
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                if (IsmTableScrollPane.this.headerCheckBox.isEnabled()) {
                    IsmTableScrollPane.this.headerCheckBox.setRecovered(true);
                    IsmTableScrollPane.this.headerCheckBox.repaint();
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                IsmTableScrollPane.this.headerCheckBox.setRecovered(false);
                IsmTableScrollPane.this.headerCheckBox.repaint();
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (IsmTableScrollPane.this.headerCheckBox.isEnabled() && IsmTableScrollPane.this.headerCheckBox.contains(mouseEvent.getPoint())) {
                    IsmTableScrollPane.this.headerCheckBox.setRecovered(true);
                    IsmTableScrollPane.this.headerCheckBox.repaint();
                }
            }
        });
    }

    public IsmTable getIsmTable() {
        return this.ismTable;
    }

    private static final class EptMouseAdapter
    extends MouseAdapter {
        private EptMouseAdapter() {
        }
    }
}

