/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.table;

import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.ui.swing.table.IsmAbstractTableModel;
import com.huawei.ism.ui.swing.table.MultiFilterIsmTable;
import com.huawei.ism.ui.swing.table.TableCountPane;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.util.UCD;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.ListSelectionModel;
import javax.swing.RowSorter;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.RowSorterEvent;
import javax.swing.event.RowSorterListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class MultiFilterTableCountPane
extends TableCountPane {
    private JLabel totalCountLabel = new JLabel(ResourceManager.getString("ITEMS"));
    private JLabel totalCount = new JLabel("0");
    private JLabel totalSelectLabel = new JLabel(ResourceManager.getString("SELECTED"));
    private JLabel totalSelectCount = new JLabel("0");
    private JLabel curTotalCountLabel = new JLabel(ResourceManager.getString("CUR_ITEMS"));
    private JLabel curTotalCount = new JLabel("0");
    private JLabel curSelectLabel = new JLabel(ResourceManager.getString("CUR_SELECTED"));
    private JLabel curSelectCount = new JLabel("0");
    private boolean isChangingTable = false;
    private boolean isSorterChanged = false;

    public MultiFilterTableCountPane(MultiFilterIsmTable table) {
        this.setIsmTable(table);
        this.doLayoutUI();
        this.addHandler();
        this.updateRowCount();
    }

    private void doLayoutUI() {
        this.setLayout(new BoxLayout(this, 0));
        this.setOpaque(false);
        this.add(Box.createHorizontalStrut(8));
        this.add(this.totalCountLabel);
        this.add(Box.createHorizontalStrut(5));
        this.add(this.totalCount);
        this.add(this.totalSelectLabel);
        this.add(Box.createHorizontalStrut(5));
        this.add(this.totalSelectCount);
        this.add(this.curTotalCountLabel);
        this.add(Box.createHorizontalStrut(5));
        this.add(this.curTotalCount);
        this.add(this.curSelectLabel);
        this.add(Box.createHorizontalStrut(5));
        this.add(this.curSelectCount);
        this.add(Box.createHorizontalStrut(8));
        UCD.setJComponentSize(this.totalCount, 50, 25);
        UCD.setJComponentSize(this.totalSelectCount, 50, 25);
        UCD.setJComponentSize(this.curTotalCount, 50, 25);
        UCD.setJComponentSize(this.curSelectCount, 50, 25);
    }

    private void updateRowCount() {
        MultiFilterIsmTable ismTable = (MultiFilterIsmTable)this.getIsmTable();
        int rowCount = ismTable.getRowCount();
        int selRowCount = ismTable.getSelectedRowCount();
        this.curTotalCount.setText("" + rowCount);
        this.curSelectCount.setText("" + selRowCount);
        this.totalCount.setText("" + ismTable.getModel().getRowCount());
        this.totalSelectCount.setText("" + ismTable.getTotalSelectedRows().size());
    }

    private void updateTotalSelRows() {
        int[] unSelRows;
        int[] rows;
        MultiFilterIsmTable ismTable = (MultiFilterIsmTable)this.getIsmTable();
        for (int row : rows = ismTable.getSelectedRows()) {
            int modelRowIndexTmp = ismTable.convertRowIndexToModel(row);
            boolean exist = false;
            for (int modelRowIndex : ismTable.getTotalSelectedRows()) {
                if (modelRowIndex != modelRowIndexTmp) continue;
                exist = true;
                break;
            }
            if (exist) continue;
            ismTable.getTotalSelectedRows().add(modelRowIndexTmp);
        }
        for (int viewRowIndex : unSelRows = ismTable.getUnSelectedRows()) {
            int modelRowIndexTmp = ismTable.convertRowIndexToModel(viewRowIndex);
            ismTable.getTotalSelectedRows().remove(modelRowIndexTmp);
        }
    }

    public void addHandler() {
        MultiFilterIsmTable ismTable = (MultiFilterIsmTable)this.getIsmTable();
        ListSelectionModel selectionModel = ismTable.getSelectionModel();
        selectionModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                if (!MultiFilterTableCountPane.this.isChangingTable) {
                    MultiFilterTableCountPane.this.updateTotalSelRows();
                }
                MultiFilterTableCountPane.this.updateRowCount();
                if (MultiFilterTableCountPane.this.isSorterChanged) {
                    MultiFilterTableCountPane.this.isSorterChanged = false;
                }
            }
        });
        TableModel tableModel = ismTable.getModel();
        tableModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent event) {
                MultiFilterTableCountPane.this.updateRowCount();
            }
        });
        RowSorter<? extends TableModel> sorter = ismTable.getRowSorter();
        if (null != sorter) {
            sorter.addRowSorterListener(new RowSorterListener(){

                @Override
                public void sorterChanged(RowSorterEvent rowSorterEvent) {
                    if (rowSorterEvent.getType() == RowSorterEvent.Type.SORT_ORDER_CHANGED) {
                        MultiFilterTableCountPane.this.isSorterChanged = true;
                        MultiFilterTableCountPane.this.isChangingTable = false;
                    } else if (!MultiFilterTableCountPane.this.isSorterChanged) {
                        MultiFilterTableCountPane.this.isChangingTable = true;
                    }
                    MultiFilterTableCountPane.this.updateRowCount();
                }
            });
        }
    }

    public void remarkSelRows() {
        MultiFilterIsmTable ismTable = null;
        if (this.getIsmTable() instanceof MultiFilterIsmTable) {
            ismTable = (MultiFilterIsmTable)this.getIsmTable();
        }
        TableModel model = this.getIsmTable().getModel();
        IsmAbstractTableModel tableModel = null;
        if (model instanceof IsmAbstractTableModel) {
            tableModel = (IsmAbstractTableModel)model;
        }
        if (ismTable == null || tableModel == null) {
            return;
        }
        List<TableRow> allViewRows = ismTable.getAllRows();
        for (TableRow row : allViewRows) {
            int rowIndex = tableModel.getRowIndex(row.getIdentifier());
            int rowViewIndex = ismTable.convertRowIndexToView(rowIndex);
            if (!ismTable.getTotalSelectedRows().contains(rowIndex) || rowViewIndex == -1) continue;
            ismTable.markTableRow(row);
        }
    }

    public void setChangeTableEnd() {
        this.isChangingTable = false;
        this.isSorterChanged = false;
    }
}

