/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.tree;

import com.huawei.ism.ui.swing.tree.IsmTreeNode;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IsmTreeModel
extends DefaultTreeModel {
    private static final Logger LOGGER = LoggerFactory.getLogger(IsmTreeModel.class);
    private static final long serialVersionUID = 5105880707525907150L;
    private boolean supportMultiTopNode;

    public IsmTreeModel(boolean supportMultiTopNode) {
        super(null);
        if (supportMultiTopNode) {
            this.supportMultiTopNode = supportMultiTopNode;
            super.setRoot(new IsmTreeNode(null));
        }
    }

    public void deleteTreeNode(IsmTreeNode deletedNode) {
        if (deletedNode == null) {
            return;
        }
        IsmTreeNode parentNode = deletedNode.getParentNode();
        if (null != parentNode) {
            int index;
            block4: {
                index = parentNode.getIndex(deletedNode);
                try {
                    parentNode.remove(deletedNode);
                }
                catch (Exception e) {
                    if (!LOGGER.isErrorEnabled()) break block4;
                    LOGGER.error("remove node error! parentNode=" + parentNode + "\ndeletedNode=" + deletedNode);
                }
            }
            this.nodesWereRemoved(parentNode, new int[]{index}, new Object[]{deletedNode});
        }
    }

    public IsmTreeNode findTreeNode(Object userObject) {
        return this.findNodeByUserObject(this.getRootNode(), userObject);
    }

    private IsmTreeNode findNodeByUserObject(IsmTreeNode from, Object userObject) {
        if (userObject.equals(from.getUserObject())) {
            return from;
        }
        int nCount = from.getChildCount();
        IsmTreeNode treeNode = null;
        IsmTreeNode findNode = null;
        for (int i = 0; i < nCount; ++i) {
            treeNode = (IsmTreeNode)from.getChildAt(i);
            findNode = this.findNodeByUserObject(treeNode, userObject);
            if (null == findNode) continue;
            return findNode;
        }
        return null;
    }

    public void addTopNode(IsmTreeNode topNode) {
        if (this.supportMultiTopNode) {
            IsmTreeNode rootTreeNode = this.getRootNode();
            if (null == rootTreeNode) {
                rootTreeNode = new IsmTreeNode(null);
                this.setRoot(rootTreeNode);
            }
            this.addTreeNode(rootTreeNode, topNode);
        } else {
            this.setRoot(topNode);
        }
    }

    public void addTreeNode(IsmTreeNode parent, IsmTreeNode child) {
        this.addTreeNode(parent, child, parent.getChildCount());
    }

    public void addTreeNode(IsmTreeNode parent, IsmTreeNode child, int index) {
        if (null == parent || null == child) {
            return;
        }
        int count = parent.getChildCount();
        if (index > 0 && index < count) {
            parent.insert(child, index);
        } else {
            parent.add(child);
        }
        this.nodesWereInserted(parent, new int[]{parent.getIndex(child)});
    }

    public TreePath getTreePath(IsmTreeNode treeNode) {
        Object[] nodes = this.getPathToRoot(treeNode);
        if (null != nodes && nodes.length > 0) {
            return new TreePath(nodes);
        }
        return null;
    }

    public List<IsmTreeNode> getTopNodes() {
        ArrayList<IsmTreeNode> result = new ArrayList<IsmTreeNode>(this.getRootNode().getChildCount());
        Enumeration<TreeNode> enume = this.getRootNode().children();
        while (enume.hasMoreElements()) {
            result.add((IsmTreeNode)enume.nextElement());
        }
        return result;
    }

    public IsmTreeNode getRootNode() {
        return (IsmTreeNode)this.getRoot();
    }
}

