/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.templets;

import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.ui.swing.PropertyPane;
import com.huawei.ism.ui.swing.plaf.IsmPlafUtils;
import com.huawei.ism.ui.swing.text.IsmTextArea;
import com.huawei.ism.ui.widgets.action.BaseAction;
import com.huawei.ism.util.SwingUtil;
import com.huawei.ism.util.UCD;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.ToolTipManager;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigAssistantPane
extends PropertyPane {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigAssistantPane.class);
    private static final long serialVersionUID = -6750839513877266673L;
    private int itemsInRow = 2;
    private String deviceIDFor;

    public ConfigAssistantPane(String deviceID) {
        this(deviceID, 2);
    }

    public ConfigAssistantPane(String deviceID, int itemsInRow) {
        this(deviceID, itemsInRow, false);
    }

    public ConfigAssistantPane(String deviceID, int itemsInRow, boolean newLayout) {
        this.itemsInRow = itemsInRow;
        this.deviceIDFor = deviceID;
        if (newLayout) {
            this.layoutNewUI();
        } else {
            this.layoutUI();
        }
        SwingUtil.setName(this);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (IsmPlafUtils.getLAFStyle() == IsmPlafUtils.LAFStyle.blue) {
            this.setBorder(new EmptyBorder(-1, -1, -1, -1));
        }
    }

    private void layoutNewUI() {
        JComponent[] coms = this.initComponents(true);
        Box wholeBox = Box.createVerticalBox();
        JPanel rowPane = null;
        int tag = 0;
        for (int i = 0; i < coms.length; ++i) {
            if (i % this.itemsInRow == 0) {
                rowPane = new JPanel(new GridLayout(0, this.itemsInRow));
                rowPane.setOpaque(false);
            }
            ++tag;
            if (null == rowPane) {
                LOGGER.error("The rowPane parameter is null.");
                return;
            }
            if (tag % this.itemsInRow == 0) {
                wholeBox.add(rowPane);
                wholeBox.add(Box.createVerticalStrut(60));
            }
            if (i != coms.length - 1) continue;
            if (tag % this.itemsInRow != 0) {
                wholeBox.add(rowPane);
                wholeBox.add(Box.createVerticalStrut(24));
            }
            wholeBox.add(Box.createVerticalGlue());
        }
        JPanel contentPane = UCD.layComponentToTop(wholeBox);
        this.setLayout(new BoxLayout(this, 1));
        contentPane.setBorder(UCD.createEmptyBorder(40));
        MyCustScrollPane sp = new MyCustScrollPane(contentPane);
        this.add(sp);
    }

    private void layoutUI() {
        Box wholeBox = Box.createVerticalBox();
        JComponent[] coms = this.initComponents(false);
        for (int i = 0; i < coms.length; ++i) {
            wholeBox.add(coms[i]);
            if (i == coms.length - 1) {
                wholeBox.add(Box.createVerticalGlue());
                break;
            }
            wholeBox.add(Box.createVerticalStrut(10));
        }
        JPanel contentPane = UCD.layComponentToTop(wholeBox);
        this.setLayout(new BoxLayout(this, 1));
        contentPane.setBorder(UCD.createEmptyBorder(12));
        JScrollPane sp = new JScrollPane(contentPane);
        this.add(sp);
    }

    @Override
    public void updateProperty(int updateMode) {
    }

    protected int configGroupSize() {
        return 0;
    }

    protected String getConfigGroupTitle(int groupIndex) {
        return null;
    }

    protected ImageIcon getConfigGroupIcon(int groupIndex) {
        return null;
    }

    protected List<List<ConfigItem>> getConfigItems(int groupIndex) {
        return new ArrayList<List<ConfigItem>>(0);
    }

    private JComponent buildGroup(int groupIndex) {
        Box groupBox = Box.createVerticalBox();
        String groupTitle = this.getConfigGroupTitle(groupIndex);
        if (null != groupTitle && !"".equals(groupTitle)) {
            TitledBorder tb = new TitledBorder(groupTitle);
            groupBox.setBorder(tb);
        }
        List<List<ConfigItem>> itemLists = this.getConfigItems(groupIndex);
        int itemClass = 0;
        int tag = 0;
        JPanel hPanel = null;
        JComponent itemBox = null;
        int row = 0;
        for (List<ConfigItem> classItems : itemLists) {
            tag = 0;
            hPanel = new JPanel();
            hPanel.setOpaque(false);
            row = classItems.size() / this.itemsInRow;
            if (classItems.size() % this.itemsInRow != 0) {
                ++row;
            }
            hPanel.setLayout(new GridLayout(row, this.itemsInRow));
            for (ConfigItem configItem : classItems) {
                if (tag % this.itemsInRow == 0) {
                    tag = 0;
                }
                itemBox = this.buildComponentBox(configItem);
                hPanel.add(itemBox);
                ++tag;
            }
            groupBox.add(hPanel);
            for (int i = 0; i < this.itemsInRow - tag; ++i) {
                hPanel.add(new JLabel());
            }
            if (itemClass != itemLists.size() - 1) {
                groupBox.add(new JSeparator(0));
            }
            ++itemClass;
        }
        return groupBox;
    }

    private JComponent buildSubGroup(int groupIndex) {
        Locale locale = ResourceManager.getLocale();
        String lan = locale.getLanguage();
        Box wholeBox = Box.createHorizontalBox();
        Box groupBox = Box.createVerticalBox();
        String groupTitle = this.getConfigGroupTitle(groupIndex);
        JLabel label = new JLabel(groupTitle);
        label.setFont(new Font("\u9ed1\u4f53", 0, 16));
        if (lan.equals("en")) {
            label.setFont(new Font("Arial", 0, 16));
        }
        Box titleBox = Box.createHorizontalBox();
        titleBox.add(label);
        titleBox.add(new JLabel(" "));
        titleBox.add(Box.createHorizontalGlue());
        groupBox.add(titleBox);
        List<List<ConfigItem>> itemLists = this.getConfigItems(groupIndex);
        int index = 0;
        Box contentBox = null;
        Box itemBox = null;
        for (List<ConfigItem> configItems : itemLists) {
            index = 0;
            contentBox = Box.createVerticalBox();
            for (ConfigItem configItem : configItems) {
                itemBox = this.buildSubItemBox(configItem);
                contentBox.add(itemBox);
                if (index != configItems.size() - 1) {
                    contentBox.add(Box.createVerticalStrut(5));
                }
                ++index;
            }
            contentBox.add(Box.createVerticalGlue());
            groupBox.add(contentBox);
        }
        JLabel imgLabel = new JLabel();
        ImageIcon imageIcon = ResourceManager.getImage("shareService.gif");
        imgLabel.setSize(imageIcon.getIconWidth(), imageIcon.getIconHeight());
        imgLabel.setPreferredSize(new Dimension(imageIcon.getIconWidth(), imageIcon.getIconHeight()));
        imgLabel.setIcon(imageIcon);
        Box imgBox = Box.createVerticalBox();
        imgBox.add(imgLabel);
        imgBox.add(Box.createVerticalGlue());
        wholeBox.add(imgBox);
        wholeBox.add(Box.createHorizontalStrut(12));
        wholeBox.add(groupBox);
        return wholeBox;
    }

    private JComponent[] initComponents(boolean newLayout) {
        int groupSize = this.configGroupSize();
        JComponent[] coms = new JComponent[groupSize];
        for (int i = 0; i < groupSize; ++i) {
            coms[i] = newLayout ? this.buildSubGroup(i) : this.buildGroup(i);
        }
        return coms;
    }

    private Box buildSubItemBox(ConfigItem item) {
        JLabel label = new JLabel();
        label.addMouseListener(this.getActionMouseListner(item));
        label.setText("<html>" + item.getItemName() + "</html>");
        label.setForeground(new Color(26879));
        if (null != item.getItemName()) {
            FontMetrics fm = label.getFontMetrics(label.getFont());
            int length = fm.stringWidth(item.getItemName());
            UCD.setJComponentSize(label, new Dimension(length, fm.getHeight()));
        }
        ToolTipManager.sharedInstance().registerComponent(label);
        String toolTipText = UCD.wrapTextWithHTML(label.getFontMetrics(label.getFont()), item.getDescription(), 300);
        label.setToolTipText(toolTipText);
        Box actionBox = Box.createHorizontalBox();
        actionBox.add(label);
        actionBox.add(new JLabel(" "));
        actionBox.add(Box.createHorizontalGlue());
        return actionBox;
    }

    private JComponent buildComponentBox(ConfigItem item) {
        JLabel label = new JLabel();
        label.addMouseListener(this.getActionMouseListner(item));
        label.setText("<html>" + item.getItemName() + "</html>");
        label.setForeground(new Color(26879));
        if (null != item.getItemName()) {
            FontMetrics fm = label.getFontMetrics(label.getFont());
            int length = fm.stringWidth(item.getItemName());
            UCD.setJComponentSize(label, new Dimension(length, fm.getHeight()));
        }
        Box titleBox = Box.createHorizontalBox();
        titleBox.add(label);
        titleBox.add(new JLabel(" "));
        titleBox.add(Box.createHorizontalGlue());
        Box infoBox = Box.createHorizontalBox();
        IsmTextArea textArea = UCD.createTextArea(item.getDescription());
        textArea.setRows(1);
        infoBox.add(textArea);
        JComponent titleAndInfoBox = UCD.buildVerticalBox(UCD.createEmptyBorder(), titleBox, infoBox, Box.createVerticalGlue());
        return titleAndInfoBox;
    }

    private MouseAdapter getActionMouseListner(final ConfigItem item) {
        return new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (null == mouseEvent) {
                    return;
                }
                JLabel label = (JLabel)mouseEvent.getSource();
                label.setForeground(new Color(4359891));
                item.getAction().actionPerformed(null);
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                JLabel label = (JLabel)mouseEvent.getSource();
                label.setForeground(new Color(4359891));
                ConfigAssistantPane.this.setCursor(new Cursor(12));
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                JLabel label = (JLabel)mouseEvent.getSource();
                label.setForeground(new Color(5477856));
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                ConfigAssistantPane.this.setCursor(new Cursor(0));
                JLabel label = (JLabel)mouseEvent.getSource();
                label.setForeground(new Color(26879));
            }
        };
    }

    @Override
    public final String getDeviceID() {
        return this.deviceIDFor;
    }

    protected static class ConfigItem {
        private String description = null;
        private ImageIcon icon = null;
        private BaseAction action = null;

        public ConfigItem(String description, ImageIcon icon, BaseAction action) {
            this.description = description;
            this.icon = icon;
            this.action = action;
        }

        public String getItemName() {
            return (String)this.action.getValue("Name");
        }

        public String getDescription() {
            return this.description;
        }

        public ImageIcon getIcon() {
            return this.icon;
        }

        public BaseAction getAction() {
            return this.action;
        }
    }

    private static final class MyCustScrollPane
    extends JScrollPane {
        private static final long serialVersionUID = 4547673978536614371L;

        private MyCustScrollPane(Component view) {
            super(view);
        }

        @Override
        public void updateUI() {
            super.updateUI();
            if (IsmPlafUtils.getLAFStyle() == IsmPlafUtils.LAFStyle.armor) {
                this.setBorder(null);
            }
            if (IsmPlafUtils.getLAFStyle() == IsmPlafUtils.LAFStyle.unify) {
                this.setBackground(Color.WHITE);
                this.setBorder(null);
            }
        }
    }
}

