/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.widgets.action;

import com.huawei.ism.common.Launcher;
import com.huawei.ism.common.LauncherManager;
import com.huawei.ism.ui.widgets.action.ActionCfgFile;
import com.huawei.ism.ui.widgets.action.BaseAction;
import com.huawei.ism.util.SwingUtil;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;

public class ActionManager
implements Serializable {
    private static final long serialVersionUID = 5525207670061013580L;
    private static String actionCfgfilePath = "config/framework/configuration/action.xml";
    private static ActionManager instance = new ActionManager();
    private Map<String, BaseAction> actionMap = new HashMap<String, BaseAction>(0);
    private transient Map<String, DeligateAction> deligateActions = new HashMap<String, DeligateAction>(0);

    private ActionManager() {
        ActionCfgFile file = new ActionCfgFile(actionCfgfilePath);
        List<BaseAction> actions = file.getActions();
        for (BaseAction baseAction : actions) {
            this.actionMap.put(baseAction.getID(), baseAction);
        }
    }

    public static ActionManager getInstance() {
        return instance;
    }

    public Action getAction(String actionID) {
        DeligateAction deligateAction = this.deligateActions.get(actionID);
        if (null == deligateAction) {
            BaseAction<?> action = this.getAction(null, actionID);
            deligateAction = new DeligateAction(action);
            deligateAction.setActionID(actionID);
            if (null == action) {
                deligateAction.putValue("Name", actionID);
            }
            this.deligateActions.put(actionID, deligateAction);
        }
        return deligateAction;
    }

    public void putAction(String actionID, BaseAction action) {
        this.actionMap.put(actionID, action);
    }

    public int getActionNumber() {
        return this.actionMap.size();
    }

    public void removeAllActions() {
        if (null != this.actionMap) {
            this.actionMap.clear();
        }
    }

    public BaseAction<?> getAction(String deviceID, String actionID) {
        List<Launcher> launchers;
        BaseAction<?> action;
        BaseAction defaultAction = this.actionMap.get(actionID);
        if (null != deviceID && null != (action = this.getAction(deviceID, actionID, launchers = LauncherManager.getInstance().getAllLauncher()))) {
            return action;
        }
        return defaultAction;
    }

    private BaseAction<?> getAction(String deviceID, String actionID, List<Launcher> launchers) {
        for (Launcher launcher : launchers) {
            BaseAction<?> action;
            if (!launcher.containsPart(deviceID) || null == (action = launcher.getAction(actionID))) continue;
            action.setDeviceID(deviceID);
            return action;
        }
        return null;
    }

    public void updateActions(final String deviceID) {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                Set actionKeys = ActionManager.this.deligateActions.keySet();
                DeligateAction deligateAction = null;
                BaseAction<?> baseAction = null;
                for (String actionKey : actionKeys) {
                    deligateAction = (DeligateAction)ActionManager.this.deligateActions.get(actionKey);
                    baseAction = ActionManager.this.getAction(deviceID, actionKey);
                    deligateAction.resetAction(baseAction);
                }
            }
        };
        SwingUtil.runInEventDispatchThread(run);
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
    }

    private static class DeligateAction
    extends AbstractAction {
        private static final long serialVersionUID = 3183480262549137288L;
        private String actionID = null;
        private BaseAction<?> action = null;

        public DeligateAction(BaseAction<?> baseAction) {
            this.resetAction(baseAction);
        }

        public void resetAction(BaseAction<?> baseAction) {
            if (null == baseAction) {
                return;
            }
            this.action = baseAction;
            Object[] keys = baseAction.getKeys();
            if (null != keys) {
                for (Object key : keys) {
                    this.putValue(key.toString(), baseAction.getValue(key.toString()));
                }
            }
            this.setEnabled(baseAction.isEnabled());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (null != this.action) {
                this.action.actionPerformed(actionEvent);
            }
        }

        public String getActionID() {
            return this.actionID;
        }

        public void setActionID(String actionID) {
            this.actionID = actionID;
        }
    }
}

