/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui2.module.event.alarmbuzzer;

import com.huawei.ism.common.Framework;
import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.ui.templets.IsmDialog;
import com.huawei.ism.ui2.module.event.alarmbuzzer.IsmAlarmBuzzerSwitchDialog;
import com.huawei.ism.util.SwingUtil;
import com.huawei.ism.util.UCD;
import com.huawei.ism.util.ValueMonitor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;

public class AlarmSoundManagerDialog
extends IsmDialog {
    private static final long serialVersionUID = 1L;
    private JRadioButton enableBtn = new JRadioButton();
    private JRadioButton disableBtn = new JRadioButton();
    private ButtonGroup radioGroup = new ButtonGroup();
    private JCheckBox criticalCbx = new JCheckBox();
    private JCheckBox majorCbx = new JCheckBox();
    private JCheckBox warningCbx = new JCheckBox();
    private ValueMonitor uiModifyChecker = new ValueMonitor();
    private boolean initFlag = true;

    public AlarmSoundManagerDialog(String tip) {
        super((Window)Framework.getInstance().getMainFrame(), ResourceManager.getString("alarm.buzzer.setting.title"), IsmDialog.ECommonButton.Confirm, IsmDialog.ECommonButton.Apply, IsmDialog.ECommonButton.Cancel, IsmDialog.ECommonButton.Help);
        this.initUI(tip);
        this.initDefaultProperty();
        this.setDialogProperty();
    }

    protected void addComponentsEvent() {
        this.uiModifyChecker.addCheckpoint(this.enableBtn);
        this.uiModifyChecker.addCheckpoint(this.disableBtn);
        this.enableBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AlarmSoundManagerDialog.this.enableAlarm();
            }
        });
        this.disableBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AlarmSoundManagerDialog.this.enableAlarm();
            }
        });
    }

    protected void initDefaultProperty() {
    }

    private void setDialogProperty() {
        this.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        this.pack();
        this.setResizable(false);
        SwingUtil.putScreenCenter(this);
    }

    @Override
    protected String getHelpKey() {
        return this instanceof IsmAlarmBuzzerSwitchDialog ? "alarm_client_buzzer" : "alarm_ism_buzzer";
    }

    protected void initUI(String tip) {
        this.initComponents(tip);
        this.setButtonStatusFromParent(true, false);
    }

    protected void setButtonStatusFromParent(boolean comfirmBtnStatus, boolean applyBtnStatus) {
        this.getButtonBy(IsmDialog.ECommonButton.Confirm).setEnabled(comfirmBtnStatus);
        this.getButtonBy(IsmDialog.ECommonButton.Apply).setEnabled(applyBtnStatus);
    }

    private void initComponents(String tip) {
        JPanel main = new JPanel();
        main.setLayout(new BorderLayout());
        main.setBorder(UCD.createEmptyBorder());
        JPanel tipPanel = UCD.newInformationPanel(null == tip || "".equals(tip) ? ResourceManager.getString("ALARM_BUZZER_DESC") : tip);
        main.add((Component)tipPanel, "North");
        Box box = Box.createVerticalBox();
        box.add(Box.createVerticalStrut(12));
        box.add(this.createParamBox(tip));
        if (ResourceManager.getLocale().getLanguage().equals("en")) {
            if (null == tip || "".equals(tip)) {
                main.setPreferredSize(new Dimension(370, 120));
            } else {
                main.setPreferredSize(new Dimension(370, 140));
            }
        } else if (null == tip || "".equals(tip)) {
            main.setPreferredSize(new Dimension(370, 120));
        } else {
            main.setPreferredSize(new Dimension(370, 125));
        }
        main.add((Component)box, "Center");
        this.getDialogContentPane().add(main);
    }

    private JPanel createParamBox(String tip) {
        Box createFirstSettingBox;
        JPanel box = UCD.createBoxLayoutPane(1);
        if (null != tip && !"".equals(tip)) {
            box.add(this.createAlarmSwitchButton());
            box.add(Box.createVerticalStrut(2));
        }
        if ((createFirstSettingBox = this.createFirstSettingRow()) != null) {
            box.add(this.createFirstSettingRow());
        }
        if (null == tip || "".equals(tip)) {
            box.add(Box.createVerticalStrut(2));
            box.add(this.createAlarmSwitchButton());
        }
        box.add(Box.createVerticalGlue());
        box.setBorder(new CompoundBorder(new TitledBorder(ResourceManager.getString("CONFIG_BUZZER")), new EmptyBorder(2, 2, 2, 2)));
        return box;
    }

    protected Box createFirstSettingRow() {
        return null;
    }

    protected void enableAlarm() {
        this.setButtonState(IsmDialog.ECommonButton.Apply, this.uiModifyChecker.isValueChanged());
    }

    private Box createAlarmSwitchButton() {
        this.enableBtn.setText(ResourceManager.getString("ALARM_SETTING_ENABLE_BUTTON_TEXT"));
        this.disableBtn.setText(ResourceManager.getString("ALARM_SETTING_DISABLE_BUTTON_TEXT"));
        this.radioGroup.add(this.enableBtn);
        this.radioGroup.add(this.disableBtn);
        Box box = Box.createHorizontalBox();
        return box;
    }

    public JRadioButton getEnableBtn() {
        return this.enableBtn;
    }

    public void setEnableBtn(JRadioButton enableBtn) {
        this.enableBtn = enableBtn;
    }

    public JRadioButton getDisableBtn() {
        return this.disableBtn;
    }

    public void setDisableBtn(JRadioButton disableBtn) {
        this.disableBtn = disableBtn;
    }

    public ButtonGroup getRadioGroup() {
        return this.radioGroup;
    }

    public void setRadioGroup(ButtonGroup radioGroup) {
        this.radioGroup = radioGroup;
    }

    public JCheckBox getCriticalCbx() {
        return this.criticalCbx;
    }

    public void setCriticalCbx(JCheckBox criticalCbx) {
        this.criticalCbx = criticalCbx;
    }

    public JCheckBox getMajorCbx() {
        return this.majorCbx;
    }

    public void setMajorCbx(JCheckBox majorCbx) {
        this.majorCbx = majorCbx;
    }

    public JCheckBox getWarningCbx() {
        return this.warningCbx;
    }

    public void setWarningCbx(JCheckBox warningCbx) {
        this.warningCbx = warningCbx;
    }

    public ValueMonitor getUiModifyChecker() {
        return this.uiModifyChecker;
    }

    public void setUiModifyChecker(ValueMonitor uiModifyChecker) {
        this.uiModifyChecker = uiModifyChecker;
    }

    public boolean isInitFlag() {
        return this.initFlag;
    }

    public void setInitFlag(boolean initFlag) {
        this.initFlag = initFlag;
    }
}

