/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui2.module.featuremanager;

import com.huawei.ism.common.bean.DeviceType;
import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.ui.swing.PropertyPane;
import com.huawei.ism.ui.widgets.action.BaseAction;
import com.huawei.ism.ui.widgets.propertypane.ProgressingPropertyPane;
import com.huawei.ism.ui2.module.featuremanager.FeatureItem;
import com.huawei.ism.util.Assert;
import java.lang.reflect.Constructor;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FeatureItemFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(FeatureItemFactory.class);
    private static ConcurrentMap<String, Class<? extends PropertyPane>> propertyPaneClazzs = new ConcurrentHashMap<String, Class<? extends PropertyPane>>();
    private static ConcurrentMap<String, FeatureItem> featureItems = new ConcurrentHashMap<String, FeatureItem>();
    private static ConcurrentMap<String, String> urlLinks = new ConcurrentHashMap<String, String>();

    private FeatureItemFactory() {
    }

    public static FeatureItem getFeatureItem(String deviceID, DeviceType deviceType, String featureName) {
        Assert.notNull(featureName);
        Assert.notNull((Object)deviceType);
        if (featureItems.containsKey(deviceID + featureName + (Object)((Object)deviceType))) {
            return (FeatureItem)featureItems.get(deviceID + featureName + (Object)((Object)deviceType));
        }
        if (!propertyPaneClazzs.containsKey(featureName + (Object)((Object)deviceType))) {
            throw new IllegalArgumentException("The feature name is not registed.");
        }
        Class propertyPaneClazz = (Class)propertyPaneClazzs.get(featureName + (Object)((Object)deviceType));
        FeatureItem featrueItem = FeatureItemFactory.createFeatureItem(deviceID, featureName, deviceType, propertyPaneClazz);
        featureItems.put(deviceID + featureName + (Object)((Object)deviceType), featrueItem);
        return featrueItem;
    }

    public static FeatureItem getFeatureItem(String deviceID, String featureName, BaseAction<Object> baseAction, DeviceType deviceType) {
        Assert.notNull(featureName);
        if (featureItems.containsKey(deviceID + featureName + (Object)((Object)deviceType))) {
            return (FeatureItem)featureItems.get(deviceID + featureName + (Object)((Object)deviceType));
        }
        FeatureItem featrueItem = FeatureItemFactory.createFeatureItem(deviceID, featureName, baseAction, deviceType);
        featureItems.put(deviceID + featureName + (Object)((Object)deviceType), featrueItem);
        return featrueItem;
    }

    public static FeatureItem getURLFeatureItem(String deviceID, String featureName, DeviceType deviceType) {
        Assert.notNull(featureName);
        if (featureItems.containsKey(featureName + (Object)((Object)deviceType))) {
            return (FeatureItem)featureItems.get(featureName + (Object)((Object)deviceType));
        }
        if (!urlLinks.containsKey(featureName + (Object)((Object)deviceType))) {
            throw new IllegalArgumentException("The url feature name is not registed.");
        }
        String urlLink = (String)urlLinks.get(featureName + (Object)((Object)deviceType));
        FeatureItem featrueItem = FeatureItemFactory.createURLFeatureItem(deviceID, featureName, urlLink, deviceType);
        featureItems.put(featureName + (Object)((Object)deviceType), featrueItem);
        return featrueItem;
    }

    private static FeatureItem createURLFeatureItem(String deviceID, String featureNameKey, String urlLink, DeviceType deviceType) {
        Assert.notNull(featureNameKey);
        String prefix = "feature_";
        String normalIconFileName = prefix + featureNameKey + "_normal.png";
        String rolloverIconFileName = prefix + featureNameKey + "_rollover.png";
        String selectedIconFileName = prefix + featureNameKey + "_selected.png";
        String nameKey = ("FEATURE.NAME." + featureNameKey).toUpperCase(ResourceManager.getLocale());
        String featureName = ResourceManager.getString(nameKey);
        FeatureItem featureItem = new FeatureItem(deviceID, normalIconFileName, featureName, urlLink, deviceType);
        featureItem.setRolloverIcon(rolloverIconFileName);
        featureItem.setSelectedIcon(selectedIconFileName);
        return featureItem;
    }

    private static FeatureItem createFeatureItem(final String deviceID, String featureNameKey, DeviceType deviceType, final Class<? extends PropertyPane> propertyPaneClazz) {
        String prefix = "feature_";
        String normalIconFileName = prefix + featureNameKey + "_normal.png";
        String rolloverIconFileName = prefix + featureNameKey + "_rollover.png";
        String selectedIconFileName = prefix + featureNameKey + "_selected.png";
        String nameKey = ("FEATURE.NAME." + featureNameKey).toUpperCase(ResourceManager.getLocale());
        String featureName = ResourceManager.getString(nameKey);
        FeatureItem featureItem = new FeatureItem(deviceID, normalIconFileName, featureName, deviceType){

            @Override
            protected PropertyPane createPropertyPane() {
                if (null == propertyPaneClazz) {
                    return ProgressingPropertyPane.getInstance();
                }
                try {
                    Constructor constructor;
                    PropertyPane pane = null;
                    if (null != deviceID) {
                        constructor = propertyPaneClazz.getConstructor(String.class);
                        pane = (PropertyPane)constructor.newInstance(deviceID);
                    }
                    if (null == pane) {
                        pane = (PropertyPane)propertyPaneClazz.newInstance();
                        constructor = propertyPaneClazz.getConstructor(String.class);
                        pane = (PropertyPane)constructor.newInstance(new Object[]{null});
                    }
                    return pane;
                }
                catch (Throwable e) {
                    LOGGER.error("", e);
                    return ProgressingPropertyPane.getInstance();
                }
            }
        };
        featureItem.setRolloverIcon(rolloverIconFileName);
        featureItem.setSelectedIcon(selectedIconFileName);
        return featureItem;
    }

    private static FeatureItem createFeatureItem(String deviceID, String featureNameKey, BaseAction<Object> baseAction, DeviceType deviceType) {
        String prefix = "feature_";
        String normalIconFileName = prefix + featureNameKey + "_normal.png";
        String rolloverIconFileName = prefix + featureNameKey + "_rollover.png";
        String selectedIconFileName = prefix + featureNameKey + "_selected.png";
        String nameKey = ("FEATURE.NAME." + featureNameKey).toUpperCase(ResourceManager.getLocale());
        String featureName = ResourceManager.getString(nameKey);
        FeatureItem featureItem = new FeatureItem(deviceID, normalIconFileName, featureName, baseAction, true, deviceType);
        featureItem.setRolloverIcon(rolloverIconFileName);
        featureItem.setSelectedIcon(selectedIconFileName);
        return featureItem;
    }

    public static void registerURLFeatureItem(String featureItemKey, String urlLink, DeviceType deviceType) {
        Assert.notNull(featureItemKey);
        Assert.notNull(urlLink);
        Assert.notNull((Object)deviceType);
        urlLinks.put(featureItemKey + (Object)((Object)deviceType), urlLink);
    }

    public static void registerFeatureItem(String featureItemKey, DeviceType deviceType, Class<? extends PropertyPane> proepryPaneClazz) {
        Assert.notNull(featureItemKey);
        Assert.notNull(proepryPaneClazz);
        Assert.notNull((Object)deviceType);
        propertyPaneClazzs.put(featureItemKey + (Object)((Object)deviceType), proepryPaneClazz);
    }

    public static void unRegisterFeatureItem(String featureItemKey, DeviceType deviceType) {
        Assert.notNull(featureItemKey);
        Assert.notNull((Object)deviceType);
        propertyPaneClazzs.remove(featureItemKey + (Object)((Object)deviceType));
    }
}

