/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui2.perfstat;

import com.huawei.ism.common.Framework;
import com.huawei.ism.common.Launcher;
import com.huawei.ism.common.LauncherManager;
import com.huawei.ism.common.bean.User;
import com.huawei.ism.common.bean.impl.IDataTypeEnum;
import com.huawei.ism.common.bean.impl.IObjectTypeEnum;
import com.huawei.ism.common.bean.impl.IPerfStatData;
import com.huawei.ism.common.bean.impl.IPerfStatObject;
import com.huawei.ism.common.bean.impl.IPerfStatObjectType;
import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.exception.IsmException;
import com.huawei.ism.ui.module.perfhis.TimeSeriesChart;
import com.huawei.ism.ui.module.perfhis.Tools;
import com.huawei.ism.ui.module.perfhis.XYTimeSeriesData;
import com.huawei.ism.ui.module.perfhis.util.ColorContainer;
import com.huawei.ism.ui.swing.PropertyPane;
import com.huawei.ism.ui.swing.dialog.ConfirmDialog;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.InformationDialog;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.IsmTableCell;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.ui2.perfstat.AdvancePerfStatXYToolTipGenerator;
import com.huawei.ism.ui2.perfstat.NormalPerfStatXYToolTipGenerator;
import com.huawei.ism.ui2.perfstat.PerfStatRealTimeLayout;
import com.huawei.ism.ui2.perfstat.PerfStatStrategySettingDialog;
import com.huawei.ism.ui2.perfstat.util.DataSourceManager;
import com.huawei.ism.ui2.perfstat.util.ObjectKeeper;
import com.huawei.ism.ui2.perfstat.util.PerfStatDataSource;
import com.huawei.ism.ui2.perfstat.util.PerfStatUtil;
import com.huawei.ism.ui2.perfstat.util.TickableTree;
import com.huawei.ism.ui2.perfstat.util.TickableTreeNode;
import com.huawei.ism.util.CommonUtil;
import com.huawei.ism.util.Pair;
import com.huawei.ism.util.SwingUtil;
import com.huawei.ism.util.Utils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.swing.JComboBox;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesDataItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PerfStatRealTimePane
extends PropertyPane {
    private static final Logger LOGGER = LoggerFactory.getLogger(PerfStatRealTimePane.class);
    private static final long serialVersionUID = -9214205501472401917L;
    private static final String PANE_NAME = "PerfStatRealTimePane";
    private String deviceID = null;
    private PerfStatRealTimeLayout layout;
    private Map<IPerfStatObjectType, List<Object>> perfStatObjectTypeToMOMap = new HashMap<IPerfStatObjectType, List<Object>>(0);
    private Map<IObjectTypeEnum, DefaultMutableTreeNode> advanceObjectTypeToDataTypeTreeNodeMapping = new HashMap<IObjectTypeEnum, DefaultMutableTreeNode>(0);
    private Map<IObjectTypeEnum, DefaultMutableTreeNode> advanceObjectTypeToObjectsMapping = new HashMap<IObjectTypeEnum, DefaultMutableTreeNode>(0);
    private Map<IObjectTypeEnum, DefaultMutableTreeNode> normalObjectTypeToDataTypeTreeNodeMapping = new HashMap<IObjectTypeEnum, DefaultMutableTreeNode>(0);
    private Map<IObjectTypeEnum, DefaultMutableTreeNode> normalObjectTypeToObjectsMapping = new HashMap<IObjectTypeEnum, DefaultMutableTreeNode>(0);
    private Map<IObjectTypeEnum, List<IDataTypeEnum>> objectTypeToSelectedDataTypeMapping = new HashMap<IObjectTypeEnum, List<IDataTypeEnum>>(0);
    private Set<IPerfStatObject> normalSelectedObjectSet = new HashSet<IPerfStatObject>(5);
    private final transient QueryPerfStatStrategyTask queryPerfStatStrategyTask = new QueryPerfStatStrategyTask();
    private final transient AdvanceQueryPerfStatDataTask advanceQueryPerfStatDataTask = new AdvanceQueryPerfStatDataTask();
    private final transient NormalQueryPerfStatDataTask normalQueryPerfStatDataTask = new NormalQueryPerfStatDataTask();
    private transient ScheduledFuture<?> queryPerfStatStrategyFuture;
    private transient ScheduledFuture<?> advanceScheduledFuture;
    private transient ScheduledFuture<?> normalScheduledFuture;
    private transient ScheduledThreadPoolExecutor scheduledTimer = new ScheduledThreadPoolExecutor(3);
    private Map<String, Double> currentScales = new HashMap<String, Double>(0);
    private transient ColorContainer colorContainer = new ColorContainer();
    private transient IObjectTypeEnum advancePreviousSelectedObjectTypeEnum;
    private transient IObjectTypeEnum normalPreviousSelectedObjectTypeEnum;
    private boolean isKeepThisObject = true;
    private List<String> deviceList;
    private transient ItemListener advanceItemListener;
    private transient ItemListener normalItemListener;
    private transient ItemListener deviceComboBoxlistener;
    private boolean isShowAgain = true;
    private Object lastSelectobjectTypePair;
    private InformationDialog infoDialog;
    private List<Pair<String, String>> namePair;
    private final Object LOCK = new Object();

    public PerfStatRealTimePane(String deviceID) {
        this.deviceID = deviceID;
        this.initDeviceList();
        this.doLayoutUI();
        this.initData();
        this.addHandler();
        this.normalObjectTypeComboBoxChanged();
        this.setOpaque(false);
    }

    protected void initDeviceList() {
        this.deviceList = new ArrayList<String>();
        this.deviceList.add(this.deviceID);
        Launcher launcher = LauncherManager.getInstance().getLauncher(this.deviceID);
        List<String> subDeviceIDs = launcher.getSubDeviceIDs();
        if (subDeviceIDs != null) {
            for (String id : subDeviceIDs) {
                this.deviceList.add(id);
            }
        }
    }

    private void doLayoutUI() {
        this.layout = new PerfStatRealTimeLayout(Framework.getInstance().getMainFrame(), PANE_NAME);
        this.setLayout(new BorderLayout());
        this.add((Component)this.layout, "Center");
        this.layout.setNormalDesc(ResourceManager.getStringWithParams("perfstat.realtime.desc.normal.open", 5));
        this.layout.setAdvanceDesc(ResourceManager.getString("perfstat.realtime.desc.advance.open"));
    }

    private void initData() {
        this.initDataSource();
        this.namePair = PerfStatUtil.getDeviceIDNamePair(this.deviceList);
        this.initDeviceComboBoxListener();
        this.layout.getDeviceComboBox().addItemListener(this.deviceComboBoxlistener);
        this.initDeviceNames(this.namePair);
        this.initComboBoxListeners();
        this.initSelectedDeviceData();
        if (this.isKeepThisObject) {
            this.holdThisObject();
        }
    }

    private void initComboBoxListeners() {
        this.initAdvanceObjectTypeComboBoxListener();
        this.initNormalObjectTypeComboBoxListener();
    }

    protected void initDataSource() {
        for (String device : this.deviceList) {
            DataSourceManager.getDataSource(device).setParentWindow(this.getParentWindow());
        }
    }

    private void initDeviceNames(List<Pair<String, String>> namePairs) {
        int index = this.layout.getDeviceComboBox().getSelectedIndex();
        this.layout.getDeviceComboBox().removeItemListener(this.deviceComboBoxlistener);
        this.layout.setDeviceNames(namePairs);
        if (index >= 0) {
            this.layout.getDeviceComboBox().setSelectedIndex(index);
        }
        this.layout.getDeviceComboBox().addItemListener(this.deviceComboBoxlistener);
    }

    private void initSelectedDeviceData() {
        this.initBaseData();
        this.fillNormalTypeTreeMapping();
        this.cloneDataToNormalObjectMapping();
        this.delAndAddListener();
    }

    private void cloneDataToNormalObjectMapping() {
        this.normalObjectTypeToObjectsMapping.clear();
        for (Map.Entry<IObjectTypeEnum, DefaultMutableTreeNode> temp : this.advanceObjectTypeToObjectsMapping.entrySet()) {
            IObjectTypeEnum key = temp.getKey();
            this.normalObjectTypeToObjectsMapping.put(key, this.cloneTreeNode(temp.getValue()));
        }
    }

    private void delAndAddListener() {
        this.layout.getAdvanceObjectTypeComboBox().removeItemListener(this.advanceItemListener);
        this.layout.getNormalObjectTypeComboBox().removeItemListener(this.normalItemListener);
        List<IObjectTypeEnum> advanceObjectTypes = this.getCurrentDataSource().getObjectTypes(this);
        this.getPerfStatLayout().setAdvanceObjectTypes(advanceObjectTypes);
        this.getPerfStatLayout().setNormalObjectTypes(this.filterObjectTypes(advanceObjectTypes));
        this.layout.getAdvanceObjectTypeComboBox().addItemListener(this.advanceItemListener);
        this.layout.getNormalObjectTypeComboBox().addItemListener(this.normalItemListener);
        this.handleIfAdvanceObjAdded();
    }

    private void fillNormalTypeTreeMapping() {
        for (Map.Entry<IObjectTypeEnum, DefaultMutableTreeNode> temp : this.advanceObjectTypeToDataTypeTreeNodeMapping.entrySet()) {
            DefaultMutableTreeNode cloneTreeNode = this.cloneDataTypeTreeNode(temp.getValue(), temp.getKey());
            if (cloneTreeNode == null) continue;
            this.tickAllNode(cloneTreeNode);
            this.normalObjectTypeToDataTypeTreeNodeMapping.put(temp.getKey(), cloneTreeNode);
        }
    }

    private void initBaseData() {
        this.getCurrentDataSource().initDeviceData(this);
        this.removeAllLegendRows();
        this.clearNormalChart();
        this.objectTypeToSelectedDataTypeMapping.clear();
        this.perfStatObjectTypeToMOMap = this.getPerfStatObjectTypes();
        this.advanceObjectTypeToObjectsMapping = this.getObjectTypeToObjectsMap(this.perfStatObjectTypeToMOMap);
        this.advanceObjectTypeToDataTypeTreeNodeMapping = PerfStatUtil.createObjectTypeToDataTypeTreeNodeMapping(PerfStatUtil.convertToObjectTypeToDataTypesMapping(this.perfStatObjectTypeToMOMap));
        this.normalObjectTypeToDataTypeTreeNodeMapping.clear();
    }

    private void handleIfAdvanceObjAdded() {
        if (this.layout.getAdvanceObjectTypeComboBox().getItemCount() > 0) {
            this.advanceItemListener.itemStateChanged(new ItemEvent(this.layout.getAdvanceObjectTypeComboBox(), 701, this.layout.getAdvanceObjectTypeComboBox().getItemAt(0), 1));
            this.normalItemListener.itemStateChanged(new ItemEvent(this.layout.getNormalObjectTypeComboBox(), 701, this.layout.getNormalObjectTypeComboBox().getItemAt(0), 1));
        }
    }

    private List<IObjectTypeEnum> filterObjectTypes(List<IObjectTypeEnum> advanceObjectTypes) {
        ArrayList<IObjectTypeEnum> result = new ArrayList<IObjectTypeEnum>();
        for (IObjectTypeEnum objectType : advanceObjectTypes) {
            if (!this.hasBasicDataType(objectType)) continue;
            result.add(objectType);
        }
        return result;
    }

    private boolean hasBasicDataType(IObjectTypeEnum objectType) {
        IObjectTypeEnum[] array;
        for (IObjectTypeEnum objectTypeTemp : array = this.getCurrentDataSource().getAllObjectType(objectType)) {
            DefaultMutableTreeNode node = this.normalObjectTypeToDataTypeTreeNodeMapping.get(objectTypeTemp);
            if (node == null) continue;
            Enumeration<TreeNode> allNodes = node.children();
            while (allNodes.hasMoreElements()) {
                TickableTreeNode tickableTreeNode;
                IDataTypeEnum dataType;
                DefaultMutableTreeNode temp = (DefaultMutableTreeNode)allNodes.nextElement();
                if (!(temp instanceof TickableTreeNode) || !this.layout.isBasicDataType(dataType = (IDataTypeEnum)((Pair)(tickableTreeNode = (TickableTreeNode)temp).getUserObject()).getKey(), objectType)) continue;
                return true;
            }
        }
        return false;
    }

    private DefaultMutableTreeNode cloneTreeNode(DefaultMutableTreeNode node) {
        DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)node.clone();
        int size = node.getChildCount();
        for (int i = 0; i < size; ++i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getChildAt(i);
            if (child == null) continue;
            parentNode.add(this.cloneTreeNode(child));
        }
        return parentNode;
    }

    private DefaultMutableTreeNode cloneDataTypeTreeNode(DefaultMutableTreeNode node, IObjectTypeEnum objectType) {
        Pair pair;
        DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)node.clone();
        if (parentNode instanceof TickableTreeNode && !parentNode.getUserObject().equals("root") && !this.layout.isBasicDataType((IDataTypeEnum)(pair = (Pair)((TickableTreeNode)parentNode).getUserObject()).getKey(), objectType)) {
            return null;
        }
        int size = node.getChildCount();
        for (int i = 0; i < size; ++i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getChildAt(i);
            DefaultMutableTreeNode cloneDataTypeTreeNode = this.cloneDataTypeTreeNode(child, objectType);
            if (cloneDataTypeTreeNode == null) continue;
            parentNode.add(cloneDataTypeTreeNode);
        }
        return parentNode;
    }

    private void tickAllNode(DefaultMutableTreeNode treeNode) {
        if (treeNode instanceof TickableTreeNode && !treeNode.getUserObject().equals("root")) {
            ((TickableTreeNode)treeNode).setTicked(true);
        }
        int size = treeNode.getChildCount();
        for (int i = 0; i < size; ++i) {
            this.tickAllNode((DefaultMutableTreeNode)treeNode.getChildAt(i));
        }
    }

    protected Map<IPerfStatObjectType, List<Object>> getPerfStatObjectTypes() {
        return this.getCurrentDataSource().getPerfStatObjectTypes();
    }

    protected Map<IObjectTypeEnum, DefaultMutableTreeNode> getObjectTypeToObjectsMap(Map<IPerfStatObjectType, List<Object>> map) {
        return this.getCurrentDataSource().getObjectTypeToObjectsMap(map);
    }

    @Override
    public String getDeviceID() {
        return this.deviceID;
    }

    @Override
    public void updateProperty(int updateMode) {
        this.initDeviceList();
        List<Pair<String, String>> tempNamePair = PerfStatUtil.getDeviceIDNamePair(this.deviceList);
        if (!this.isSameNameParis(this.namePair, tempNamePair)) {
            this.namePair = tempNamePair;
            this.initDeviceNames(this.namePair);
        }
        if (updateMode == 0) {
            this.trigerQueryPerfStatStrategyTask();
            this.startQueryPerfStatStrategyTask();
        }
    }

    private boolean isSameNameParis(List<Pair<String, String>> namePairs1, List<Pair<String, String>> namePairs2) {
        int pairSize = namePairs1.size();
        if (namePairs2.size() != pairSize) {
            return false;
        }
        while (pairSize-- > 0) {
            Pair<String, String> pair = namePairs1.get(pairSize);
            Pair<String, String> tempPair = namePairs2.get(pairSize);
            if (pair.getKey().equals(tempPair.getKey()) && pair.getValue().equals(tempPair.getValue())) continue;
            return false;
        }
        return true;
    }

    @Override
    public String getHelpKey() {
        return "monitor_realtime_performance";
    }

    private void setStrategyAndSwitchStatus(final Map<Object, Object> strategyAndSwitchStatus) {
        SwingUtil.runInEventDispatchThread(new Runnable(){

            @Override
            public void run() {
                if (PerfStatRealTimePane.this.isPerformanceSwitchOn(strategyAndSwitchStatus)) {
                    PerfStatRealTimePane.this.layout.setNormalDesc(ResourceManager.getStringWithParams("perfstat.realtime.desc.normal.open", 5));
                    PerfStatRealTimePane.this.layout.setAdvanceDesc(ResourceManager.getString("perfstat.realtime.desc.advance.open"));
                    PerfStatRealTimePane.this.layout.getPeriodValueLabel().setText("" + PerfStatRealTimePane.this.getSamplingInterval(strategyAndSwitchStatus));
                } else {
                    PerfStatRealTimePane.this.layout.setNormalDesc(ResourceManager.getStringWithParams("perfstat.realtime.desc.normal.close", 5));
                    PerfStatRealTimePane.this.layout.setAdvanceDesc(ResourceManager.getString("perfstat.realtime.desc.advance.close"));
                    PerfStatRealTimePane.this.layout.getPeriodValueLabel().setText("--");
                }
            }
        });
    }

    protected long getSamplingInterval() {
        return this.getCurrentDataSource().getSamplingInterval();
    }

    protected Map<Object, Object> getStrategyAndSwitchStatus() {
        return this.getCurrentDataSource().getStrategyAndSwitchStatus();
    }

    protected Map<Object, Object> syncGetStrategyAndSwitchStatus() {
        return this.getCurrentDataSource().syncGetStrategyAndSwitchStatus();
    }

    private boolean isPerformanceSwitchOn(Map<Object, Object> strategyAndSwitchStatus) {
        return (Long)strategyAndSwitchStatus.get("isPerformanceSwitchOn") == 1L;
    }

    private long getSamplingInterval(Map<Object, Object> strategyAndSwitchStatus) {
        return (Long)strategyAndSwitchStatus.get("samplingInterval");
    }

    private void addHandler() {
        this.layout.getJEditorPane().addHyperlinkListener(this.createStatStrategyHypeLinkListener());
        this.layout.getAdvanceObjectsTree().addTreeSelectionListener(this.createAdvanceObjectTreeSelectionListener());
        this.layout.getAdvanceObjectsTree().addTreeTickListener(this.createAdvanceObjectTreeTickListener());
        this.layout.getAdvanceDataTypeTree().addTreeTickListener(this.createAdvanceDataTypeTickTreeListener());
        this.layout.getAdvanceDataTypeComboBox().addItemListener(this.createDataTypeComboBoxListener());
        this.layout.getNormalObjectsTree().addTreeSelectionListener(this.createNormalObjectTreeSelectionListener());
        this.layout.getNormalObjectsTree().addTreeTickListener(this.createNormalObjectTreeTickListener());
        this.layout.getNormalDataTypeTree().addTreeTickListener(this.createNormalDataTypeTickTreeListener());
    }

    private ItemListener createDataTypeComboBoxListener() {
        ItemListener listener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                PerfStatRealTimePane.this.layout.refreshAdvanceDataTypes();
            }
        };
        return listener;
    }

    private void initDeviceComboBoxListener() {
        this.deviceComboBoxlistener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    PerfStatRealTimePane.this.trigerQueryPerfStatStrategyTask();
                    PerfStatRealTimePane.this.initSelectedDeviceData();
                }
            }
        };
    }

    private TreeSelectionListener createAdvanceObjectTreeSelectionListener() {
        TreeSelectionListener listener = new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                IPerfStatObject perfObject = PerfStatRealTimePane.this.layout.getAdvanceSelectedPerfStatObjectInTree();
                if (perfObject != null) {
                    IObjectTypeEnum objectType = perfObject.getObjectType();
                    if (!perfObject.getObjectType().equals(PerfStatRealTimePane.this.advancePreviousSelectedObjectTypeEnum)) {
                        PerfStatRealTimePane.this.advancePreviousSelectedObjectTypeEnum = objectType;
                        PerfStatRealTimePane.this.setDataTypeCategories();
                        DefaultMutableTreeNode dataTypesNode = PerfStatRealTimePane.this.getAdvanceDataTypesNode(objectType);
                        PerfStatRealTimePane.this.layout.setAdvanceDataTypes(dataTypesNode, objectType);
                    }
                } else {
                    PerfStatRealTimePane.this.setDataTypeCategories();
                    PerfStatRealTimePane.this.advancePreviousSelectedObjectTypeEnum = null;
                    PerfStatRealTimePane.this.layout.setAdvanceDataTypes(new DefaultMutableTreeNode("root"), null);
                }
            }
        };
        return listener;
    }

    private TreeSelectionListener createNormalObjectTreeSelectionListener() {
        TreeSelectionListener listener = new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                IPerfStatObject perfObject = PerfStatRealTimePane.this.layout.getNormalSelectedPerfStatObjectInTree();
                if (perfObject != null) {
                    IObjectTypeEnum objectType = perfObject.getObjectType();
                    if (!perfObject.getObjectType().equals(PerfStatRealTimePane.this.normalPreviousSelectedObjectTypeEnum)) {
                        PerfStatRealTimePane.this.normalPreviousSelectedObjectTypeEnum = objectType;
                        PerfStatRealTimePane.this.setDataTypeCategories();
                        DefaultMutableTreeNode dataTypesNode = PerfStatRealTimePane.this.getNormalDataTypesNode(objectType);
                        PerfStatRealTimePane.this.layout.setNormalDataTypes(dataTypesNode, objectType);
                    }
                } else {
                    PerfStatRealTimePane.this.setDataTypeCategories();
                    PerfStatRealTimePane.this.normalPreviousSelectedObjectTypeEnum = null;
                    PerfStatRealTimePane.this.layout.setNormalDataTypes(new DefaultMutableTreeNode("root"), null);
                }
            }
        };
        return listener;
    }

    protected void setDataTypeCategories() {
        List<Pair<String, String>> list = this.getCurrentDataSource().getDataTypeCategories(this.layout);
        this.layout.getAdvanceDataTypeComboBox().removeAllItems();
        for (Pair<String, String> temp : list) {
            this.getPerfStatLayout().getAdvanceDataTypeComboBox().addItem(temp);
        }
    }

    private DefaultMutableTreeNode getAdvanceDataTypesNode(IObjectTypeEnum objectType) {
        DefaultMutableTreeNode root = this.advanceObjectTypeToDataTypeTreeNodeMapping.get(objectType);
        if (root == null) {
            root = new DefaultMutableTreeNode("root");
        }
        return root;
    }

    private DefaultMutableTreeNode getNormalDataTypesNode(IObjectTypeEnum objectType) {
        DefaultMutableTreeNode root = this.normalObjectTypeToDataTypeTreeNodeMapping.get(objectType);
        if (root == null) {
            root = new DefaultMutableTreeNode("root");
        }
        return root;
    }

    private List<IPerfStatObject> getTickObjects(IObjectTypeEnum objectType, List<TickableTreeNode> tickObjectTreeNodeList) {
        ArrayList<IPerfStatObject> tickObjects = new ArrayList<IPerfStatObject>(0);
        Pair pair = null;
        IPerfStatObject perfStatObject = null;
        for (TickableTreeNode node : tickObjectTreeNodeList) {
            pair = (Pair)node.getUserObject();
            perfStatObject = (IPerfStatObject)pair.getKey();
            if (!objectType.equals(perfStatObject.getObjectType())) continue;
            tickObjects.add(perfStatObject);
            perfStatObject.setColor(node.getColor());
        }
        return tickObjects;
    }

    private List<TableRow> getRemoveTableRows(IObjectTypeEnum selectObjectType, List<IDataTypeEnum> tickDataTypeList, List<TickableTreeNode> tickTreeNodeList) {
        ArrayList<TableRow> removeRows = new ArrayList<TableRow>(0);
        for (TickableTreeNode node : tickTreeNodeList) {
            Pair pair = (Pair)node.getUserObject();
            String name = (String)pair.getValue();
            for (IDataTypeEnum tickDataType : tickDataTypeList) {
                String rowKey = Tools.generateStatItemKey(selectObjectType, name, tickDataType);
                int index = this.layout.getTableMode().getRowIndex(rowKey);
                if (index < 0) continue;
                removeRows.add(this.layout.getTableMode().getRow(index));
            }
        }
        return removeRows;
    }

    private List<IPerfStatObject> getNewRows(IObjectTypeEnum selectObjectType, IDataTypeEnum tickDataType, List<TickableTreeNode> tickTreeNodeList) {
        if (this.layout.getTableMode().getRowCount() == 0) {
            return this.getTickObjects(selectObjectType, tickTreeNodeList);
        }
        ArrayList<IPerfStatObject> newList = new ArrayList<IPerfStatObject>(0);
        String tableRowKey = null;
        for (IPerfStatObject iPerfStatObject : this.getTickObjects(selectObjectType, tickTreeNodeList)) {
            tableRowKey = Tools.generateStatItemKey(selectObjectType, iPerfStatObject.getText(), tickDataType);
            int tableIndex = this.layout.getTableMode().getRowIndex(tableRowKey);
            if (tableIndex >= 0) continue;
            newList.add(iPerfStatObject);
        }
        if (newList.isEmpty()) {
            return null;
        }
        return newList;
    }

    private boolean isTooManyStatItemsAdvance(int newRowCount) {
        if (newRowCount + this.layout.getTableMode().getRowCount() > 16) {
            DialogUtils.showInfoDialog(this.getParentWindow(), ResourceManager.getStringWithParams("perf.warning.tooManyStatItem", String.valueOf(16)));
            return true;
        }
        return false;
    }

    private boolean isTooManyStatItemsNormal() {
        if (this.normalSelectedObjectSet.size() >= 5) {
            DialogUtils.showInfoDialog(this.getParentWindow(), ResourceManager.getStringWithParams("perf.warning.tooManyStatItem.normal", String.valueOf(5)));
            return true;
        }
        return false;
    }

    private boolean isSwitchOn() {
        if (this.isPerformanceSwitchOn(this.syncGetStrategyAndSwitchStatus())) {
            return true;
        }
        if (DialogUtils.showYesNoDialog(this.getParentWindow(), ResourceManager.getString("OPEN_PERFORMANCE_SWITCH_PROMPT")).getValue() == 0) {
            this.showSettingDialog();
        }
        return this.isPerformanceSwitchOn(this.syncGetStrategyAndSwitchStatus());
    }

    private TickableTree.TreeTickListener createAdvanceObjectTreeTickListener() {
        TickableTree.TreeTickListener listener = new TickableTree.TreeTickListener(){

            @Override
            public void treeTicked(TickableTree.TreeTickEvent e) {
                TickableTreeNode tickTreeNode = e.getCurrentNode();
                IObjectTypeEnum objectType = ((IPerfStatObject)((Pair)tickTreeNode.getUserObject()).getKey()).getObjectType();
                List<TickableTreeNode> tickTreeNodeList = new ArrayList<TickableTreeNode>(0);
                List dataTypeEnumList = (List)PerfStatRealTimePane.this.objectTypeToSelectedDataTypeMapping.get(objectType);
                if (tickTreeNode.isTicked()) {
                    tickTreeNode.setTicked(false);
                    if (!PerfStatRealTimePane.this.isSwitchOn()) {
                        return;
                    }
                    tickTreeNode.setTicked(true);
                    if (dataTypeEnumList == null || dataTypeEnumList.isEmpty()) {
                        return;
                    }
                    if (PerfStatRealTimePane.this.isTooManyStatItemsAdvance(dataTypeEnumList.size())) {
                        tickTreeNode.setTicked(false);
                        return;
                    }
                    tickTreeNodeList = PerfStatRealTimePane.this.layout.getAdvanceObjectsTree().getTickedTreeNodes();
                    PerfStatRealTimePane.this.addAdvanceStatItems(objectType, PerfStatRealTimePane.this.getTickObjects(objectType, tickTreeNodeList), dataTypeEnumList);
                } else {
                    tickTreeNodeList.add(tickTreeNode);
                    if (dataTypeEnumList == null || dataTypeEnumList.isEmpty()) {
                        return;
                    }
                    List needRemoveTableRow = PerfStatRealTimePane.this.getRemoveTableRows(objectType, dataTypeEnumList, tickTreeNodeList);
                    PerfStatRealTimePane.this.removeLegendRows(needRemoveTableRow);
                }
            }
        };
        return listener;
    }

    private TickableTree.TreeTickListener createNormalObjectTreeTickListener() {
        TickableTree.TreeTickListener listener = new TickableTree.TreeTickListener(){

            @Override
            public void treeTicked(TickableTree.TreeTickEvent e) {
                TickableTreeNode tickTreeNode = e.getCurrentNode();
                IPerfStatObject perfStatObject = (IPerfStatObject)((Pair)tickTreeNode.getUserObject()).getKey();
                perfStatObject.setColor(tickTreeNode.getColor());
                IObjectTypeEnum objectType = perfStatObject.getObjectType();
                ArrayList<IPerfStatObject> tickPerfStatObjectList = new ArrayList<IPerfStatObject>(0);
                tickPerfStatObjectList.add(perfStatObject);
                DefaultMutableTreeNode dataTypeNode = (DefaultMutableTreeNode)PerfStatRealTimePane.this.normalObjectTypeToDataTypeTreeNodeMapping.get(objectType);
                List dataTypeEnumList = PerfStatRealTimePane.this.getTickedDataTypes(dataTypeNode);
                if (tickTreeNode.isTicked()) {
                    tickTreeNode.setTicked(false);
                    if (!PerfStatRealTimePane.this.isSwitchOn()) {
                        return;
                    }
                    tickTreeNode.setTicked(true);
                    if (PerfStatRealTimePane.this.isTooManyStatItemsNormal()) {
                        tickTreeNode.setTicked(false);
                        return;
                    }
                    if (dataTypeEnumList == null || dataTypeEnumList.isEmpty()) {
                        PerfStatRealTimePane.this.normalSelectedObjectSet.add(perfStatObject);
                        return;
                    }
                    PerfStatRealTimePane.this.normalSelectedObjectSet.add(perfStatObject);
                    PerfStatRealTimePane.this.addNormalStatItems(tickPerfStatObjectList, dataTypeEnumList);
                } else {
                    PerfStatRealTimePane.this.normalSelectedObjectSet.remove(perfStatObject);
                    PerfStatRealTimePane.this.removeNormalStatItems(tickPerfStatObjectList, dataTypeEnumList, PerfStatUtil.existCurrentObjectType(perfStatObject.getObjectType(), PerfStatRealTimePane.this.normalSelectedObjectSet));
                }
            }
        };
        return listener;
    }

    private TickableTree.TreeTickListener createAdvanceDataTypeTickTreeListener() {
        TickableTree.TreeTickListener listener = new TickableTree.TreeTickListener(){

            @Override
            public void treeTicked(TickableTree.TreeTickEvent e) {
                TickableTreeNode node = e.getCurrentNode();
                IDataTypeEnum tickDataType = (IDataTypeEnum)((Pair)node.getUserObject()).getKey();
                IPerfStatObject perfStatObject = PerfStatRealTimePane.this.layout.getAdvanceSelectedPerfStatObjectInTree();
                if (perfStatObject == null) {
                    return;
                }
                IObjectTypeEnum selectObjectType = perfStatObject.getObjectType();
                List<TickableTreeNode> tickNodeList = PerfStatRealTimePane.this.layout.getAdvanceObjectsTree().getTickedTreeNodes();
                ArrayList<IDataTypeEnum> selectedDataTypes = new ArrayList<IDataTypeEnum>(0);
                if (!PerfStatRealTimePane.this.objectTypeToSelectedDataTypeMapping.containsKey(selectObjectType)) {
                    PerfStatRealTimePane.this.objectTypeToSelectedDataTypeMapping.put(selectObjectType, selectedDataTypes);
                }
                if (node.isTicked()) {
                    node.setTicked(false);
                    if (!PerfStatRealTimePane.this.isSwitchOn()) {
                        return;
                    }
                    node.setTicked(true);
                    List newList = PerfStatRealTimePane.this.getNewRows(selectObjectType, tickDataType, tickNodeList);
                    if (newList == null || newList.isEmpty()) {
                        ((List)PerfStatRealTimePane.this.objectTypeToSelectedDataTypeMapping.get(selectObjectType)).add(tickDataType);
                        return;
                    }
                    if (PerfStatRealTimePane.this.isTooManyStatItemsAdvance(newList.size())) {
                        node.setTicked(false);
                        return;
                    }
                    ((List)PerfStatRealTimePane.this.objectTypeToSelectedDataTypeMapping.get(selectObjectType)).add(tickDataType);
                    PerfStatRealTimePane.this.addAdvanceStatItems(selectObjectType, newList, (List)PerfStatRealTimePane.this.objectTypeToSelectedDataTypeMapping.get(selectObjectType));
                } else {
                    ((List)PerfStatRealTimePane.this.objectTypeToSelectedDataTypeMapping.get(selectObjectType)).remove(tickDataType);
                    selectedDataTypes.clear();
                    selectedDataTypes.add(tickDataType);
                    List removeRows = PerfStatRealTimePane.this.getRemoveTableRows(selectObjectType, selectedDataTypes, tickNodeList);
                    PerfStatRealTimePane.this.removeLegendRows(removeRows);
                }
            }
        };
        return listener;
    }

    private TickableTree.TreeTickListener createNormalDataTypeTickTreeListener() {
        TickableTree.TreeTickListener listener = new TickableTree.TreeTickListener(){

            @Override
            public void treeTicked(TickableTree.TreeTickEvent e) {
                TickableTreeNode node = e.getCurrentNode();
                IDataTypeEnum tickDataType = (IDataTypeEnum)((Pair)node.getUserObject()).getKey();
                IPerfStatObject perfStatObject = PerfStatRealTimePane.this.layout.getNormalSelectedPerfStatObjectInTree();
                if (perfStatObject == null) {
                    return;
                }
                IObjectTypeEnum selectObjectType = perfStatObject.getObjectType();
                List<TickableTreeNode> tickNodeList = PerfStatRealTimePane.this.layout.getNormalObjectsTree().getTickedTreeNodes();
                ArrayList<IDataTypeEnum> dataTypeEnumList = new ArrayList<IDataTypeEnum>();
                dataTypeEnumList.add(tickDataType);
                if (node.isTicked()) {
                    node.setTicked(false);
                    if (!PerfStatRealTimePane.this.isSwitchOn()) {
                        return;
                    }
                    node.setTicked(true);
                    PerfStatRealTimePane.this.addNormalStatItems(PerfStatRealTimePane.this.getTickObjects(selectObjectType, tickNodeList), dataTypeEnumList);
                } else {
                    PerfStatRealTimePane.this.removeNormalStatItems(PerfStatRealTimePane.this.getTickObjects(selectObjectType, tickNodeList), dataTypeEnumList, true);
                }
            }
        };
        return listener;
    }

    private void initAdvanceObjectTypeComboBoxListener() {
        this.advanceItemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getID() == 701 && itemEvent.getStateChange() == 1) {
                    PerfStatRealTimePane.this.perfStatObjectTypeToMOMap = PerfStatRealTimePane.this.getPerfStatObjectTypes();
                    PerfStatRealTimePane.this.advanceObjectTypeToObjectsMapping = PerfStatUtil.createNewObjectTypeToObjectsMapping(PerfStatRealTimePane.this.advanceObjectTypeToObjectsMapping, PerfStatRealTimePane.this.getObjectTypeToObjectsMap(PerfStatRealTimePane.this.perfStatObjectTypeToMOMap), PerfStatRealTimePane.this.perfStatObjectTypeToMOMap);
                    PerfStatRealTimePane.this.advanceObjectTypeComboBoxChanged();
                }
            }
        };
    }

    private void initNormalObjectTypeComboBoxListener() {
        this.normalItemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getID() == 701 && itemEvent.getStateChange() == 1) {
                    if (!this.needChangeObjectType()) {
                        return;
                    }
                    PerfStatRealTimePane.this.lastSelectobjectTypePair = PerfStatRealTimePane.this.layout.getNormalObjectTypeComboBox().getSelectedItem();
                    PerfStatRealTimePane.this.clearNormalChart();
                    PerfStatRealTimePane.this.perfStatObjectTypeToMOMap = PerfStatRealTimePane.this.getPerfStatObjectTypes();
                    PerfStatRealTimePane.this.normalObjectTypeToObjectsMapping = PerfStatUtil.createNewObjectTypeToObjectsMapping(PerfStatRealTimePane.this.normalObjectTypeToObjectsMapping, PerfStatRealTimePane.this.getObjectTypeToObjectsMap(PerfStatRealTimePane.this.perfStatObjectTypeToMOMap), PerfStatRealTimePane.this.perfStatObjectTypeToMOMap);
                    PerfStatRealTimePane.this.normalObjectTypeComboBoxChanged();
                }
            }

            private boolean needChangeObjectType() {
                if (PerfStatRealTimePane.this.isShowAgain && !PerfStatRealTimePane.this.normalSelectedObjectSet.isEmpty()) {
                    return this.needChageObjectTypeDegread();
                }
                return true;
            }

            private boolean needChageObjectTypeDegread() {
                ConfirmDialog confirmDilaog = ConfirmDialog.showDialog(Framework.getInstance().getMainFrame(), ConfirmDialog.Level.INFO, ResourceManager.getString("PERFSTAT_SWITCH_STAT_NOTICE"), false, ResourceManager.getString("PERFSTAT_SWITCH_STAT_OBJECT_TIP"), "", "", new String[0]);
                if (confirmDilaog.getIsConfirmPerformed()) {
                    if (confirmDilaog.getIsSelectedLinkage()) {
                        PerfStatRealTimePane.this.isShowAgain = false;
                    }
                    return true;
                }
                if (null != PerfStatRealTimePane.this.lastSelectobjectTypePair) {
                    PerfStatRealTimePane.this.layout.getNormalObjectTypeComboBox().removeItemListener(PerfStatRealTimePane.this.normalItemListener);
                    PerfStatRealTimePane.this.layout.getNormalObjectTypeComboBox().setSelectedItem(PerfStatRealTimePane.this.lastSelectobjectTypePair);
                    PerfStatRealTimePane.this.layout.getNormalObjectTypeComboBox().addItemListener(PerfStatRealTimePane.this.normalItemListener);
                }
                return false;
            }
        };
    }

    protected void advanceObjectTypeComboBoxChanged() {
        this.getCurrentDataSource().objectTypeComboBoxChanged(this);
        IObjectTypeEnum objectType = this.layout.getAdvanceSelectedObjectType();
        if (objectType == null) {
            return;
        }
        DefaultMutableTreeNode objectsNode = this.advanceObjectTypeToObjectsMapping.get(objectType);
        this.setDataTypeCategories();
        this.layout.setAdvanceObjects(objectsNode);
    }

    protected void normalObjectTypeComboBoxChanged() {
        this.getCurrentDataSource().objectTypeComboBoxChanged(this);
        IObjectTypeEnum objectType = this.layout.getNormalSelectedObjectType();
        if (objectType == null) {
            return;
        }
        DefaultMutableTreeNode objectsNode = this.normalObjectTypeToObjectsMapping.get(objectType);
        this.layout.setNormalObjects(objectsNode);
    }

    private HyperlinkListener createStatStrategyHypeLinkListener() {
        HyperlinkListener listener = new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    try {
                        PerfStatRealTimePane.this.showSettingDialog();
                    }
                    catch (Exception ex) {
                        LOGGER.error("open the setting dialogerror" + ex);
                        DialogUtils.showErrorDialog(Framework.getInstance().getMainFrame(), (Throwable)new IsmException(-1L));
                    }
                }
            }
        };
        return listener;
    }

    private void showSettingDialog() {
        if (!this.checkSystemStauts()) {
            return;
        }
        String reason = CommonUtil.checkUserLevel(this.layout.getCurrentDeviceID(), User.Level.Admin);
        if (null != reason) {
            DialogUtils.showErrorDialog((Window)this.getParentWindow(), reason);
            return;
        }
        PerfStatStrategySettingDialog perfStatStrategySettingDialog = this.getPerfStatStrategySettingDialog();
        perfStatStrategySettingDialog.setVisible(true);
        this.trigerQueryPerfStatStrategyTask();
    }

    protected PerfStatStrategySettingDialog getPerfStatStrategySettingDialog() {
        return this.getCurrentDataSource().getPerfStatStrategySettingDialog();
    }

    private void removeSeriesByRow(TableRow tableRow) {
        String key = (String)tableRow.getIdentifier();
        IPerfStatObject removeObj = null;
        String name = null;
        String identifier = null;
        for (IPerfStatObject obj : this.advanceQueryPerfStatDataTask.statObjects) {
            name = obj.getText();
            identifier = obj.getObjectType().getDescription() + "_" + name + "_" + obj.getDataType().getDescription();
            if (!identifier.equals(key)) continue;
            removeObj = obj;
        }
        this.advanceQueryPerfStatDataTask.statObjects.remove(removeObj);
        ObjectKeeper.removeDataObject(removeObj);
        this.layout.getStatViewPanel().removeSeriesByKey(key);
        this.currentScales.remove(key);
    }

    private AdvancePerfStatXYToolTipGenerator createAdvanceToolTipGenerator() {
        DecimalFormat numberFormat = new DecimalFormat("###,###,###,###,##0.0000000000");
        AdvancePerfStatXYToolTipGenerator generator = new AdvancePerfStatXYToolTipGenerator(Tools.generateDateFormat(this.layout.getStatViewPanel().getTimeZone()), numberFormat, this.layout.getTableMode(), this.currentScales);
        return generator;
    }

    private NormalPerfStatXYToolTipGenerator createNormalToolTipGenerator() {
        NormalPerfStatXYToolTipGenerator generator = new NormalPerfStatXYToolTipGenerator(this.layout.getNormalPerfStatPanel(), Tools.generateDateFormat(this.layout.getNormalPerfStatPanel().getTimeZone()), NumberFormat.getInstance());
        return generator;
    }

    private void addTimeSeriesData(String text, XYTimeSeriesData data) {
        this.layout.getStatViewPanel().addOrUpdateData(text, data);
        Date maxDate = this.layout.getStatViewPanel().getAxisX().getMaximumDate();
        maxDate.setTime(maxDate.getTime() + 1L);
        this.layout.getStatViewPanel().getAxisX().setMaximumDate(maxDate);
    }

    private void trigerQueryPerfStatStrategyTask() {
        if (this.queryPerfStatStrategyTask != null) {
            this.scheduledTimer.execute(this.queryPerfStatStrategyTask);
        }
    }

    private void trigerAdvanceQueryPerfStatDataTask() {
        if (this.advanceQueryPerfStatDataTask != null) {
            this.scheduledTimer.execute(this.advanceQueryPerfStatDataTask);
        }
    }

    private void trigerNormalQueryPerfStatDataTask() {
        if (this.normalQueryPerfStatDataTask != null) {
            this.scheduledTimer.execute(this.normalQueryPerfStatDataTask);
        }
    }

    private void startQueryPerfStatStrategyTask() {
        if (this.queryPerfStatStrategyFuture == null) {
            this.queryPerfStatStrategyFuture = this.scheduledTimer.scheduleAtFixedRate(this.queryPerfStatStrategyTask, 0L, 60L, TimeUnit.SECONDS);
        }
    }

    private void startQueryPerfStatDataTask(long sampleInterval) {
        if (this.advanceScheduledFuture == null) {
            this.advanceScheduledFuture = this.scheduledTimer.scheduleAtFixedRate(this.advanceQueryPerfStatDataTask, 0L, sampleInterval, TimeUnit.SECONDS);
        }
        if (this.normalScheduledFuture == null) {
            this.normalScheduledFuture = this.scheduledTimer.scheduleAtFixedRate(this.normalQueryPerfStatDataTask, 0L, sampleInterval, TimeUnit.SECONDS);
        }
    }

    private void stopPerfStatTask() {
        if (null != this.advanceScheduledFuture && this.advanceScheduledFuture.cancel(true)) {
            this.advanceScheduledFuture = null;
        }
        if (null != this.normalScheduledFuture && this.normalScheduledFuture.cancel(true)) {
            this.normalScheduledFuture = null;
        }
        this.scheduledTimer.purge();
    }

    private synchronized boolean isQueryPerfStatDataTaskStopped() {
        if (this.advanceScheduledFuture == null && this.normalScheduledFuture == null) {
            return true;
        }
        if (this.advanceScheduledFuture == null && this.normalScheduledFuture != null) {
            return this.normalScheduledFuture.isCancelled();
        }
        if (this.advanceScheduledFuture != null && this.normalScheduledFuture == null) {
            return this.advanceScheduledFuture.isCancelled();
        }
        if (this.advanceScheduledFuture != null && this.normalScheduledFuture != null) {
            return this.advanceScheduledFuture.isCancelled() && this.normalScheduledFuture.isCancelled();
        }
        return true;
    }

    private void initAdvanceStatView() {
        TimeZone deviceTimeZone = this.getTimeZone();
        this.layout.getStatViewPanel().setTimeZone(deviceTimeZone);
        this.layout.getStatViewPanel().setToolTipGenerator((XYToolTipGenerator)this.createAdvanceToolTipGenerator());
        this.layout.getStatViewPanel().setAutoRange(this.getSamplingInterval() * 1000L * 60L + 2L);
        SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss");
        this.layout.getStatViewPanel().setDateAxisFormat(dateFormat);
    }

    private void initNormalStatView() {
        TimeZone deviceTimeZone = this.getTimeZone();
        this.layout.getNormalPerfStatPanel().setTimeZone(deviceTimeZone);
        this.layout.getNormalPerfStatPanel().setToolTipGenerator(this.createNormalToolTipGenerator());
        this.layout.getNormalPerfStatPanel().setAutoRange(this.getSamplingInterval() * 1000L * 60L + 2L);
        SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss");
        this.layout.getNormalPerfStatPanel().setDateAxisFormat(dateFormat);
    }

    private TimeZone getTimeZone() {
        TimeZone timeZone = null;
        try {
            timeZone = this.getCurrentDataSource().getTimeZone();
        }
        catch (Exception e) {
            timeZone = TimeZone.getDefault();
            LOGGER.error("get TimeZone encounter error:" + e.getMessage(), (Throwable)e);
        }
        return timeZone;
    }

    protected Frame getParentWindow() {
        Frame parent = (Frame)SwingUtilities.getWindowAncestor(this.layout);
        return parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPerfStatStrategy() {
        Thread.currentThread().setName("Performance Statistic Strategy Thread Begin:" + this.layout.getCurrentDeviceID());
        try {
            String previousPeriod = this.layout.getPeriodValueLabel().getText();
            Map<Object, Object> strategyAndSwitchStatus = this.getStrategyAndSwitchStatus();
            Object object = this.LOCK;
            synchronized (object) {
                this.setStrategyAndSwitchStatus(strategyAndSwitchStatus);
                if (this.isPerformanceSwitchOn(strategyAndSwitchStatus)) {
                    long sampleInterval = this.getSamplingInterval(strategyAndSwitchStatus);
                    if (!("" + sampleInterval).equals(previousPeriod)) {
                        this.stopPerfStatTask();
                        this.startQueryPerfStatDataTask(sampleInterval);
                    }
                } else if (!this.isQueryPerfStatDataTaskStopped()) {
                    this.stopPerfStatTask();
                    String tip = MessageFormat.format(ResourceManager.getString("PERFORMANCE_STAT_SWITCH_OFF_TIP"), CommonUtil.getDeviceName(this.layout.getCurrentDeviceID()));
                    this.showDialog(tip);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Performance statistic Strategy scheduled task encounter error:" + e.getMessage(), (Throwable)e);
        }
        Thread.currentThread().setName("Performance Statistic Strategy Thread End:" + this.layout.getCurrentDeviceID());
    }

    private void showDialog(final String tip) {
        if (null != this.infoDialog && this.infoDialog.isShowing()) {
            return;
        }
        SwingUtil.runInEventDispatchThread(new Runnable(){

            @Override
            public void run() {
                if (null != PerfStatRealTimePane.this.getParentWindow()) {
                    PerfStatRealTimePane.this.infoDialog = new InformationDialog(PerfStatRealTimePane.this.getParentWindow(), tip);
                    PerfStatRealTimePane.this.infoDialog.setVisible(!Utils.isJunitTest());
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void advanceProcessPerfStatData(List<IPerfStatObject> statObjects) {
        Thread.currentThread().setName("Performance Statistic Data Thread Begin");
        try {
            List<IPerfStatData> perfStats = this.getPerfStats(statObjects);
            this.initAdvanceStatView();
            AdvanceQueryPerfStatDataTask advanceQueryPerfStatDataTask = this.advanceQueryPerfStatDataTask;
            synchronized (advanceQueryPerfStatDataTask) {
                this.drawGraph(perfStats);
            }
        }
        catch (Exception e) {
            LOGGER.error("Performance statistic Data scheduled task encounter error:" + e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void normalProcessPerfStatData(List<IPerfStatObject> statObjects) {
        Thread.currentThread().setName("Performance Statistic Data Thread Begin");
        try {
            List<IPerfStatData> perfStats = this.getPerfStats(statObjects);
            this.initNormalStatView();
            NormalQueryPerfStatDataTask normalQueryPerfStatDataTask = this.normalQueryPerfStatDataTask;
            synchronized (normalQueryPerfStatDataTask) {
                for (IPerfStatData perfStatValue : perfStats) {
                    IPerfStatObject statObject = perfStatValue.getStatObject();
                    statObject.setColor(perfStatValue.getColor());
                    if (!this.isSelected(statObject)) continue;
                    XYTimeSeriesData data = new XYTimeSeriesData(perfStatValue.getTime(), null == perfStatValue.getValue() ? Double.valueOf(0.0) : perfStatValue.getValue());
                    this.layout.getNormalPerfStatPanel().addOrUpdateData(statObject, data);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Performance statistic Data scheduled task encounter error:" + e.getMessage(), (Throwable)e);
        }
    }

    private boolean isSelected(IPerfStatObject perfStatObject) {
        for (IPerfStatObject obj : this.normalSelectedObjectSet) {
            if (!obj.getObjectType().equals(perfStatObject.getObjectType()) || !obj.getText().equals(perfStatObject.getText())) continue;
            return true;
        }
        return false;
    }

    protected List<IPerfStatData> getPerfStats(List<IPerfStatObject> statObjects) {
        return this.getCurrentDataSource().getPerfStats(statObjects);
    }

    private void drawGraph(List<IPerfStatData> perfStats) {
        String serialName = null;
        XYTimeSeriesData data = null;
        TableRow<?, ?> row = null;
        IsmTableCell.ComboBoxCell cell = null;
        String selectedScaleString = null;
        for (IPerfStatData perfStatValue : perfStats) {
            serialName = perfStatValue.getStatObject().getObjectType().getDescription() + "_" + perfStatValue.getStatObject().getText() + "_" + perfStatValue.getStatObject().getDataType().getDescription();
            double currentScale = this.currentScales.get(serialName);
            data = new XYTimeSeriesData(perfStatValue.getTime(), perfStatValue.getValue() * currentScale);
            this.addTimeSeriesData(serialName, data);
            row = this.layout.getTableMode().getTableRowBy(serialName);
            cell = (IsmTableCell.ComboBoxCell)row.getValueAt(3);
            selectedScaleString = cell.toString();
            if (selectedScaleString.indexOf(ResourceManager.getString("perf.ui.scale.autoAdapt")) == -1) continue;
            this.processAutoScale(serialName, currentScale, cell);
        }
        this.setLineColor();
    }

    private void processAutoScale(String serialName, Double currentScale, IsmTableCell.ComboBoxCell cell) {
        TimeSeriesChart seriesChart = this.layout.getStatViewPanel();
        long firstDisplyedTimePoint = seriesChart.getAxisX().getMinimumDate().getTime();
        TimeSeries timeSeries = seriesChart.getOrCreate((Comparable<?>)((Object)serialName));
        double maxValue = this.calculateMaxYValue(timeSeries, firstDisplyedTimePoint, currentScale);
        double newScale = Tools.calculateScale(maxValue);
        Tools.scaleTimeSeries(timeSeries, currentScale, newScale);
        cell.setRendererItem(" (" + Tools.convertScaleToString(newScale) + ")");
        this.layout.repaint();
        this.currentScales.put(serialName, newScale);
    }

    private void addAdvanceStatItems(IObjectTypeEnum objectType, List<IPerfStatObject> objectTableRows, List<IDataTypeEnum> dataTypes) {
        this.addLegendRows(objectType, objectTableRows, dataTypes);
        this.trigerAdvanceQueryPerfStatDataTask();
    }

    private void addLegendRows(IObjectTypeEnum objectType, List<IPerfStatObject> iPerfStatObjects, List<IDataTypeEnum> dataTypes) {
        for (IPerfStatObject iPerfStatObject : iPerfStatObjects) {
            this.addOneObjectLegendRow(objectType, iPerfStatObject, dataTypes);
        }
    }

    private void addOneObjectLegendRow(IObjectTypeEnum objectType, IPerfStatObject iPerfStatObject, List<IDataTypeEnum> dataTypes) {
        String key = null;
        for (IDataTypeEnum dataType : dataTypes) {
            key = Tools.generateStatItemKey(objectType, iPerfStatObject.getText(), dataType);
            this.addOneObjectLegendRow2(objectType, iPerfStatObject, dataType, key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addNormalStatItems(List<IPerfStatObject> perfStatObjects, List<IDataTypeEnum> dataTypes) {
        List list = this.normalQueryPerfStatDataTask.statObjects;
        synchronized (list) {
            for (IPerfStatObject perfStatObject : perfStatObjects) {
                for (IDataTypeEnum dataType : dataTypes) {
                    IPerfStatObject statObject = this.getCurrentDataSource().getPerfStatObject(perfStatObject);
                    statObject.setDataType(dataType);
                    this.layout.getNormalPerfStatPanel().createChart(statObject);
                    this.normalQueryPerfStatDataTask.statObjects.add(statObject);
                    ObjectKeeper.addDataObject(statObject);
                }
            }
        }
        this.layout.getNormalPerfStatPanel().refreshPanel();
        this.trigerNormalQueryPerfStatDataTask();
    }

    private void addOneObjectLegendRow2(IObjectTypeEnum objectType, IPerfStatObject iPerfStatObject, IDataTypeEnum dataType, String key) {
        DefaultTableRow<IPerfStatObject, String> row = null;
        IsmTableCell.ColorTableCell colorLabelCell = null;
        JComboBox comboBox = null;
        ItemListener changeScaleListener = null;
        String text = null;
        IPerfStatObject statObject = null;
        IsmTableCell.ComboBoxCell cell = null;
        int index = this.layout.getTableMode().getRowIndex(key);
        if (index == -1) {
            row = new DefaultTableRow<IPerfStatObject, String>(PerfStatUtil.getScaleTableColNames().length, iPerfStatObject, key);
            colorLabelCell = new IsmTableCell.ColorTableCell();
            colorLabelCell.setColor(this.colorContainer.getColor());
            cell = Tools.createScaleTableCell();
            comboBox = (JComboBox)cell.getEditor().getComponent();
            changeScaleListener = this.createChangeScaleListener(key);
            comboBox.addItemListener(changeScaleListener);
            row.setValueAt(0, colorLabelCell);
            row.setValueAt(1, objectType.getDescription());
            row.setValueAt(2, iPerfStatObject.getText());
            row.setValueAt(3, cell);
            row.setValueAt(4, dataType.getDescription());
            row.setValueAt(5, dataType.getUnitDesc(CommonUtil.isXVEDevice()));
            this.layout.getTableMode().addRow(row);
            text = iPerfStatObject.getText();
            statObject = this.getCurrentDataSource().getPerfStatObject(iPerfStatObject);
            statObject.setDataType(dataType);
            statObject.setObjectType(objectType);
            statObject.setText(text);
            this.advanceQueryPerfStatDataTask.statObjects.add(statObject);
            ObjectKeeper.addDataObject(statObject);
            this.currentScales.put(key, 1.0);
        }
    }

    private ItemListener createChangeScaleListener(final String key) {
        ItemListener changeScaleListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                PerfStatRealTimePane.this.changeScale(e, key);
            }
        };
        return changeScaleListener;
    }

    private void changeScale(ItemEvent e, String key) {
        if (e.getID() == 701 && e.getStateChange() == 1) {
            JComboBox comboBox = (JComboBox)e.getSource();
            Pair selectItem = (Pair)comboBox.getSelectedItem();
            TableRow<?, ?> row = this.layout.getTableMode().getTableRowBy(key);
            IsmTableCell.ComboBoxCell cell = (IsmTableCell.ComboBoxCell)row.getValueAt(3);
            double currentScale = this.currentScales.get(key);
            double newScale = (Double)selectItem.getKey();
            if (newScale != 0.0) {
                cell.setRendererItem(null);
                TimeSeriesChart seriesChart = this.layout.getStatViewPanel();
                TimeSeries timeSeries = seriesChart.getOrCreate((Comparable<?>)((Object)key));
                Tools.scaleTimeSeries(timeSeries, currentScale, newScale);
                this.currentScales.put(key, newScale);
                this.layout.getStatViewPanel().repaint();
            } else {
                this.processAutoScale(key, currentScale, cell);
                this.layout.getStatViewPanel().repaint();
            }
        }
    }

    private void removeAllLegendRows() {
        this.removeLegendRows(this.layout.getScaleTable().getAllRows());
    }

    public void removeLegendRows(List<TableRow> rows) {
        IsmTableCell.ColorTableCell colorLabelCell = null;
        Color color = null;
        for (TableRow tableRow : rows) {
            this.layout.getTableMode().removeRow(tableRow);
            colorLabelCell = (IsmTableCell.ColorTableCell)tableRow.getValueAt(0);
            color = colorLabelCell.getColor();
            this.colorContainer.releaseColor(color);
            this.removeSeriesByRow(tableRow);
            this.setLineColor();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeNormalStatItems(List<IPerfStatObject> perfStatObjects, List<IDataTypeEnum> dataTypes, boolean isRemoveable) {
        ArrayList<IPerfStatObject> temp = new ArrayList<IPerfStatObject>();
        for (IPerfStatObject perfStatObject : perfStatObjects) {
            for (IDataTypeEnum dataType : dataTypes) {
                for (IPerfStatObject obj : this.normalQueryPerfStatDataTask.statObjects) {
                    if (!dataType.equals(obj.getDataType()) || !obj.getObjectType().equals(perfStatObject.getObjectType()) || !obj.getText().equals(perfStatObject.getText())) continue;
                    temp.add(obj);
                }
            }
        }
        List list = this.normalQueryPerfStatDataTask.statObjects;
        synchronized (list) {
            this.normalQueryPerfStatDataTask.statObjects.removeAll(temp);
            for (IPerfStatObject object : temp) {
                this.layout.getNormalPerfStatPanel().removeSeriesByKey(object, isRemoveable);
            }
            ObjectKeeper.removeDataObject(temp);
        }
        this.layout.getNormalPerfStatPanel().refreshPanel();
    }

    private void clearNormalChart() {
        List<TickableTreeNode> list = this.layout.getNormalObjectsTree().getTickedTreeNodes();
        for (TickableTreeNode node : list) {
            node.setTicked(false);
        }
        this.layout.getNormalObjectsTree().releaseAllColor();
        this.layout.getNormalPerfStatPanel().removeAllChart();
        ObjectKeeper.removeDataObject(this.normalSelectedObjectSet);
        this.normalSelectedObjectSet.clear();
        this.normalQueryPerfStatDataTask.statObjects.clear();
    }

    private void setLineColor() {
        List<TableRow> rows = this.layout.getTableMode().getAllRows();
        TableRow row = null;
        String key = null;
        IsmTableCell.ColorTableCell colorLabelCell = null;
        TimeSeriesChart seriesChart = null;
        Color color = null;
        for (int i = 0; i < rows.size(); ++i) {
            row = rows.get(i);
            key = (String)row.getIdentifier();
            colorLabelCell = (IsmTableCell.ColorTableCell)row.getValueAt(0);
            color = colorLabelCell.getColor();
            seriesChart = this.layout.getStatViewPanel();
            seriesChart.setSeriesColor((Comparable<?>)((Object)key), color);
        }
    }

    private double calculateMaxYValue(TimeSeries timeSeries, long firstDisplyedTimePoint, double currentScale) {
        double maxValue = 0.0;
        List list = timeSeries.getItems();
        long thisTimePoint = 0L;
        for (int i = list.size() - 1; i >= 0; --i) {
            thisTimePoint = ((TimeSeriesDataItem)list.get(i)).getPeriod().getFirstMillisecond();
            if (i < list.size() - 60 && thisTimePoint - firstDisplyedTimePoint < 0L) break;
            double value = ((TimeSeriesDataItem)list.get(i)).getValue().doubleValue();
            maxValue = (value /= currentScale) > maxValue ? value : maxValue;
        }
        return maxValue;
    }

    private boolean checkSystemStauts() {
        Launcher launcher = LauncherManager.getInstance().getLauncher(this.layout.getCurrentDeviceID());
        String reason = launcher.checkSystemStatus(this.layout.getCurrentDeviceID());
        if (null != reason) {
            DialogUtils.showErrorDialog((Window)this.getParentWindow(), reason);
            return false;
        }
        return true;
    }

    private void holdThisObject() {
        ObjectKeeper.keepObject(this.deviceID, (Object)this);
    }

    private List<IDataTypeEnum> getTickedDataTypes(DefaultMutableTreeNode dataTypesNode) {
        ArrayList<IDataTypeEnum> dataTypes = new ArrayList<IDataTypeEnum>();
        if (dataTypesNode != null) {
            Enumeration<TreeNode> allNodes = dataTypesNode.breadthFirstEnumeration();
            while (allNodes.hasMoreElements()) {
                TickableTreeNode tickableTreeNode;
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)allNodes.nextElement();
                if (!(node instanceof TickableTreeNode) || !(tickableTreeNode = (TickableTreeNode)node).isTicked()) continue;
                IDataTypeEnum dataType = (IDataTypeEnum)((Pair)((TickableTreeNode)node).getUserObject()).getKey();
                dataTypes.add(dataType);
            }
        }
        return dataTypes;
    }

    public Map<IPerfStatObjectType, List<Object>> getPerfStatObjectTypeToMOMap() {
        return this.perfStatObjectTypeToMOMap;
    }

    public PerfStatRealTimeLayout getPerfStatLayout() {
        return this.layout;
    }

    public void setDeviceList(List<String> devices) {
        this.deviceList = devices;
    }

    public String getCurrentDeviceID() {
        return this.deviceID;
    }

    private PerfStatDataSource getCurrentDataSource() {
        return DataSourceManager.getDataSource(this.layout.getCurrentDeviceID());
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
    }

    private class NormalQueryPerfStatDataTask
    implements Runnable {
        private List<IPerfStatObject> statObjects = new ArrayList<IPerfStatObject>(0);

        private NormalQueryPerfStatDataTask() {
        }

        @Override
        public void run() {
            if (this.statObjects.isEmpty()) {
                return;
            }
            PerfStatRealTimePane.this.normalProcessPerfStatData(this.statObjects);
        }
    }

    private class AdvanceQueryPerfStatDataTask
    implements Runnable {
        private List<IPerfStatObject> statObjects = new ArrayList<IPerfStatObject>(0);

        private AdvanceQueryPerfStatDataTask() {
        }

        @Override
        public void run() {
            if (this.statObjects.isEmpty()) {
                return;
            }
            PerfStatRealTimePane.this.advanceProcessPerfStatData(this.statObjects);
        }
    }

    private class QueryPerfStatStrategyTask
    implements Runnable {
        private QueryPerfStatStrategyTask() {
        }

        @Override
        public void run() {
            PerfStatRealTimePane.this.processPerfStatStrategy();
        }
    }
}

