/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.util;

import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.util.NumberCollator;
import com.huawei.ism.util.Pair;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.Formatter;
import java.util.Locale;

public class Unit {
    private static final int SECTOR_SIZE = 512;

    private static double convert(double value, Scaleble srcUnit, Scaleble targetUnit) {
        long tmp;
        double returnValue = value;
        if (srcUnit.getScale() > targetUnit.getScale()) {
            tmp = srcUnit.getScale() / targetUnit.getScale();
            returnValue = (double)tmp * value;
        }
        if (srcUnit.getScale() < targetUnit.getScale()) {
            tmp = targetUnit.getScale() / srcUnit.getScale();
            returnValue = value / (double)tmp;
        }
        return returnValue;
    }

    public static <T extends Number> T convert(T convertingObj, Scaleble srcUnit, Scaleble targetUnit) {
        if (!srcUnit.getClass().isInstance(targetUnit)) {
            throw new IllegalArgumentException("unmatiching unit");
        }
        if (convertingObj.doubleValue() == -2.147483648E9 || -9.223372036854776E18 == convertingObj.doubleValue()) {
            return convertingObj;
        }
        Double value = Unit.convert(convertingObj.doubleValue(), srcUnit, targetUnit);
        Object returnValue = convertingObj;
        if (convertingObj instanceof Integer) {
            returnValue = (Number)Integer.class.cast(value.intValue());
        } else if (convertingObj instanceof Long) {
            returnValue = (Number)Long.class.cast(value.longValue());
        } else if (convertingObj instanceof Double) {
            returnValue = value;
        } else if (convertingObj instanceof Short) {
            returnValue = (Number)Short.class.cast(value.shortValue());
        } else if (convertingObj instanceof Float) {
            returnValue = (Number)Float.class.cast(Float.valueOf(value.floatValue()));
        } else {
            throw new IllegalArgumentException("The T type cannot supported.");
        }
        if (srcUnit instanceof DataUnit && convertingObj instanceof Double) {
            BigDecimal bd = new BigDecimal((Double)Double.class.cast(returnValue));
            bd = bd.setScale(3, 1);
            returnValue = bd.doubleValue();
        }
        return returnValue;
    }

    public static <T extends Number> double convert(T sectors, int sectorSize, DataUnit targetUnit) {
        double capacity = sectors.doubleValue() * (double)sectorSize;
        return Unit.convert(capacity, (Scaleble)DataUnit.BYTE, (Scaleble)targetUnit);
    }

    public static <T extends Number> double convert(T sectors, DataUnit targetUnit) {
        double capacity = sectors.doubleValue() * 512.0;
        return Unit.convert(capacity, (Scaleble)DataUnit.BYTE, (Scaleble)targetUnit);
    }

    public static <T extends Number> String adaptConvert2(T temp, DataUnit srcUnit) {
        return Unit.adaptConvertDeleteZero(temp, srcUnit, false);
    }

    public static <T extends Number> String adaptConvertDeleteZero(T tempValue, DataUnit srcUnit, boolean isDeleteZero) {
        Double value = tempValue.doubleValue();
        DecimalFormat decFormat2 = new DecimalFormat("##,###,###,###,##0.000");
        if (-2.147483648E9 == value || -9.223372036854776E18 == value || 0.0 > value) {
            return "--";
        }
        if (0.0 == value) {
            return "0 " + DataUnit.MB.name();
        }
        Double currentValue = value;
        DataUnit currentDataUnit = srcUnit;
        DataUnit nextDataUtil = null;
        while (currentValue >= 1024.0 && !currentDataUnit.equals(nextDataUtil = currentDataUnit.getNextUnit())) {
            currentValue = currentValue / 1024.0;
            currentDataUnit = currentDataUnit.getNextUnit();
        }
        if (DataUnit.KB == currentDataUnit) {
            currentValue = currentValue / 1024.0;
            currentDataUnit = DataUnit.MB;
        } else if (DataUnit.BYTE == currentDataUnit) {
            currentValue = currentValue / 1024.0 / 1024.0;
            currentDataUnit = DataUnit.MB;
        }
        BigDecimal bd = new BigDecimal(currentValue);
        bd = bd.setScale(3, 1);
        if (isDeleteZero) {
            return Unit.deleteUnnecessaryZero(decFormat2.format(bd.doubleValue())) + ' ' + currentDataUnit.toString();
        }
        return decFormat2.format(bd.doubleValue()) + ' ' + currentDataUnit.toString();
    }

    public static <T extends Number> String adaptSectorConvert(T sectors) {
        return Unit.adaptSectorConvert(sectors, 512L);
    }

    public static <T extends Number> String adaptSectorConvert(T sectors, long sectorSize) {
        Double capacity = sectors.doubleValue() * (double)sectorSize;
        return Unit.adaptConvert2(capacity, DataUnit.BYTE);
    }

    public static <T extends Number> String adaptTimeConvert(T time, TimeUnit timeUnit) {
        StringBuilder timeStr = new StringBuilder("");
        Long timeValue = time.longValue();
        if (Integer.MIN_VALUE == timeValue || Long.MIN_VALUE == timeValue || 0L > timeValue) {
            return "--";
        }
        if (timeValue <= 0L) {
            return "0 " + timeUnit;
        }
        int range = Unit.getTwoTimeUnitRange(timeUnit);
        TimeUnit iterTimeUnit = timeUnit;
        for (int i = range; i >= 0; --i) {
            long rate = iterTimeUnit.getNextUnit().getScale() / iterTimeUnit.getScale();
            if (timeValue / rate == 0L || rate == 1L) {
                timeStr.append(timeValue + " " + iterTimeUnit);
                break;
            }
            long num = timeValue % rate;
            if (num != 0L) {
                timeStr.append(num + " " + iterTimeUnit + ',');
            }
            iterTimeUnit = iterTimeUnit.getNextUnit();
            timeValue = timeValue / rate;
        }
        StringBuilder result = new StringBuilder();
        for (int i = timeStr.toString().trim().split(",").length - 1; i >= 0; --i) {
            result.append(timeStr.toString().trim().split(",")[i] + ' ');
        }
        return result.toString();
    }

    private static int getTwoTimeUnitRange(TimeUnit timeUnit) {
        int range = 0;
        switch (timeUnit) {
            case NANOSECOND: {
                range = 6;
                break;
            }
            case MICROSECOND: {
                range = 5;
                break;
            }
            case MILLISECOND: {
                range = 4;
                break;
            }
            case SECOND: {
                range = 3;
                break;
            }
            case MINUTE: {
                range = 2;
                break;
            }
            case HOUR: {
                range = 1;
                break;
            }
        }
        return range;
    }

    @Deprecated
    public static <T extends Number> String adaptConvert(T tmpValue, DataUnit srcUnit) {
        double value = tmpValue.doubleValue();
        if (value == -2.147483648E9 || -9.223372036854776E18 == value) {
            return "--";
        }
        if (0.0 == value) {
            return "0 " + srcUnit.name();
        }
        Pair<DataUnit, Double> currentPair = new Pair<DataUnit, Double>(srcUnit, value);
        if (Unit.canUpConvert(currentPair)) {
            currentPair = Unit.upConvert(currentPair);
        } else if (Unit.canDownConvert(currentPair)) {
            currentPair = Unit.downConvert(currentPair);
        }
        return Unit.doubleFormat(currentPair.getValue()) + ' ' + currentPair.getKey().toString();
    }

    private static boolean canUpConvert(Pair<DataUnit, Double> currentPair) {
        if (currentPair.getKey() == DataUnit.PB) {
            return false;
        }
        if (currentPair.getValue() < 1024.0) {
            return false;
        }
        BigDecimal result = new BigDecimal(currentPair.getValue().toString()).divide(new BigDecimal("1024"));
        return result.scale() <= 2;
    }

    private static boolean canDownConvert(Pair<DataUnit, Double> currentPair) {
        if (currentPair.getKey() == DataUnit.BYTE) {
            return false;
        }
        BigDecimal value = new BigDecimal(currentPair.getValue().toString());
        if (value.scale() <= 2) {
            return false;
        }
        String strValue = new DecimalFormat("#.######").format(value.multiply(new BigDecimal("1024")));
        BigDecimal result = new BigDecimal(strValue);
        return result.scale() <= 2;
    }

    private static Pair<DataUnit, Double> upConvert(Pair<DataUnit, Double> currentPair) {
        double newValue = currentPair.getValue() / 1024.0;
        Pair<DataUnit, Double> newPair = new Pair<DataUnit, Double>(currentPair.getKey().getNextUnit(), newValue);
        if (Unit.canUpConvert(newPair)) {
            return Unit.upConvert(newPair);
        }
        return newPair;
    }

    private static Pair<DataUnit, Double> downConvert(Pair<DataUnit, Double> currentPair) {
        double newValue = currentPair.getValue() * 1024.0;
        Pair<DataUnit, Double> newPair = new Pair<DataUnit, Double>(currentPair.getKey().getPreviousUnit(), newValue);
        if (Unit.canDownConvert(newPair)) {
            return Unit.downConvert(newPair);
        }
        return newPair;
    }

    public static String doubleFormat(double data) {
        DecimalFormat decFormat = new DecimalFormat("##,###,###,###,##0.00");
        if (-2.147483648E9 == data || -9.223372036854776E18 == data) {
            return "--";
        }
        return decFormat.format(data);
    }

    public static String doubleFormat2(double data) {
        DecimalFormat decFormat2 = new DecimalFormat("##,###,###,###,##0.000");
        if (-2.147483648E9 == data || -9.223372036854776E18 == data) {
            return "--";
        }
        if (0.0 == data) {
            return "0";
        }
        return decFormat2.format(data);
    }

    public static String format(double data) {
        DecimalFormat decFormatwithoutComma = new DecimalFormat("######0.00");
        if (-2.147483648E9 == data || -9.223372036854776E18 == data) {
            return "--";
        }
        return decFormatwithoutComma.format(data);
    }

    public static String commaFormat(long data) {
        if (Integer.MIN_VALUE == data || Long.MIN_VALUE == data) {
            return "--";
        }
        return new Formatter(new StringBuilder(), Locale.CHINA).format("%," + String.valueOf(data).length() + "d", data).toString();
    }

    public static NumberCollator convertMB2GB(double mb) {
        return new NumberCollator(Unit.convert(mb, (Scaleble)DataUnit.MB, (Scaleble)DataUnit.GB));
    }

    public static String remainingTimeFormat(long remainingTime) {
        if (Integer.MIN_VALUE == remainingTime || Long.MIN_VALUE == remainingTime || 0xFFFFFFFFL == remainingTime) {
            return "--";
        }
        double convertHour = 60.0;
        double convertDay = 24.0;
        double minuteResult = (double)remainingTime % convertHour;
        long minutepart = Math.round(Math.floor(minuteResult));
        double tempHourResult = (double)remainingTime / convertHour;
        double hourResult = tempHourResult % convertDay;
        long hourPart = Math.round(Math.floor(hourResult));
        double dayResult = tempHourResult / convertDay;
        long dayPart = Math.round(Math.floor(dayResult));
        StringBuilder result = new StringBuilder(" ");
        result.append(String.valueOf(dayPart)).append(" ").append(ResourceManager.getString("Day")).append(" ").append(String.valueOf(hourPart)).append(" ").append(ResourceManager.getString("REMOTE_ALARM_MSG_3")).append(" ").append(String.valueOf(minutepart)).append(" ").append(ResourceManager.getString("Minute"));
        return result.toString();
    }

    private static String deleteUnnecessaryZero(String value) {
        String result = String.valueOf(value);
        if (result.indexOf(".") != -1) {
            int length = result.length();
            char c = result.charAt(--length);
            while (c == '0') {
                result = result.substring(0, length);
                c = result.charAt(--length);
            }
            if (c == '.') {
                result = result.substring(0, length);
            }
        }
        return result;
    }

    public static enum SpeedUnit {
        MBPS(0),
        KBPS(1),
        GBPS(2);

        private int unitValue;

        private SpeedUnit(int value) {
            this.unitValue = value;
        }

        public static SpeedUnit getSpeedUnit(int type) {
            SpeedUnit dlType = null;
            switch (type) {
                case 0: {
                    dlType = MBPS;
                    break;
                }
                case 1: {
                    dlType = KBPS;
                    break;
                }
                case 2: {
                    dlType = GBPS;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("wrong SpeedUnit value:" + type);
                }
            }
            return dlType;
        }

        public SpeedUnit getNextUnit() {
            switch (this) {
                case KBPS: {
                    return MBPS;
                }
                case MBPS: 
                case GBPS: {
                    return GBPS;
                }
            }
            return this;
        }

        public int getValue() {
            return this.unitValue;
        }

        public String toString() {
            return ResourceManager.getString(this.name());
        }
    }

    public static enum FrequencyUnit implements Scaleble
    {
        HZ(1L),
        KHZ(1000L),
        MHZ(1000000L),
        GHZ(1000000000L),
        THZ(1000000000000L);

        private long scale;

        private FrequencyUnit(long scale) {
            this.scale = scale;
        }

        @Override
        public long getScale() {
            return this.scale;
        }
    }

    public static enum DataSpeedUnit implements Scaleble
    {
        BPS(1L),
        KBPS(1000L),
        MBPS(1000000L),
        GBPS(1000000000L),
        TBPS(1000000000000L),
        PBPS(1000000000000000L);

        private long scale;

        private DataSpeedUnit(long scale) {
            this.scale = scale;
        }

        @Override
        public long getScale() {
            return this.scale;
        }
    }

    public static enum DataUnit implements Scaleble
    {
        BIT(1L),
        BYTE(8L),
        KB(8192L),
        MB(0x800000L),
        GB(0x200000000L),
        TB(0x80000000000L),
        PB(0x20000000000000L);

        private long scale;

        private DataUnit(long scale) {
            this.scale = scale;
        }

        @Override
        public long getScale() {
            return this.scale;
        }

        public DataUnit getNextUnit() {
            switch (this) {
                case BIT: {
                    return BYTE;
                }
                case BYTE: {
                    return KB;
                }
                case KB: {
                    return MB;
                }
                case MB: {
                    return GB;
                }
                case GB: {
                    return TB;
                }
                case TB: {
                    return PB;
                }
            }
            return this;
        }

        public DataUnit getPreviousUnit() {
            switch (this) {
                case PB: {
                    return TB;
                }
                case TB: {
                    return GB;
                }
                case GB: {
                    return MB;
                }
                case MB: {
                    return KB;
                }
                case KB: {
                    return BYTE;
                }
                case BYTE: {
                    return BIT;
                }
            }
            return this;
        }
    }

    public static enum TimeUnit implements Scaleble
    {
        NANOSECOND(1L),
        MICROSECOND(1000L),
        MILLISECOND(1000000L),
        SECOND(1000000000L),
        MINUTE(60000000000L),
        HOUR(3600000000000L),
        DAY(86400000000000L);

        private long scale;

        private TimeUnit(long scale) {
            this.scale = scale;
        }

        @Override
        public long getScale() {
            return this.scale;
        }

        public TimeUnit getNextUnit() {
            switch (this) {
                case NANOSECOND: {
                    return MICROSECOND;
                }
                case MICROSECOND: {
                    return MILLISECOND;
                }
                case MILLISECOND: {
                    return SECOND;
                }
                case SECOND: {
                    return MINUTE;
                }
                case MINUTE: {
                    return HOUR;
                }
                case HOUR: {
                    return DAY;
                }
            }
            return this;
        }

        public String toString() {
            return ResourceManager.getString("Unit.TimeUnit." + this.name().toUpperCase(ResourceManager.getLocale()));
        }
    }

    public static interface Scaleble {
        public long getScale();
    }
}

