/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.channel.upload.service;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.channel.cert.service.HttpsCertManager;
import com.huawei.ism.tool.channel.cert.utils.SSLCertUtils;
import com.huawei.ism.tool.channel.config.entity.InternetParams;
import com.huawei.ism.tool.channel.upload.entity.UploadProcess;
import com.huawei.ism.tool.channel.upload.entity.UploadStatus;
import com.huawei.ism.tool.channel.upload.entity.UploadTask;
import com.huawei.ism.tool.channel.upload.entity.UploadTaskType;
import com.huawei.ism.tool.channel.upload.utils.FileCompressUtil;
import com.huawei.ism.tool.channel.upload.utils.FileProcessUtil;
import com.huawei.ism.tool.channel.utils.HttpsPropUtils;
import com.huawei.ism.tool.channel.utils.InternetInfoKeeper;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.https.conn.HttpsConnManager;
import com.huawei.ism.tool.https.entity.HttpsConnection;
import com.huawei.json.JSONObject;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpsPrepareService {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpsPrepareService.class);
    private static final HttpsPrepareService INSTANCE = new HttpsPrepareService();
    private static final int TWO = 2;

    public static HttpsPrepareService getInstance() {
        return INSTANCE;
    }

    public long prepareTrans(UploadProcess uploadProcess, UploadTask task) {
        LOGGER.info("start to open prepare trans...");
        String url = HttpsPropUtils.getFilePrepareUrl(HttpsPropUtils.getPropValue("https.url.domain", ResourceUtil.getString((String)"default.smartkit.url")));
        InternetParams internetParams = InternetInfoKeeper.getInstance().getInternetParams();
        HttpsConnection httpsConnection = HttpsConnManager.getInstance().getHttpsConnByUrl(url, internetParams.isUseProxy() ? internetParams.getHttpProxy() : null, SSLCertUtils.getSSLFactory());
        if (null == httpsConnection) {
            LOGGER.error("Connect is error:");
            return 0L;
        }
        if (!httpsConnection.isSuccess()) {
            uploadProcess.setStatus(UploadStatus.FAILED);
            uploadProcess.setDescription("upload.trans.prepare.failed");
            LOGGER.error("prepare trans error:upload.trans.prepare.failed");
            return 0L;
        }
        HttpsURLConnection connection = httpsConnection.getConnection();
        LOGGER.info("build request params.");
        this.setRequestParams(connection, task);
        if (!HttpsConnManager.getInstance().isHttpsResponseSuccess(connection)) {
            uploadProcess.setStatus(UploadStatus.FAILED);
            uploadProcess.setDescription("upload.http.response.error");
            return 0L;
        }
        int resultCode = 0;
        try {
            resultCode = Integer.parseInt(HttpsConnManager.getInstance().getHttpsResponseParams(connection, "resultCode"));
        }
        catch (NumberFormatException e) {
            LOGGER.error("response params format error.");
        }
        if (resultCode == 2) {
            uploadProcess.setStatus(UploadStatus.FINISHED);
            LOGGER.error("prepare trans successed: the file has upload finished.");
            return -1L;
        }
        long breakpoint = 0L;
        try {
            breakpoint = Long.parseLong(HttpsConnManager.getInstance().getHttpsResponseParams(connection, "fileBreakpoint"));
        }
        catch (NumberFormatException e) {
            LOGGER.error("response params format error.");
        }
        connection.disconnect();
        LOGGER.info("prepare trans finished.");
        return breakpoint;
    }

    private void setRequestParams(HttpsURLConnection connection, UploadTask task) {
        LOGGER.info("start to set request params");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("fileKey", FileProcessUtil.getFileIdentifier(task.getFileFullPath()));
        params.put("fileDesc", task.getFileDesc());
        params.put("siteId", task.getSiteID());
        params.put("clientFileId", task.getTaskId() + "");
        params.put("clientFileId", task.getTaskId() + "");
        this.setUploadTaskType(task, params);
        params.put("fileOrigName", task.getFileName());
        params.put("domain", task.getUploadDomain().getDomainId());
        params.put("productType", task.getProductType());
        params.put("fileType", task.getUploadTaskType().toString());
        params.put("fileSize", FileProcessUtil.getFileSize(task.getFileFullPath()) + "");
        params.put("channel", "1");
        params.put("uploadCode", task.getUpCode());
        params.put("userId", this.checkCurrentUserReady());
        params.put("remarks", task.getRemarks());
        params.put("startUploadTime", String.valueOf(task.getStartUploadTime()));
        params.put("deviceSN", task.getDeviceSN());
        params.put("fileCreateTime", task.getCreateFileTime());
        params.put("uploadClient", ApplicationContext.getInstance().getVersion());
        params.put("recordClient", "SmartKit");
        String userRole = ApplicationContext.getInstance().getUserRole();
        if (org.apache.commons.lang3.StringUtils.isBlank(userRole)) {
            params.put("BG", "enterprise");
        } else {
            params.put("BG", userRole.toLowerCase(Locale.ENGLISH));
        }
        if (!task.getUploadMethod().equals("autoUpload")) {
            params.put("autoUpload", "0");
            params.put("autoFileType", "0");
        }
        HttpsConnManager.getInstance().setHttpsRequestParams(connection, params);
    }

    private void setUploadTaskType(UploadTask task, Map<String, String> params) {
        if (task.getUploadTaskType().equals((Object)UploadTaskType.TOOLOPERATIONS) || task.getUploadTaskType().equals((Object)UploadTaskType.FEEDBACK)) {
            params.put("fileName", task.getFileName());
        } else {
            String fileName = FileCompressUtil.getUploadFileName(task.getFileFullPath(), task.getFileName());
            if (null != fileName) {
                params.put("fileName", fileName);
            } else {
                params.put("fileName", task.getFileName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getIP() {
        StringBuilder sb;
        block8: {
            sb = new StringBuilder();
            String command = "cmd.exe /c ipconfig | findstr IPv4";
            BufferedReader br = null;
            InputStreamReader isr = null;
            InputStream is = null;
            Process process = null;
            try {
                process = Runtime.getRuntime().exec(command);
                is = process.getInputStream();
                isr = new InputStreamReader(is, "utf-8");
                br = new BufferedReader(isr);
                String line = null;
                while ((line = br.readLine()) != null) {
                    line = line.substring(line.lastIndexOf(":") + 2, line.length());
                    sb.append(line);
                }
                StreamUtils.closeResource(null, (Closeable)br);
            }
            catch (IOException e) {
                LOGGER.error("can not get ip.");
                break block8;
            }
            finally {
                StreamUtils.closeResource(null, br);
                StreamUtils.closeResource(null, isr);
                StreamUtils.closeResource(null, (Closeable)is);
                if (null != process) {
                    process.destroy();
                }
            }
            StreamUtils.closeResource(null, (Closeable)isr);
            StreamUtils.closeResource(null, (Closeable)is);
            if (null != process) {
                process.destroy();
            }
        }
        return sb.toString();
    }

    public HttpsURLConnection establishConnection(UploadProcess uploadProcess, UploadTask task) {
        LOGGER.info("start to establish connection...");
        String url = HttpsPropUtils.getFileTransUrl();
        InternetParams internetParams = InternetInfoKeeper.getInstance().getInternetParams();
        if (null == internetParams) {
            LOGGER.info("establish connection failed , because internet param is null");
            return null;
        }
        HttpsConnection httpsConnection = HttpsConnManager.getInstance().getHttpsConnByUrl(url, internetParams.isUseProxy() ? internetParams.getHttpProxy() : null, SSLCertUtils.getSSLFactory());
        if (null == httpsConnection || !httpsConnection.isSuccess()) {
            uploadProcess.setStatus(UploadStatus.FAILED);
            uploadProcess.setDescription("upload.connection.establish.failed");
            LOGGER.error("establish connection error:upload.connection.establish.failed");
            return null;
        }
        uploadProcess.setDescription("upload.connection.established");
        LOGGER.info("establish connection successed.");
        HttpsURLConnection connection = httpsConnection.getConnection();
        if (null != task) {
            this.setRequestParams(connection, task);
        }
        return connection;
    }

    public void setFileNameParams(HttpsURLConnection connection, String fileOrigName, String fileName, long fileSize) {
        LOGGER.info("start to set file name params");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("fileName", fileName);
        params.put("fileOrigName", fileOrigName);
        params.put("fileSize", fileSize + "");
        HttpsConnManager.getInstance().setHttpsRequestParams(connection, params);
    }

    private String checkCurrentUserReady() {
        String desc;
        String userId = ApplicationContext.getInstance().getSupportUser();
        if (userId.equals("unKnown") && !StringUtils.isNULLStr((String)(desc = HttpsCertManager.getInstance().getUserInfo()))) {
            JSONObject roleInfoObj = new JSONObject(desc);
            userId = roleInfoObj.getString("userId");
        }
        return userId;
    }
}

