/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.channel.upload.utils;

import com.huawei.ism.tool.obase.utils.StringUtils;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileProcessUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileProcessUtil.class);
    private static final int HEX = 16;
    private static final int INT_0XFF = 255;
    private static final int INT_0X100 = 256;

    private FileProcessUtil() {
    }

    public static String getFileIdentifier(String fileAbsPath) {
        MessageDigest fileDigest;
        if (StringUtils.isNULLStr(fileAbsPath)) {
            return "";
        }
        File file = new File(fileAbsPath);
        if (!file.exists() || !file.isFile()) {
            return "";
        }
        String fileIdStr = fileAbsPath + file.length() + file.lastModified();
        try {
            fileDigest = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.error("message digest error.NoSuchAlgorithmException");
            return "";
        }
        try {
            fileDigest.update(fileIdStr.getBytes("utf-8"));
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error("message digest error.UnsupportedEncodingException");
            return "";
        }
        byte[] digestBytes = fileDigest.digest();
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < digestBytes.length; ++i) {
            result.append(Integer.toString((digestBytes[i] & 0xFF) + 256, 16).substring(1));
        }
        return result.toString();
    }

    public static long getFileSize(String fileAbsPath) {
        if (StringUtils.isNULLStr(fileAbsPath)) {
            return 0L;
        }
        File file = new File(fileAbsPath);
        if (!file.exists() || !file.isFile()) {
            return 0L;
        }
        return file.length();
    }
}

