/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.base.ui.wizard;

import com.huawei.ism.tool.base.flow.Flow;
import com.huawei.ism.tool.base.flow.FlowContext;
import com.huawei.ism.tool.base.flow.FlowException;
import com.huawei.ism.tool.base.flow.FlowFactory;
import com.huawei.ism.tool.base.flow.FlowState;
import com.huawei.ism.tool.base.flow.IFlow;
import com.huawei.ism.tool.base.flow.IFlowListener;
import com.huawei.ism.tool.base.flow.ui.IFlowUI;
import com.huawei.ism.tool.base.flow.ui.IFlowUIState;
import com.huawei.ism.tool.base.flow.ui.IStepUI;
import com.huawei.ism.tool.base.flow.ui.Title;
import com.huawei.ism.tool.base.ui.UiMethod;
import com.huawei.ism.tool.base.ui.component.wizard.IHelpActionCallBack;
import com.huawei.ism.tool.base.ui.component.wizard.WizardConstants;
import com.huawei.ism.tool.base.ui.component.wizard.WizardHeadPanel;
import com.huawei.ism.tool.base.ui.component.wizard.WizardRootPaneUI;
import com.huawei.ism.tool.base.ui.component.wizard.WizardStepGroup;
import com.huawei.ism.tool.base.ui.component.wizard.WizardStepItem;
import com.huawei.ism.tool.base.ui.wizard.FlowWizardCardLayout;
import com.huawei.ism.tool.base.ui.wizard.FlowWizardState;
import com.huawei.ism.tool.base.ui.wizard.HelpManager;
import com.huawei.ism.tool.base.ui.wizard.Navigation;
import com.huawei.ism.tool.base.ui.wizard.WizardResource;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;

public class FlowWizardDialog
extends JDialog
implements IFlowUI {
    private static final long serialVersionUID = 5329056444374574123L;
    private static final WizardResource RESOURCE = WizardResource.getInstance();
    private static final String TITLE_DECO_ZH = "\u5411\u5bfc \u6b65\u9aa4";
    private static final String TITLE_DECO_EN = " Wizard ";
    private static final int WIZARD_DIALOG_WIDTH = 900;
    private static final int WIZARD_DIALOG_HEIGHT = 650;
    private Map<String, String> customWindowSizeMap = new HashMap<String, String>();
    protected JPanel contentPane = null;
    protected Box southBox = Box.createVerticalBox();
    protected List<Title> stageTitles = null;
    protected String wizardTitle = "";
    protected Locale loc = null;
    protected WizardHeadPanel stepsPanel = null;
    private Title flowTitle = null;
    private WizardRootPaneUI rootPaneUI = new WizardRootPaneUI();
    private WizardStepGroup stepsGroup = new WizardStepGroup();
    private Box navigationBar = null;
    private Map<Navigation, JButton> naviButtons = new HashMap<Navigation, JButton>();
    private IFlow flow = null;
    private String helpDir = null;
    private boolean isStandrad = true;

    public FlowWizardDialog(Window parent, Locale loc, FlowFactory flowFactory, String helpDir) {
        this(parent, loc, flowFactory, helpDir, true);
    }

    public FlowWizardDialog(Window parent, Locale loc, FlowFactory flowFactory, String helpDir, boolean isStandrad) {
        super(parent, Dialog.ModalityType.APPLICATION_MODAL);
        this.loc = loc;
        this.helpDir = helpDir;
        this.isStandrad = isStandrad;
        this.initWizard(flowFactory);
    }

    public FlowWizardDialog(Window parent, Locale loc, ClassLoader clsLoader, InputStream defXmlStream, InputStream flowXmlStream, String helpDir) {
        this(parent, loc, clsLoader, defXmlStream, flowXmlStream, helpDir, true);
    }

    public FlowWizardDialog(Window parent, Locale loc, ClassLoader clsLoader, InputStream defXmlStream, InputStream flowXmlStream, String helpDir, boolean isStandrad) {
        super(parent, Dialog.ModalityType.APPLICATION_MODAL);
        this.loc = loc;
        this.helpDir = helpDir;
        this.isStandrad = isStandrad;
        FlowFactory flowFactory = new FlowFactory(defXmlStream, flowXmlStream, clsLoader, loc);
        this.initWizard(flowFactory);
    }

    @Override
    public void initUIState(IFlowUIState state, List<JButton> operators) {
        this.updateNavigation((FlowWizardState)state, operators);
        this.repaint();
    }

    @Override
    public void changeUIState(IFlowUIState state) {
        this.changeEnableState((FlowWizardState)state);
    }

    @Override
    public void showStep(int index, IStepUI stepUI) {
        if (index < 0 || index > this.stepsGroup.getStepSize() || null == stepUI) {
            return;
        }
        this.updateContent(stepUI);
        this.updateTitle(index);
    }

    @Override
    public void init(Title title, String flowHelp, List<Title> stageTitleList) {
        if (null == stageTitleList || stageTitleList.isEmpty()) {
            return;
        }
        String titleDeco = this.getTitleDeco();
        this.wizardTitle = title.getName(this.loc) + titleDeco;
        this.stageTitles = stageTitleList;
        this.flowTitle = title;
        if (null == flowHelp || flowHelp.isEmpty()) {
            this.rootPaneUI.setShowHelp(false);
        }
        this.getRootPane().setUI(this.rootPaneUI);
        this.initHelp(flowHelp);
        this.initUI();
    }

    protected String getTitleDeco() {
        return "zh".equalsIgnoreCase(this.loc.getLanguage()) ? TITLE_DECO_ZH : TITLE_DECO_EN;
    }

    public void addFlowListener(IFlowListener flowListener) {
        this.flow.addListener(flowListener);
    }

    public void initHelp(final String flowHelp) {
        if (null == flowHelp) {
            return;
        }
        HelpManager.createHelp(this.helpDir, flowHelp, this.loc);
        this.rootPaneUI.setHelpActionCallBack(new IHelpActionCallBack(){

            @Override
            public void doHelpActionWork() {
                HelpManager.openHelpFile(FlowWizardDialog.this.helpDir, flowHelp, FlowWizardDialog.this.loc);
            }

            @Override
            public String getListenerName() {
                return "Flow Wizard Help";
            }
        });
    }

    public Title getFlowTitle() {
        return this.flowTitle;
    }

    private void initWizard(FlowFactory flowFactory) {
        this.customWindowSizeMap = flowFactory.getWindowSizeMap();
        this.initComponent();
        this.bondListener();
        try {
            this.flow = flowFactory.createFlow(this);
        }
        catch (FlowException e) {
            ToolLoggerFactory.getLogger(this.getClass()).error(e.getMessage());
        }
        this.flow.init();
    }

    @Override
    public void setVisible(boolean visible) {
        boolean actualVisible = visible;
        if (actualVisible && FlowState.READY == this.flow.getCurState()) {
            actualVisible = this.flow.start();
        }
        super.setVisible(actualVisible);
    }

    public FlowContext getContext() {
        return this.flow.getContext();
    }

    protected void updateTitle(int index) {
        Title subtitle = this.stageTitles.get(index);
        StringBuffer title = new StringBuffer();
        title.append(this.wizardTitle).append(" ");
        title.append(this.stageTitles.size()).append("-").append(index + 1).append(this.getColon()).append(subtitle.getName(this.loc));
        this.setTitle(title.toString());
        this.stepsGroup.setSelect(index);
    }

    private String getColon() {
        return "zh".equalsIgnoreCase(this.loc.getLanguage()) ? "\uff1a" : ": ";
    }

    private void updateContent(IStepUI stepUI) {
        FlowWizardCardLayout cardLayout = (FlowWizardCardLayout)stepUI;
        this.contentPane.removeAll();
        if (this.isStandrad) {
            this.contentPane.add(UiMethod.buildFrameSpace(cardLayout, 20));
        } else {
            this.contentPane.add(cardLayout);
        }
        this.contentPane.revalidate();
        this.contentPane.repaint();
        this.repaint();
    }

    private void addOperatorButtons(List<JButton> operators) {
        if (null == operators || operators.isEmpty()) {
            return;
        }
        for (JButton btn : operators) {
            this.navigationBar.add(Box.createHorizontalStrut(10));
            this.navigationBar.add(btn);
        }
    }

    private void updateNavigation(FlowWizardState state, List<JButton> operators) {
        this.navigationBar.removeAll();
        this.initButtonState();
        this.addOperatorButtons(operators);
        this.navigationBar.add(Box.createHorizontalGlue());
        switch (state) {
            case FIRST_STEP: {
                this.navigationBar.add(this.naviButtons.get((Object)Navigation.NEXT));
                this.navigationBar.add(Box.createHorizontalStrut(15));
                this.navigationBar.add(this.naviButtons.get((Object)Navigation.CANCEL));
                break;
            }
            case FIRST_STEP_RUNNING: {
                this.navigationBar.add(this.naviButtons.get((Object)Navigation.NEXT));
                this.navigationBar.add(Box.createHorizontalStrut(15));
                this.navigationBar.add(this.naviButtons.get((Object)Navigation.CANCEL));
                this.naviButtons.get((Object)Navigation.NEXT).setEnabled(false);
                break;
            }
            case SINGLE_STEP_SUCCESS: {
                this.navigationBar.add(this.naviButtons.get((Object)Navigation.COMPLETE));
                this.navigationBar.add(Box.createHorizontalStrut(15));
                this.navigationBar.add(this.naviButtons.get((Object)Navigation.CANCEL));
                break;
            }
            case SINGLE_STEP_FAILED: {
                this.navigationBar.add(this.naviButtons.get((Object)Navigation.COMPLETE));
                this.navigationBar.add(Box.createHorizontalStrut(15));
                this.navigationBar.add(this.naviButtons.get((Object)Navigation.CANCEL));
                this.naviButtons.get((Object)Navigation.COMPLETE).setEnabled(false);
                break;
            }
        }
        this.setFirstStep(state);
        this.setSecondStep(state);
        this.setThirdStep(state);
        this.navigationBar.add(Box.createHorizontalStrut(20));
    }

    private void setThirdStep(FlowWizardState state) {
        switch (state) {
            case MIDDLE_STEP_DISABLE: {
                this.navigationBar.add(this.naviButtons.get((Object)Navigation.PREVIOUS));
                this.navigationBar.add(Box.createHorizontalStrut(10));
                this.navigationBar.add(this.naviButtons.get((Object)Navigation.NEXT));
                this.navigationBar.add(Box.createHorizontalStrut(15));
                this.navigationBar.add(this.naviButtons.get((Object)Navigation.CANCEL));
                this.naviButtons.get((Object)Navigation.PREVIOUS).setEnabled(false);
                this.naviButtons.get((Object)Navigation.NEXT).setEnabled(false);
                this.naviButtons.get((Object)Navigation.CANCEL).setEnabled(false);
                break;
            }
            case MIDDLE_STEP_NEXT: {
                this.navigationBar.add(this.naviButtons.get((Object)Navigation.PREVIOUS));
                this.navigationBar.add(Box.createHorizontalStrut(10));
                this.navigationBar.add(this.naviButtons.get((Object)Navigation.NEXT));
                this.navigationBar.add(Box.createHorizontalStrut(15));
                this.navigationBar.add(this.naviButtons.get((Object)Navigation.CANCEL));
                this.naviButtons.get((Object)Navigation.PREVIOUS).setEnabled(false);
                this.naviButtons.get((Object)Navigation.CANCEL).setEnabled(false);
                break;
            }
        }
    }

    private void setSecondStep(FlowWizardState state) {
        switch (state) {
            case MIDDLE_STEP: {
                this.navigationBar.add(this.naviButtons.get((Object)Navigation.PREVIOUS));
                this.navigationBar.add(Box.createHorizontalStrut(10));
                this.navigationBar.add(this.naviButtons.get((Object)Navigation.NEXT));
                this.navigationBar.add(Box.createHorizontalStrut(15));
                this.navigationBar.add(this.naviButtons.get((Object)Navigation.CANCEL));
                break;
            }
            case MIDDLE_STEP_RUNNING: {
                this.navigationBar.add(this.naviButtons.get((Object)Navigation.PREVIOUS));
                this.navigationBar.add(Box.createHorizontalStrut(10));
                this.navigationBar.add(this.naviButtons.get((Object)Navigation.NEXT));
                this.navigationBar.add(Box.createHorizontalStrut(15));
                this.navigationBar.add(this.naviButtons.get((Object)Navigation.CANCEL));
                this.naviButtons.get((Object)Navigation.PREVIOUS).setEnabled(false);
                this.naviButtons.get((Object)Navigation.NEXT).setEnabled(false);
                break;
            }
            case MIDDLE_STEP_SUCCESS: {
                this.navigationBar.add(this.naviButtons.get((Object)Navigation.PREVIOUS));
                this.navigationBar.add(Box.createHorizontalStrut(10));
                this.navigationBar.add(this.naviButtons.get((Object)Navigation.NEXT));
                this.navigationBar.add(Box.createHorizontalStrut(15));
                this.navigationBar.add(this.naviButtons.get((Object)Navigation.CANCEL));
                this.naviButtons.get((Object)Navigation.PREVIOUS).setEnabled(false);
                break;
            }
            case MIDDLE_STEP_FAILED: {
                this.navigationBar.add(this.naviButtons.get((Object)Navigation.PREVIOUS));
                this.navigationBar.add(Box.createHorizontalStrut(10));
                this.navigationBar.add(this.naviButtons.get((Object)Navigation.NEXT));
                this.navigationBar.add(Box.createHorizontalStrut(15));
                this.navigationBar.add(this.naviButtons.get((Object)Navigation.CANCEL));
                this.naviButtons.get((Object)Navigation.NEXT).setEnabled(false);
                break;
            }
        }
    }

    private void setFirstStep(FlowWizardState state) {
        switch (state) {
            case LAST_STEP: {
                this.navigationBar.add(this.naviButtons.get((Object)Navigation.PREVIOUS));
                this.navigationBar.add(Box.createHorizontalStrut(10));
                this.navigationBar.add(this.naviButtons.get((Object)Navigation.COMPLETE));
                this.navigationBar.add(Box.createHorizontalStrut(15));
                this.navigationBar.add(this.naviButtons.get((Object)Navigation.CANCEL));
                break;
            }
            case LAST_STEP_SUCCESS: {
                this.navigationBar.add(this.naviButtons.get((Object)Navigation.PREVIOUS));
                this.navigationBar.add(Box.createHorizontalStrut(10));
                this.navigationBar.add(this.naviButtons.get((Object)Navigation.COMPLETE));
                this.navigationBar.add(Box.createHorizontalStrut(15));
                this.navigationBar.add(this.naviButtons.get((Object)Navigation.CANCEL));
                this.naviButtons.get((Object)Navigation.PREVIOUS).setEnabled(false);
                this.naviButtons.get((Object)Navigation.CANCEL).setEnabled(false);
                break;
            }
            case LAST_STEP_FAILED: {
                this.navigationBar.add(this.naviButtons.get((Object)Navigation.PREVIOUS));
                this.navigationBar.add(Box.createHorizontalStrut(10));
                this.navigationBar.add(this.naviButtons.get((Object)Navigation.COMPLETE));
                this.navigationBar.add(Box.createHorizontalStrut(15));
                this.navigationBar.add(this.naviButtons.get((Object)Navigation.CANCEL));
                this.naviButtons.get((Object)Navigation.COMPLETE).setEnabled(false);
                break;
            }
            case LAST_STEP_RUNNING: {
                this.navigationBar.add(this.naviButtons.get((Object)Navigation.PREVIOUS));
                this.navigationBar.add(Box.createHorizontalStrut(10));
                this.navigationBar.add(this.naviButtons.get((Object)Navigation.COMPLETE));
                this.navigationBar.add(Box.createHorizontalStrut(15));
                this.navigationBar.add(this.naviButtons.get((Object)Navigation.CANCEL));
                this.naviButtons.get((Object)Navigation.PREVIOUS).setEnabled(false);
                this.naviButtons.get((Object)Navigation.COMPLETE).setEnabled(false);
                break;
            }
        }
    }

    private void changeEnableState(FlowWizardState state) {
        switch (state) {
            case FIRST_STEP: {
                this.naviButtons.get((Object)Navigation.NEXT).setEnabled(true);
                this.naviButtons.get((Object)Navigation.CANCEL).setEnabled(true);
                break;
            }
            case FIRST_STEP_RUNNING: {
                this.naviButtons.get((Object)Navigation.NEXT).setEnabled(false);
                this.naviButtons.get((Object)Navigation.CANCEL).setEnabled(true);
                break;
            }
            case FIRST_STEP_DISABLE: {
                this.naviButtons.get((Object)Navigation.NEXT).setEnabled(false);
                this.naviButtons.get((Object)Navigation.CANCEL).setEnabled(false);
                break;
            }
            case LAST_STEP_SUCCESS: {
                this.naviButtons.get((Object)Navigation.COMPLETE).setEnabled(true);
                this.naviButtons.get((Object)Navigation.PREVIOUS).setEnabled(false);
                this.naviButtons.get((Object)Navigation.CANCEL).setEnabled(false);
                break;
            }
            case LAST_STEP_PRE_SUC: {
                this.naviButtons.get((Object)Navigation.COMPLETE).setEnabled(true);
                this.naviButtons.get((Object)Navigation.PREVIOUS).setEnabled(true);
                this.naviButtons.get((Object)Navigation.CANCEL).setEnabled(false);
                break;
            }
            case SINGLE_STEP_SUCCESS: {
                this.naviButtons.get((Object)Navigation.COMPLETE).setEnabled(true);
                this.naviButtons.get((Object)Navigation.CANCEL).setEnabled(true);
                break;
            }
            case SINGLE_STEP_FAILED: {
                this.naviButtons.get((Object)Navigation.COMPLETE).setEnabled(false);
                this.naviButtons.get((Object)Navigation.CANCEL).setEnabled(true);
                break;
            }
        }
        this.setChangeSecondStep(state);
        this.setChangeThirdStep(state);
    }

    private void setChangeSecondStep(FlowWizardState state) {
        switch (state) {
            case LAST_STEP_FAILED: {
                this.naviButtons.get((Object)Navigation.COMPLETE).setEnabled(false);
                this.naviButtons.get((Object)Navigation.PREVIOUS).setEnabled(true);
                this.naviButtons.get((Object)Navigation.CANCEL).setEnabled(true);
                break;
            }
            case LAST_STEP_RUNNING: {
                this.naviButtons.get((Object)Navigation.CANCEL).setEnabled(true);
                this.naviButtons.get((Object)Navigation.PREVIOUS).setEnabled(false);
                this.naviButtons.get((Object)Navigation.COMPLETE).setEnabled(false);
                break;
            }
            case LAST_STEP_DISABLE: {
                this.naviButtons.get((Object)Navigation.CANCEL).setEnabled(false);
                this.naviButtons.get((Object)Navigation.PREVIOUS).setEnabled(false);
                this.naviButtons.get((Object)Navigation.COMPLETE).setEnabled(false);
                break;
            }
            case MIDDLE_STEP: {
                this.naviButtons.get((Object)Navigation.PREVIOUS).setEnabled(true);
                this.naviButtons.get((Object)Navigation.NEXT).setEnabled(true);
                this.naviButtons.get((Object)Navigation.CANCEL).setEnabled(true);
                break;
            }
            case MIDDLE_STEP_RUNNING: {
                this.naviButtons.get((Object)Navigation.PREVIOUS).setEnabled(false);
                this.naviButtons.get((Object)Navigation.NEXT).setEnabled(false);
                this.naviButtons.get((Object)Navigation.CANCEL).setEnabled(true);
                break;
            }
            case MIDDLE_STEP_SUCCESS: {
                this.naviButtons.get((Object)Navigation.PREVIOUS).setEnabled(false);
                this.naviButtons.get((Object)Navigation.NEXT).setEnabled(true);
                this.naviButtons.get((Object)Navigation.CANCEL).setEnabled(true);
                break;
            }
        }
    }

    private void setChangeThirdStep(FlowWizardState state) {
        switch (state) {
            case MIDDLE_STEP_FAILED: {
                this.naviButtons.get((Object)Navigation.NEXT).setEnabled(false);
                this.naviButtons.get((Object)Navigation.PREVIOUS).setEnabled(true);
                this.naviButtons.get((Object)Navigation.CANCEL).setEnabled(true);
                break;
            }
            case MIDDLE_STEP_DISABLE: {
                this.naviButtons.get((Object)Navigation.PREVIOUS).setEnabled(false);
                this.naviButtons.get((Object)Navigation.NEXT).setEnabled(false);
                this.naviButtons.get((Object)Navigation.CANCEL).setEnabled(false);
                break;
            }
            case MIDDLE_STEP_NEXT: {
                this.naviButtons.get((Object)Navigation.NEXT).setEnabled(true);
                this.naviButtons.get((Object)Navigation.PREVIOUS).setEnabled(false);
                this.naviButtons.get((Object)Navigation.CANCEL).setEnabled(false);
                break;
            }
        }
    }

    private void initComponent() {
        JButton previous = UiMethod.createButton(Navigation.PREVIOUS.toString(this.loc), 'P');
        JButton next = UiMethod.createButton(Navigation.NEXT.toString(this.loc), 'N');
        JButton complete = UiMethod.createButton(Navigation.COMPLETE.toString(this.loc), 'F');
        JButton cancel = UiMethod.createButton(Navigation.CANCEL.toString(this.loc), 'C');
        this.naviButtons.put(Navigation.PREVIOUS, previous);
        this.naviButtons.put(Navigation.NEXT, next);
        this.naviButtons.put(Navigation.COMPLETE, complete);
        this.naviButtons.put(Navigation.CANCEL, cancel);
    }

    private void initButtonState() {
        for (Map.Entry<Navigation, JButton> entry : this.naviButtons.entrySet()) {
            entry.getValue().setEnabled(true);
        }
    }

    private void bondListener() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent ev) {
                if (!FlowWizardDialog.this.flow.exit()) {
                    FlowWizardDialog.this.setDefaultCloseOperation(0);
                } else {
                    FlowWizardDialog.this.setDefaultCloseOperation(2);
                }
            }
        });
        this.naviButtons.get((Object)Navigation.PREVIOUS).addActionListener(new PreviousAction());
        this.naviButtons.get((Object)Navigation.NEXT).addActionListener(new NextAction());
        this.naviButtons.get((Object)Navigation.CANCEL).addActionListener(new CancelAction());
        this.naviButtons.get((Object)Navigation.COMPLETE).addActionListener(new CompleteAction());
    }

    private void initUI() {
        ArrayList<WizardStepItem> stepList = new ArrayList<WizardStepItem>();
        int i = 1;
        for (Title title : this.stageTitles) {
            String link = title.getLink(this.loc);
            if (null == link) {
                link = "";
            }
            WizardStepItem step = new WizardStepItem(title.getName(this.loc), title.getDesc(this.loc), i, this.loc);
            if (1 == i) {
                step.setSelected(true);
            }
            stepList.add(step);
            ++i;
        }
        this.stepsGroup.setSetps(stepList.toArray(new WizardStepItem[stepList.size()]));
        this.navigationBar = Box.createHorizontalBox();
        this.contentPane = new JPanel(new BorderLayout());
        this.southBox.add(Box.createVerticalStrut(12));
        this.southBox.add(this.navigationBar);
        JPanel pane = this.getWizardPanel(this.helpDir);
        this.southBox.setPreferredSize(new Dimension((int)this.getPreferredSize().getWidth(), 39));
        pane.setBackground(WizardConstants.WIZARD_BACKGROUND);
        int windowWidth = StringUtils.isNULLStr(this.customWindowSizeMap.get("width")) ? 900 : Integer.parseInt(this.customWindowSizeMap.get("width"));
        int windowHeight = StringUtils.isNULLStr(this.customWindowSizeMap.get("height")) ? 650 : Integer.parseInt(this.customWindowSizeMap.get("height"));
        pane.setPreferredSize(new Dimension(windowWidth, windowHeight));
        JPanel buttomPanel = new JPanel();
        buttomPanel.setPreferredSize(new Dimension((int)this.getPreferredSize().getWidth(), 6));
        buttomPanel.setBackground(WizardConstants.WIZARD_BUTTOM_LINE_COLOR);
        Container container = this.getContentPane();
        this.setLayout(new BorderLayout());
        container.add((Component)pane, "Center");
        container.add((Component)buttomPanel, "South");
        int height = (int)this.stepsGroup.getPreferredSize().getHeight() + 6 + 39;
        this.setSize(height / 3 * 4, height);
        this.setCompName();
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.pack();
        this.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
    }

    protected JPanel getWizardPanel(String helpPath) {
        JPanel pane = new JPanel(new BorderLayout());
        pane.add((Component)this.stepsGroup, "West");
        pane.add((Component)this.contentPane, "Center");
        pane.add((Component)this.southBox, "South");
        return pane;
    }

    private void setCompName() {
        this.naviButtons.get((Object)Navigation.CANCEL).setName("_Button_cancel");
        this.naviButtons.get((Object)Navigation.NEXT).setName("_Button_next");
        this.naviButtons.get((Object)Navigation.PREVIOUS).setName("_Button_previous");
        this.naviButtons.get((Object)Navigation.COMPLETE).setName("_Button_complete");
    }

    public Flow getFlow() {
        if (this.flow instanceof Flow) {
            return (Flow)this.flow;
        }
        return null;
    }

    public void clickNaviButton(Navigation button) {
        JButton naviButton = this.naviButtons.get((Object)button);
        JButton completeButton = this.naviButtons.get((Object)Navigation.COMPLETE);
        if (button == Navigation.NEXT && completeButton.isShowing()) {
            completeButton.setEnabled(true);
            completeButton.doClick();
        } else {
            naviButton.setEnabled(true);
            naviButton.doClick();
        }
    }

    private final class CancelAction
    implements ActionListener {
        private CancelAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (FlowWizardDialog.this.flow.exit()) {
                FlowWizardDialog.this.dispose();
            }
        }
    }

    private final class CompleteAction
    implements ActionListener {
        private CompleteAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (FlowWizardDialog.this.flow.complete()) {
                FlowWizardDialog.this.dispose();
            }
        }
    }

    private final class NextAction
    implements ActionListener {
        private NextAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FlowWizardDialog.this.flow.goNext();
        }
    }

    private final class PreviousAction
    implements ActionListener {
        private PreviousAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FlowWizardDialog.this.flow.goPrevious();
        }
    }
}

