/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uMate.common;

import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.uMate.common.GlobalStaticValue;
import com.huawei.uMate.common.UMateException;
import com.huawei.uMate.common.log.Logger;
import com.huawei.uMate.common.utils.ResUtil;
import com.huawei.uMate.common.utils.SecurityUtils;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Locale;

public class CommonMethods {
    private static final Logger LOGGER = new Logger(CommonMethods.class);
    private static final ResUtil RES = ResUtil.getInstance("common");
    public static final String BUNDLE_UPGRADE_PKG_PATH = "template/BundleUpgrade/FirmwarePackages/";

    public static boolean checkIP(String ip) {
        if (ip == null || "".equals(ip)) {
            return false;
        }
        String regex = "^(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|[1-9])\\.(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|\\d)\\.(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|\\d)\\.(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|\\d)$|0.0.0.0";
        String regex6 = SecurityUtils.getregxIPv6();
        return ip.matches(regex) || ip.matches(regex6);
    }

    public static boolean checkIPv4(String ip) {
        if (StringUtils.isNULLStr((String)ip)) {
            return false;
        }
        String regex = "^(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|[1-9])\\.(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|\\d)\\.(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|\\d)\\.(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|\\d)$";
        return ip.matches(regex);
    }

    public static boolean checkIPv6(String ip) {
        if (StringUtils.isNULLStr((String)ip)) {
            return false;
        }
        String regex6 = SecurityUtils.getregxIPv6();
        return ip.matches(regex6);
    }

    public static boolean checkIPZero(String ip) {
        if (!ip.contains(".") && !ip.contains(":")) {
            try {
                if (0 <= Integer.parseInt(ip) && Integer.parseInt(ip) <= 128) {
                    return true;
                }
            }
            catch (NumberFormatException e) {
                LOGGER.error(e);
                return false;
            }
        }
        if (CommonMethods.checkIP(ip)) {
            return true;
        }
        return ip.equals("0.0.0.0");
    }

    public static boolean checkPort(String port, String portName) throws UMateException {
        String validPort;
        String string = validPort = port == null ? "" : port.trim();
        if ("".equals(validPort)) {
            throw new UMateException(portName + RES.getString("common.message.port.empty"));
        }
        try {
            if (Integer.parseInt(validPort) > 65535) {
                throw new UMateException(portName + RES.getString("common.message.port.range"));
            }
            if (Integer.parseInt(validPort) < 1) {
                throw new UMateException(portName + RES.getString("common.message.port.range"));
            }
        }
        catch (NumberFormatException ex) {
            if (validPort.matches("[0-9]+")) {
                throw new UMateException(portName + RES.getString("common.message.port.range"));
            }
            throw new UMateException(portName + RES.getString("common.message.port.number"));
        }
        return true;
    }

    public static void logEnvironment(boolean isUMate) {
        try {
            if (isUMate) {
                LOGGER.info(GlobalStaticValue.UMATE_VERSION);
            } else {
                LOGGER.info(GlobalStaticValue.INFOCOLLECT_VERSION);
            }
            LOGGER.info(String.format(Locale.ROOT, "JAVA_HOME:%s,version:%s.", System.getProperty("java.home"), System.getProperty("java.version")));
            LOGGER.info(String.format(Locale.ROOT, "OS name:%s,version:%s,language:%s.", System.getProperty("os.name"), System.getProperty("os.version"), System.getProperty("user.language")));
            LOGGER.info("Execution directory:" + System.getProperty("user.dir"));
            LOGGER.info(String.format(Locale.ROOT, "User name:%s", System.getProperty("user.name")));
            LOGGER.info(String.format(Locale.ROOT, "Host name:%s.", InetAddress.getLocalHost().getHostName()));
        }
        catch (UnknownHostException ex) {
            LOGGER.error(ex);
        }
    }
}

