/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uMate.common.rest;

import com.huawei.uMate.HWDiscover.model.HWDiscoverModel;
import com.huawei.uMate.common.UMateException;
import com.huawei.uMate.common.log.Logger;
import com.huawei.uMate.common.rest.RedfishConnestion;
import com.huawei.uMate.common.rest.RedfishResult;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class RedfishExecutor {
    private static final Logger LOGGER = new Logger(RedfishExecutor.class);
    private static final Map<String, RedfishConnestion> CONN_MAP = new ConcurrentHashMap<String, RedfishConnestion>();
    public static final String POST = "POST";
    public static final String GET = "GET";
    public static final String PATCH = "PATCH";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RedfishConnestion prepareConn(HWDiscoverModel destModel) {
        if (destModel == null) {
            return null;
        }
        RedfishConnestion conn = CONN_MAP.get(destModel.getDeviceKey());
        if (conn == null) {
            Map<String, RedfishConnestion> map = CONN_MAP;
            synchronized (map) {
                conn = CONN_MAP.get(destModel.getDeviceKey());
                if (conn == null) {
                    conn = new RedfishConnestion(destModel);
                    boolean conres = conn.connect();
                    if (!conres) {
                        LOGGER.error("connect to server error :" + destModel.getDeviceKey());
                        return null;
                    }
                    CONN_MAP.put(destModel.getDeviceKey(), conn);
                }
            }
        }
        return conn;
    }

    public static RedfishResult reqGet(HWDiscoverModel destModel, String url) {
        RedfishConnestion conn = RedfishExecutor.prepareConn(destModel);
        if (conn == null) {
            LOGGER.error(String.format(Locale.ENGLISH, "faled to connect redfish to %s", destModel.getIPAddress()));
            return RedfishResult.createConnErrorResult();
        }
        return conn.executeGet(url);
    }

    public static HWDiscoverModel createDevModel(String destKey, String username, String password, String port) throws UMateException {
        HWDiscoverModel destModel = new HWDiscoverModel();
        destModel.setIPAddress(destKey.replaceAll("[\\[\\]]", ""));
        destModel.setUserName(username);
        destModel.setUserPwd(password);
        destModel.setHTTPSPort(port);
        return destModel;
    }
}

