/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uMate.common.rest;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.uMate.common.log.Logger;
import com.huawei.uMate.common.utils.ResUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class RedfishResult {
    public static final String CONN_INIT_ERROR = "-1";
    public static final String CONN_HOST_ERROR = "-2";
    public static final String RESP_ERROR = "-3";
    public static final List<String> NOT_RETRY_ERROR = Arrays.asList("-1", "-2", "-3", "404");
    private static final ResUtil RES = ResUtil.getInstance("common");
    private static final Logger LOGGER = new Logger(RedfishResult.class);
    private boolean isSuccess;
    private String errorCode;
    private String errorMsg;
    private String statusCode;
    private String result;
    private JSONObject resultJSON;
    private Map<String, String> headers;
    private String soluation;

    public RedfishResult() {
    }

    public RedfishResult(boolean isSuccess, String errorCode, String errorMsg, String result) {
        this.isSuccess = isSuccess;
        this.errorCode = errorCode;
        this.errorMsg = errorMsg;
        this.result = result;
    }

    public static RedfishResult createConnErrorResult() {
        return new RedfishResult(CONN_INIT_ERROR, RES.getString("config.check.device.redfish.conn.error"));
    }

    public RedfishResult(String errorCode, String errorMsg) {
        this.errorCode = errorCode;
        this.errorMsg = errorMsg;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public String getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(String statusCode) {
        this.statusCode = statusCode;
    }

    public boolean isSuccess() {
        return this.isSuccess;
    }

    public boolean isNotRetryError() {
        return CONN_INIT_ERROR.equals(this.errorCode) || CONN_HOST_ERROR.equals(this.errorCode);
    }

    public void setSuccess(boolean success) {
        this.isSuccess = success;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    public String getResult() {
        return this.result == null ? "" : this.result;
    }

    public void setResult(String result) {
        this.result = result;
    }

    public JSONObject getResultJSON() {
        if (StringUtils.isNULLStr((String)this.result)) {
            return null;
        }
        try {
            if (this.resultJSON != null) {
                return this.resultJSON;
            }
            this.resultJSON = JSON.parseObject(this.result);
            return this.resultJSON;
        }
        catch (Exception e) {
            LOGGER.error(String.format(Locale.ENGLISH, "format json error:%s", this.result));
            return null;
        }
    }

    public String getSoluation() {
        return this.soluation;
    }

    public void setSoluation(String soluation) {
        this.soluation = soluation;
    }

    public static RedfishResult createConnHostError() {
        RedfishResult result = new RedfishResult(CONN_HOST_ERROR, RES.getString("common.message.redfish.conn.fail.tip"));
        result.setSoluation(RES.getString("common.message.redfish.conn.fail.solution.tip"));
        return result;
    }

    public boolean isPwdError() {
        return this.result != null && this.result.contains("UserNamePasswordError");
    }
}

