/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uMate.common.utils;

import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.util.NetUtil;
import com.huawei.uMate.common.log.Logger;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DataCheckUtil {
    private static final Logger LOGGER = new Logger(DataCheckUtil.class);
    private static final String EMAIL_REGEX = "^[\\w`~!#$%^&*\\(\\)_+\\|\\-\\=\\{\\}\\[\\]\\:\\;\\,\\<\\>\\.\\?\\/a-z0-9A-Z*][^@]+@\\w+([-.]\\w+)*\\.\\w+([-.]\\w+)*";
    private static final String DOMAIN_REGEX = "^((25[0-5])|(2[0-4]\\d)|(1\\d\\d)|([1-9]\\d)|\\d)(\\.((25[0-5])|(2[0-4]\\d)|(1\\d\\d)|([1-9]\\d)|\\d)){3}$|^([a-zA-Z0-9]([a-zA-Z0-9\\-]{0,61}[a-zA-Z0-9])?\\.)+[a-zA-Z]{2,6}$";
    private static final String SCOPE_REGEX = "^(?![A-Za-z0-9]+$)(?![a-z0-9\\W]+$)(?![A-Za-z\\W]+$)(?![A-Z0-9\\W]+$)[a-zA-Z0-9\\W]{1,}$";
    private static final String NUM_REGEX = "[0-9]*";
    private static final int NUM = 255;
    private static final int USERNAME_LENGTH = 64;
    private static final int MIN_VALUE = 1;
    private static final int MAX_VALUE = 65535;
    private static final int GROUPNAME_MIN_VALUE = 8;
    private static final int GROUPNAME_MAX_VALUE = 18;

    public static boolean isValidRange(String toCheckStr, int startData, int endData) {
        try {
            if (toCheckStr == null) {
                return false;
            }
            Integer toCheck = Integer.parseInt(toCheckStr);
            return startData < toCheck && toCheck < endData;
        }
        catch (NumberFormatException e) {
            LOGGER.error(String.format(Locale.ENGLISH, "toCheckStr is not valid:%s ", toCheckStr));
            return false;
        }
    }

    public static boolean isValidRange(int toCheck, int startData, int endData) {
        return startData < toCheck && toCheck < endData;
    }

    public static boolean isValidServerAddress(String toCheck, boolean isAllowEmpty) {
        if (isAllowEmpty && StringUtils.isNULLStr((String)toCheck)) {
            return true;
        }
        if (NetUtil.isValidIP((String)toCheck)) {
            return !toCheck.substring(0, 3).equalsIgnoreCase("fe8");
        }
        if (StringUtils.isNULLStr((String)toCheck.replaceAll("[0-9\\.]", ""))) {
            return false;
        }
        if (StringUtils.isNULLStr((String)toCheck)) {
            return false;
        }
        if (toCheck.length() > 255) {
            return false;
        }
        if (toCheck.matches(DOMAIN_REGEX)) {
            return true;
        }
        return toCheck.equals("::");
    }

    public static boolean isValidDesc(String toCheck, boolean isAllowEmpty, int maxSize) {
        if (isAllowEmpty && StringUtils.isNULLStr((String)toCheck)) {
            return true;
        }
        for (int i = 0; i < toCheck.length(); ++i) {
            if (!DataCheckUtil.isChinesePunctuation(toCheck.charAt(i))) continue;
            return false;
        }
        return !DataCheckUtil.isContainChinese(toCheck) && toCheck.length() <= maxSize;
    }

    public static boolean isChinesePunctuation(char chr) {
        Character.UnicodeBlock ub = Character.UnicodeBlock.of(chr);
        return ub == Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION || ub == Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS || ub == Character.UnicodeBlock.CJK_COMPATIBILITY_FORMS || ub == Character.UnicodeBlock.VERTICAL_FORMS;
    }

    public static boolean isValidEmail(String toCheck, boolean isAllowEmpty) {
        if (isAllowEmpty && StringUtils.isNULLStr((String)toCheck)) {
            return true;
        }
        if (StringUtils.isNULLStr((String)toCheck)) {
            return false;
        }
        return !DataCheckUtil.isContainChinese(toCheck) && toCheck.length() < 256 && toCheck.matches(EMAIL_REGEX);
    }

    public static boolean isValidEmailSubject(String toCheck, boolean isAllowEmpty) {
        if (isAllowEmpty && StringUtils.isNULLStr((String)toCheck)) {
            return true;
        }
        return toCheck.matches(SCOPE_REGEX) && toCheck.length() <= 255;
    }

    public static boolean isValidUserNameAndPassword(String checkUserName, String checkPassword, boolean isAllowEmpty) {
        if (isAllowEmpty && StringUtils.isNULLStr((String)checkUserName)) {
            return true;
        }
        if (!checkUserName.matches(SCOPE_REGEX)) {
            return false;
        }
        if (checkUserName.indexOf(" ") != -1 || checkUserName.length() > 64) {
            return false;
        }
        if (isAllowEmpty && StringUtils.isNULLStr((String)checkPassword)) {
            return true;
        }
        return true;
    }

    public static boolean isValidUserName(String checkUserInfo, boolean isAllowEmpty) {
        if (isAllowEmpty && StringUtils.isNULLStr((String)checkUserInfo)) {
            return true;
        }
        if (StringUtils.isNULLStr((String)checkUserInfo)) {
            return false;
        }
        return !DataCheckUtil.isContainChinese(checkUserInfo) && checkUserInfo.indexOf(" ") == -1 && checkUserInfo.length() <= 64;
    }

    public static boolean isValidGroupName(String checkGroupName, boolean isAllowEmpty) {
        if (isAllowEmpty && StringUtils.isNULLStr((String)checkGroupName)) {
            return true;
        }
        if (checkGroupName.indexOf(" ") != -1) {
            return false;
        }
        return checkGroupName.length() >= 8 && checkGroupName.length() <= 18;
    }

    public static boolean isContainChinese(String str) {
        Pattern pattern = Pattern.compile("[\u4e00-\u9fa5]");
        Matcher matcher = pattern.matcher(str);
        return matcher.find();
    }

    public static boolean isValidNumParam(String checkNum, boolean isAllowEmpty) {
        if (checkNum.length() > 9) {
            return false;
        }
        if (isAllowEmpty && StringUtils.isNULLStr((String)checkNum)) {
            return true;
        }
        if (StringUtils.isNULLStr((String)checkNum)) {
            return false;
        }
        if (checkNum.indexOf(" ") != -1) {
            return false;
        }
        if (checkNum.matches(NUM_REGEX)) {
            return Integer.valueOf(checkNum) >= 1 && Integer.valueOf(checkNum) <= 65535;
        }
        return false;
    }
}

