/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.base.context;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmartKitClassLoader
extends ClassLoader {
    private static final Logger log = LoggerFactory.getLogger(SmartKitClassLoader.class);
    private final Set<String> needLoadJarPaths;
    private final Map<String, String> needLoadClassPath;
    private final Map<String, String> classNameToClassPathInJar = new HashMap<String, String>();
    private final Map<String, List<String>> jarPathAndContainClassName = new HashMap<String, List<String>>();
    private ClassLoader extClassLoader;

    public SmartKitClassLoader(Set<String> needLoadJarPaths, Map<String, String> needLoadClassPath) {
        this.needLoadJarPaths = needLoadJarPaths != null ? needLoadJarPaths : new HashSet();
        this.needLoadClassPath = needLoadClassPath != null ? needLoadClassPath : new HashMap();
        this.initClassPath();
        this.initExtClassLoader();
    }

    private void initExtClassLoader() {
        for (ClassLoader classLoader = this.getClass().getClassLoader(); classLoader != null; classLoader = classLoader.getParent()) {
            if (!classLoader.getClass().getName().contains("ExtClassLoader")) continue;
            this.extClassLoader = classLoader;
            break;
        }
    }

    private void initClassPath() {
        log.info("default classloader: {}", (Object)this.getClass().getClassLoader());
        this.needLoadJarPaths.stream().filter(this::isLegalJarPath).forEach(this::parseJarFile);
        this.needLoadClassPath.values().removeIf(this::isIllegalClassPath);
    }

    private boolean isLegalJarPath(String path) {
        if (!path.endsWith(".jar")) {
            log.warn("{} is not end with .jar", (Object)path);
            return false;
        }
        return !this.notExitOrIsDirectory(path);
    }

    private boolean isIllegalClassPath(String path) {
        if (!path.endsWith(".class")) {
            log.warn("{} is not end with class", (Object)path);
            return true;
        }
        if (this.notExitOrIsDirectory(path)) {
            return true;
        }
        log.info("add class path: {}", (Object)path);
        return false;
    }

    private boolean notExitOrIsDirectory(String path) {
        File file = new File(path);
        if (!file.exists()) {
            log.warn("{} is not exits", (Object)path);
            return true;
        }
        if (file.isDirectory()) {
            log.warn("{} is directory", (Object)path);
            return true;
        }
        return false;
    }

    private void parseJarFile(String jarPath) {
        File file = new File(jarPath);
        try (JarFile jarFile = new JarFile(file);){
            log.info("read jar file: {}", (Object)jarPath);
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                this.parseJarContainClass(jarPath, entries.nextElement());
            }
        }
        catch (FileNotFoundException e) {
            log.error("{} not found", (Object)file.getName());
        }
        catch (IOException e) {
            log.error("read jar file {} error", (Object)file.getName(), (Object)e);
        }
    }

    private void parseJarContainClass(String jarPath, JarEntry entry) {
        String entryName = entry.getName();
        if (!entry.isDirectory() && entryName.endsWith(".class")) {
            String className = entryName.replace("/", ".").substring(0, entryName.length() - 6);
            this.classNameToClassPathInJar.put(className, entryName);
            this.jarPathAndContainClassName.computeIfAbsent(jarPath, key -> new ArrayList()).add(className);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            Optional<Class<?>> result;
            if (this.extClassLoader != null && (result = this.loadClassByJdkClassLoader(name)).isPresent()) {
                return result.get();
            }
            Class<?> loadedClass = this.findLoadedClass(name);
            if (loadedClass != null) {
                return loadedClass;
            }
            byte[] content = this.readClassBytes(name);
            if (content != null && content.length > 0) {
                log.info("{} loaded by smartkit classloader", (Object)name);
                return this.defineClass(name, content, 0, content.length);
            }
            return this.readClassByDefaultClassLoader(name).orElse(null);
        }
    }

    private Optional<Class<?>> loadClassByJdkClassLoader(String name) {
        try {
            return Optional.ofNullable(this.extClassLoader.loadClass(name));
        }
        catch (ClassNotFoundException classNotFoundException) {
            return Optional.empty();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Optional<Class<?>> readClassByDefaultClassLoader(String name) throws ClassNotFoundException {
        String path = name.replace(".", "/") + ".class";
        try (InputStream in = this.getClass().getClassLoader().getResourceAsStream(path);){
            if (in == null) {
                log.warn("can't find {} class bytes file", (Object)name);
                Optional<Class<?>> optional = Optional.empty();
                return optional;
            }
            byte[] content = IOUtils.toByteArray((InputStream)in);
            if (content == null) throw new ClassNotFoundException(name + " not found");
            if (content.length <= 0) throw new ClassNotFoundException(name + " not found");
            log.info("{} loaded by smartkit classloader", (Object)name);
            Optional<Class<?>> optional = Optional.ofNullable(this.defineClass(name, content, 0, content.length));
            return optional;
        }
        catch (IOException e) {
            log.error("{} read class bytes error", (Throwable)e);
        }
        throw new ClassNotFoundException(name + " not found");
    }

    private byte[] readClassBytes(String name) {
        if (this.needLoadClassPath.containsKey(name)) {
            return this.readBytesFromClass(name);
        }
        return this.jarPathAndContainClassName.entrySet().stream().filter(entry -> ((List)entry.getValue()).contains(name)).map(Map.Entry::getKey).findFirst().map(jarPath -> this.readBytesFromJar(name, (String)jarPath)).orElse(new byte[0]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] readBytesFromJar(String name, String jarPath) {
        try (JarFile jarFile = new JarFile(new File(jarPath));){
            byte[] byArray = this.readBytesInJar(this.classNameToClassPathInJar.get(name), jarFile);
            return byArray;
        }
        catch (FileNotFoundException e) {
            log.error("can't find jar file");
            return new byte[0];
        }
        catch (IOException e) {
            log.error("read jar file {} error", (Object)jarPath, (Object)e);
        }
        return new byte[0];
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] readBytesInJar(String path, JarFile jarFile) {
        try (InputStream in = jarFile.getInputStream(jarFile.getEntry(path));){
            byte[] byArray = IOUtils.toByteArray((InputStream)in);
            return byArray;
        }
        catch (FileNotFoundException e) {
            log.error("can't find {} in jar", (Object)path);
            return new byte[0];
        }
        catch (IOException e) {
            log.error("read {} error", (Object)path, (Object)e);
        }
        return new byte[0];
    }

    private byte[] readBytesFromClass(String name) {
        File file = new File(this.needLoadClassPath.get(name));
        try {
            return FileUtils.readFileToByteArray((File)file);
        }
        catch (FileNotFoundException e) {
            log.error("{} not found", (Object)file.getName());
        }
        catch (IOException e) {
            log.error("read {} in {} error", new Object[]{name, file.getName(), e});
        }
        return new byte[0];
    }
}

