/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.base.start;

import com.huawei.ism.tool.base.start.StartParam;
import java.util.Arrays;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractStartParam<T>
implements StartParam<T> {
    private static final Logger log = LoggerFactory.getLogger(AbstractStartParam.class);
    private final String needParamName;
    private final T needResult;

    protected AbstractStartParam(String[] args, String needParamName) {
        this.needParamName = needParamName;
        this.needResult = this.getParseResult(args);
    }

    private T getParseResult(String[] args) {
        log.info("start parse start param from input");
        if (args != null) {
            return this.parseNeedResultByArgs(args);
        }
        log.info("start parse start param from env");
        return this.parseNeedResultByEnv();
    }

    private T parseNeedResultByArgs(String[] args) {
        Optional<String> need = Arrays.stream(args).filter(param -> StringUtils.startsWithIgnoreCase((CharSequence)param, (CharSequence)this.needParamName)).findFirst();
        if (need.isPresent()) {
            return this.parseNeedParam(need.get().substring(this.needParamName.length()));
        }
        log.info("start parse start param from env");
        return this.parseNeedResultByEnv();
    }

    private T parseNeedResultByEnv() {
        String envKey = this.getEnvKey(this.needParamName);
        String envValue = System.getenv(envKey);
        log.info("env param: {}={}", (Object)envKey, (Object)envValue);
        return this.parseNeedParam(envValue);
    }

    protected abstract T parseNeedParam(String var1);

    @Override
    public T getStartParam() {
        return this.needResult;
    }

    private String getEnvKey(String needField) {
        String result = "";
        if (needField.startsWith("-")) {
            result = needField.substring(1);
        }
        if (result.endsWith("=")) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }
}

