/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.framework.platform.pwdSecurityResMgr;

import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.platform.pwdSecurityResMgr.PwdSecurityType;
import com.huawei.ism.tool.framework.platform.pwdSecurityResMgr.PwdSecurityUserScene;
import com.huawei.ism.tool.framework.platform.resource.PlatformResource;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.framework.platform.util.LanguageManager;
import java.util.Locale;

public class PwdSecurityResMgr {
    private static final PwdSecurityResMgr INSTANCE = new PwdSecurityResMgr();

    private PwdSecurityResMgr() {
    }

    public static PwdSecurityResMgr getInstance() {
        return INSTANCE;
    }

    public String getDesc(PwdSecurityType type, PwdSecurityUserScene scenne) {
        if (PwdSecurityType.CLISOVERRUN.equals((Object)type)) {
            return this.getResourceByKey("login.clis.overrun.info");
        }
        String desc = this.handleSpeficDev(type, scenne);
        if (desc != null) {
            return desc;
        }
        return this.handleMultiDewvMgrDesc(type, scenne);
    }

    private String handleMultiDewvMgrDesc(PwdSecurityType type, PwdSecurityUserScene scenne) {
        if (PwdSecurityUserScene.DeviceMgr.equals((Object)scenne)) {
            if (PwdSecurityType.INIT_PWD_NOT_CHANGE.equals((Object)type)) {
                return this.getResourceByKey("lowlevel.deviceMgr.tool.connet.initPwd.not.change.info");
            }
            if (PwdSecurityType.PWD_WILL_EXPIRE.equals((Object)type)) {
                return this.getResourceByKey("lowlevel.deviceMgr.tool.connet.pwd.willexpired.info");
            }
            if (PwdSecurityType.UN_SAFE.equals((Object)type)) {
                return this.getResourceByKey("lowlevel.deviceMgr.tool.connet.pwd.unsafe.info");
            }
            return this.getResourceByKey("lowlevel.deviceMgr.tool.connet.pwd.expired.info");
        }
        if (PwdSecurityType.INIT_PWD_NOT_CHANGE.equals((Object)type)) {
            return this.getResourceByKey("lowlevel.tool.connet.initPwd.not.change.info");
        }
        if (PwdSecurityType.PWD_WILL_EXPIRE.equals((Object)type)) {
            return this.getResourceByKey("lowlevel.tool.connet.pwd.willexpired.info");
        }
        if (PwdSecurityType.UN_SAFE.equals((Object)type)) {
            return this.getResourceByKey("lowlevel.tool.connet.pwd.unsafe.info");
        }
        return this.getResourceByKey("lowlevel.tool.connet.pwd.expired.info");
    }

    private String handleSpeficDev(PwdSecurityType type, PwdSecurityUserScene scenne) {
        if (ApplicationContext.getInstance().isSpecificDeviceMode()) {
            if (PwdSecurityUserScene.DeviceMgr.equals((Object)scenne)) {
                if (PwdSecurityType.INIT_PWD_NOT_CHANGE.equals((Object)type)) {
                    return this.getResourceByKey("highlevel.deviceMgr.tool.connet.initPwd.not.change.info");
                }
                if (PwdSecurityType.PWD_WILL_EXPIRE.equals((Object)type)) {
                    return this.getResourceByKey("highlevel.deviceMgr.tool.connet.pwd.willexpired.info");
                }
                if (PwdSecurityType.UN_SAFE.equals((Object)type)) {
                    return this.getResourceByKey("highlevel.deviceMgr.tool.connet.pwd.unsafe.info");
                }
                return this.getResourceByKey("highlevel.deviceMgr.tool.connet.pwd.expired.info");
            }
            if (PwdSecurityType.INIT_PWD_NOT_CHANGE.equals((Object)type)) {
                return this.getResourceByKey("highlevel.tool.connet.initPwd.not.change.info");
            }
            if (PwdSecurityType.PWD_WILL_EXPIRE.equals((Object)type)) {
                return this.getResourceByKey("highlevel.tool.connet.pwd.willexpired.info");
            }
            if (PwdSecurityType.UN_SAFE.equals((Object)type)) {
                return this.getResourceByKey("highlevel.tool.connet.pwd.unsafe.info");
            }
            return this.getResourceByKey("highlevel.tool.connet.pwd.expired.info");
        }
        return null;
    }

    public String queryUpdateDesc(String errorMsg) {
        ToolLoggerFactory.getLogger(this.getClass()).info("query update desc, original msg is \"" + errorMsg + "\".");
        if (this.getResourceByKey("lowlevel.deviceMgr.tool.connet.initPwd.not.change.info").equals(errorMsg)) {
            return this.getResourceByKey("lowlevel.tool.connet.initPwd.not.change.info");
        }
        if (this.getResourceByKey("lowlevel.deviceMgr.tool.connet.pwd.willexpired.info").equals(errorMsg)) {
            return this.getResourceByKey("lowlevel.tool.connet.pwd.willexpired.info");
        }
        if (this.getResourceByKey("login.clis.overrun.info").equals(errorMsg)) {
            return this.getResourceByKey("login.clis.overrun.info");
        }
        return this.getResourceByKey("lowlevel.tool.connet.pwd.expired.info");
    }

    public String queryImportDesc(String errorMsg) {
        ToolLoggerFactory.getLogger(this.getClass()).info("query import desc, original msg is \"" + errorMsg + "\".");
        if (this.getResourceByKey("lowlevel.deviceMgr.tool.connet.initPwd.not.change.info").equals(errorMsg)) {
            return this.getResourceByKey("lowlevel.deviceMgr.import.tool.connet.initPwd.not.change.info");
        }
        if (this.getResourceByKey("lowlevel.deviceMgr.tool.connet.pwd.willexpired.info").equals(errorMsg)) {
            return this.getResourceByKey("lowlevel.deviceMgr.import.tool.connet.pwd.willexpired.info");
        }
        if (this.getResourceByKey("login.clis.overrun.info").equals(errorMsg)) {
            return this.getResourceByKey("login.clis.overrun.info");
        }
        return this.getResourceByKey("lowlevel.deviceMgr.import.tool.connet.pwd.expired.info");
    }

    public String getResourceByKey(String key) {
        Locale loc = LanguageManager.getInstance().getCurrentLanguage();
        return PlatformResource.getInstance().getString(loc, key);
    }
}

