/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.framework.pubservice.sceneimpl;

import com.huawei.ism.tool.base.utils.SceneUtils;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.base.utils.XmlUtils;
import com.huawei.ism.tool.framework.platform.exception.ToolException;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.framework.pubservice.common.devmanage.ISceneBean;
import com.huawei.ism.tool.framework.pubservice.common.devmanage.ISceneEnvironment;
import com.huawei.ism.tool.framework.pubservice.entity.DevNode;
import com.huawei.ism.tool.framework.pubservice.entity.ScenePathValue;
import com.huawei.ism.tool.framework.pubservice.entity.SceneUserValue;
import com.huawei.ism.tool.framework.pubservice.entity.SceneValue;
import com.huawei.ism.tool.framework.pubservice.entity.TaskResult;
import com.huawei.ism.tool.framework.pubservice.entity.ToolSceneData;
import com.huawei.ism.tool.framework.pubservice.entity.ToolSceneDataKey;
import com.huawei.ism.tool.framework.pubservice.scenedata.SceneDataConstant;
import com.huawei.ism.tool.framework.pubservice.scenedata.SceneDeviceData;
import com.huawei.ism.tool.framework.pubservice.scenedata.SceneXmlData;
import com.huawei.ism.tool.framework.pubservice.utils.DateFormatUtil;
import com.huawei.json.JSONObject;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class SceneEnvironmentImpl
extends SceneDataConstant
implements ISceneEnvironment {
    private static final String TOOLS = "tools";
    private static final String SCENE_DEVICE_LIST_XML = "sceneDeviceList.xml";
    private static String sceneDevicelistXmlPath;
    private static final ISceneEnvironment INSTANCE;
    private static final int IS_FIRST_WRITE = 1;
    private static File sceneDeviceListXml;
    private static final File SCENEDATAXML;
    private static final Logger LOGGER;
    private List<String> strKey = new LinkedList<String>();
    private String[] xmlToolIdDevElement = new String[]{"status", "fileName", "fileLog"};
    private static final String SKIP_DEVICE = "isSkipDeviceAdd";
    private String[] xmlDynamicStepElement = new String[]{"infoUrl_id", "type", "title_zh", "title_en"};
    private String[] xmlToolFutherProcess = new String[]{"info_title", "info_description", "link_title", "link_path", "operation_status"};
    private String[] xmlNoRealtedDevElement = new String[]{"deviceName", "productVersion", "hotpatchversion", "deviceType", "itDeviceType", "devTypeLevel2", "socks5Proxy", "sshForwardList", "ipList", "tlvSocketType", "peerIp", "userName", "hostFCLauncherWwns", "password", "developerPwd", "rootPassword", "createTime", "port", "tlvPort", "hostISCSILauncherWwns", "devInfoPkgPath", "isHyperMetroHost", "nodeAddType", "ipListAreInnerIp", "PriKeyInfo", "remoteSNs", "hostAssociatedRemoteSN", "dbName", "useJdbc", "adminName", "adminPassword", "domainName", "status", "reason", "isSVPSupport", "highDevSVPModuleInfo", "hostIbLauncherWwns", "hostNvmeLauncherWwns", "canEnterDiagnose", "isVerifyCertificate", "computeStorageInfoFcvOpenApiUserName", "computeStorageInfoFcvStorageUserName", "computeStorageInfoList", "computeStorageInfoFcvOpenApiUserPwd", "computeStorageInfoChassisNum", "computeStorageInfoFcvPort", "computeStorageInfoFcvDeviceId", "computeStorageInfoFcvIp", "storageDeviceType", "computeStorageIp", "sshUsername", "sshPassword", "scenarioInfo", "selectNodeIps"};
    private FileLock fileLock = null;
    private FileOutputStream fos = null;
    private static DocumentBuilder documentBuilder;

    private SceneEnvironmentImpl() {
        this.initKeyStrList();
    }

    private void initKeyStrList() {
        this.strKey.add("status");
        this.strKey.add("IP");
        this.strKey.add("SN");
        this.strKey.add("toolId");
        this.strKey.add("chm_click_event");
        this.strKey.add("fileName");
        this.strKey.add("startTime");
        this.strKey.add("endTime");
        this.strKey.add("disabledStepList");
        this.strKey.add("displayStepList");
        this.strKey.add("disableDesc");
        this.strKey.add("operation_result");
        this.strKey.add("operation_status");
        this.strKey.add("info_title");
        this.strKey.add("info_description");
        this.strKey.add("link_title");
        this.strKey.add("link_path");
        this.strKey.add("toolShowInfo");
        this.strKey.add("infoUrl_id");
        this.strKey.add("title_en");
        this.strKey.add("title_zh");
        this.strKey.add("type");
        this.strKey.add("resultFileSavePath");
        this.strKey.add("executeType");
        this.strKey.add(SKIP_DEVICE);
    }

    public static ISceneEnvironment getInstance() {
        return INSTANCE;
    }

    @Override
    public TaskResult initSceneEnvir() throws ToolException {
        TaskResult ret = new TaskResult();
        try {
            boolean retCF;
            boolean isToolBox = !ApplicationContext.isRunInTool();
            File filePath = isToolBox ? new File(SCENE_DATA_XML_TB_PATH) : SCENEDATAXML;
            File parentFolder = new File(filePath.getParent());
            if (!parentFolder.exists() && LOGGER.isInfoEnabled()) {
                LOGGER.info("mkdir result:" + parentFolder.mkdir());
            }
            if (filePath.exists()) {
                this.deleteFile(filePath);
            }
            if (!(retCF = filePath.createNewFile())) {
                LOGGER.error("Creat file error" + filePath.getName());
            }
            this.fos = new FileOutputStream(filePath);
            this.fileLock = this.fos.getChannel().lock();
            LOGGER.info("fileLock Lock locked.");
            ret.setResult(TaskResult.Result.SUCCESS);
        }
        catch (Exception e) {
            LOGGER.error("Init environment error!", (Throwable)e);
        }
        return ret;
    }

    private void deleteFile(File file) throws Exception {
        int retryTimes = 2;
        for (int i = 0; i < retryTimes && !file.delete(); ++i) {
        }
    }

    public TaskResult writeDataToStore(Document doc, Element root, List<Map<String, String>> listMap) {
        return this.writeDataToStore(doc, root, listMap, sceneDeviceListXml);
    }

    public TaskResult writeDataToStore(Document doc, Element root, List<Map<String, String>> listMap, String indent) {
        return this.writeDataToStore(doc, root, listMap, sceneDeviceListXml, indent);
    }

    public TaskResult writeDataToStore(Document doc, Element root, List<Map<String, String>> listMap, File file) {
        return this.writeDataToStore(doc, root, listMap, file, "yes");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskResult writeDataToStore(Document doc, Element root, List<Map<String, String>> listMap, File file, String indent) {
        FileOutputStream fops = null;
        TaskResult result = new TaskResult();
        try {
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            fops = new FileOutputStream(file);
            this.addChooserDeviceData(doc, root, listMap);
            result = this.tranformerResult(doc, fops, indent);
            this.fileOutDtreamClosed(fops);
        }
        catch (Exception e) {
            try {
                LOGGER.error("File write error.", (Throwable)e);
                this.fileOutDtreamClosed(fops);
            }
            catch (Throwable throwable) {
                this.fileOutDtreamClosed(fops);
                throw throwable;
            }
        }
        return result;
    }

    private Document writeFinishedTime(Document newdoc, Element toolId) {
        Date date = new Date();
        String time = new DateFormatUtil().getDateString(date);
        Element endTime = newdoc.createElement("endTime");
        toolId.appendChild(endTime);
        CDATASection endTimeText = newdoc.createCDATASection(time);
        endTime.appendChild(endTimeText);
        return newdoc;
    }

    private TaskResult tranformerResult(Document newdoc, FileOutputStream fops) {
        return this.tranformerResult(newdoc, fops, "yes");
    }

    private TaskResult tranformerResult(Document newdoc, FileOutputStream fops, String indent) {
        TaskResult result = new TaskResult();
        try {
            Transformer transformer = XmlUtils.newTransformer();
            transformer.setOutputProperty("indent", indent);
            transformer.setOutputProperty("method", "xml");
            transformer.transform(new DOMSource(newdoc), new StreamResult(fops));
            result.setResult(TaskResult.Result.SUCCESS);
        }
        catch (RuntimeException e) {
            LOGGER.error("xml write failed.", (Throwable)e);
            result.setResult(TaskResult.Result.FAILED);
        }
        catch (Exception e) {
            LOGGER.error("xml write failed.", (Throwable)e);
            result.setResult(TaskResult.Result.FAILED);
        }
        return result;
    }

    private void addChooserDeviceData(Document doc, Element root, List<Map<String, String>> listMap) {
        Set<String> existedNodes = this.getExistsToolIds(root);
        for (Map<String, String> map : listMap) {
            this.appendToolId(doc, root, existedNodes, map);
            this.appendDeviceInfoData(doc, root, map);
        }
    }

    private void appendDeviceInfoData(Document doc, Element root, Map<String, String> map) {
        Element device = doc.createElement(xmlDeviceName);
        device.setAttribute("SN", map.get("SN"));
        device.setAttribute("IP", map.get("IP"));
        for (String tag : this.xmlNoRealtedDevElement) {
            Element element = doc.createElement(tag);
            String key = element.getTagName();
            CDATASection elementContext = doc.createCDATASection(String.valueOf(map.get(key)));
            device.appendChild(element);
            element.appendChild(elementContext);
        }
        NodeList deviceInfoExist = root.getElementsByTagName("deviceInfo");
        this.createDeviceInfoData(doc, root, device, deviceInfoExist);
    }

    private void createDeviceInfoData(Document doc, Element root, Element device, NodeList deviceInfoExist) {
        if (deviceInfoExist.getLength() == 0) {
            Element deviceInfoEle = doc.createElement("deviceInfo");
            root.appendChild(deviceInfoEle);
            deviceInfoEle.appendChild(device);
            return;
        }
        for (int i = 0; i < deviceInfoExist.getLength(); ++i) {
            Node deviceInfoNode = deviceInfoExist.item(i);
            if (!(deviceInfoNode instanceof Element)) continue;
            Element deviceInfoEle = (Element)deviceInfoNode;
            deviceInfoEle.appendChild(device);
            return;
        }
    }

    private Set<String> getExistsToolIds(Element root) {
        HashSet<String> exists = new HashSet<String>();
        NodeList toolIdList = root.getChildNodes();
        for (int i = 0; i < toolIdList.getLength(); ++i) {
            Element toolIdEle;
            String toolIdattr;
            Node toolId = toolIdList.item(i);
            if (!(toolId instanceof Element) || (toolIdattr = (toolIdEle = (Element)toolId).getAttribute("toolId")) == null) continue;
            exists.add(toolIdattr);
        }
        return exists;
    }

    private void appendToolId(Document doc, Element root, Set<String> existedNodes, Map<String, String> map) {
        NodeList toolIdList = root.getChildNodes();
        for (int i = 0; i < toolIdList.getLength(); ++i) {
            Node toolId = toolIdList.item(i);
            if (!(toolId instanceof Element)) continue;
            Element toolIdEle = (Element)toolId;
            String toolIdStr = map.get("toolId");
            if (toolIdEle.getAttribute("toolId").equalsIgnoreCase(toolIdStr)) {
                this.appendDeviceData(doc, toolIdEle, map);
                break;
            }
            if (!toolIdEle.getTagName().equalsIgnoreCase("toolId") || existedNodes.contains(toolIdStr)) continue;
            existedNodes.add(toolIdStr);
            this.createNewToolId(doc, root, map);
            break;
        }
        this.createToolIdFirstExec(doc, root, map, toolIdList);
    }

    private void createToolIdFirstExec(Document doc, Element root, Map<String, String> map, NodeList toolIdList) {
        if (toolIdList.getLength() <= 1) {
            this.createNewToolId(doc, root, map);
        }
    }

    private void createNewToolId(Document doc, Element root, Map<String, String> map) {
        Element newToolId = doc.createElement("toolId");
        newToolId.setAttribute("toolId", map.get("toolId"));
        root.appendChild(newToolId);
        this.appendDeviceData(doc, newToolId, map);
    }

    private void appendDeviceData(Document doc, Element toolId, Map<String, String> map) {
        Element device = doc.createElement(xmlDeviceName);
        device.setAttribute("SN", map.get("SN"));
        device.setAttribute("IP", map.get("IP"));
        this.appendDevData(doc, map, device);
        toolId.appendChild(device);
        this.writeFinishedTime(doc, device);
    }

    private void appendDevData(Document doc, Map<String, String> map, Element device) {
        for (String tag : this.xmlToolIdDevElement) {
            Element element = doc.createElement(tag);
            String key = element.getTagName();
            CDATASection elementContext = doc.createCDATASection(String.valueOf(map.get(key)));
            device.appendChild(element);
            element.appendChild(elementContext);
        }
    }

    @Override
    public TaskResult finishedSceneTask(List<Map<String, String>> listMap) throws ToolException {
        try {
            LinkedList<Map<String, String>> finalResMapList = new LinkedList<Map<String, String>>();
            for (Map<String, String> map : listMap) {
                finalResMapList.add(this.checkIsContainsKey(map));
            }
            return this.wirteDevDataToFile(finalResMapList);
        }
        catch (Exception e) {
            LOGGER.error("The map is error...." + listMap, (Throwable)e);
            throw new ToolException("The map is error....", e);
        }
    }

    private TaskResult wirteDevDataToFile(List<Map<String, String>> listMap) {
        TaskResult sceneDataResult;
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("get finishedSceneTask params..." + listMap.toString().replace('\n', '_').replace('\r', '_'));
        }
        if ((sceneDataResult = this.writeToolSceneData(listMap)).getResult() == TaskResult.Result.FAILED) {
            LOGGER.error("return scenedata xml..." + sceneDataResult);
            return sceneDataResult;
        }
        TaskResult result = this.addDeviceResult(listMap);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("return sceneDeviceList data to xml..." + result);
        }
        return result;
    }

    private TaskResult writeToolSceneData(List<Map<String, String>> listMap) {
        LoggerFactory.getLogger(this.getClass()).info("scenedata file write ");
        Document doc = null;
        TaskResult result = new TaskResult();
        try {
            doc = documentBuilder.newDocument();
            Element root = doc.createElement("scene");
            if (listMap.size() == 1 && null != listMap.get(0).get(SKIP_DEVICE)) {
                root.setAttribute("status", listMap.get(0).get(SKIP_DEVICE));
            }
            doc.appendChild(root);
            result = this.writeToSceneData(doc, root, listMap);
        }
        catch (RuntimeException e) {
            LoggerFactory.getLogger(this.getClass()).error("xml writer failed.");
        }
        catch (Exception e) {
            LoggerFactory.getLogger(this.getClass()).error("xml writer failed.");
        }
        return result;
    }

    private Map<String, String> checkIsContainsKey(Map<String, String> map) {
        for (String keyStr : map.keySet()) {
            if (this.strKey.contains(keyStr)) continue;
            throw new IllegalArgumentException("Missing must-input column:" + this.strKey);
        }
        HashMap<String, String> resultMap = new HashMap<String, String>();
        for (String keyStr : this.strKey) {
            resultMap.put(keyStr, null);
        }
        resultMap.putAll(map);
        return resultMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TaskResult writeToSceneData(Document doc, Element root, List<Map<String, String>> listMap) {
        TaskResult result = new TaskResult();
        try {
            boolean hasExecuteType = false;
            for (Map<String, String> map : listMap) {
                this.addToolSceneData(doc, root, map);
                if (StringUtils.isNULLStr(map.get("executeType"))) continue;
                hasExecuteType = true;
            }
            if (hasExecuteType) {
                this.writeSceneDataExeType(doc, root);
            }
            LoggerFactory.getLogger(this.getClass()).info("scenedata file start " + this.fos.getChannel());
            result = this.tranformerResult(doc, this.fos);
            LOGGER.info("File write success.");
        }
        catch (Exception e) {
            LOGGER.error("File write error.", (Throwable)e);
        }
        finally {
            this.lockClose();
        }
        return result;
    }

    private void lockClose() {
        LOGGER.info("fileLock Lock released.");
        try {
            this.fileLock.release();
        }
        catch (Exception e) {
            LOGGER.error("FileUnlock failed.", (Throwable)e);
        }
        try {
            this.fos.close();
        }
        catch (Exception e) {
            LOGGER.error("File close failed.", (Throwable)e);
        }
    }

    private void addToolSceneData(Document doc, Element root, Map<String, String> map) {
        this.writeSceneDataDis(doc, root, map);
        this.writeSceneDisplayDesc(doc, root, map);
        this.writeSceneDataDesc(doc, root, map);
        this.appendDevDataOperation(root, doc, map);
        if (!StringUtils.isNULLStr(map.get("SN"))) {
            Element device = doc.createElement(xmlDeviceName);
            device.setAttribute("SN_IP", map.get("SN") + "_" + map.get("IP"));
            this.appendDevData(doc, map, device);
            root.appendChild(device);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("SN is  not null..." + map.get("SN"));
            }
        }
        this.writeSceneData(doc, root, map);
    }

    private void appendDevDataOperation(Element root, Document doc, Map<String, String> map) {
        if (StringUtils.isNULLStr(map.get("operation_status"))) {
            return;
        }
        Element operation = doc.createElement("operation_result");
        for (String tag : this.xmlToolFutherProcess) {
            Element element = doc.createElement(tag);
            String key = element.getTagName();
            CDATASection elementContext = doc.createCDATASection(String.valueOf(map.get(key)));
            operation.appendChild(element);
            element.appendChild(elementContext);
        }
        root.appendChild(operation);
    }

    private void writeSceneDataDis(Document doc, Element root, Map<String, String> map) {
        this.writeSceneDataFinishedTime(doc, root, map);
        if (!StringUtils.isNULLStr(map.get("disabledStepList"))) {
            this.writeSceneDateDisableStep(doc, root, map);
        }
    }

    private void writeSceneDataDesc(Document doc, Element root, Map<String, String> map) {
        this.writeSceneDataFinishedTime(doc, root, map);
        if (!StringUtils.isNULLStr(map.get("disableDesc"))) {
            this.writeSceneDateDisableDesc(doc, root, map);
        }
    }

    private void writeSceneDisplayDesc(Document doc, Element root, Map<String, String> map) {
        if (!StringUtils.isNULLStr(map.get("displayStepList"))) {
            Element displayItem = doc.createElement("displayStepList");
            root.appendChild(displayItem);
            CDATASection disableSteptText = doc.createCDATASection(map.get("displayStepList"));
            displayItem.appendChild(disableSteptText);
        }
    }

    private Document writeSceneDateDisableStep(Document doc, Element root, Map<String, String> map) {
        Element chmClickEvent = doc.createElement("disabledStepList");
        root.appendChild(chmClickEvent);
        CDATASection disableSteptText = doc.createCDATASection(map.get("disabledStepList"));
        chmClickEvent.appendChild(disableSteptText);
        return doc;
    }

    private Document writeSceneDateDisableDesc(Document doc, Element root, Map<String, String> map) {
        Element chmClickEvent = doc.createElement("disableDesc");
        chmClickEvent.setAttribute("id", "hostEvaluation");
        root.appendChild(chmClickEvent);
        CDATASection disableSteptText = doc.createCDATASection(map.get("disableDesc"));
        chmClickEvent.appendChild(disableSteptText);
        return doc;
    }

    private void writeSceneData(Document doc, Element root, Map<String, String> map) {
        this.writeSceneDataFinishedTime(doc, root, map);
        if (!StringUtils.isNULLStr(map.get("chm_click_event"))) {
            this.writeSceneDateChmClickEvent(doc, root, map);
        }
        if (!StringUtils.isNULLStr(map.get("toolShowInfo"))) {
            LOGGER.info("enter append dynamic step");
            this.appendDynamicStep(doc, root, map);
        }
        if (!StringUtils.isNULLStr(map.get("resultFileSavePath"))) {
            Element element = doc.createElement("resultFileSavePath");
            CDATASection elementContext = doc.createCDATASection(String.valueOf(map.get("resultFileSavePath")));
            element.appendChild(elementContext);
            root.appendChild(element);
        }
    }

    private void appendDynamicStep(Document doc, Element root, Map<String, String> map) {
        Element dynamicStep = doc.createElement("toolShowInfo");
        for (String tag : this.xmlDynamicStepElement) {
            Element element = doc.createElement(tag);
            String key = element.getTagName();
            CDATASection elementContext = doc.createCDATASection(String.valueOf(map.get(key)));
            dynamicStep.appendChild(element);
            element.appendChild(elementContext);
            if (!LOGGER.isInfoEnabled()) continue;
            LOGGER.info("elementContex=" + elementContext);
        }
        root.appendChild(dynamicStep);
    }

    private Document writeSceneDateChmClickEvent(Document doc, Element root, Map<String, String> map) {
        Element chmClickEvent = doc.createElement("chm_click_event");
        root.appendChild(chmClickEvent);
        CDATASection chmClickEventText = doc.createCDATASection(map.get("chm_click_event"));
        chmClickEvent.appendChild(chmClickEventText);
        return doc;
    }

    private Document writeSceneDataFinishedTime(Document doc, Element root, Map<String, String> map) {
        if (!StringUtils.isNULLStr(map.get("startTime"))) {
            String startTime = map.get("startTime");
            Element startTimeEle = doc.createElement("startTime");
            root.appendChild(startTimeEle);
            Text startTimeText = doc.createTextNode(startTime);
            startTimeEle.appendChild(startTimeText);
        }
        Date endDate = new Date();
        String endTime = new DateFormatUtil().getDateString(endDate);
        if (!StringUtils.isNULLStr(map.get("endTime"))) {
            endTime = map.get("endTime");
        }
        Element endTimeEle = doc.createElement("endTime");
        root.appendChild(endTimeEle);
        Text endTimeText = doc.createTextNode(endTime);
        endTimeEle.appendChild(endTimeText);
        return doc;
    }

    private Document writeSceneDataExeType(Document doc, Element root) {
        Element executeTypeEle = doc.createElement("executeType");
        root.appendChild(executeTypeEle);
        Text executeTypeText = doc.createTextNode("0");
        executeTypeEle.appendChild(executeTypeText);
        return doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private TaskResult addDeviceResult(List<Map<String, String>> listMap) {
        Document doc = null;
        FileOutputStream fops = null;
        TaskResult result = new TaskResult();
        try {
            doc = documentBuilder.parse(sceneDeviceListXml);
            fops = new FileOutputStream(sceneDeviceListXml);
            Element root = doc.getDocumentElement();
            Set<String> existedNodes = this.getExistsToolIds(root);
            for (Map<String, String> map : listMap) {
                this.appendToolId(doc, root, existedNodes, map);
            }
            result = this.tranformerResult(doc, fops);
        }
        catch (RuntimeException e) {
            LoggerFactory.getLogger(this.getClass()).error("xml builder failed.");
            this.fileOutDtreamClosed(fops);
        }
        catch (Exception e2) {
            LoggerFactory.getLogger(this.getClass()).error("xml builder failed.");
            this.fileOutDtreamClosed(fops);
            {
                catch (Throwable throwable) {
                    this.fileOutDtreamClosed(fops);
                    throw throwable;
                }
            }
        }
        this.fileOutDtreamClosed(fops);
        return result;
    }

    private void fileOutDtreamClosed(FileOutputStream fops) {
        try {
            if (null != fops) {
                fops.close();
            }
        }
        catch (Exception e) {
            LOGGER.error("File close failed.", (Throwable)e);
        }
    }

    @Override
    public String getDataVarByKey(String jsonStr) throws ToolException {
        try {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("SceneEnvironmentImpl.getDataVarByKey: " + jsonStr);
            }
            if (StringUtils.isNULLStr(jsonStr)) {
                LOGGER.error("jsonStr can not null.");
                return "";
            }
            List<Map<ToolSceneDataKey, ToolSceneData>> toolIdListMap = this.getDeviceData();
            if (null == toolIdListMap) {
                throw new NullPointerException();
            }
            String status = this.analysisEnvirKey(jsonStr, toolIdListMap);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("return device status..." + status);
            }
            return status;
        }
        catch (Exception e) {
            LOGGER.error("json string is error...");
            throw new ToolException("json string is error...", e);
        }
    }

    private String analysisEnvirKey(String jsonStr, List<Map<ToolSceneDataKey, ToolSceneData>> toolIdListMap) {
        JSONObject object = new JSONObject(jsonStr);
        String toolId = object.getString("toolId");
        String deviceSerialNumber = object.getString("SN");
        String status = String.valueOf((Object)TaskResult.Result.CANCELED);
        for (Map<ToolSceneDataKey, ToolSceneData> toolIdMap : toolIdListMap) {
            for (Map.Entry<ToolSceneDataKey, ToolSceneData> entry : toolIdMap.entrySet()) {
                ToolSceneDataKey keyData = entry.getKey();
                if (!toolId.equals(keyData.getToolId()) || !deviceSerialNumber.equals(keyData.getDeviceSerialNumber())) continue;
                status = entry.getValue().getDeviceMap().get("status").toUpperCase(Locale.getDefault());
            }
        }
        return status;
    }

    @Override
    public Map<String, ToolSceneData> getDataVarMap(String keyStr) throws ToolException {
        try {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("get device data key..." + keyStr);
            }
            HashMap<String, ToolSceneData> dataVarMap = new HashMap<String, ToolSceneData>();
            if (StringUtils.isNULLStr(keyStr)) {
                LOGGER.error("key can not null..." + keyStr);
                return dataVarMap;
            }
            List<Map<ToolSceneDataKey, ToolSceneData>> toolIdListMap = this.getDeviceData();
            if (null == toolIdListMap) {
                throw new NullPointerException();
            }
            for (Map<ToolSceneDataKey, ToolSceneData> toolIdMap : toolIdListMap) {
                for (Map.Entry<ToolSceneDataKey, ToolSceneData> entry : toolIdMap.entrySet()) {
                    ToolSceneDataKey dataKey = entry.getKey();
                    if (!keyStr.equalsIgnoreCase(dataKey.getToolId())) continue;
                    dataVarMap.put(dataKey.getDeviceSerialNumber(), entry.getValue());
                }
            }
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("return data Map..." + dataVarMap);
            }
            return dataVarMap;
        }
        catch (Exception e) {
            LOGGER.error("toolId is error...", (Throwable)e);
            throw new ToolException("toolId is error...");
        }
    }

    private List<Map<ToolSceneDataKey, ToolSceneData>> getDeviceData() {
        try {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("file xml..." + sceneDeviceListXml);
            }
            return this.getChildren(documentBuilder.parse(sceneDeviceListXml).getDocumentElement());
        }
        catch (FileNotFoundException e) {
            LOGGER.error("file {} not found.", (Object)sceneDeviceListXml.getName());
        }
        catch (RuntimeException e) {
            LOGGER.error("xml builder failed.", (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.error("xml builder failed.", (Throwable)e);
        }
        return null;
    }

    @Override
    public ISceneBean getEnvirValueByKey(String envirKeyStr) throws ToolException {
        try {
            String envirStrVslue;
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("scene get envir value..." + envirKeyStr);
            }
            if (StringUtils.isNULLStr(envirStrVslue = System.getenv(envirKeyStr))) {
                LOGGER.error("envirKeyStr value can not null.");
                return null;
            }
            if (envirKeyStr.equalsIgnoreCase("jsonSceneResultPath")) {
                ScenePathValue sceneResultPath = new ScenePathValue(envirStrVslue);
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("return scene path envir value..." + sceneResultPath);
                }
                return sceneResultPath;
            }
            JSONObject jsonObject = new JSONObject(envirStrVslue);
            if (envirKeyStr.equalsIgnoreCase("jsonScene")) {
                ISceneBean sceneBean = this.getSceneValue(jsonObject);
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("return scene envir value..." + sceneBean);
                }
                return sceneBean;
            }
            if (envirKeyStr.equalsIgnoreCase("jsonSceneUser")) {
                ISceneBean sceneUser = this.getSceneUserValue(jsonObject);
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("return scene user envir value..." + sceneUser);
                }
                return sceneUser;
            }
            LOGGER.error("key is error." + envirKeyStr);
            return null;
        }
        catch (Exception e) {
            LOGGER.error("envirKeyStr is error...", (Throwable)e);
            throw new ToolException("envirKeyStr is error...");
        }
    }

    private ISceneBean getSceneUserValue(JSONObject jsonObject) {
        String charctor = jsonObject.getString("charctor");
        String location = jsonObject.getString("location");
        SceneUserValue sceneUserValue = new SceneUserValue(charctor, location);
        return sceneUserValue;
    }

    private ISceneBean getSceneValue(JSONObject jsonObject) {
        String mainScene = jsonObject.getString("mainScene");
        String subScene = jsonObject.getString("subScene");
        String field = jsonObject.getString("field");
        String stepID = jsonObject.getString("stepID");
        String stepTitleEn = jsonObject.getString("stepTitleEn");
        String executedSteps = jsonObject.getStringOrDefault("executedSteps", "");
        return new SceneValue(mainScene, subScene, field, stepID, stepTitleEn, executedSteps);
    }

    public List<Map<ToolSceneDataKey, ToolSceneData>> getChildren(Element parent) {
        ArrayList<Map<ToolSceneDataKey, ToolSceneData>> listMap = new ArrayList<Map<ToolSceneDataKey, ToolSceneData>>();
        if (null == parent) {
            return listMap;
        }
        NodeList toolId = parent.getChildNodes();
        for (int i = 0; i < toolId.getLength(); ++i) {
            Node toolIdNode = toolId.item(i);
            if (!(toolIdNode instanceof Element)) continue;
            Element node = (Element)toolIdNode;
            listMap.add(this.getToolIdNode(node));
        }
        return listMap;
    }

    private Map<ToolSceneDataKey, ToolSceneData> getToolIdNode(Node toolIdNode) {
        Map<ToolSceneDataKey, ToolSceneData> dataMap = new HashMap<ToolSceneDataKey, ToolSceneData>();
        NodeList toolIdChild = toolIdNode.getChildNodes();
        HashMap<ToolSceneDataKey, ToolSceneData> deviceDataMap = new HashMap<ToolSceneDataKey, ToolSceneData>();
        for (int i = 0; i < toolIdChild.getLength(); ++i) {
            Node node = toolIdChild.item(i);
            if (!(node instanceof Element)) continue;
            dataMap = this.getDataMap(node, deviceDataMap);
        }
        return dataMap;
    }

    private Map<ToolSceneDataKey, ToolSceneData> getDataMap(Node node, Map<ToolSceneDataKey, ToolSceneData> deviceDataMap) {
        HashMap<String, String> map = new HashMap<String, String>();
        this.fillDevData2Map(node, map);
        String attr = ((Element)node.getParentNode()).getAttribute("toolId");
        if (node instanceof Element) {
            map.put("SN", ((Element)node).getAttribute("SN"));
            map.put("IP", ((Element)node).getAttribute("IP"));
        }
        ToolSceneData data = new ToolSceneData();
        data.setDeviceMap(map);
        ToolSceneDataKey key = new ToolSceneDataKey(attr, (String)map.get("SN"));
        this.checkAndAddToResult(deviceDataMap, data, key);
        return deviceDataMap;
    }

    private void fillDevData2Map(Node node, Map<String, String> map) {
        for (Node deviceData = node.getFirstChild(); deviceData != null; deviceData = deviceData.getNextSibling()) {
            if (!(deviceData instanceof Element)) continue;
            Element element = (Element)deviceData;
            String tagName = element.getTagName();
            String contentData = element.getTextContent();
            map.put(tagName, contentData);
        }
    }

    private void checkAndAddToResult(Map<ToolSceneDataKey, ToolSceneData> deviceDataMap, ToolSceneData data, ToolSceneDataKey key) {
        String currEndTime;
        String oldEndTime;
        ToolSceneData oldData = deviceDataMap.get(key);
        if (oldData != null && (oldEndTime = oldData.getDeviceMap().get("endTime")).compareTo(currEndTime = data.getDeviceMap().get("endTime")) < 0) {
            deviceDataMap.put(key, data);
            return;
        }
        deviceDataMap.put(key, data);
    }

    @Override
    public void refreshDevVersion(List<DevNode> devs) {
        SceneDeviceData sceneDevData = new SceneDeviceData();
        List<DevNode> devNodes = sceneDevData.refreshDeviceNodes(devs);
        List<Map<String, String>> listMap = SceneDeviceData.injectDeviceData(devNodes);
        SceneXmlData.getInstance().writeDevData2File(devs, listMap);
    }

    public static String getSceneStepTitle() {
        try {
            ISceneBean sceneValueObject = SceneEnvironmentImpl.getInstance().getEnvirValueByKey("jsonScene");
            if (sceneValueObject == null) {
                LOGGER.error("sceneValueObject is null.");
                return null;
            }
            if (sceneValueObject instanceof SceneValue) {
                SceneValue sceneValue = (SceneValue)sceneValueObject;
                return sceneValue.getStepTitleEn().trim();
            }
        }
        catch (ToolException e) {
            LOGGER.error("initScenseParam error:" + e.toString());
            return null;
        }
        catch (RuntimeException e) {
            LOGGER.error("initScenseParam error:" + e.toString());
            return null;
        }
        return null;
    }

    @Override
    public String getSceneDir() {
        ScenePathValue scenePathValue = null;
        try {
            ISceneEnvironment environmentImpl = SceneEnvironmentImpl.getInstance();
            ISceneBean envirValueByKey = environmentImpl.getEnvirValueByKey("jsonSceneResultPath");
            if (envirValueByKey instanceof ScenePathValue) {
                scenePathValue = (ScenePathValue)envirValueByKey;
            }
        }
        catch (ToolException e) {
            LOGGER.error("git scence path faild!", (Throwable)e);
            return "";
        }
        if (scenePathValue == null) {
            LOGGER.info("get scence path null!");
            return "";
        }
        return scenePathValue.getJsonSceneResultPathValue();
    }

    static {
        INSTANCE = new SceneEnvironmentImpl();
        SCENEDATAXML = new File(SCENE_DATA_XML_PATH);
        LOGGER = ToolLoggerFactory.getLogger(SceneEnvironmentImpl.class);
        documentBuilder = null;
        try {
            documentBuilder = XmlUtils.newDocumentBuilder();
            sceneDevicelistXmlPath = SceneUtils.getSceneFilePath(SCENE_DEVICE_LIST_XML);
            sceneDeviceListXml = new File(sceneDevicelistXmlPath);
        }
        catch (ParserConfigurationException e) {
            LOGGER.error("documentBuilder build faild", (Throwable)e);
        }
    }
}

