/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.tool.framwork.util.func;

import com.huawei.ism.tool.base.utils.OSCmdUtils;
import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.platform.util.UserOpDataSaveUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.Normalizer;
import java.util.List;
import org.slf4j.Logger;

public class LocalHostUtil {
    private static final String V1_LATER_FILE = "C:/Huawei/version";
    private static final String V3_LATER_FILE = "D:/Huawei/version";
    private static final char PROCESS_SEPRATOR = '@';
    private static final String TASKKILL_PROCESS_CMD = "taskkill /F /T /PID ";
    private static final int TO_MUCH_SIZE = 500;
    private static final String DFT_CPU_ID = "178BFBFF012306E4";
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(LocalHostUtil.class);
    private static String hostCpuId;
    private static boolean isRunInV3LaterSvp;
    private static final String SVP_ENV_CHECK_MARKER = "D:\\Huawei\\version;C:\\Huawei\\version,.*SVP_Version.*";
    private static String svpVerMatchRegix;
    private static final String SVP_V5_LATER_REGIX = ".*V[5-9]00R00[7-9].*";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCPUSerial() {
        StringBuffer result;
        block9: {
            if (!org.apache.commons.lang3.StringUtils.isBlank((CharSequence)hostCpuId)) {
                return hostCpuId;
            }
            result = new StringBuffer();
            String os = LocalHostUtil.getOsName();
            if (!org.apache.commons.lang3.StringUtils.isBlank((CharSequence)os) && os.startsWith("Windows")) {
                InputStream inputStream = null;
                InputStreamReader streamReader = null;
                BufferedReader input = null;
                Process process = null;
                try {
                    String line;
                    LOGGER.info("process start exec.");
                    process = Runtime.getRuntime().exec("wmic cpu get processorid");
                    process.getOutputStream().close();
                    inputStream = process.getInputStream();
                    streamReader = new InputStreamReader(inputStream, Charset.defaultCharset());
                    input = new BufferedReader(streamReader);
                    LOGGER.info("process finish exec.");
                    LOGGER.info("get input start.");
                    while ((line = input.readLine()) != null) {
                        if (line.trim().length() <= 0 || line.contains("ProcessorId")) continue;
                        result.append(line);
                    }
                    LOGGER.info("finish to get input start.");
                    StreamUtils.closeStream(null, inputStream);
                }
                catch (Exception e) {
                    LOGGER.error("The file is fail.", (Throwable)e);
                    break block9;
                }
                finally {
                    StreamUtils.closeStream(null, inputStream);
                    StreamUtils.closeResource(null, streamReader);
                    StreamUtils.closeResource(null, input);
                    OSCmdUtils.closeProcess(process);
                }
                StreamUtils.closeResource(null, streamReader);
                StreamUtils.closeResource(null, input);
                OSCmdUtils.closeProcess(process);
            }
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)result.toString())) {
            return DFT_CPU_ID;
        }
        return result.toString().trim();
    }

    private static String getOsName() {
        String os = System.getProperty("os.name");
        return os == null ? "Windows" : os;
    }

    public static boolean isRunInV3LaterSvp() {
        return isRunInV3LaterSvp;
    }

    public static boolean isRunInSvp() {
        String[] checkInfo;
        String checkStr = UserOpDataSaveUtil.getToolBoxIniProp("app.svp.env.check.regix");
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)checkStr)) {
            checkStr = SVP_ENV_CHECK_MARKER;
        }
        if ((checkInfo = SVP_ENV_CHECK_MARKER.split(",")).length < 2) {
            LOGGER.error("configuration is wrong:{}", (Object)StringUtils.getCleanMessage(checkStr));
            return false;
        }
        return LocalHostUtil.checkEnv(checkInfo);
    }

    private static boolean checkEnv(String[] checkInfo) {
        String[] checkFile;
        for (String file : checkFile = checkInfo[0].split(";")) {
            Path path = Paths.get(file, new String[0]);
            if (!path.toFile().isFile()) continue;
            try {
                if (Files.size(path) > 500L) {
                    LOGGER.warn("version file is too big:" + Files.size(path));
                    continue;
                }
                List<String> contents = Files.readAllLines(path, Charset.defaultCharset());
                for (String content : contents) {
                    if (!(content = Normalizer.normalize(content, Normalizer.Form.NFKC)).matches(checkInfo[1])) continue;
                    return true;
                }
            }
            catch (IOException e) {
                LOGGER.error("check run env error!");
            }
            catch (Exception e) {
                LOGGER.error("check run env error!", (Throwable)e);
            }
        }
        return false;
    }

    public static boolean isRunInSvp(Path path) {
        if (!Files.exists(path, new LinkOption[0])) {
            return false;
        }
        try {
            List<String> contents = Files.readAllLines(path, Charset.defaultCharset());
            for (String line : contents) {
                if (line == null || !Normalizer.normalize(line, Normalizer.Form.NFKC).matches(svpVerMatchRegix)) continue;
                return true;
            }
            return false;
        }
        catch (RuntimeException e) {
            LOGGER.error("match svp version error!", (Throwable)e);
            return false;
        }
        catch (Exception e) {
            LOGGER.error("match svp version error!", (Throwable)e);
            return false;
        }
    }

    public static void killCurrentProcess() {
        String pid = ManagementFactory.getRuntimeMXBean().getName();
        pid = pid.substring(0, pid.indexOf(64));
        LocalHostUtil.killProcess(pid);
    }

    private static void killProcess(String processId) {
        String exitCmd = TASKKILL_PROCESS_CMD + processId;
        new Thread(new AsyncKillProcessTask(exitCmd)).start();
    }

    public static String getSvpVersion() {
        Path v3Path = Paths.get(V3_LATER_FILE, new String[0]);
        Path v1Path = Paths.get(V1_LATER_FILE, new String[0]);
        try {
            Path path;
            Path path2 = path = v3Path.toFile().isFile() ? v3Path : v1Path;
            if (!path.toFile().isFile()) {
                return null;
            }
            List<String> infos = Files.readAllLines(path, Charset.defaultCharset());
            for (String line : infos) {
                String[] info;
                if (!(line = Normalizer.normalize(line, Normalizer.Form.NFKC)).contains("SVP_Version") || (info = line.split(":")).length <= 1) continue;
                return info[1].trim();
            }
        }
        catch (IOException e) {
            LOGGER.error("parse error", (Throwable)e);
        }
        return null;
    }

    static {
        svpVerMatchRegix = UserOpDataSaveUtil.getToolBoxIniProp("app.svp.version.match.regix");
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)svpVerMatchRegix)) {
            svpVerMatchRegix = ".*SVP_Version.*V300R00[36].*";
        }
        svpVerMatchRegix = svpVerMatchRegix + "|" + SVP_V5_LATER_REGIX;
        isRunInV3LaterSvp = LocalHostUtil.isRunInSvp(Paths.get(V3_LATER_FILE, new String[0]));
    }

    private static final class AsyncKillProcessTask
    implements Runnable {
        private String exitCmd;

        public AsyncKillProcessTask(String exitCmd) {
            this.exitCmd = exitCmd;
        }

        @Override
        public void run() {
            OSCmdUtils.executeCmd(this.exitCmd);
        }
    }
}

