/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.singletoolbox.utils;

import com.huawei.ism.tool.base.utils.FilePathUtils;
import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.framework.platform.common.data.UserDataType;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.framework.pubservice.common.ILogSupportService;
import com.huawei.ism.tool.framework.pubservice.entity.DevNode;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.framework.pubservice.entity.OperaLog;
import com.huawei.ism.tool.framework.pubservice.listener.INodeObserver;
import com.huawei.ism.tool.framework.pubservice.scenedata.SceneDeviceData;
import com.huawei.ism.tool.framework.pubservice.scenedata.SceneXmlData;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.Flushable;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;

public class UserDataRefresher
implements INodeObserver,
ILogSupportService {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(UserDataRefresher.class);
    private static final int INTERVAL = 300;
    private static final String DEVDATAFILE = UserDataType.device.getFileName();
    private static final String LOGDATAFILE = UserDataType.operatingLogs.getFileName();
    private static final String ENVENTCONFIG_DATA_FILE = UserDataType.enventConfig.getFileName();
    private File refreshDataDir = null;
    private AtomicInteger deviceIndex = new AtomicInteger(0);

    public UserDataRefresher() {
    }

    public UserDataRefresher(String refreshPath) {
        if (null == refreshPath) {
            return;
        }
        this.refreshDataDir = new File(FilePathUtils.filterPath((String)refreshPath));
        Thread hook = new Thread(){

            @Override
            public void run() {
                UserDataRefresher.this.clearFile(new File(UserDataRefresher.this.refreshDataDir, DEVDATAFILE));
                UserDataRefresher.this.clearFile(new File(UserDataRefresher.this.refreshDataDir, ENVENTCONFIG_DATA_FILE));
            }
        };
        hook.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                LOGGER.error("Uncaught error on thread " + t.getName(), e);
            }
        });
        Runtime.getRuntime().addShutdownHook(hook);
    }

    public void fireNodeAdd(DevNode dev) {
        if (this.notStorageDev(dev) || ApplicationContext.getInstance().isSpecificDeviceModeConfigured()) {
            LOGGER.info("not need refresh device to toolbox.");
            return;
        }
        List<String> heteroStorages = Arrays.asList("EMC", "IBM", "HP", "NetApp", "PureStorage", "Fujistu");
        if (heteroStorages.contains(dev.getDeviceName())) {
            LOGGER.info("not need refresh hetero storage device to toolbox.");
            return;
        }
        LOGGER.info("write device xml for refresh toolbox.");
        String fileName = UserDataType.deviceNode.getFileName() + this.deviceIndex.getAndIncrement();
        File devFile = new File(this.refreshDataDir, fileName);
        ArrayList<DevNode> nodes = new ArrayList<DevNode>();
        nodes.add(dev);
        try {
            List listMap = SceneDeviceData.injectDeviceDataBySubTool(nodes);
            SceneXmlData.getInstance().writeDevData2File(nodes, listMap, devFile);
        }
        catch (Exception e) {
            LOGGER.error("write device file error.");
        }
    }

    private boolean notStorageDev(DevNode dev) {
        return dev.getItDeviceType() != ItDeviceType.Storage && dev.getItDeviceType() != ItDeviceType.DStorage && dev.getItDeviceType() != ItDeviceType.A800_NODE;
    }

    public void fireNodeDelete(DevNode dev) {
    }

    public void fireNodeModify(DevNode dev) {
        File devFile = new File(this.refreshDataDir, DEVDATAFILE);
        ArrayList<String> strList = new ArrayList<String>();
        strList.add("type=" + dev.getDeviceType().toString());
        strList.add("sn=" + dev.getDeviceSerialNumber());
        strList.add("version=" + dev.getProductVersion());
        strList.add("hotpatch=" + dev.getHotPatchVersion());
        this.saveData(devFile, strList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveData(File devFile, List<String> strList) {
        if (null == this.refreshDataDir) {
            return;
        }
        if (!this.refreshDataDir.exists() && !this.refreshDataDir.mkdirs()) {
            LOGGER.error("Make dir failed: " + this.refreshDataDir);
            return;
        }
        if (!this.clearFile(devFile)) {
            this.waitSomeTime();
            if (!this.clearFile(devFile)) {
                return;
            }
        }
        FileOutputStream output = null;
        BufferedWriter writer = null;
        try {
            if (devFile.createNewFile()) {
                output = new FileOutputStream(devFile);
                writer = new BufferedWriter(new OutputStreamWriter((OutputStream)output, Charset.forName("utf-8")));
                for (String st : strList) {
                    writer.write(st);
                    writer.newLine();
                }
            }
        }
        catch (RuntimeException e) {
            LOGGER.error("create new file error: " + devFile, (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.error("create new file error: " + devFile, (Throwable)e);
        }
        finally {
            StreamUtils.closeResource(writer, writer);
            StreamUtils.closeResource((Flushable)output, (Closeable)output);
        }
    }

    private void waitSomeTime() {
        try {
            Thread.sleep(300L);
        }
        catch (InterruptedException e) {
            LOGGER.error("Sleep error when refresh device.", (Throwable)e);
        }
    }

    private boolean clearFile(File file) {
        if (file.exists() && !file.delete()) {
            LOGGER.error("Delete file error:" + file);
            return false;
        }
        return true;
    }

    public void addOperaLog(OperaLog log) {
        File devFile = null;
        if ("operalog.name.adddevices".equals(log.getOperaName())) {
            String point = ".";
            StringBuilder devPath = new StringBuilder(LOGDATAFILE);
            devPath.append(point);
            devPath.append(log.getOperaName());
            devPath.append(point);
            devPath.append(log.getDeviceName());
            devFile = new File(this.refreshDataDir, devPath.toString());
        } else {
            devFile = new File(this.refreshDataDir, LOGDATAFILE);
        }
        ArrayList<String> strList = new ArrayList<String>();
        strList.add("operateType=" + log.getOperateType());
        strList.add("result=" + log.isResult());
        strList.add("operaName=" + log.getOperaName());
        strList.add("deviceName=" + log.getDeviceName());
        strList.add("deviceNameEn=" + log.getDeviceNameEn());
        strList.add("level=" + log.getLevel().toString());
        strList.add("detailInfo=" + log.getDetailInfo());
        strList.add("userName=" + log.getUserName());
        this.saveData(devFile, strList);
    }

    public void addOperaLog(String key, boolean result) {
    }

    public void clearEnv() {
    }
}

