/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicemanager.service;

import com.huawei.ism.tool.obase.connection.ICliConnection;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.utils.StringUtils;
import java.text.Normalizer;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;

public class VerSphGainer {
    private static final String HOTPATCH_VERSION = "hotpatch version";
    private static final Pattern SPH_VER_REGEX_PATTERN = Pattern.compile("v\\d{3}r\\d{3}c\\d{2}sph\\w{1,3}");
    private static final int DEFAULT_TIMEOUT = 130;
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(VerSphGainer.class);

    public String query(ICliConnection con) {
        try {
            String cliInfo = con.execCmdWithTimout("show upgrade package", 130);
            cliInfo = Normalizer.normalize(cliInfo, Normalizer.Form.NFKC);
            cliInfo = cliInfo.toLowerCase(Locale.ENGLISH);
            String sver = "";
            if (cliInfo.contains(HOTPATCH_VERSION)) {
                sver = this.getVerByKeys(cliInfo);
            }
            if (StringUtils.isNULLStr((String)sver)) {
                cliInfo = con.execCmdWithTimout("showupgradepkginfo -t 3", 130);
                cliInfo = Normalizer.normalize(cliInfo, Normalizer.Form.NFKC);
                cliInfo = cliInfo.toLowerCase(Locale.ENGLISH);
                String[] keys = new String[]{"running", " a ", " b "};
                sver = this.getStringByKeys(cliInfo, keys, SPH_VER_REGEX_PATTERN);
            }
            if (!StringUtils.isNULLStr((String)sver)) {
                return sver.toUpperCase(Locale.ENGLISH);
            }
        }
        catch (RuntimeException e) {
            LOGGER.error("query device sph version runtime exception.", (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.error("query device sph version error.");
        }
        return "";
    }

    public String getVerByKeys(String cliInfo) {
        String[] lines = cliInfo.split("\n");
        boolean hasHotPatchKey = false;
        for (String line : lines) {
            Matcher matcher;
            if (!hasHotPatchKey && HOTPATCH_VERSION.equals(line.trim())) {
                hasHotPatchKey = true;
            }
            if (!hasHotPatchKey || !(matcher = SPH_VER_REGEX_PATTERN.matcher(line)).find()) continue;
            return matcher.group(0);
        }
        LOGGER.warn("the command output does not contain hotpatch");
        return "";
    }

    private String getStringByKeys(String cliInfo, String[] keys, Pattern pattern) {
        String[] lines;
        for (String line : lines = cliInfo.split("\n")) {
            Matcher matcher;
            if (!this.containKeyword(line, keys) || !(matcher = pattern.matcher(line)).find()) continue;
            return matcher.group(0);
        }
        return "";
    }

    private boolean containKeyword(String lineStr, String[] keys) {
        if (null == keys || keys.length < 1) {
            return false;
        }
        for (String key : keys) {
            if (!lineStr.contains(key)) continue;
            return true;
        }
        return false;
    }
}

