/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicemanager.service.dev.infoqry;

import com.huawei.ism.tool.devicemanager.service.DeviceOpr;
import com.huawei.ism.tool.devicemanager.service.INodeTypeQuery;
import com.huawei.ism.tool.devicemanager.ui.action.SceneAddDeviceAction;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.framework.pubservice.listener.INodeSupport;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.DeviceType;
import com.huawei.ism.tool.obase.entity.EntityUtils;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.taskexecutor.TaskResult;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.protocol.rest.CyberEngineRestConnection;
import com.huawei.ism.tool.protocol.rest.RestConnFactory;
import com.huawei.ism.tool.protocol.rest.entity.ResponseInfo;
import com.huawei.ism.ui.swing.dialog.ProgressDialog;
import com.huawei.json.JSONException;
import com.huawei.json.JSONObject;
import java.util.Objects;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CyberEngineInfoQryServiceImpl
implements INodeTypeQuery {
    private static final Logger log = LoggerFactory.getLogger(CyberEngineInfoQryServiceImpl.class);
    public static final String DEVICE_CANNOT_CONNECT = "devicemanager.layout.device.add.deviceadddialog.deviceconnecterror";
    public static final String FCE_LOGIN_ROLE_NOT_OPENAPI = "fce.login.role.is.not.openapi";
    public static final String CLUSTER_INFO_QUERY_FAIL = "devicemanager.layout.device.add.deviceadddialog.query.cluster.info.fail";
    protected INodeSupport nodeSupport;

    @Override
    public TaskResult queryNodeInfo(DevNode devNode, DeviceOpr opr, ProgressDialog progressDialog) {
        TaskResult ret = new TaskResult();
        ret.setResultObject((Object)devNode);
        try {
            CyberEngineRestConnection restConn = RestConnFactory.getCyberEngineRestConnection(devNode);
            restConn.login();
            if (!restConn.isLogin()) {
                String errId = DEVICE_CANNOT_CONNECT;
                ret.setErrorId(errId);
                ret.setErrorLocaleDescription(ResourceUtil.getStringWithParams((String)errId, (Object[])new Object[]{devNode.getIp()}));
                ret.setResult(TaskResult.Result.FAILED);
                log.error("rest conn is build failed.");
                return ret;
            }
            if (!this.isRightGetStorageDeviceInfo(devNode, restConn)) {
                log.error("Query cluster info by OceanCyber failed.");
                this.makeQueryCluserInfoFailResult(devNode, ret);
                return ret;
            }
            log.info("Query node info by OceanCyber success.");
            ret.setResult(TaskResult.Result.SUCCESS);
            ret.setErrorLocaleDescription("");
            ret.setResultObject((Object)devNode);
            devNode.setItDeviceType(ItDeviceType.OCEAN_CYBER);
            this.nodeSupportCheck(devNode, ret);
            return ret;
        }
        catch (ToolException e) {
            ret.setErrorId(e.getErrorId());
            log.error("execute cmd error.", (Throwable)e);
            this.makeErrorTaskResult(devNode, ret);
            return ret;
        }
    }

    protected void nodeSupportCheck(DevNode devNode, TaskResult ret) {
        if (this.nodeSupport == null || TaskResult.Result.FAILED.equals((Object)ret.getResult())) {
            return;
        }
        com.huawei.ism.tool.framework.pubservice.entity.DevNode newDevNode = EntityUtils.toNewDev((DevNode)devNode);
        if (this.nodeSupport.isNodeSupport(newDevNode)) {
            return;
        }
        DeviceType tmpType = DeviceType.valueOf((String)(devNode.getDeviceType() + " " + devNode.getProductVersion()));
        if (this.nodeSupport instanceof SceneAddDeviceAction) {
            SceneAddDeviceAction sceneAddDeviceAction = (SceneAddDeviceAction)this.nodeSupport;
            this.setTaskFailedResult(sceneAddDeviceAction.getAddDevErrMsgPropKey(), ret, devNode, tmpType);
            return;
        }
        this.setTaskFailedResult("devicemanager.layout.device.add.deviceadddialog.nosupportdevtype", ret, devNode, tmpType);
    }

    private void setTaskFailedResult(String errorMsg, TaskResult ret, DevNode devNode, DeviceType tmpType) {
        ret.setResult(TaskResult.Result.FAILED);
        if (!StringUtils.isNULLStr((String)devNode.getErrorDecs())) {
            ret.setErrorLocaleDescription(devNode.getErrorDecs());
            return;
        }
        ret.setErrorLocaleDescription(ResourceUtil.getStringWithParams((String)errorMsg, (Object[])new Object[]{devNode.getIp(), tmpType}));
    }

    public boolean isRightGetStorageDeviceInfo(DevNode devNode, CyberEngineRestConnection conn) {
        try {
            ResponseInfo clusterPdtInfoResp = conn.execGet(conn.getQueryDevTypeInfoUrl());
            ResponseInfo clusterEsnInfoResp = conn.execGet(conn.getQueryDevEsnUrl());
            JSONObject jsonObjInfo = new JSONObject(clusterPdtInfoResp.getContent());
            JSONObject jsonObjEsn = new JSONObject(clusterEsnInfoResp.getContent());
            String productType = jsonObjInfo.getString("productModeString");
            String productVersion = jsonObjInfo.getString("pointRelease");
            String esn = jsonObjEsn.getStringOrDefault("esn", devNode.getIp() + UUID.randomUUID());
            devNode.setProductModel(productType);
            devNode.setProductVersion(productVersion);
            devNode.setDeviceName(productType);
            devNode.setDeviceModel(productType);
            DeviceType type = DeviceType.valueOf((String)productType);
            devNode.setDeviceType(type);
            devNode.setDeviceSerialNumber(esn);
            log.info("query OceanCyber ProductInfo : node info:{}", (Object)devNode);
            return true;
        }
        catch (JSONException e) {
            log.error("get OceanCyber DeviceInfo JSONException:", (Throwable)e);
            return false;
        }
        catch (ToolException te) {
            log.error("get OceanCyber DeviceInfo tool exception:", (Throwable)te);
            return false;
        }
        catch (Exception e) {
            log.error("get OceanCyber DeviceInfo exception:", (Throwable)e);
            return false;
        }
    }

    private void makeErrorTaskResult(DevNode devNode, TaskResult ret) {
        if (Objects.equals(ret.getErrorId(), FCE_LOGIN_ROLE_NOT_OPENAPI)) {
            String errorDes = ResourceUtil.getString((String)FCE_LOGIN_ROLE_NOT_OPENAPI);
            ret.setErrorLocaleDescription(errorDes);
            ret.setResult(TaskResult.Result.FAILED);
            return;
        }
        String errorDes = ResourceUtil.getStringWithParams((String)DEVICE_CANNOT_CONNECT, (Object[])new Object[]{devNode.getIp()});
        ret.setErrorLocaleDescription(errorDes);
        ret.setResult(TaskResult.Result.FAILED);
    }

    private void makeQueryCluserInfoFailResult(DevNode devNode, TaskResult ret) {
        String errorDes = ResourceUtil.getStringWithParams((String)CLUSTER_INFO_QUERY_FAIL, (Object[])new Object[]{devNode.getIp()});
        ret.setErrorLocaleDescription(errorDes);
        ret.setResult(TaskResult.Result.FAILED);
    }

    @Override
    public TaskResult queryNodeInfo(DevNode devNode, DeviceOpr opr) {
        return this.queryNodeInfo(devNode, opr, null);
    }

    public INodeSupport getNodeSupport() {
        return this.nodeSupport;
    }

    public void setNodeSupport(INodeSupport nodeSupport) {
        this.nodeSupport = nodeSupport;
    }
}

