/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicemanager.ui.dialog;

import com.huawei.ism.tool.base.utils.VerifyUtil;
import com.huawei.ism.tool.devicemanager.service.SettingService;
import com.huawei.ism.tool.devicemanager.ui.dialog.CreateSshForwardDialog;
import com.huawei.ism.tool.devicemanager.utils.LogUtils;
import com.huawei.ism.tool.framework.pubservice.entity.OperaLog;
import com.huawei.ism.tool.obase.connection.MultiRouteNode;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.ui.component.TextEditCell;
import com.huawei.ism.tool.obase.utils.KeyOrderedHashMap;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.WarningDialog;
import com.huawei.ism.ui.swing.table.DefaultTableModel;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.IsmTableScrollPane;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.ui.swing.text.IsmPasswordField;
import com.huawei.ism.ui.swing.text.IsmTextField;
import com.huawei.ism.util.UCD;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;
import org.slf4j.Logger;

public class SshForwardSetLayout
extends JPanel {
    private static final long serialVersionUID = 6051057299633867153L;
    private static final String DELETE_SSH = "operalog.setting.operaLog.deleteSSH";
    private static final String ADD_SSH = "operalog.setting.operaLog.addSSH";
    private static final String MODIFY_SSH = "operalog.setting.operaLog.modifySSH";
    private DefaultListModel defaultListModel = new DefaultListModel();
    private JList routeList = new JList(this.defaultListModel);
    private DefaultTableModel defaultTableModel = new DefaultTableModel(new String[]{ResourceUtil.getString((String)"device.adddialog.proxysetting.routenodeip"), ResourceUtil.getString((String)"device.adddialog.proxysetting.routenodeuser"), ResourceUtil.getString((String)"device.adddialog.proxysetting.routenodepwd"), ResourceUtil.getString((String)"device.adddialog.proxysetting.routenodeport")}, new int[0]);
    private IsmTable detailTable = new IsmTable((TableModel)this.defaultTableModel);
    private JButton createBtn = new JButton(ResourceUtil.getImage((String)"add.png"));
    private JButton deleteBtn = new JButton(ResourceUtil.getImage((String)"delete.png"));
    private JButton addRouteNode = new JButton(ResourceUtil.getImage((String)"add.png"));
    private JButton delRouteNode = new JButton(ResourceUtil.getImage((String)"delete.png"));
    private JButton upArrowNode = new JButton(ResourceUtil.getImage((String)"uparrow.gif"));
    private JButton downArrowNode = new JButton(ResourceUtil.getImage((String)"downarrow.gif"));
    private final KeyOrderedHashMap<String, List<MultiRouteNode>> routeMap = new KeyOrderedHashMap();
    private JDialog parent;
    private int curRouteIndex = -1;
    private JLabel detailLabel = new JLabel(ResourceUtil.getString((String)"device.adddialog.proxysetting.routedetail1"));
    private boolean isShowTip = false;
    private List<OperaLog> addOperaLogs = new ArrayList<OperaLog>();
    private KeyOrderedHashMap<String, List<MultiRouteNode>> tableRows = new KeyOrderedHashMap();
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(SshForwardSetLayout.class);

    public SshForwardSetLayout(JDialog parent, boolean isShowTip) {
        this.parent = parent;
        this.isShowTip = isShowTip;
        this.initUI();
        this.initListener();
        this.initData();
        this.setCompName();
    }

    private void initData() {
        int routeSize;
        KeyOrderedHashMap<String, List<MultiRouteNode>> routeMapHistory = SettingService.getSshForwards();
        this.tableRows.putAll(routeMapHistory);
        if (null != routeMapHistory) {
            List keys = routeMapHistory.keyList();
            for (String key : keys) {
                this.defaultListModel.addElement(key);
                this.routeMap.put((Object)key, routeMapHistory.get((Object)key));
            }
        }
        if ((routeSize = this.defaultListModel.getSize()) > 0) {
            this.routeList.setSelectedIndex(0);
            this.curRouteIndex = 0;
            this.changeSelectRoute(this.defaultListModel.elementAt(0).toString());
        } else {
            this.addRouteNode.setEnabled(false);
            this.delRouteNode.setEnabled(false);
        }
    }

    private void initRouteListListener() {
        this.createForwardListener();
        this.delForwardListener();
        this.routeList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (SwingUtilities.isRightMouseButton(mouseEvent) || mouseEvent.getClickCount() > 1) {
                    return;
                }
                SshForwardSetLayout.this.fireRouteListSelectChange();
            }
        });
        this.routeList.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                SshForwardSetLayout.this.fireRouteListSelectChange();
            }
        });
    }

    private void createForwardListener() {
        this.createBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!SshForwardSetLayout.this.saveCurRouteNodes()) {
                    return;
                }
                CreateSshForwardDialog createSshForwardDialog = new CreateSshForwardDialog(SshForwardSetLayout.this.parent);
                createSshForwardDialog.setVisible(true);
                String nameText = createSshForwardDialog.getRouteNameText();
                if (nameText.length() > 16) {
                    DialogUtils.showInfoDialog((JDialog)SshForwardSetLayout.this.parent, (String)ResourceUtil.getStringWithParams((String)"device.adddialog.proxysetting.routenametoolong", (Object[])new Object[0]));
                    return;
                }
                if (SshForwardSetLayout.this.defaultListModel.contains(nameText)) {
                    DialogUtils.showInfoDialog((JDialog)SshForwardSetLayout.this.parent, (String)ResourceUtil.getStringWithParams((String)"device.adddialog.proxysetting.nameexists", (Object[])new Object[]{nameText}));
                    return;
                }
                if (!StringUtils.isNULLStr((String)nameText)) {
                    SshForwardSetLayout.this.defaultListModel.addElement(nameText);
                    SshForwardSetLayout.this.routeMap.put((Object)nameText, new ArrayList());
                    int index = SshForwardSetLayout.this.defaultListModel.indexOf(nameText);
                    SshForwardSetLayout.this.routeList.setSelectedIndex(index);
                    SshForwardSetLayout.this.changeSelectRoute(SshForwardSetLayout.this.defaultListModel.elementAt(index).toString());
                    SshForwardSetLayout.this.curRouteIndex = index;
                    ToolLoggerFactory.getLogger(this.getClass()).info("create defauModel!");
                    SshForwardSetLayout.this.addRouteNode.setEnabled(true);
                    SshForwardSetLayout.this.delRouteNode.setEnabled(true);
                    OperaLog operaLog = LogUtils.addOperaLogForProxy(SshForwardSetLayout.ADD_SSH, nameText, true, true);
                    SshForwardSetLayout.this.addOperaLogs.add(operaLog);
                }
            }
        });
    }

    private void delForwardListener() {
        this.deleteBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int selectIndex = SshForwardSetLayout.this.routeList.getSelectedIndex();
                if (-1 == selectIndex) {
                    return;
                }
                if (selectIndex != SshForwardSetLayout.this.curRouteIndex && !SshForwardSetLayout.this.saveCurRouteNodes()) {
                    return;
                }
                String msg = ResourceUtil.getStringWithParams((String)"device.adddialog.proxysetting.delroute", (Object[])new Object[]{selectIndex + 1});
                WarningDialog wd = DialogUtils.showYesNoDialog((Window)SshForwardSetLayout.this.parent, (String)msg);
                if (0 == wd.getValue()) {
                    String sshName = (String)SshForwardSetLayout.this.routeMap.keyList().get(selectIndex);
                    SettingService.getSshForwards().remove(SshForwardSetLayout.this.defaultListModel.get(selectIndex));
                    SshForwardSetLayout.this.routeMap.remove(SshForwardSetLayout.this.defaultListModel.get(selectIndex));
                    SshForwardSetLayout.this.defaultListModel.removeElementAt(selectIndex);
                    SshForwardSetLayout.this.detailLabel.setText(ResourceUtil.getString((String)"device.adddialog.proxysetting.routedetail1"));
                    SshForwardSetLayout.this.defaultTableModel.removeAll();
                    SshForwardSetLayout.this.curRouteIndex = -1;
                    ToolLoggerFactory.getLogger(this.getClass()).info("delete sshModel!");
                    SshForwardSetLayout.this.isRecordDelLog(sshName);
                }
            }
        });
    }

    private void isRecordDelLog(String sshName) {
        OperaLog operaLog = LogUtils.addOperaLogForProxy(DELETE_SSH, sshName, true, true);
        if (this.isisLogsContain(operaLog) && !this.addOperaLogs.isEmpty()) {
            this.removeLogs(operaLog);
        }
        LogUtils.addSettingLog(DELETE_SSH, sshName, true, true);
    }

    private void removeLogs(OperaLog operaLog) {
        try {
            Iterator<OperaLog> it = this.addOperaLogs.iterator();
            while (it.hasNext()) {
                OperaLog log = it.next();
                if (!log.getDeviceNameEn().equals(operaLog.getDeviceNameEn())) continue;
                it.remove();
            }
        }
        catch (RuntimeException e) {
            LOGGER.error("delete " + operaLog.getDeviceNameEn() + " runtime exception", (Throwable)e);
        }
        catch (Exception e) {
            ToolLoggerFactory.getLogger(this.getClass()).error("delete " + operaLog.getDeviceNameEn() + " Failed");
        }
    }

    public boolean isisLogsContain(OperaLog operaLog) {
        if (null != this.addOperaLogs && !this.addOperaLogs.isEmpty()) {
            for (OperaLog log : this.addOperaLogs) {
                if (!log.getDeviceNameEn().equals(operaLog.getDeviceNameEn())) continue;
                return true;
            }
        }
        return false;
    }

    private void fireRouteListSelectChange() {
        int index = this.routeList.getSelectedIndex();
        if (-1 == index) {
            return;
        }
        DefaultListModel model = (DefaultListModel)this.routeList.getModel();
        if (this.saveCurRouteNodes()) {
            this.changeSelectRoute(model.getElementAt(index).toString());
            this.curRouteIndex = index;
        } else {
            this.routeList.setSelectedIndex(this.curRouteIndex);
        }
    }

    public boolean saveCurRouteNodes() {
        if (-1 == this.curRouteIndex) {
            return true;
        }
        List<MultiRouteNode> nodes = this.getTableRouteNodes();
        if (this.checkTableDataInvalid(nodes)) {
            Object curRoute = this.routeList.getModel().getElementAt(this.curRouteIndex);
            this.routeMap.put((Object)curRoute.toString(), nodes);
            return true;
        }
        return false;
    }

    private boolean checkTableDataInvalid(List<MultiRouteNode> nodes) {
        if (nodes.isEmpty()) {
            DialogUtils.showInfoDialog((JDialog)this.parent, (String)ResourceUtil.getStringWithParams((String)"device.adddialog.proxysetting.routenode.empty", (Object[])new Object[]{this.routeList.getModel().getElementAt(this.curRouteIndex).toString()}));
            return false;
        }
        List hostNames = nodes.stream().map(MultiRouteNode::getHost).filter(host -> !StringUtils.isNULLStr((String)host)).collect(Collectors.toList());
        for (MultiRouteNode node : nodes) {
            if (!node.isValid()) {
                DialogUtils.showInfoDialog((JDialog)this.parent, (String)ResourceUtil.getString((String)"device.adddialog.proxysetting.routenodeerror"));
                return false;
            }
            long count = hostNames.stream().filter(node.getHost()::equalsIgnoreCase).count();
            if (count <= 1L) continue;
            String msg = ResourceUtil.getStringWithParams((String)"device.adddialog.proxysetting.routenode.repeated", (Object[])new Object[]{node.getHost()});
            DialogUtils.showInfoDialog((JDialog)this.parent, (String)msg);
            return false;
        }
        return true;
    }

    private List<MultiRouteNode> getTableRouteNodes() {
        ArrayList<MultiRouteNode> list = new ArrayList<MultiRouteNode>();
        List allRows = this.defaultTableModel.getAllRows();
        for (TableRow row : allRows) {
            String host = row.getValueAt(0).toString();
            String username = row.getValueAt(1).toString();
            String password = row.getValueAt(2).toString();
            int port = -1;
            if (!StringUtils.isNULLStr((String)row.getValueAt(3).toString())) {
                port = StringUtils.str2Int((String)row.getValueAt(3).toString());
            }
            MultiRouteNode multiRouteNode = new MultiRouteNode(host, port, username, password);
            list.add(multiRouteNode);
        }
        return list;
    }

    private void initListener() {
        this.initRouteListListener();
        this.addRouteNode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int editRouteIndex = SshForwardSetLayout.this.routeList.getSelectedIndex();
                if (-1 == editRouteIndex) {
                    DialogUtils.showInfoDialog((JDialog)SshForwardSetLayout.this.parent, (String)ResourceUtil.getString((String)"device.adddialog.proxysetting.noteselectroute"));
                    return;
                }
                SshForwardSetLayout.this.defaultTableModel.addRow(new TableRow[]{SshForwardSetLayout.this.createBlankRow()});
                SshForwardSetLayout.this.addAndUpdateLog();
            }
        });
        this.defaultTableModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                SshForwardSetLayout.this.clearTableEdit();
            }
        });
        this.delRouteNode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int selectIndex = SshForwardSetLayout.this.detailTable.getSelectedRow();
                selectIndex = SshForwardSetLayout.this.detailTable.convertRowIndexToModel(selectIndex);
                if (-1 == selectIndex) {
                    return;
                }
                String msg = ResourceUtil.getStringWithParams((String)"device.adddialog.proxysetting.delroutenode", (Object[])new Object[]{selectIndex + 1});
                WarningDialog dialog = DialogUtils.showYesNoDialog((Window)SshForwardSetLayout.this.parent, (String)msg);
                if (0 == dialog.getValue()) {
                    SshForwardSetLayout.this.defaultTableModel.removeRow(new TableRow[]{SshForwardSetLayout.this.defaultTableModel.getRow(selectIndex)});
                    SshForwardSetLayout.this.addAndUpdateLog();
                }
            }
        });
        this.upArrowNode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SshForwardSetLayout.this.clearTableEdit();
                int selectIndex = SshForwardSetLayout.this.detailTable.getSelectedRow();
                selectIndex = SshForwardSetLayout.this.detailTable.convertRowIndexToModel(selectIndex);
                if (-1 == selectIndex) {
                    return;
                }
                if (0 == selectIndex) {
                    SshForwardSetLayout.this.detailTable.clearSelection();
                    return;
                }
                List allRows = SshForwardSetLayout.this.detailTable.getAllRows();
                TableRow selectedRow = (TableRow)allRows.get(selectIndex);
                int aimIndex = selectIndex - 1;
                TableRow aimRow = (TableRow)allRows.get(aimIndex);
                allRows.set(aimIndex, selectedRow);
                allRows.set(selectIndex, aimRow);
                SshForwardSetLayout.this.defaultTableModel.removeAll();
                SshForwardSetLayout.this.defaultTableModel.addRow(allRows);
                SshForwardSetLayout.this.detailTable.setRowSelectionInterval(aimIndex, aimIndex);
                SshForwardSetLayout.this.addAndUpdateLog();
            }
        });
        this.downArrowActionListener();
        this.detailKeyListener();
    }

    private void downArrowActionListener() {
        this.downArrowNode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SshForwardSetLayout.this.clearTableEdit();
                int selectIndex = SshForwardSetLayout.this.detailTable.getSelectedRow();
                selectIndex = SshForwardSetLayout.this.detailTable.convertRowIndexToModel(selectIndex);
                if (-1 == selectIndex) {
                    return;
                }
                if (selectIndex == SshForwardSetLayout.this.detailTable.getRowCount() - 1) {
                    SshForwardSetLayout.this.detailTable.clearSelection();
                    return;
                }
                List allRows = SshForwardSetLayout.this.detailTable.getAllRows();
                TableRow selectedRow = (TableRow)allRows.get(selectIndex);
                int aimIndex = selectIndex + 1;
                TableRow aimRow = (TableRow)allRows.get(aimIndex);
                allRows.set(aimIndex, selectedRow);
                allRows.set(selectIndex, aimRow);
                SshForwardSetLayout.this.defaultTableModel.removeAll();
                SshForwardSetLayout.this.defaultTableModel.addRow(allRows);
                SshForwardSetLayout.this.detailTable.setRowSelectionInterval(aimIndex, aimIndex);
                SshForwardSetLayout.this.addAndUpdateLog();
            }
        });
    }

    private void addAndUpdateLog() {
        String sshName = String.valueOf(this.routeList.getSelectedValue());
        OperaLog operaLog = LogUtils.addOperaLogForProxy(MODIFY_SSH, sshName, true, true);
        if (!this.isisLogsContain(operaLog)) {
            this.addOperaLogs.add(operaLog);
        }
    }

    private void detailKeyListener() {
        this.detailTable.addKeyListener((KeyListener)new MyCustKeyAdapter());
    }

    private void changeSelectRoute(String routeName) {
        List routes = (List)this.routeMap.get((Object)routeName);
        if (null == routes) {
            this.defaultTableModel.removeAll();
            return;
        }
        this.clearTableEdit();
        this.defaultTableModel.removeAll();
        for (MultiRouteNode node : routes) {
            this.defaultTableModel.addRow(new TableRow[]{this.createRow(node)});
        }
        this.detailLabel.setText(ResourceUtil.getStringWithParams((String)"device.adddialog.proxysetting.routedetail", (Object[])new Object[]{routeName}));
    }

    public void clearTableEdit() {
        TableCellEditor editor = this.detailTable.getCellEditor();
        if (null != editor) {
            editor.stopCellEditing();
        }
    }

    private TableRow<?, ?> createBlankRow() {
        DefaultTableRow row = new DefaultTableRow(this.defaultTableModel.getColumnCount(), (Object)UUID.randomUUID().toString());
        IsmTextField ipTextField = UiMethod.createIpv4v6TextField();
        TextEditCell tec = new TextEditCell(ResourceUtil.getString((String)"devicemanager.layout.device.add.sshfrd.detail"), (JTextField)ipTextField);
        row.setValueAt(0, (Object)tec);
        row.setValueAt(1, (Object)new TextEditCell("", (JTextField)UiMethod.getUsernameFiled()));
        row.setValueAt(2, (Object)new TextEditCell("", (JTextField)UiMethod.getPasswordFiled(), true));
        IsmTextField portFileField = IsmTextField.getRegexTextField((String)"\\d{1,5}", (int)5);
        row.setValueAt(3, (Object)new TextEditCell("", (JTextField)portFileField));
        return row;
    }

    private TableRow<?, ?> createRow(MultiRouteNode multiRouteNode) {
        DefaultTableRow row = new DefaultTableRow(this.defaultTableModel.getColumnCount(), (Object)UUID.randomUUID().toString());
        IsmTextField ip = UiMethod.createIpv4v6TextField();
        IsmTextField username = UiMethod.getUsernameFiled();
        IsmPasswordField password = UiMethod.getPasswordFiled();
        TextEditCell ipCell = new TextEditCell(multiRouteNode.getHost(), (JTextField)ip);
        final TextEditCell userNameCell = new TextEditCell(multiRouteNode.getUname(), (JTextField)username);
        ipCell.getEditor().addCellEditorListener(new CellEditorListener((TableRow)row, username, password){
            final /* synthetic */ TableRow val$row;
            final /* synthetic */ IsmTextField val$username;
            final /* synthetic */ IsmPasswordField val$password;
            {
                this.val$row = tableRow;
                this.val$username = ismTextField;
                this.val$password = ismPasswordField;
            }

            @Override
            public void editingStopped(ChangeEvent changeEvent) {
                this.clearUserNamePwdContent();
            }

            @Override
            public void editingCanceled(ChangeEvent changeEvent) {
                this.clearUserNamePwdContent();
            }

            private void clearUserNamePwdContent() {
                if (!VerifyUtil.isEmpty((Object)userNameCell.getValue())) {
                    this.val$row.setValueAt(1, (Object)new TextEditCell("", (JTextField)this.val$username));
                    this.val$row.setValueAt(2, (Object)new TextEditCell("", (JTextField)this.val$password, true));
                    SshForwardSetLayout.this.detailTable.repaint();
                }
            }
        });
        row.setValueAt(0, (Object)ipCell);
        row.setValueAt(1, (Object)userNameCell);
        row.setValueAt(2, (Object)new TextEditCell(multiRouteNode.getPwd(), (JTextField)password, true));
        row.setValueAt(3, (Object)new TextEditCell(multiRouteNode.getPort() + "", (JTextField)IsmTextField.getRegexTextField((String)"\\d{1,5}", (int)5)));
        return row;
    }

    private void initUI() {
        JComponent tableOpration;
        this.detailTable.setRowSorter(null);
        this.routeList.setSelectionMode(0);
        JScrollPane listScrollPan = new JScrollPane(this.routeList);
        listScrollPan.setName("_List_listScrollPan");
        IsmTableScrollPane tableScorllPan = new IsmTableScrollPane(this.detailTable, false);
        UiMethod.setComponentSize((Dimension)new Dimension(18, 18), (Component[])new Component[]{this.addRouteNode, this.delRouteNode, this.upArrowNode, this.downArrowNode, this.createBtn, this.deleteBtn});
        this.addRouteNode.setToolTipText(ResourceUtil.getString((String)"device.adddialog.proxysetting.routenodeadd"));
        this.delRouteNode.setToolTipText(ResourceUtil.getString((String)"device.adddialog.proxysetting.routenodedel"));
        this.upArrowNode.setToolTipText(ResourceUtil.getString((String)"device.adddialog.proxysetting.routenodeup"));
        this.downArrowNode.setToolTipText(ResourceUtil.getString((String)"device.adddialog.proxysetting.routenodedown"));
        this.createBtn.setToolTipText(ResourceUtil.getString((String)"device.adddialog.proxysetting.routecreate"));
        this.deleteBtn.setToolTipText(ResourceUtil.getString((String)"device.adddialog.proxysetting.routedelete"));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.anchor = 11;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = new Insets(0, 12, 0, 12);
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        JLabel routeListLabel = new JLabel(ResourceUtil.getString((String)"device.adddialog.proxysetting.routelist"));
        JComponent topComp = UCD.buildHorizotalBox(null, (Component[])new Component[]{UCD.buildHBoxLeft((Component[])new Component[]{routeListLabel}), UCD.buildHBoxRight((Component[])new Component[]{this.createBtn, this.deleteBtn})});
        this.add((Component)topComp, gbc);
        gbc.weighty = 5.0;
        ++gbc.gridy;
        this.add((Component)listScrollPan, gbc);
        JComponent tableOprete = UCD.buildHorizotalBox(null, (Component[])new Component[]{UCD.buildHBoxLeft((Component[])new Component[]{this.detailLabel}), UCD.buildHBoxRight((Component[])new Component[]{this.addRouteNode, this.delRouteNode, this.upArrowNode, this.downArrowNode})});
        if (this.isShowTip) {
            JLabel sshForwardTip = new JLabel(ResourceUtil.getString((String)"device.adddialog.proxysetting.sshforward.tip"));
            tableOpration = UCD.buildVerticalBox(null, (Component[])new Component[]{tableOprete, UCD.buildHBoxLeft((Component[])new Component[]{sshForwardTip})});
        } else {
            tableOpration = tableOprete;
        }
        gbc.weighty = 1.0;
        ++gbc.gridy;
        this.add((Component)tableOpration, gbc);
        gbc.weighty = 5.0;
        ++gbc.gridy;
        gbc.insets.bottom = 12;
        this.add((Component)tableScorllPan, gbc);
        this.setOpaque(false);
    }

    public void setCompName() {
        this.createBtn.setName("_Button_createBtn");
        this.deleteBtn.setName("_Button_deleteBtn");
        this.addRouteNode.setName("_Button_addRouteNode");
        this.delRouteNode.setName("_Button_delRouteNode");
        this.upArrowNode.setName("_Button_upArrowNode");
        this.downArrowNode.setName("_Button_downArrowNode");
        this.detailTable.setName("_IsmTable_detailTable");
    }

    public KeyOrderedHashMap<String, List<MultiRouteNode>> getRouteMap() {
        return this.routeMap;
    }

    public List<OperaLog> getAddOperaLogs() {
        return this.addOperaLogs;
    }

    public void setAddOperaLogs(List<OperaLog> addOperaLogs) {
        this.addOperaLogs = addOperaLogs;
    }

    public KeyOrderedHashMap<String, List<MultiRouteNode>> getTableRows() {
        return this.tableRows;
    }

    public void setTableRows(KeyOrderedHashMap<String, List<MultiRouteNode>> tableRows) {
        this.tableRows = tableRows;
    }

    public void setShowTip(boolean isShowTip) {
        this.isShowTip = isShowTip;
    }

    private static final class MyCustKeyAdapter
    extends KeyAdapter {
        private MyCustKeyAdapter() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.isControlDown() && 67 == e.getKeyCode()) {
                e.consume();
            }
        }
    }
}

