/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicemanager.ui.dialog.deviceadd.service;

import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.devicemanager.service.DeviceManageService;
import com.huawei.ism.tool.devicemanager.service.dev.infoqry.DSstorageInfoQryServiceImpl;
import com.huawei.ism.tool.devicemanager.utils.LogUtils;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.DeviceType;
import com.huawei.ism.tool.obase.taskexecutor.TaskResult;
import com.huawei.ism.ui.swing.dialog.CustMsgProgressDialog;
import com.huawei.ism.ui.swing.dialog.ProgressDialog;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CubeDeviceAddService
implements Callable<TaskResult> {
    private static final Logger log = LoggerFactory.getLogger(CubeDeviceAddService.class);
    private final DeviceManageService deviceManageService = new DeviceManageService(new DSstorageInfoQryServiceImpl());
    private final ProgressDialog progressDialog;
    private final DevNode devNode;

    public CubeDeviceAddService(DevNode devNode, CustMsgProgressDialog progressDialog) {
        this.progressDialog = progressDialog;
        this.devNode = devNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TaskResult call() throws Exception {
        try {
            long startTime = System.currentTimeMillis();
            TaskResult result = this.deviceManageService.addDeviceParallel(this.progressDialog, this.devNode, true);
            this.recordAddTime(this.devNode, startTime, result);
            TaskResult taskResult = this.handleTaskResult(this.devNode, result);
            return taskResult;
        }
        finally {
            this.progressDialog.dispose();
        }
    }

    public DevNode createFusionCubeSSHDevNode(DevNode devNode) {
        DevNode fusionCubeDevNode = new DevNode();
        fusionCubeDevNode.setLoginUser(devNode.getFusionCubeLoginUser());
        fusionCubeDevNode.setRootUser(devNode.getRootUser());
        fusionCubeDevNode.setPriKey(devNode.getPriKey());
        fusionCubeDevNode.setDevKey(devNode.getDevKey());
        fusionCubeDevNode.setPort(devNode.getFusionCubeSSHPort());
        fusionCubeDevNode.setIp(devNode.getIp());
        fusionCubeDevNode.setDeviceSerialNumber(devNode.getDeviceSerialNumber());
        fusionCubeDevNode.setProductVersion(devNode.getProductVersion());
        fusionCubeDevNode.setProductModel(devNode.getProductModel());
        fusionCubeDevNode.setDeviceType(DeviceType.valueOf((String)ItDeviceType.FUSIONCUBE.getName()));
        return fusionCubeDevNode;
    }

    private TaskResult handleTaskResult(DevNode dev, TaskResult result) {
        if (null == result) {
            log.error("Result is null");
            TaskResult ret = new TaskResult();
            ret.setResult(TaskResult.Result.FAILED);
            ret.setErrorLocaleDescription("");
            ret.setResultObject((Object)dev);
            return ret;
        }
        if (result.getResultObject() == null) {
            result.setResultObject((Object)dev);
        }
        if (result.getResult() == TaskResult.Result.SUCCESS) {
            LogUtils.addOperaLog("operalog.name.adddevice", dev, result, "");
        } else {
            LogUtils.addOperaLog("operalog.name.adddevice", dev, result, result.getErrorId());
        }
        return result;
    }

    private void recordAddTime(DevNode dev, long sTime, TaskResult result) {
        log.info(StringUtils.getCleanMessage((String)("add dev version:" + dev.getProductVersion() + " devIp" + dev.getUid() + " takes time:" + (System.currentTimeMillis() - sTime) + " taskResult:" + (result == null ? null : result.getResult()))));
    }
}

