/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicemanager.ui.former.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.huawei.ism.tool.devicemanager.service.implement.DefaultNodeProviderImpl;
import com.huawei.ism.tool.devicemanager.ui.former.ExtendNodeSaveUtil;
import com.huawei.ism.tool.devicemanager.ui.former.service.NodeSceneOptionService;
import com.huawei.ism.tool.devicemanager.ui.listener.verify.VerifyResult;
import com.huawei.ism.tool.devicemanager.utils.DeviceAddUtil;
import com.huawei.ism.tool.framework.pubservice.entity.DevNode;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.obase.entity.A800Node;
import com.huawei.ism.tool.obase.entity.AiDevNode;
import com.huawei.ism.tool.obase.entity.DeviceType;
import com.huawei.ism.tool.obase.entity.DmeNode;
import com.huawei.ism.tool.obase.entity.EntityUtils;
import com.huawei.ism.tool.obase.entity.User;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IntelligentComputeSceneImpl
implements NodeSceneOptionService<AiDevNode> {
    private static final Logger log = LoggerFactory.getLogger(IntelligentComputeSceneImpl.class);

    @Override
    public void saveExtend(List<DevNode> selectNodes) {
        List nodes = DefaultNodeProviderImpl.getInstance().getNodeList().stream().filter(AiDevNode.class::isInstance).map(AiDevNode.class::cast).collect(Collectors.toList());
        ArrayList<JSONObject> result = new ArrayList<JSONObject>();
        for (AiDevNode node : nodes) {
            IntelligentComputeSceneImpl.selectDmeNodes(node, selectNodes);
            result.add(this.buildDmeExtend(node));
        }
        if (result.isEmpty()) {
            log.info("no node need save extend info");
            return;
        }
        ExtendNodeSaveUtil.writeNodeExtendInfo(JSON.toJSONString(result));
    }

    public void saveAiExtend() {
        List result = DefaultNodeProviderImpl.getInstance().getNodeList().stream().filter(AiDevNode.class::isInstance).map(AiDevNode.class::cast).map(this::buildDmeExtend).collect(Collectors.toList());
        if (result.isEmpty()) {
            log.info("no node need save extend info");
            return;
        }
        ExtendNodeSaveUtil.writeNodeExtendInfo(JSON.toJSONString(result), ExtendNodeSaveUtil.TO_BOX_DEVICE_FILE);
    }

    public List<AiDevNode> readAiExtend() {
        List<AiDevNode> aiDevNodes = ExtendNodeSaveUtil.readExtendNodeInfoFromFile(new TypeReference<List<AiDevNode>>(){}, Collections.emptyList(), ExtendNodeSaveUtil.TO_BOX_DEVICE_FILE);
        for (AiDevNode aiDevNode : aiDevNodes) {
            IntelligentComputeSceneImpl.setDeviceType(aiDevNode);
            this.decryptPwd((com.huawei.ism.tool.obase.entity.DevNode)aiDevNode);
            this.decryptA800(aiDevNode);
            this.decryptOm(aiDevNode);
        }
        return aiDevNodes;
    }

    private JSONObject buildDmeExtend(AiDevNode node) {
        JSONObject jsonObject = JSON.parseObject((String)JSON.toJSONString((Object)node));
        jsonObject.put("loginUser", (Object)IntelligentComputeSceneImpl.buildUser(node.getLoginUser()));
        List a800Nodes = node.getA800Nodes().stream().map(this::buildA800Info).collect(Collectors.toList());
        List oms = node.getOmNodes().stream().map(this::buildOmInfo).collect(Collectors.toList());
        jsonObject.put("a800Nodes", a800Nodes);
        jsonObject.put("omNodes", oms);
        return jsonObject;
    }

    private static void selectDmeNodes(AiDevNode node, List<DevNode> selectNodes) {
        Set selectSns = selectNodes.stream().map(DevNode::getDeviceSerialNumber).collect(Collectors.toSet());
        node.getA800Nodes().forEach(a800Node -> a800Node.setSelect(selectSns.contains(a800Node.getDeviceSerialNumber())));
        node.getOmNodes().forEach(omNode -> omNode.setSelect(selectSns.contains(omNode.getDeviceSerialNumber())));
    }

    private JSONObject buildOmInfo(DmeNode dmeNode) {
        JSONObject jsonObject = JSON.parseObject((String)JSON.toJSONString((Object)dmeNode));
        jsonObject.put("loginUser", (Object)IntelligentComputeSceneImpl.buildUser(dmeNode.getLoginUser()));
        return jsonObject;
    }

    private JSONObject buildA800Info(A800Node a800Node) {
        JSONObject jsonObject = JSON.parseObject((String)JSON.toJSONString((Object)a800Node));
        jsonObject.put("loginUser", (Object)IntelligentComputeSceneImpl.buildUser(a800Node.getLoginUser()));
        jsonObject.put("zones", this.buildZones(a800Node.getZones()));
        return jsonObject;
    }

    private List<JSONObject> buildZones(List<DmeNode> zones) {
        return zones.stream().map(this::buildZoneInfo).collect(Collectors.toList());
    }

    private JSONObject buildZoneInfo(DmeNode dmeNode) {
        JSONObject jsonObject = JSON.parseObject((String)JSON.toJSONString((Object)dmeNode));
        jsonObject.put("loginUser", (Object)IntelligentComputeSceneImpl.buildUser(dmeNode.getLoginUser()));
        return jsonObject;
    }

    private static JSONObject buildUser(User loginUser) {
        if (Objects.isNull(loginUser)) {
            return new JSONObject();
        }
        JSONObject user = new JSONObject();
        user.put("username", (Object)loginUser.getUserName());
        user.put("password", (Object)loginUser.getEcptPassword());
        return user;
    }

    @Override
    public List<AiDevNode> readExtend() {
        List<AiDevNode> aiDevNodes = ExtendNodeSaveUtil.readExtendNodeInfoFromFile(new TypeReference<List<AiDevNode>>(){}, Collections.emptyList());
        for (AiDevNode aiDevNode : aiDevNodes) {
            IntelligentComputeSceneImpl.setDeviceType(aiDevNode);
            this.decryptPwd((com.huawei.ism.tool.obase.entity.DevNode)aiDevNode);
            this.decryptA800(aiDevNode);
            this.decryptOm(aiDevNode);
        }
        return aiDevNodes;
    }

    private static void setDeviceType(AiDevNode aiDevNode) {
        aiDevNode.setDeviceType(DeviceType.valueOf((String)ItDeviceType.DME_NODE.getName()));
        for (A800Node a800Node : aiDevNode.getA800Nodes()) {
            a800Node.setDeviceType(DeviceType.valueOf((String)ItDeviceType.A800_NODE.getName()));
            for (DmeNode zone : a800Node.getZones()) {
                zone.setDeviceType(DeviceType.valueOf((String)ItDeviceType.A800_NODE.getName()));
            }
        }
        for (DmeNode omNode : aiDevNode.getOmNodes()) {
            omNode.setDeviceType(DeviceType.valueOf((String)ItDeviceType.A800_OM.getName()));
        }
    }

    private void decryptOm(AiDevNode aiDevNode) {
        aiDevNode.getOmNodes().forEach(this::decryptPwd);
    }

    private void decryptA800(AiDevNode aiDevNode) {
        aiDevNode.getA800Nodes().forEach(a800Node -> {
            this.decryptPwd((com.huawei.ism.tool.obase.entity.DevNode)a800Node);
            a800Node.getZones().forEach(this::decryptPwd);
        });
    }

    private void decryptPwd(com.huawei.ism.tool.obase.entity.DevNode devNode) {
        User loginUser = devNode.getLoginUser();
        if (Objects.isNull(loginUser)) {
            return;
        }
        loginUser.setEcptPassword(loginUser.getPassword());
    }

    @Override
    public List<DevNode> buildPrepareShowNode(List<DevNode> devNodes) {
        return devNodes.stream().map(node -> DefaultNodeProviderImpl.getInstance().findDevNode(node.getDeviceSerialNumber())).filter(AiDevNode.class::isInstance).map(AiDevNode.class::cast).map(this::buildShowNodeByScene).filter(Objects::nonNull).flatMap(Collection::stream).map(EntityUtils::toNewDev).collect(Collectors.toList());
    }

    @Override
    public VerifyResult verifyNodeAdd(com.huawei.ism.tool.obase.entity.DevNode devNode) {
        if (!(devNode instanceof AiDevNode)) {
            return new VerifyResult();
        }
        AiDevNode aiDevNode = (AiDevNode)devNode;
        if (DeviceAddUtil.isSceneSupportOmOnly()) {
            return this.verifyOmAuth(aiDevNode);
        }
        if (DeviceAddUtil.isSceneSupportA800Only()) {
            return this.verifyZone(aiDevNode);
        }
        if (this.allOmNotAuth(aiDevNode) && this.allZoneNotAuth(aiDevNode)) {
            return new VerifyResult(false, ResourceUtil.getString((String)"has.no.auth.dme.in.scene"));
        }
        String errorMsg = "";
        if (IntelligentComputeSceneImpl.hasNoAuthZone(aiDevNode)) {
            errorMsg = errorMsg + ResourceUtil.getString((String)"has.no.auth.zones.confirm.info") + System.lineSeparator();
        }
        if (this.hsNoAuthOm(aiDevNode)) {
            errorMsg = errorMsg + ResourceUtil.getString((String)"has.no.auth.om.in.scene.confirm");
        }
        if (StringUtils.isNULLStr((String)errorMsg)) {
            return new VerifyResult();
        }
        return new VerifyResult(false, errorMsg, true);
    }

    @NotNull
    private VerifyResult verifyZone(AiDevNode aiDevNode) {
        if (!IntelligentComputeSceneImpl.hasNoAuthZone(aiDevNode)) {
            return new VerifyResult();
        }
        if (this.allZoneNotAuth(aiDevNode)) {
            return new VerifyResult(!IntelligentComputeSceneImpl.hasNoAuthZone(aiDevNode), ResourceUtil.getString((String)"has.no.auth.zone.in.scene"));
        }
        if (DeviceAddUtil.isAllowZoneNoAuth(DeviceAddUtil.getCurrentScene())) {
            return new VerifyResult(false, ResourceUtil.getString((String)"has.no.auth.zones.confirm.info"), true);
        }
        return new VerifyResult(!IntelligentComputeSceneImpl.hasNoAuthZone(aiDevNode), ResourceUtil.getString((String)"has.no.auth.zone.in.scene"));
    }

    private boolean allZoneNotAuth(AiDevNode aiDevNode) {
        return aiDevNode.getA800Nodes().stream().map(A800Node::getZones).flatMap(Collection::stream).allMatch(zone -> Objects.isNull(zone.getLoginUser()));
    }

    @NotNull
    private VerifyResult verifyOmAuth(AiDevNode aiDevNode) {
        if (!this.hsNoAuthOm(aiDevNode)) {
            return new VerifyResult();
        }
        if (this.allOmNotAuth(aiDevNode)) {
            return new VerifyResult(false, ResourceUtil.getString((String)"has.no.auth.om.in.scene"));
        }
        if (DeviceAddUtil.isAllowOmNoAuth(DeviceAddUtil.getCurrentScene())) {
            return new VerifyResult(false, ResourceUtil.getString((String)"has.no.auth.om.in.scene.confirm"), true);
        }
        return new VerifyResult(false, ResourceUtil.getString((String)"has.not.auth.om.node"), true);
    }

    private boolean allOmNotAuth(AiDevNode aiDevNode) {
        return aiDevNode.getOmNodes().stream().allMatch(node -> Objects.isNull(node.getLoginUser()));
    }

    @Override
    public List<DevNode> transToSaveInXmlNode(List<DevNode> selectNodes) {
        return DefaultNodeProviderImpl.getInstance().getNodeList().stream().filter(AiDevNode.class::isInstance).map(AiDevNode.class::cast).filter(node -> this.containsSelectDmeNode(selectNodes, (AiDevNode)node)).map(EntityUtils::toNewDev).collect(Collectors.toList());
    }

    @Override
    public String getPrepareHelpDocFileName() {
        return String.join((CharSequence)File.separator, "SencePrepare", "Prepare_IntellijCompute");
    }

    private boolean containsSelectDmeNode(List<DevNode> selectNodes, AiDevNode cacheNode) {
        Set<String> selectNodeFlag = selectNodes.stream().map(selectNode -> selectNode.getIp() + selectNode.getDeviceSerialNumber()).collect(Collectors.toSet());
        List a800Nodes = cacheNode.getA800Nodes();
        return IntelligentComputeSceneImpl.a800Select(a800Nodes, selectNodeFlag) || IntelligentComputeSceneImpl.omSelect(cacheNode.getOmNodes(), selectNodeFlag);
    }

    private static boolean omSelect(List<DmeNode> omNodes, Set<String> selectNodeFlag) {
        return omNodes.stream().anyMatch(node -> selectNodeFlag.contains(node.getIp() + node.getDeviceSerialNumber()));
    }

    private static boolean a800Select(List<A800Node> a800Nodes, Set<String> selectNodeFlag) {
        return a800Nodes.stream().anyMatch(node -> selectNodeFlag.contains(node.getIp() + node.getDeviceSerialNumber()));
    }

    private static boolean hasNoAuthZone(AiDevNode aiDevNode) {
        return aiDevNode.getA800Nodes().stream().map(A800Node::getZones).flatMap(Collection::stream).anyMatch(zone -> zone.getLoginUser() == null);
    }

    private boolean hsNoAuthOm(AiDevNode aiDevNode) {
        return aiDevNode.getOmNodes().stream().anyMatch(om -> om.getLoginUser() == null);
    }

    private List<? extends DmeNode> buildShowNodeByScene(AiDevNode node) {
        if (DeviceAddUtil.isSceneSupportA800Only()) {
            return node.getA800Nodes();
        }
        if (DeviceAddUtil.isSceneSupportOmOnly()) {
            return node.getOmNodes();
        }
        ArrayList omNodes = new ArrayList(node.getOmNodes());
        omNodes.addAll(node.getA800Nodes());
        return omNodes;
    }
}

