/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicemanager.utils;

import com.huawei.ism.tool.base.utils.SystemEnvUtil;
import com.huawei.ism.tool.devicemanager.ui.dialog.DeviceAddDialog;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.utils.StreamUtils;
import com.huawei.ism.tool.obase.utils.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;

public class HostKeyCheckUtils {
    private static final String FINGERPRINT_CONFIG = "configuration";
    private static final String HOSTKEY_PROPERTIES = "hostkey.properties";
    private static final String TOOLSFOLDER = "tools";
    private static final String LANGUAGE = "language";
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(DeviceAddDialog.class);
    private static String currHostKeyPath;

    public static Properties getFingerPrintProp() {
        return HostKeyCheckUtils.shareHostkey();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - bad return control flow
     */
    private static Properties shareHostkey() {
        Properties ret2333333332;
        LOGGER.info("start build host key");
        Properties propertites = new Properties();
        FileInputStream in = null;
        currHostKeyPath = HostKeyCheckUtils.initHostKeyPath();
        File hostKeyFile = new File(currHostKeyPath);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Current hostkey path is : " + currHostKeyPath);
        }
        try {
            boolean ret2333333332;
            if (!hostKeyFile.exists() && !(ret2333333332 = com.huawei.ism.tool.base.utils.FileUtils.createFile((File)hostKeyFile))) {
                LOGGER.error("Error happened in creat file.");
            }
            in = new FileInputStream(hostKeyFile);
            propertites.load(in);
            ret2333333332 = propertites;
        }
        catch (RuntimeException re) {
            LOGGER.error("Exception of run time happened in load properties", (Throwable)re);
            StreamUtils.closeStream(null, (InputStream)in);
        }
        catch (Exception e) {
            LOGGER.error("Exception happened in load properties", (Throwable)e);
            {
                catch (Throwable throwable) {
                    StreamUtils.closeStream(null, in);
                    throw throwable;
                }
            }
            StreamUtils.closeStream(null, (InputStream)in);
        }
        StreamUtils.closeStream(null, (InputStream)in);
        return ret2333333332;
        return propertites;
    }

    private static String initHostKeyPath() {
        if (!StringUtils.isNULLStr((String)currHostKeyPath)) {
            return currHostKeyPath;
        }
        String userDir = SystemEnvUtil.getDefaultUserDir();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("userDir::::" + userDir);
        }
        if (null == userDir) {
            throw new NullPointerException("UserDir is null");
        }
        HostKeyCheckUtils.createFingerDir();
        StringBuilder sbBuilder = new StringBuilder();
        StringBuilder rightSBStr = new StringBuilder(FINGERPRINT_CONFIG).append(File.separator).append(HOSTKEY_PROPERTIES);
        if (StringUtils.isNULLStr((String)System.getenv(LANGUAGE))) {
            sbBuilder.append(userDir).append(File.separator).append((CharSequence)rightSBStr);
        } else {
            int index = userDir.lastIndexOf(TOOLSFOLDER);
            if (index != -1) {
                sbBuilder.append(userDir.substring(0, index)).append((CharSequence)rightSBStr);
            } else {
                sbBuilder.append(userDir).append(File.separator).append((CharSequence)rightSBStr);
            }
        }
        return sbBuilder.toString();
    }

    private static void createFingerDir() {
        File dir = new File(FINGERPRINT_CONFIG);
        if (!dir.exists() && dir.mkdirs()) {
            LOGGER.info("create configuration dir success");
        }
    }

    public static void setFingerPrintProps(Map<String, String> currIPFPProps) {
        Properties p = HostKeyCheckUtils.getFingerPrintProp();
        for (Map.Entry<String, String> i : currIPFPProps.entrySet()) {
            p.setProperty(i.getKey(), i.getValue());
        }
        HostKeyCheckUtils.flushPropToFile(p);
    }

    public static void setFingerPrintProp(String ipStr, String fingerPrint) {
        if (fingerPrint != null) {
            Properties p = HostKeyCheckUtils.getFingerPrintProp();
            p.setProperty(ipStr, fingerPrint);
            HostKeyCheckUtils.flushPropToFile(p);
        }
    }

    private static void flushPropToFile(Properties p) {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(new File(currHostKeyPath));
            p.store(out, "");
        }
        catch (Exception e) {
            try {
                LOGGER.error("Exception happened in store properties", (Throwable)e);
            }
            catch (Throwable throwable) {
                StreamUtils.closeStream(out, null);
                throw throwable;
            }
            StreamUtils.closeStream((OutputStream)out, null);
        }
        StreamUtils.closeStream((OutputStream)out, null);
    }

    public static void deleteFingerPrint(List<DevNode> removed) {
        File file = new File(HostKeyCheckUtils.initHostKeyPath());
        LinkedList tempList = new LinkedList();
        try {
            tempList.addAll(FileUtils.readLines((File)file, (Charset)StandardCharsets.UTF_8));
        }
        catch (FileNotFoundException e) {
            LOGGER.error("Exception happened in read file, the file name:{}", (Object)file.getName());
            return;
        }
        catch (IOException e) {
            LOGGER.error("Exception happened in read file", (Throwable)e);
            return;
        }
        removed.forEach(devNode -> tempList.removeIf(line -> Objects.equals(line.split("=")[0], devNode.getIp())));
        try (FileWriter fw = new FileWriter(file);){
            tempList.stream().map(line -> line + System.getProperty("line.separator")).forEach(line -> HostKeyCheckUtils.writeLineToFile(fw, line));
        }
        catch (FileNotFoundException e) {
            LOGGER.error("Exception happened in write file, the file name:{}", (Object)file.getName());
        }
        catch (IOException e) {
            LOGGER.error("Exception happened in write file", (Throwable)e);
        }
    }

    private static void writeLineToFile(FileWriter fw, String line) {
        try {
            fw.write(line);
        }
        catch (IOException e) {
            LOGGER.error("Exception happened in write file", (Throwable)e);
        }
    }
}

