/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.protocol.tlv;

import com.huawei.ism.tlv.TLVUtils;
import com.huawei.ism.tlv.bean.Param;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.protocol.tlv.ITLVConnection;
import java.util.List;

public class ShakeHandRunable
implements Runnable {
    public static final long XVE_SHAKE_HAND_OPCODE = 55847813125L;
    public static final long S5000TV1_SHAKE_HAND_OPCODE = 8596488201L;
    private static final long SHAKE_HAND_INTERVAL = 30000L;
    private final ITLVConnection nexConnection;
    private long shakeHandOpcode = 0L;

    public ShakeHandRunable(ITLVConnection nexConnection, long shakeHandsOpcode) {
        this.nexConnection = nexConnection;
        this.shakeHandOpcode = shakeHandsOpcode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.nexConnection.isConnected()) {
            try {
                ITLVConnection iTLVConnection = this.nexConnection;
                synchronized (iTLVConnection) {
                    ToolLoggerFactory.getLogger(this.getClass()).info("start send shake hands cmd to:" + this.nexConnection);
                    List params = TLVUtils.paramList((Param[])new Param[0]);
                    this.nexConnection.invoke(this.shakeHandOpcode, params, 30);
                    ToolLoggerFactory.getLogger(this.getClass()).info("shake hands end:" + this.nexConnection);
                }
            }
            catch (Exception e) {
                ToolLoggerFactory.getLogger(this.getClass()).error("exception for shake hands," + this.nexConnection, (Throwable)e);
            }
            try {
                Thread.sleep(30000L);
            }
            catch (InterruptedException e) {
                ToolLoggerFactory.getLogger(this.getClass()).error("exception for shake hand sleep," + this.nexConnection, (Throwable)e);
            }
        }
    }
}

