/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.protocol.utils;

import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.protocol.utils.QueryDeviceHardwareUsageTask;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.MultiErrorYesOrNoDialog;
import com.huawei.ism.ui.swing.dialog.OldConfirmDialog;
import com.huawei.ism.ui.swing.dialog.ProgressDialog;
import java.awt.Window;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import javax.swing.JDialog;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceUsageService {
    private static final Logger log = LoggerFactory.getLogger(ResourceUsageService.class);
    public static final String[] USAGE_COLUMN_NAME = new String[]{ResourceUtil.getString("distributed.device.hardware.usage.dev.ip"), ResourceUtil.getString("distributed.device.hardware.usage.node.ip"), ResourceUtil.getString("distributed.device.hardware.usage.node.role"), ResourceUtil.getString("distributed.device.hardware.usage.cpu"), ResourceUtil.getString("distributed.device.hardware.usage.mem"), ResourceUtil.getString("distributed.device.hardware.usage.io"), ResourceUtil.getString("distributed.device.hardware.usage.disk"), ResourceUtil.getString("distributed.device.hardware.usage.desc")};
    private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle("config.protocol");
    private static final String QUERY_FAILED = ResourceUtil.getString("query.hardware.usage.failed");
    private static final String QUERY_TIP = ResourceUtil.getString("distributed.device.hardware.usage.progress.tip");
    private static final Map<String, List<String>> supportDevMap = new HashMap<String, List<String>>();
    private static final Map<String, List<String>> nonSupportDevMap = new HashMap<String, List<String>>();

    private static void initDevMap() {
        Arrays.stream(RESOURCE_BUNDLE.getString("hardware.usage.query.support.list").split(";")).forEach(str -> ResourceUsageService.fillDevMap(str));
    }

    public static List<String> getQueryFailedResult(String devIp) {
        return Arrays.asList(devIp, QUERY_FAILED, QUERY_FAILED, QUERY_FAILED, QUERY_FAILED, QUERY_FAILED, QUERY_FAILED, QUERY_FAILED);
    }

    public static boolean hasHardwareHighUsageNode(JDialog mainDialog, List<DevNode> devNodes) {
        List<List<String>> showNodeUsage = ResourceUsageService.getHardwareHighUsageData(mainDialog, devNodes);
        if (CollectionUtils.isEmpty(showNodeUsage)) {
            return false;
        }
        return !ResourceUsageService.isHighUsageWarningContinue(mainDialog, showNodeUsage);
    }

    public static boolean isHighUsageWarningContinue(JDialog mainDialog, List<List<String>> showNodeUsage) {
        long failCount = showNodeUsage.stream().filter(nodeInfo -> QUERY_FAILED.equals(nodeInfo.get(1))).count();
        String tip = failCount == 0L ? ResourceUtil.getString("distributed.device.hardware.usage.risk.tip") : (failCount == (long)showNodeUsage.size() ? ResourceUtil.getString("distributed.device.hardware.usage.query.failed.tip") : ResourceUtil.getString("distributed.device.hardware.usage.all.tip"));
        MultiErrorYesOrNoDialog multiErrorYesOrNoDialog = DialogUtils.createMultiWarningYesNoDialogWithSize((Window)mainDialog, (String)tip, (String[])USAGE_COLUMN_NAME, showNodeUsage, Arrays.asList(900, 300));
        if (multiErrorYesOrNoDialog.isDisplayable()) {
            multiErrorYesOrNoDialog.setVisible(true);
        }
        if (multiErrorYesOrNoDialog.getValue() == 0) {
            OldConfirmDialog inputConfirmDialog = DialogUtils.createInputConfirmDialog((JDialog)mainDialog, (String)ResourceUtil.getString("distributed.device.hardware.usage.error.ignore"));
            return inputConfirmDialog.getValue() == 0;
        }
        return false;
    }

    public static List<List<String>> getHardwareHighUsageData(JDialog mainDialog, List<DevNode> devNodes) {
        List<DevNode> supportDevs = devNodes.stream().filter(ResourceUsageService::isSupportHardwareUsageQuery).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(supportDevs)) {
            return Collections.emptyList();
        }
        return ResourceUsageService.getNodeHardwareUsageList(mainDialog, supportDevs);
    }

    private static List<List<String>> getNodeHardwareUsageList(JDialog mainDialog, List<DevNode> devNodes) {
        ProgressDialog progressDialog = new ProgressDialog((Window)mainDialog, QUERY_TIP, 300);
        QueryDeviceHardwareUsageTask task = new QueryDeviceHardwareUsageTask(progressDialog, devNodes);
        Future queryHardwareUsageFuture = AsyncExcutor.submit((Callable)task);
        if (progressDialog.isEnabled()) {
            progressDialog.setVisible(true);
        }
        List nodeHardwareUsageList = Collections.emptyList();
        try {
            nodeHardwareUsageList = (List)queryHardwareUsageFuture.get();
        }
        catch (InterruptedException e) {
            log.error("query hardware usage get InterruptedException: ", (Throwable)e);
        }
        catch (ExecutionException e) {
            log.error("query hardware usage get ExecutionException: ", (Throwable)e);
        }
        return nodeHardwareUsageList;
    }

    private static void fillDevMap(String modelData) {
        List<String> modelAndVersions = Arrays.asList(modelData.split(":"));
        if (modelAndVersions.size() != 2) {
            return;
        }
        String model = modelAndVersions.get(0);
        Map versions = Arrays.stream(modelAndVersions.get(1).split(",")).collect(Collectors.groupingBy(version -> !version.startsWith("!"), Collectors.toList()));
        supportDevMap.put(model, versions.getOrDefault(true, Collections.emptyList()));
        List notSupportVersions = versions.getOrDefault(false, Collections.emptyList()).stream().map(version -> version.replace("!", "")).collect(Collectors.toList());
        nonSupportDevMap.put(model, notSupportVersions);
    }

    public static boolean isSupportHardwareUsageQuery(DevNode devNode) {
        String devVersion;
        String devModel = devNode.getProductModel();
        if (ResourceUsageService.isInMap(nonSupportDevMap, devModel, devVersion = devNode.getProductVersion())) {
            return false;
        }
        return ResourceUsageService.isInMap(supportDevMap, devModel, devVersion);
    }

    private static boolean isInMap(Map<String, List<String>> devMap, String devModel, String devVersion) {
        if (!devMap.containsKey(devModel)) {
            return false;
        }
        return devMap.get(devModel).stream().anyMatch(version -> ResourceUsageService.isMatch(version, devVersion));
    }

    private static boolean isMatch(String version, String devVersion) {
        if (StringUtils.isEmpty((CharSequence)version) || StringUtils.isEmpty((CharSequence)devVersion)) {
            return false;
        }
        return !version.endsWith("*") && version.equals(devVersion) || version.endsWith("*") && devVersion.startsWith(version.replace("*", ""));
    }

    static {
        ResourceUsageService.initDevMap();
    }
}

