/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.certbase.entitys;

import com.huawei.ism.tool.certbase.annotations.FieldDesc;
import com.huawei.ism.tool.certbase.entitys.CertManageBaseEntity;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertReqEntity
extends CertManageBaseEntity {
    private static final Logger log = LoggerFactory.getLogger(CertReqEntity.class);
    @FieldDesc(fieldMapName="-keyalg", validRegex="[a-zA-Z0-9\\-]{1,20}")
    private String keyAlg;
    @FieldDesc(fieldMapName="-keysize")
    private int keySize;
    @FieldDesc(fieldMapName="-validity")
    private int validity;
    @FieldDesc(fieldMapName="-sigalg", validRegex="[a-zA-Z0-9]{1,20}")
    private String sigalg;
    @FieldDesc(fieldMapName="-deststoretype", validRegex="pkcs12")
    private String destStoreType;
    @FieldDesc(fieldMapName="cn", canBeEmpty=true, validRegex=".{1,50}", isExtendField=true)
    private String certApplierName;
    @FieldDesc(fieldMapName="ou", canBeEmpty=true, validRegex=".{1,50}", isExtendField=true)
    private String company;
    @FieldDesc(fieldMapName="o", canBeEmpty=true, validRegex=".{1,50}", isExtendField=true)
    private String organization;
    @FieldDesc(fieldMapName="c", canBeEmpty=true, validRegex=".{1,50}", isExtendField=true)
    private String stateName;

    private static String getProperty(String pripName, String defaultVal) {
        String val = System.getProperty(pripName);
        return StringUtils.isEmpty((CharSequence)val) ? defaultVal : val.replaceAll("[/\\\\]", " ");
    }

    private static String $default$keyAlg() {
        return "RSA";
    }

    private static int $default$keySize() {
        return 2048;
    }

    private static int $default$validity() {
        return 365;
    }

    private static String $default$sigalg() {
        return "SHA256withRSA";
    }

    private static String $default$destStoreType() {
        return "pkcs12";
    }

    private static String $default$certApplierName() {
        return CertReqEntity.getProperty("user.name", "--");
    }

    private static String $default$company() {
        return "eService&SmartKit";
    }

    private static String $default$organization() {
        return "HUAWEI";
    }

    private static String $default$stateName() {
        return CertReqEntity.getProperty("user.country", "--");
    }

    protected CertReqEntity(CertReqEntityBuilder<?, ?> b) {
        super(b);
        this.keyAlg = ((CertReqEntityBuilder)b).keyAlg$set ? ((CertReqEntityBuilder)b).keyAlg$value : CertReqEntity.$default$keyAlg();
        this.keySize = ((CertReqEntityBuilder)b).keySize$set ? ((CertReqEntityBuilder)b).keySize$value : CertReqEntity.$default$keySize();
        this.validity = ((CertReqEntityBuilder)b).validity$set ? ((CertReqEntityBuilder)b).validity$value : CertReqEntity.$default$validity();
        this.sigalg = ((CertReqEntityBuilder)b).sigalg$set ? ((CertReqEntityBuilder)b).sigalg$value : CertReqEntity.$default$sigalg();
        this.destStoreType = ((CertReqEntityBuilder)b).destStoreType$set ? ((CertReqEntityBuilder)b).destStoreType$value : CertReqEntity.$default$destStoreType();
        this.certApplierName = ((CertReqEntityBuilder)b).certApplierName$set ? ((CertReqEntityBuilder)b).certApplierName$value : CertReqEntity.$default$certApplierName();
        this.company = ((CertReqEntityBuilder)b).company$set ? ((CertReqEntityBuilder)b).company$value : CertReqEntity.$default$company();
        this.organization = ((CertReqEntityBuilder)b).organization$set ? ((CertReqEntityBuilder)b).organization$value : CertReqEntity.$default$organization();
        this.stateName = ((CertReqEntityBuilder)b).stateName$set ? ((CertReqEntityBuilder)b).stateName$value : CertReqEntity.$default$stateName();
    }

    public static CertReqEntityBuilder<?, ?> builder() {
        return new CertReqEntityBuilderImpl();
    }

    public CertReqEntityBuilder<?, ?> toBuilder() {
        return new CertReqEntityBuilderImpl().$fillValuesFrom(this);
    }

    public String getKeyAlg() {
        return this.keyAlg;
    }

    public int getKeySize() {
        return this.keySize;
    }

    public int getValidity() {
        return this.validity;
    }

    public String getSigalg() {
        return this.sigalg;
    }

    public String getDestStoreType() {
        return this.destStoreType;
    }

    public String getCertApplierName() {
        return this.certApplierName;
    }

    public String getCompany() {
        return this.company;
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getStateName() {
        return this.stateName;
    }

    public void setKeyAlg(String keyAlg) {
        this.keyAlg = keyAlg;
    }

    public void setKeySize(int keySize) {
        this.keySize = keySize;
    }

    public void setValidity(int validity) {
        this.validity = validity;
    }

    public void setSigalg(String sigalg) {
        this.sigalg = sigalg;
    }

    public void setDestStoreType(String destStoreType) {
        this.destStoreType = destStoreType;
    }

    public void setCertApplierName(String certApplierName) {
        this.certApplierName = certApplierName;
    }

    public void setCompany(String company) {
        this.company = company;
    }

    public void setOrganization(String organization) {
        this.organization = organization;
    }

    public void setStateName(String stateName) {
        this.stateName = stateName;
    }

    public CertReqEntity() {
        this.keyAlg = CertReqEntity.$default$keyAlg();
        this.keySize = CertReqEntity.$default$keySize();
        this.validity = CertReqEntity.$default$validity();
        this.sigalg = CertReqEntity.$default$sigalg();
        this.destStoreType = CertReqEntity.$default$destStoreType();
        this.certApplierName = CertReqEntity.$default$certApplierName();
        this.company = CertReqEntity.$default$company();
        this.organization = CertReqEntity.$default$organization();
        this.stateName = CertReqEntity.$default$stateName();
    }

    private static final class CertReqEntityBuilderImpl
    extends CertReqEntityBuilder<CertReqEntity, CertReqEntityBuilderImpl> {
        private CertReqEntityBuilderImpl() {
        }

        @Override
        protected CertReqEntityBuilderImpl self() {
            return this;
        }

        @Override
        public CertReqEntity build() {
            return new CertReqEntity(this);
        }
    }

    public static abstract class CertReqEntityBuilder<C extends CertReqEntity, B extends CertReqEntityBuilder<C, B>>
    extends CertManageBaseEntity.CertManageBaseEntityBuilder<C, B> {
        private boolean keyAlg$set;
        private String keyAlg$value;
        private boolean keySize$set;
        private int keySize$value;
        private boolean validity$set;
        private int validity$value;
        private boolean sigalg$set;
        private String sigalg$value;
        private boolean destStoreType$set;
        private String destStoreType$value;
        private boolean certApplierName$set;
        private String certApplierName$value;
        private boolean company$set;
        private String company$value;
        private boolean organization$set;
        private String organization$value;
        private boolean stateName$set;
        private String stateName$value;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            CertReqEntityBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(CertReqEntity instance, CertReqEntityBuilder<?, ?> b) {
            b.keyAlg(instance.keyAlg);
            b.keySize(instance.keySize);
            b.validity(instance.validity);
            b.sigalg(instance.sigalg);
            b.destStoreType(instance.destStoreType);
            b.certApplierName(instance.certApplierName);
            b.company(instance.company);
            b.organization(instance.organization);
            b.stateName(instance.stateName);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B keyAlg(String keyAlg) {
            this.keyAlg$value = keyAlg;
            this.keyAlg$set = true;
            return (B)this.self();
        }

        public B keySize(int keySize) {
            this.keySize$value = keySize;
            this.keySize$set = true;
            return (B)this.self();
        }

        public B validity(int validity) {
            this.validity$value = validity;
            this.validity$set = true;
            return (B)this.self();
        }

        public B sigalg(String sigalg) {
            this.sigalg$value = sigalg;
            this.sigalg$set = true;
            return (B)this.self();
        }

        public B destStoreType(String destStoreType) {
            this.destStoreType$value = destStoreType;
            this.destStoreType$set = true;
            return (B)this.self();
        }

        public B certApplierName(String certApplierName) {
            this.certApplierName$value = certApplierName;
            this.certApplierName$set = true;
            return (B)this.self();
        }

        public B company(String company) {
            this.company$value = company;
            this.company$set = true;
            return (B)this.self();
        }

        public B organization(String organization) {
            this.organization$value = organization;
            this.organization$set = true;
            return (B)this.self();
        }

        public B stateName(String stateName) {
            this.stateName$value = stateName;
            this.stateName$set = true;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "CertReqEntity.CertReqEntityBuilder(super=" + super.toString() + ", keyAlg$value=" + this.keyAlg$value + ", keySize$value=" + this.keySize$value + ", validity$value=" + this.validity$value + ", sigalg$value=" + this.sigalg$value + ", destStoreType$value=" + this.destStoreType$value + ", certApplierName$value=" + this.certApplierName$value + ", company$value=" + this.company$value + ", organization$value=" + this.organization$value + ", stateName$value=" + this.stateName$value + ")";
        }
    }
}

