/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.certbase.integrity;

import java.io.FileInputStream;
import java.io.InputStream;
import java.text.Normalizer;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Sha256CheckTool {
    private static final Logger LOGGER = LoggerFactory.getLogger(Sha256CheckTool.class);
    private static final Sha256CheckTool INSTANCE = new Sha256CheckTool();

    private Sha256CheckTool() {
    }

    public static Sha256CheckTool getInstance() {
        return INSTANCE;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getFileSha256(String fileName) {
        try (FileInputStream fis = new FileInputStream(Normalizer.normalize(fileName, Normalizer.Form.NFKC));){
            String string = DigestUtils.sha256Hex((InputStream)fis);
            return string;
        }
        catch (Exception e) {
            LOGGER.error("SHA256 parse error", (Throwable)e);
            return "";
        }
    }

    public boolean isFileSha256Valid(String filePath, String inputSha256) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{filePath, inputSha256})) {
            return false;
        }
        return this.getFileSha256(filePath).equals(inputSha256);
    }

    public String getStrSha256(String str) {
        if (StringUtils.isBlank((CharSequence)str)) {
            LOGGER.warn("the input :{} is blank", (Object)str);
            return "";
        }
        return DigestUtils.sha256Hex((String)str);
    }

    public boolean isStrSha256Valid(String inputStr, String inputSha256) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{inputStr, inputSha256})) {
            return false;
        }
        return this.getStrSha256(inputStr).equals(inputSha256);
    }
}

