/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.certbase.ssl;

import com.huawei.ism.tool.certbase.enums.CertFileType;
import com.huawei.ism.tool.certbase.ssl.MySslX509TrustManager;
import com.huawei.ism.tool.certbase.utils.LocalTrustRootCertUtil;
import com.huawei.ism.tool.certbase.utils.RevokedCertUtil;
import java.io.File;
import java.io.FileInputStream;
import java.nio.file.NoSuchFileException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.text.Normalizer;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MutualAuthSslSocketFactoryTool {
    private static final Logger log = LoggerFactory.getLogger(MutualAuthSslSocketFactoryTool.class);
    private static final String SUN_X_509 = "SunX509";

    private MutualAuthSslSocketFactoryTool() {
    }

    public static SSLSocketFactory getSSLSocketFactory(String selfCertPath, char[] selfCertPwd, CertFileType fileType, String trustCertPath, String protocol) throws GeneralSecurityException, NoSuchFileException {
        TrustManager[] trustManagers = MutualAuthSslSocketFactoryTool.initTrustManager(trustCertPath);
        RevokedCertUtil.addCrl(trustCertPath + File.separator + "crl");
        KeyManager[] keyManagers = MutualAuthSslSocketFactoryTool.initKeyManager(selfCertPath, selfCertPwd, fileType);
        SSLContext sslContext = SSLContext.getInstance(protocol);
        sslContext.init(keyManagers, trustManagers, SecureRandom.getInstanceStrong());
        return sslContext.getSocketFactory();
    }

    @Deprecated
    public static SSLSocketFactory getSSLSocketFactory(String selfCertPath, char[] selfCertPwd, String trustCertPath, String protocol) throws GeneralSecurityException, NoSuchFileException {
        TrustManager[] trustManagers = MutualAuthSslSocketFactoryTool.initTrustManager(trustCertPath);
        RevokedCertUtil.addCrl(trustCertPath + File.separator + "crl");
        KeyManager[] keyManagers = MutualAuthSslSocketFactoryTool.initKeyManager(selfCertPath, selfCertPwd, CertFileType.PKCS_12);
        SSLContext sslContext = SSLContext.getInstance(protocol);
        sslContext.init(keyManagers, trustManagers, SecureRandom.getInstanceStrong());
        return sslContext.getSocketFactory();
    }

    private static TrustManager[] initTrustManager(String trustStroreFile) throws NoSuchAlgorithmException, KeyStoreException, CertificateException {
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(SUN_X_509);
        KeyStore trustkeyStore = LocalTrustRootCertUtil.getTrustKeyStore(trustStroreFile);
        if (null == trustkeyStore) {
            throw new CertificateException("no trust manager found");
        }
        trustManagerFactory.init(trustkeyStore);
        TrustManager[] trustManagers = MutualAuthSslSocketFactoryTool.getWrappedTrustManagers(trustManagerFactory.getTrustManagers());
        if (trustManagers.length == 0) {
            throw new NoSuchAlgorithmException("no trust manager found");
        }
        return trustManagers;
    }

    private static TrustManager[] getWrappedTrustManagers(TrustManager[] tms) {
        int len = tms.length;
        TrustManager[] x509TrustManagerWrapper = new MySslX509TrustManager[len];
        for (int i = 0; i < len; ++i) {
            if (!(tms[i] instanceof X509TrustManager)) continue;
            x509TrustManagerWrapper[i] = new MySslX509TrustManager((X509TrustManager)tms[i]);
        }
        return x509TrustManagerWrapper;
    }

    private static KeyManager[] initKeyManager(String certDirPathOrOneCertFilePath, char[] clientPwd, CertFileType fileType) throws NoSuchFileException, NoSuchAlgorithmException, KeyStoreException, UnrecoverableKeyException {
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(SUN_X_509);
        KeyStore keyStore = MutualAuthSslSocketFactoryTool.getSelfCertKeyStore(certDirPathOrOneCertFilePath, clientPwd, fileType);
        keyManagerFactory.init(keyStore, clientPwd);
        return keyManagerFactory.getKeyManagers();
    }

    private static KeyStore getSelfCertKeyStore(String selfCertFilePath, char[] clientPwd, CertFileType fileType) throws NoSuchFileException, KeyStoreException {
        File certFile = new File(Normalizer.normalize(selfCertFilePath, Normalizer.Form.NFKC));
        if (!certFile.exists()) {
            throw new NoSuchFileException("the file path is not exists, please check.");
        }
        KeyStore keyStore = KeyStore.getInstance(fileType.getFileType());
        if (certFile.isFile()) {
            try (FileInputStream clientCertIn = new FileInputStream(certFile);){
                keyStore.load(clientCertIn, clientPwd);
            }
            catch (Exception e) {
                log.error("init keyStore fail.", (Throwable)e);
            }
        }
        return keyStore;
    }
}

