#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2021-2023. All rights reserved.

"""
@version: SmartKit V200R007C00
@time: 2021/05/31
@file: java_adapter.py
@function: 与java类交互的adapter
        将外部影响py脚本直接运行的依赖内放到函数中，便于UT做mock
@modify:
"""


def get_rest_connection_manager_class():
    from com.huawei.ism.tool.protocol.rest import RestConnectionManager
    return RestConnectionManager


def get_ssh_connection_manager_class():
    from com.huawei.ism.tool.obase.connection import SshConnectionManager
    return SshConnectionManager


def get_redfish_connection_manager_class():
    from com.huawei.ism.tool.service.rest.service.device import RedfishConnectionManager
    return RedfishConnectionManager.INS


def get_language():
    from com.huawei.ism.tool.obase.utils import ApplicationContext
    return ApplicationContext.getInstance().getCurrentLanguage().getLanguage()


def get_logger():
    from com.huawei.ism.tool.distributed.fru.service.task import ItemTask
    return ItemTask.getLogger()


def get_java_exception_class():
    from java.lang import Exception
    return Exception


def get_disk_class():
    from com.huawei.ism.tool.distributed.fru.model.module.disk import BaseDisk
    return BaseDisk


def get_media_role_class():
    from com.huawei.ism.tool.distributed.fru.model.module.disk.BaseDisk import MediaRole
    return MediaRole


def get_media_type_class():
    from com.huawei.ism.tool.distributed.fru.model.module.disk.BaseDisk import MediaType
    return MediaType


def get_rest_util_class():
    from com.huawei.ism.tool.protocol.utils import RestUtil
    return RestUtil


def get_sftp_transfer_class():
    from com.huawei.ism.tool.protocol.sftp import SftpTransfer
    return SftpTransfer


def compare_version(version1, version2):
    from utils import Products
    return Products.compareVersion(version1, version2)


def get_dev_info_util_class():
    from com.huawei.ism.tool.service.common import DevInfoUtil
    return DevInfoUtil


def get_product_type():
    from com.huawei.ism.tool.distributed.fru.model.entity import ProductTypeJudgments
    return ProductTypeJudgments


def get_device_util_instance():
    from com.huawei.ism.tool.distributed.fru.util import DeviceUtil
    return DeviceUtil.INS


def get_ar_task_service():
    from com.huawei.ism.tool.distributed.fru.service.fusioncube.board.arcard import ArCardTaskService
    return ArCardTaskService.INS


def get_cascade_task_service():
    from com.huawei.ism.tool.distributed.fru.service.fusioncube.board.cascade import CascadeBoardTaskService
    return CascadeBoardTaskService.INS


def get_cascade_pre_info():
    from com.huawei.ism.tool.distributed.fru.service.fusioncube.board.cascade import CascadeBoardTaskService
    return CascadeBoardTaskService.INS


def get_cascade_replace_info():
    from com.huawei.ism.tool.distributed.fru.service.fusioncube.board.cascade import CascadeBoardTaskService
    return CascadeBoardTaskService.INS


def get_nvme_disk_restart_service():
    from com.huawei.ism.tool.distributed.fru.service.fusioncube.disk import NvmeDiskPowerService
    return NvmeDiskPowerService.INS


def get_base64_encode_util():
    from com.huawei.ism.tool.obase.utils import Base64EncodeUtils
    return Base64EncodeUtils


def get_node_pool_service():
    from com.huawei.ism.tool.service.rest.query import NodePoolService
    return NodePoolService


def get_switch_over_enum():
    from com.huawei.ism.tool.service.rest.model.entity import SwitchoverEnum
    return SwitchoverEnum


def get_task_name_class():
    from com.huawei.ism.tool.service.rest.model.entity import TaskLanguage
    return TaskLanguage


def get_query_task_process():
    from com.huawei.ism.tool.service.rest.query import QueryTaskUtils
    return QueryTaskUtils
