#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2021-2024. All rights reserved.

"""
@version: SmartKit V200R007C00
@time: 2021/06/01 
@file: resource.py 
@function: 
@modify: 
"""

MESSAGES_DICT = {
    "not.queried.pool.status": {
        "zh": u"未查到硬盘所属存储池[{}]状态信息。",
        "en": "The status information about storage pool [{}] to which "
              "the disk belongs is not found."
    },
    "pool.status.refactoring": {
        "zh": u"硬盘所属存储池{}在重构中",
        "en": "Storage pool {} to which the disk belongs "
              "is being reconstructed."
    },
    "main.pool.status.refactoring.retry": {
        "zh": u"请等待存储池重构完成后点击重试",
        "en": "Please click Retry after the reconstruction is complete."
    },
    "pool.status.abnormal": {
        "zh": u"硬盘所属存储池{}状态不满足更换条件。",
        "en": "The status of storage pool {} to which "
              "the disk belongs does not meet the replacement conditions."
    },
    "need.preferentially.replace.cache": {
        "zh": u"存储池内存在故障或亚健康缓存盘，更换主存盘存在风险，请先处理缓存盘。",
        "en": "The storage pool has faulty or subhealthy cache disks, "
              "so main storage disk replacement is risky. "
              "Please handle the cache disks first."
    },
    "disk.status.abnormal": {
        "zh": u"未找到盘或盘状态不正常，请确认硬盘是否已经接入。",
        "en": "The disk is not found or the disk status is abnormal. "
              "Please check whether the disk is connected properly."
    },
    "not.found.replace.disk": {
        "zh": u"未找到更换后的盘，请确认硬盘是否正常接入。",
        "en": "The replacement disk is not found. "
              "Please check whether the disk is connected properly."
    },
    "found.same.replace.disk": {
        "zh": u"根据槽位号找到的更换盘与原盘esn相同。",
        "en": "The ESN of the replacement disk found based on the slot ID "
              "is the same as that of the replaced disk."
    },
    "found.more.than.one.replace.disk": {
        "zh": u"发现多个新增盘esn:{}，无法确认更换盘。",
        "en": "The ESNs ({}) of multiple new disks are found. "
              "The replacement disk cannot be confirmed."
    },
    "disk.not.compatibility": {
        "zh": u"硬盘不兼容。",
        "en": "The disk is incompatible."
    },
    "not.found.replace.disk.mode": {
        "zh": u"未找到更换盘MODE信息。",
        "en": "The MODE information about the replacement disk is not found."
    },
    "query.raid.card.id.failed": {
        "zh": u"查询RAID卡ID失败，请确认节点是否正常或是否安装arcconf工具。",
        "en": "Failed to query the RAID controller card ID. "
              "Please check whether the node is normal or "
              "whether the arcconf tool is installed."
    },
    "query.hiraidadm.raid.card.id.failed": {
        "zh": u"查询RAID卡ID失败，请确认节点是否正常或是否安装hiraidadm工具。",
        "en": "Failed to query the RAID controller card ID. "
              "Please check whether the node is normal or "
              "whether the hiraidadm tool is installed."
    },
    "node.in.upgrade": {
        "zh": u"当前设备存在升级任务，请等待任务完成后再更换部件。",
        "en": "The current device has upgrade tasks. "
              "Replace the device after the task is completed."
    },
    "node.in.failover": {
        "zh": u"当前节点处于故障倒换状态，请恢复节点状态后再更换部件。",
        "en": "The current node is in the failover state. "
              "Please restore the node status before replacing the component."
    },
    "disk.in.takeover": {
        "zh": u"当前硬盘处于被接管状态，请等待节点回切后在原节点更换部件。",
        "en": "The current disk is in the takeover state. "
              "Please replace the disk on the original node when the node switchback."
    },
    "product.version.not.support": {
        "zh": u"{}版本暂不支持工具更换缓存盘，建议参考《备件更换指导书》。",
        "en": "The version {} does not support tool replacement. For details, see the spare parts replacement guide."
    },
    "set.raid.card.mode.failed": {
        "zh": u"设置RAID卡{}模式为5（Mixed）失败。",
        "en": "Failed to set the mode of RAID controller card {} to 5 (Mixed)."
    },
    "restore.zk.error": {
        "zh": u"恢复ZK失败。",
        "en": "Failed to restore ZooKeeper."
    },
    "restore.zk.failed": {
        "zh": u"恢复ZK失败，错误信息为：{}",
        "en": "Failed to restore ZooKeeper. Error message: {}"
    },
    "sector.format.error": {
        "zh": u"参考产品文档的“格式化NVMe SSD“章节进行修复。",
        "en": 'Rectify the fault by referring to section "Formatting an NVMe SSD" in the product documentation.'
    },
    "add.storage.pool.failed": {
        "zh": u"加入存储池{}失败: {}",
        "en": "Failed to be added to storage pool {}. Error message: {}"
    },
    "add.storage.pool.failed.time.out": {
        "zh": u"加入存储池失败，查询超时。",
        "en": "Failed to be added to the storage pool. Query timed out."
    },
    "cache.add.storage.pool.failed": {
        "zh": u"加入存储池失败: {}",
        "en": "Failed to be added to the storage pool. Error message: {}"
    },
    "get.nvme.form.failed": {
        "zh": u"获取nvme形态失败",
        "en": "Failed to obtain the NVMe form."
    },
    "failed.process.node": {
        "zh": u"节点处理失败",
        "en": "Failed to process the node."
    },
    "failed.process_check.node": {
        "zh": u"有部分主存盘未刷盘",
        "en": "Data is not flushed to some main storage disks."
    },
    "failed.restore.node.normal": {
        "zh": u"{} 节点恢复亚健康执行失败: {}",
        "en": "Failed to restore subhealthy node {}. Error message: {}"
    },
    "failed.setting.server.normal": {
        "zh": u"{} 节点恢复正常模式执行失败: {}",
        "en": "Failed to restore node {} to the normal mode. Error message: {}"
    },
    "failed.setting.server.maintenance": {
        "zh": u"{} 节点设置为维护模式执行失败: {}",
        "en": "Failed to enable the maintenance mode for node {}. "
              "Error message {}"
    },
    "out.disk.failed": {
        "zh": u"主存盘：{}踢出存储池失败",
        "en": "Failed to remove main storage disks ({}) from the storage pool."
    },
    "manual.out.main.disk": {
        "zh": u"未被移出存储池的主存盘：{}",
        "en": "Main storage disks that are not removed "
              "from the storage pool: {}",
    },
    "replace.disk.type.not.same": {
        "zh": u"硬盘介质类型不一致，旧盘介质类型:{}，新盘介质类型：{}",
        "en": "The medium types of disks are different. "
              "Medium type of the old disk: {}; "
              "medium type of the new disk: {}."
    },
    "replace.disk.capacity.less": {
        "zh": u"新盘容量小于旧盘容量，旧盘容量:{}，新盘容量：{}",
        "en": "The capacity of the new disk is smaller than "
              "that of the old disk. Old disk capacity: {}; "
              "new disk capacity: {}"
    },
    "sectors.not.equal": {
        "zh": u"新盘与旧盘物理扇区不一致，旧盘扇区:{}，新盘扇区：{}",
        "en": "The physical sector sizes of the new and old disks "
              "are different. Physical sector size of the old disk: {}; "
              "physical sector size of the new disk: {}."
    },
    "logic.sectors.not.equal": {
        "zh": u"新盘与旧盘逻辑扇区不一致，旧盘逻辑扇区:{}，新盘逻辑扇区：{}",
        "en": "The logical sector sizes of the new and old disks "
              "are different. Logical sector size of the old disk: {}; "
              "Logical sector size of the new disk: {}"
    },
    "manufacturer.not.equal": {
        "zh": u"新盘与旧盘厂商不一致，旧盘厂商:{}，新盘厂商：{}",
        "en": "The vendors of the new and old disks are different. "
              "Old disk vendor: {}; new disk vendor: {}"
    },
    "clean.smart.cache.meta.data.failed": {
        "zh": u"存储池{}清除smartcache元数据失败：{}",
        "en": "Failed to clear SmartCache metadata in storage pool {}. "
              "Error message {}"
    },
    "recover.ccdb.failed": {
        "zh": u"恢复ccdb失败",
        "en": "Failed to restore the CCDB."
    },
    "check.pool.used.capacity.failed": {
        "zh": u"检查存储池使用容量失败，存储池{}的已使用容量比例超过了{}",
        "en": "Failed to check the used capacity of the storage pool. "
              "The capacity usage of storage pool ({}) exceeds {}."
    },
    "meta.disk.not.exist.and.has.replication.cluster.not.support": {
        "zh": u"当前元数据盘状态为不在位，且当前节点属于复制集群。"
              u"工具暂不支持此场景，请参考产品备件更换文档进行手动更换。",
        "en": "The current metadata disk is not detected and "
              "the current node belongs to a replication cluster. "
              "Currently, the tool does not support this scenario. "
              "Manually replace the disk by referring "
              "to the corresponding parts replacement guide."
    },
    "meta.disk.modify.jbod.failed": {
        "zh": u"将元数据盘状态修改为JBOD失败:{}",
        "en": "Failed to change the metadata disk status to JBOD. "
              "Error message {}"
    },
    "mdc.id.query.failed": {
        "zh": u"查询mdc id失败",
        "en": "Failed to query the MDC ID."
    },
    "alarm.severity.warning": {
        "zh": u"警告",
        "en": "Warning"
    },
    "alarm.severity.major": {
        "zh": u"重要",
        "en": "Major"
    },
    "alarm.severity.critical": {
        "zh": u"紧急",
        "en": "Critical"
    },
    "alarm.status.unrecovered": {
        "zh": u"未恢复",
        "en": "UnRecovered"
    },
    "alarm.status.cleared": {
        "zh": u"已清除",
        "en": "Cleared"
    },
    "alarm.status.recovered": {
        "zh": u"已恢复",
        "en": "Recovered"
    },
    "alarm.property.unknown": {
        "zh": u"未知",
        "en": "Unknown"
    },
    "alarm.property.status": {
        "zh": u"告警状态",
        "en": "Alarm Status"
    },
    "alarm.property.id": {
        "zh": u"ID",
        "en": "Alarm ID"
    },
    "alarm.property.name": {
        "zh": u"名称",
        "en": "Alarm Name"
    },
    "alarm.property.severity": {
        "zh": u"级别",
        "en": "Severity"
    },
    "alarm.property.sequence": {
        "zh": u"流水号",
        "en": "Sequence"
    },
    "alarm.property.description": {
        "zh": u"描述",
        "en": "Description"
    },
    "alarm.property.suggestion": {
        "zh": u"修复建议",
        "en": "Suggestion"
    },
    "alarm.property.create.time": {
        "zh": u"发生时间",
        "en": "Create Time"
    },
    "clear.old.disk.alarm.user.select.title": {
        "zh": u"以下为旧盘告警，请选择需要工具清除的告警后点击确认。",
        "en": "The following alarms belong to old disks. "
              "Select the alarms that need to be cleared "
              "by the tool and click OK."
    },
    "clear.old.disk.alarm.failed": {
        "zh": u"清除旧盘告警失败：{}",
        "en": "Failed to clear the alarms about old disks. Error message {}"
    },
    "check.pool.status.failed.abnormal.suggestion": {
        "zh": u"请在存储池状态为以下状态之一时再进行更换：{}",
        "en": "Replace the disk only when the storage pool status "
              "is one of the following: {}"
    },
    "check.pool.status.failed.refactoring.suggestion": {
        "zh": u"请等待存储池重构完成后再进行更换。",
        "en": "Please replace the disk after the reconstruction is complete."
    },
    "pool.status.normal.name": {
        "zh": u"正常",
        "en": "Normal"
    },
    "pool.status.degraded.name": {
        "zh": u"降级",
        "en": "Degraded"
    },
    "pool.status.refactoring.name": {
        "zh": u"重构",
        "en": "Refactoring"
    },
    "update.data.pilot.esn.in.db.failed": {
        "zh": u"更新备用硬盘模块的存储表失败。",
        "en": "Failed to update the storage tables of "
              "the replacement disk module."
    },
    "replace.data.pilot.disk.failed": {
        "zh": u"更新备用硬盘模块的文件失败。",
        "en": "Failed to update the files of the replacement disk module."
    },
    "find.system.disk.failed": {
        "zh": u"未查询到系统盘，命令：{}",
        "en": "there is no system disk,cmd:{}"
    },
    "partitioned.disk.count.more.error": {
        "zh": u"存在多个已分区系统盘",
        "en": "Multiple partitioned system disks exist"
    },
    "partitioned.disk.count.less.error": {
        "zh": u"不存在已分区系统盘",
        "en": "No partitioned system disk exists"
    },
    "partitioned.disk.detail.error": {
        "zh": u"已分区盘数据查询异常",
        "en": "Failed to query partitioned disk data"
    },
    "partitioned.new.disk.error": {
        "zh": u"为新盘创建分区表失败",
        "en": "Failed to create the partition table for the new disk"
    },
    "partitioned.new.disk.detail.error": {
        "zh": u"为新盘划分分区失败",
        "en": "Failed to partition the new disk"
    },
    "sync.not.complete": {
        "zh": u"RAID数据同步尚未完成，预计0.5-4h重构完成。",
        "en": "RAID data synchronization is not complete,"
              "It will be complete in 0.5 to 4 hours."
    },
    "add.raid.failed": {
        "zh": u"将盘加入RAID失败",
        "en": "Failed to add the disk to the RAID"
    },
    "replace.sys.disk.less.two.failed": {
        "zh": u"当前节点系统盘少于2个，请参考对应产品版本的产品文档中的“更换系统硬盘模块“章节手动更换。",
        "en": "The number of system disks on the current node is less than 2."
              " For details, see Replacing a System Disk Module in the product documentation of "
              "the corresponding product version."
    },
    "replace.sys.disk.not.support.two.fault": {
        "zh": u"工具暂不支持双盘故障更换， 请参考对应产品版本的产品文档中的“更换系统硬盘模块（双盘故障）“章节手动更换。",
        "en": "Currently, the tool does not support the replacement of "
              "dual-disk faults. For details, see Replacing a System Disk "
              "Module (Dual-Disk Fault) in the product documentation of "
              "the corresponding product version."
    },
    "start.service.failed": {
        "zh": u"取消故障节点隔离失败。",
        "en": "Failed to cancel the isolation of the faulty node."
    },
    "stop.service.failed": {
        "zh": u"隔离故障节点失败。",
        "en": "Failed to isolate the faulty node."
    },
    "start.service.timeout": {
        "zh": u"取消故障节点隔离超时。",
        "en": "Canceling the isolation of the faulty node times out."
    },
    "stop.service.timeout": {
        "zh": u"隔离故障节点超时。",
        "en": "Isolating the faulty node times out."
    },
    "power.off.device.failed": {
        "zh": u"设备下电失败。",
        "en": "The device fails to be powered off."
    },
    "check.raid.status.no.type.suggestion": {
        "zh": u"未检测到系统盘RAID。",
        "en": "The system disk RAID is not detected."
    },
    "check.raid.status.rebuild.suggestion": {
        "zh": u"当前RAID卡重构尚未完成，预计0.5-4h重构完成。",
        "en": "The RAID controller card reconstruction is not complete,"
              "It will be complete in 0.5 to 4 hours."
    },
    "check.raid.status.not.in.progress": {
        "zh": u"系统盘RAID未重构。",
        "en": "The system disk RAID is not reconstructed."
    },
    "check.raid.not.supported.type.suggestion": {
        "zh": u"系统盘RAID型号不支持。",
        "en": "The system disk RAID model is not supported."
    },
    "check.not.raid1.suggestion": {
        "zh": u"未检测到RAID1，此种情况下系统不支持更换系统盘。",
        "en": "RAID 1 is not detected. In this case, the system does not support system disk replacement."
    },
    "check.raid.more.than.one.suggestion": {
        "zh": u"RAID控制器数量超过一个。",
        "en": "More than one RAID controller."
    },
    "query.raid.controller.failed": {
        "zh": u"查询RAID控制器ID失败。",
        "en": "Failed to query the RAID controller ID."
    },
    "query.raid.disk.group.failed": {
        "zh": u"查询RAID磁盘组失败。",
        "en": "Failed to query the RAID disk group."
    },
    "pilot.disk.suggestion": {
        "zh": u"当前硬盘故障，请更换新盘后点击全部重试。",
        "en": "The disk is faulty. Replace the disk and click Retry All."
    },
    "need.power.off.pilot.disk.suggestion": {
        "zh": u"当前硬盘故障，请下电对应硬盘后，更换新盘，点击全部重试。",
        "en": "The disk is faulty. Replace the disk and click Retry All after power off the corresponding disk."
    },
    "check.raid.card.status.suggestion": {
        "zh": u"方案1：等待重构完成后再点击“重试”按钮，继续工具更换流程。"
              u"\n方案2：点击“忽略“按钮以跳过此检查项，继续工具更换流程，重构过程中请勿对当前节点进行换盘操作。"
              u"\n2.1 工具流程结束后可以手动执行命令检查当前节点的RAID卡的重构状态，具体过程请参考对应产品文档《部件更换》章节。"
              u"\n2.2 重构过程中工具界面展示的盘状态为重构中，也可以以此判断是否重构完成。"
              u"\n-----------------------------"
              u"\n工具检查方法参考："
              u"\n使用root账户登陆当前节点执行命令：{}"
              u"\n检查标准：{}",
        "en": "Solution 1: Click 'Retry' after the reconstruction is complete "
              "to continue the replacement process."
              "\nSolution 2: Click 'Ignore' to skip this check item and continue the replacement process.Do not replace disks on the node during reconstruction."
              "\n2.1 After the replacement process is complete, "
              "you can manually run a command to check the reconstruction status of the RAID controller card on the node. "
              "For details, see 'Parts Replacement' in the corresponding product documentation."
              "\n2.2 During the reconstruction, "
              "the disk status displayed on the tool page is Rebuilding. "
              "You can also determine whether the reconstruction is "
              "complete based on the status."
              "\n-----------------------------"
              "\nCommand used to check the reconstruction status:"
              "\nLog in to the faulty node as user root and execute command: {}"
              "\nInspection Criteria: {}"
    },
    "check.raid.sync.complete.suggestion": {
        "zh": u"方案1：等待RAID数据同步完成后再点击“重试”按钮，继续工具更换流程。"
              u"\n方案2：点击“忽略“按钮以跳过此检查项，继续工具更换流程，数据同步过程中请勿对当前节点进行换盘操作。"
              u"\n2.1 工具流程结束后可以手动执行命令检查当前节点的RAID数据同步状态，具体过程请参考对应产品文档《部件更换》章节。"
              u"\n2.2 同步完成后更换过程中产生的告警会自动恢复，也可以以此判断是否同步完成。"
              u"\n-----------------------------"
              u"\n工具检查方法参考："
              u"\n使用root账户登陆当前节点执行命令：{}"
              u"\n检查标准：{}",
        "en": "Solution 1: Click 'Retry' after the data synchronization is complete to continue the replacement process."
              "\nSolution 2: Click 'Ignore' to skip this check item and continue the replacement process.Do not replace disks on the node during data synchronization."
              "\n2.1 After the replacement process is complete, "
              "you can manually run a command to check the RAID data "
              "synchronization status on the node. For details, see "
              "'Parts Replacement' in the corresponding product documentation."
              "\n2.2 After the synchronization is complete, "
              "the alarms generated during the replacement "
              "are automatically cleared. You can also determine whether "
              "the synchronization is complete based on the alarms."
              "\n-----------------------------"
              "\nCommand used to check the reconstruction status:"
              "\nLog in to the faulty node as user root and execute command: {}"
              "\nInspection Criteria: {}"
    },
    "wait.raid.card.reconstruction.complete": {
        "zh": u"等待重构完成后再点击“重试”按钮，继续工具更换流程。"
              u"\n-----------------------------"
              u"\n检查重构完成方法参考："
              u"\n使用root账户登陆当前节点执行命令：{}"
              u"\n检查标准：{}",
        "en": "Click 'Retry' after the reconstruction is complete"
              "\n-----------------------------"
              "\nCommand used to check the reconstruction status:"
              "\nLog in to the faulty node as user root and execute command: {}"
              "\nInspection Criteria: {}"
    },
    "wait.raid.sync.complete": {
        "zh": u"等待RAID数据同步完成后再点击“重试”按钮，继续工具更换流程。"
              u"\n-----------------------------"
              u"\n检查同步完成方法参考："
              u"\n使用root账户登陆当前节点执行命令：{}"
              u"\n检查标准：{}",
        "en": "Click 'Retry' after the data synchronization is complete to continue the replacement process."
              "\n-----------------------------"
              "\nCommand used to check the reconstruction status:"
              "\nLog in to the faulty node as user root and execute command: {}"
              "\nInspection Criteria: {}"
    },
    "check.pilot.sync.complete.suggestion": {
        "zh": u"方案1. 等待磁盘数据恢复完成后再点击“重试”按钮，继续工具更换流程。"
              u"\n方案2. 点击“忽略”按钮以跳过此检查项，继续工具更换流程。"
              u"\n数据恢复过程中，元数据检索服务功能性能降低，可能会导致DeviceManager上元数据检索功能超时。"
              u"\n-----------------------------"
              u"\n工具检查方法参考："
              u"\n使用root账户登陆当前节点执行命令："
              u"\nsh /opt/dfv/obs_service_layer/objectwebservice/elasticsearch"
              u"/script/elasticsearch_tool.sh health"
              u"\n检查标准：查询结果中status状态为'green'表示同步完成，为'yellow'时表示磁盘数据恢复正在进行。",
        "en": "Solution 1: Click 'Retry' after the data is restored to "
              "continue the replacement process."
              "\nSolution 2: Click 'Ignore' to skip this check item "
              "and continue the replacement process."
              "\nThe performance of the SmartIndexing service deteriorates "
              "during data restoration. The metadata indexing function "
              "on DeviceManager may time out."
              "\n-----------------------------"
              "\nCommand used to check the reconstruction status:"
              "\nLog in to the faulty node as user root and execute command: "
              "\nsh /opt/dfv/obs_service_layer/objectwebservice/elasticsearch"
              "/script/elasticsearch_tool.sh health"
              "\nInspection Criteria: If status is green in the command "
              "output, the synchronization is complete. If status is yellow, "
              "the disk data is being restored."
    },
    "check.pilot.sync.complete.failed.cause": {
        "zh": u"数据导航盘磁盘数据恢复正在进行，预计0.5-4h恢复完成",
        "en": "the disk data is being restored, It will be complete in 0.5 to 4 hours."
    },
    "check.3508.card.rebuilding.suggestion": {
        "zh": u"\n当查询的表格信息中Status为In progress时，表示系统盘RAID正在重构。",
        "en": "\nIf Status is In progress, the RAID of the system disk is being reconstructed."
    },
    "check.3152.card.rebuilding.suggestion": {
        "zh": u"\n当查询信息中\"Status of Logical Device\"状态为\"Rebuilding\"时，表明系统盘RAID正在重构。"
              u"\n当查询信息中\"Status of Logical Device\"状态为\"Optimal\"时，表示系统盘RAID重构完成。",
        "en": "\nIf Status of Logical Device is Rebuilding, the system disk RAID is being reconstructed."
              "\nIf Status of Logical Device is Optimized in the command output, "
              "the RAID reconstruction of the system disk is complete."
    },
    "check.1880.card.rebuilding.suggestion": {
        "zh": u"\n当Status显示degrade，Current Background Task显示Rebuild时，RAID组正在重构。"
              u"\n当Status显示normal，Current Background Task显示 NA时，RAID组重构完成。",
        "en": "\nIf Status is degrade and Current Background Task is Rebuild, "
              "the RAID group is being reconstructed."
              "\nIf Status is normal and Current Background Task is NA, "
              "the RAID group reconstruction is complete."
    },
    "check.raid.status.not.in.progress.suggestion": {
        "zh": u"联系技术支持工程师协助处理。",
        "en": "Contact technical support engineers for assistance."
    },
    'raid.sync.complete.judgements': {
        'zh': u"当所有命令执行结果中，\"State\"为\"active sync\"，才表示raid数据同步完成。",
        'en': "RAID data synchronization is complete only when \'State\' is \'active sync\' in the every command output."
    },
    'raid.3152.sync.complete.judgements': {
        'zh': u"当所有命令执行结果中，列表中\"Status of Logical Device\"为\"Optimal\"，才表示raid数据同步完成。",
        'en': "RAID data synchronization is complete only "
              "when \'Status of Logical Device\' is \'Optimal\' in the every command output."
    },
    'raid.3508.sync.complete.judgements': {
        'zh': u"当所有命令执行结果中，列表中\"Status\"为\"Not in progress\"，才表示raid数据同步完成。",
        'en': "RAID data synchronization is complete only "
              "when \'Status\' is \'Not in progress\' in the every command output."
    },
    "raid.1880.sync.complete.judgements": {
        'zh': u"当命令执行结果中，Status显示为normal, Current Background "
              u"Task显示NA时，才表示raid数据同步完成。",
        "en": "RAID data synchronization is complete only "
              "when \'Status\' is \'normal\' and 'Current Background Task' is 'NA' in the every command output."
    },
    "device.not.power.on": {
        "zh": u"当前设备尚未上电完成。",
        "en": "The current device has not been powered on. "
    },
    "device.not.power.on.suggestion": {
        "zh": u"请等待上电完成后点击重试。",
        "en": "Wait until the device is powered on and click Retry."
    },
    'raid.synchronizing': {
        'zh': u"请等待RAID数据同步完成后点击重试。"
              u"\n-----------------------------"
              u"\n工具检查方法参考："
              u"\n使用root账户登陆当前节点执行命令：{}"
              u"\n检查标准：{}",
        'en': "Wait until the RAID data synchronization is complete and click Retry"
              "\n-----------------------------"
              "\nCommand used to check the reconstruction status:"
              "\nLog in to the faulty node as user root and execute command: {}"
              "\nInspection Criteria: {}"
    },
    "node.status.abnormal": {
        "zh": u"当前节点系统尚未启动完成。",
        "en": "The system on the current node has not been started."
    },
    "node.status.abnormal.suggestion": {
        "zh": u"请等待启动完成后点击重试。",
        "en": "Wait until the startup is complete and click Retry."
    },
    "node.management.agent.not.started": {
        "zh": u"关键进程尚未启动。",
        "en": "The critical process has not been started."
    },
    "node.management.agent.not.started.suggestion": {
        "zh": u"请等待启动完成后点击重试。",
        "en": "Wait until the startup is complete and click Retry."
    },
    "cant.find.arcconf.tool.path.and.query.sys.failed": {
        "zh": u"查询系统盘失败，存储需要安装ARCCONF工具，ARCCONF工具请参见《版本配套表》中对应RAID卡型号的下载链接。",
        "en": "Failed to query the system disk. You need to install the "
              "ARCCONF tool. For details about how to download the ARCCONF "
              "tool, see the download link of the corresponding RAID "
              "controller card model in the Version Mapping."
    },
    "cant.find.arcconf.tool.path.in.default.path.and.query.sys.failed": {
        "zh": u"查询系统盘失败，存储需要在路径/usr/Arcconf下安装ARCCONF工具，ARCCONF工具请参见《版本配套表》中对应RAID卡型号的下载链接。",
        "en": "Failed to query the system disk. You need to install the "
              "ARCCONF tool in /usr/Arcconf. For details about how to download the ARCCONF "
              "tool, see the download link of the corresponding RAID "
              "controller card model in the Version Mapping."
    },
    "cant.find.hiraidadm.tool.path.and.query.sys.failed": {
        "zh": u"查询系统盘失败，存储需要安装hiraidadm工具，hiraidadm工具请参见《版本配套表》中对应RAID卡型号的下载链接。",
        "en": "Failed to query the system disk. You need to install the "
              "hiraidadm tool. For details about how to download the hiraidadm "
              "tool, see the download link of the corresponding RAID "
              "controller card model in the Version Mapping."
    },
    "cant.find.hiraidadm.tool.path.in.default.path.and.query.sys.failed": {
        "zh": u"查询系统盘失败，存储需要在/usr/bin/hiraidadm路径安装hiraidadm工具，hiraidadm工具请参见《版本配套表》中对应RAID卡型号的下载链接。",
        "en": "Failed to query the system disk. You need to install the "
              "hiraidadm tool in /usr/bin/hiraidadm. For details about how to download the hiraidadm "
              "tool, see the download link of the corresponding RAID "
              "controller card model in the Version Mapping."
    },
    "check_compatibility_user_confirm_failed": {
        "zh": u"检查兼容性手动确认失败, 请重试",
        "en": "Failed to manually confirm the compatibility check. Please try again."
    },
    "check_compatibility_user_confirm_title": {
        "zh": u"待人工确认硬盘模块兼容性",
        "en": "Hard disk module compatibility is to be confirmed manually."
    },
    "check_compatibility_user_confirm_message": {
        "zh": u"因未进行BMC鉴权，当前检查项需要人工确认，请参考以下指导进行检查：",
        "en": "The BMC authentication is not performed. Therefore, "
              "you need to manually confirm the current check items. "
              "For details, see the following instruction:"
    },
    "set.disk.down.error": {
        "zh": u"主存盘：{}置DOWN失败",
        "en": "Failed to set main storage disk {} to Down."
    },
    "set.disk.down.error.suggestion": {
        "zh": u"执行命令：{}查看失败原因，解决后重试流程",
        "en": "Run the {} command to view the failure cause. Rectify the fault and retry the process."
    },
    "clear.disk.down.error": {
        "zh": u"且清除DOWN状态失败",
        "en": "and failed to be cleared from the DOWN state."
    },
    "out.disk.error": {
        "zh": u"主存盘：{}踢出存储池失败",
        "en": "Main storage disk {} failed to be removed from the storage pool."
    },
    "out.disk.high.usage.error": {
        "zh": u"主存盘：{}因容量占用过高导致踢出存储池失败",
        "en": "Main storage disk {} fails to be kicked out of the storage pool because of its high capacity usage."
    },
    "query.sys.disk.because.storcli.version": {
        "zh": u"查询系统盘失败，请参考对应产品《版本配套表》下载安装最新的Storcli工具。",
        "en": "Failed to query the system disk. Download and install the "
              "latest Storcli tool by referring to the Version Mapping "
              "of the corresponding product."
    },
    "cant.find.storcli.tool.path.in.default.path.and.query.sys.failed": {
        "zh": u"查询系统盘失败，请参考对应产品《版本配套表》在/opt/MegaRAID/storcli路径下载安装最新的Storcli工具。",
        "en": "Failed to query the system disk. Download and install the "
              "latest Storcli tool in /opt/MegaRAID/storcli by referring to the Version Mapping "
              "of the corresponding product."
    },
    "ensure.zk.recover.failed": {
        "zh": u"zk进程未启动。",
        "en": "The ZooKeeper process is not started."
    },
    "node.failback.startup.failed": {
        "zh": u"启动回切节点任务失败。",
        "en": "Failed to start the node switchback task."
    },
    "node.failback.status.failed": {
        "zh": u"回切任务失败！",
        "en": "Failed to switch back the node."
    },
    "node.switchover.startup.failed": {
        "zh": u"启动倒换节点任务失败。",
        "en": "Failed to start the node switchover task."
    },
    "node.switchover.status.failed": {
        "zh": u"倒换任务失败！",
        "en": "Failed to switch over the node."
    },
    "node.switch.active.failed": {
        "zh": u"切换主备节点失败！",
        "en": "Failed to switch the active/standby node."
    },
    "cache.disk.set.readonly.failed": {
        "zh": u"设置缓存盘只读状态失败！",
        "en": "Failed to set cache disk readonly status."
    },
    "cache.disk.set.writable.failed": {
        "zh": u"取消缓存盘只读状态失败！",
        "en": "Failed to set cache disk writable status."
    },
    "close.sys.disk.io.check.switch.failed": {
        "zh": u"关闭系统盘IO检测开关失败！",
        "en": "Failed to disable the system disk I/O detection function."
    },
    "open.sys.disk.io.check.switch.failed": {
        "zh": u"开启系统盘IO检测开关失败！",
        "en": "Failed to enable the system disk I/O detection function."
    },
    "set.fan.speed.failed": {
        "zh": u"设置风扇转速失败。",
        "en": "Failed to set fan speed."
    },
    "decrease.temp.failed": {
        "zh": u"部件超温，且短时间无法降温，不支持备件更换。",
        "en": "Component overheating and cannot cool down within a short period of time. \
        Therefore, spare parts cannot be replaced."
    },
    "check.temp.failed": {
        "zh": u"查询部件温度失败。",
        "en": "Check component temperature failed."
    }
}
