#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2021-2021. All rights reserved.

"""
@version: SmartKit V200R007C00
@time: 2021/07/01
@file: auto_re.py
@function:
@modify:
"""
import threading
import time


class AutoBrushProgressTask(threading.Thread):

    def __init__(self, task, total_time, interval_time):
        super(AutoBrushProgressTask, self).__init__()
        if interval_time <= 0:
            raise ValueError
        self.interval_time = interval_time
        self.task = task
        self.total_time = total_time

    def run(self):
        progress = 0
        interval_add_progress = 100 / int(self.total_time / self.interval_time)
        while not self.task.isFinished() and progress < 95:
            self.task.updateProgress(progress)
            time.sleep(self.interval_time)
            progress += interval_add_progress


def auto_brush_progress(total_time, interval_time=5):
    """
    自动刷新进度装饰器，必须装饰于首位参数为context的函数，
    通常就是item的execute函数
    :param total_time: 总计时间 单位s
    :param interval_time: 间隔时间 单位s
    """
    def do_func(func):
        def wrapper(context, *params):
            AutoBrushProgressTask(
                context.getCurrentTask(),
                total_time,
                interval_time).start()
            return func(context, *params)
        return wrapper
    return do_func
