#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2021-2021. All rights reserved.

"""
@version: SmartKit V200R007C00
@time: 2021/06/07
@file: redfish_connection_service.py
@function:
@modify:
"""
import json

from py.common.adapter import java_adapter
from py.common.service.connection import connection_service


class RedfishService(connection_service.AbstractConnectionService):

    def _get_connection(self):
        manager = java_adapter.get_redfish_connection_manager_class()
        return manager.getRedFishConnection(self._dev_node)

    def _release_connection(self):
        java_adapter.get_redfish_connection_manager_class().releaseConn(
            self._dev_node)

    def _is_success_response(self, response):
        return response.isSuccess()

    def _get_execute_result(self, response):
        return json.loads(response.getResult())

    def exec_get(self, uri, retry_times=2, abnormal_judge_func=None):
        return self._execute(
            retry_times,
            abnormal_judge_func,
            self._get_connection().executeGet,
            uri
        )

    def exec_patch(self, uri, params, retry_times=0, abnormal_judge_func=None):
        return self._execute(
            retry_times,
            abnormal_judge_func,
            self._get_connection().executePatch,
            uri, json.dumps(params), None
        )

    def exec_post(self, uri, params, retry_times=0, abnormal_judge_func=None):
        return self._execute(
            retry_times,
            abnormal_judge_func,
            self._get_connection().executePost,
            uri, json.dumps(params)
        )

    def exec_delete(self, uri, retry_times=0, abnormal_judge_func=None):
        return self._execute(
            retry_times,
            abnormal_judge_func,
            self._get_connection().executeDelete,
            uri
        )
