#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2021-2021. All rights reserved.

"""
@version: SmartKit V200R007C00
@time: 2021/07/22
@file: sftp_connection.py
@function: SFTP连接, 依赖com.huawei.ism.tool.protocol.sftp.SftpTransfer
@modify:
"""
from py.common.adapter import java_adapter
from py.common.service import logger_factory


class SftpConnection(object):
    def __init__(self, dev_node, _is_pwd_will_expire_break):
        self._dev_node = dev_node
        self._is_pwd_will_expire_break = _is_pwd_will_expire_break
        self._logger = logger_factory.create_logger(__file__)
        self._conn = self._get_sftp_connection()

    def upload(self, ip, user, target_dir_path, local_file_path):
        """
        将本地文件上传到设备指定目录
        :param ip: sftpIp
        :param user: 登录信息
        :param target_dir_path: 目标目录路径 eg. /op/test
        :param local_file_path: 本地文件路径 eg. E:\test\file.txt
        :return:
        """
        try:
            self._conn.uploadFile(
                ip, user, target_dir_path, local_file_path)
        except (Exception, java_adapter.get_java_exception_class()):
            raise Exception('upload file failed.')

    def close_conn(self):
        self._conn.closeSshConnection()

    def _get_sftp_connection(self):
        return java_adapter.get_sftp_transfer_class()(
            self._dev_node, self._is_pwd_will_expire_break)
