#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2024. All rights reserved.

from py.common.service.connection.ssh_connection_service import NoNeedReturnCmd, NoLogCmd, CustomEndingJudgeCmd
from py.common.adapter import java_adapter


def get_cmd_by_ssh_type(cmd_root, cmd_mini, is_mini_system):
    if is_mini_system:
        return cmd_mini
    return cmd_root


def get_show_disk_infos_cmd(is_mini_system):
    cmd_root = "show_disk.sh"
    cmd_mini = "show_disk"
    return get_cmd_by_ssh_type(cmd_root, cmd_mini, is_mini_system)


def get_show_disk_infos_cat_cmd(is_mini_system):
    cmd_root = "show_disk.sh |cat"
    cmd_mini = "show_disk"
    return get_cmd_by_ssh_type(cmd_root, cmd_mini, is_mini_system)


def get_osd_process_online_cmd(is_mini_system):
    cmd_root = "ps -ef|grep -v 'grep'|grep ./dsware_os|cat"
    cmd_mini = "ps -ef|grep -v 'grep'|grep ./dsware_os"
    return get_cmd_by_ssh_type(cmd_root, cmd_mini, is_mini_system)


def get_metadata_disk_eid_and_status_cmd(is_mini_system):
    cmd_root = "/opt/MegaRAID/storcli/storcli64 /c0 show"
    cmd_mini = "storcli64 /c0 show"
    return get_cmd_by_ssh_type(cmd_root, cmd_mini, is_mini_system)


def get_metadata_clean_status_cmd(is_mini_system):
    cmd_root = "/opt/MegaRAID/storcli/storcli64 /c0/fall del"
    cmd_mini = "storcli64 /c0/fall del"
    return get_cmd_by_ssh_type(cmd_root, cmd_mini, is_mini_system)


def get_metadata_modify_status_cmd(is_mini_system, eid, slot):
    cmd_root = "/opt/MegaRAID/storcli/storcli64 /c0/e{}/s{} set jbod".format(eid, slot)
    cmd_mini = "storcli64 /c0/e{}/s{} set jbod".format(eid, slot)
    return get_cmd_by_ssh_type(cmd_root, cmd_mini, is_mini_system)


def get_replace_zk_disk_cmd(is_mini_system, sandbox_open, os_node):
    password = get_root_user_pass(os_node)
    cmd_root = "sh /opt/dsware/client/bin/dswareTool.sh --op restoreControlNode -ip {} -zkDiskEsn {} -replaceZkDisk {}"
    cmd_mini = "dswareTool.sh --op restoreControlNode -ip {} -zkDiskEsn {} -replaceZkDisk {}"
    if not is_mini_system and sandbox_open:
        return [
            NoNeedReturnCmd("minisystem"),
            NoLogCmd(password),
            cmd_mini
        ]
    return [get_cmd_by_ssh_type(cmd_root, cmd_mini, is_mini_system)]


def get_ensure_zk_recover_cmd(is_mini_system):
    cmd_root = "cat /opt/fusionstorage/agent/conf/agentMonitor | grep zk_para"
    cmd_mini = "comm_tool  zkPara"
    return get_cmd_by_ssh_type(cmd_root, cmd_mini, is_mini_system)


def get_query_main_disk_slots_cmd(is_mini_system, sandbox_open, os_node, pool_id):
    password = get_root_user_pass(os_node)
    cmd_root = "sh /opt/dsware/client/bin/dswareTool.sh --op queryStorageNodeInfo -id {}".format(pool_id)
    cmd_mini = "dswareTool.sh --op queryStorageNodeInfo -id {}".format(pool_id)
    if not is_mini_system and sandbox_open:
        return [
            NoNeedReturnCmd("minisystem"),
            NoLogCmd(password),
            NoNeedReturnCmd(cmd_mini)
        ]
    return [NoNeedReturnCmd(get_cmd_by_ssh_type(cmd_root, cmd_mini, is_mini_system))]


def get_control_meta_drive_letter_cmd(is_mini_system):
    cmd_root = "cat /opt/dsware/infrastructure/ccdb/ccdb_server/config/ccdb_server.cfg " \
               "| grep \"ccdb_volume=\" |awk -F \"=\" {'print $2'}"
    cmd_mini = "ccdb.sh -c getRealDiskName -t eds"
    return get_cmd_by_ssh_type(cmd_root, cmd_mini, is_mini_system)


def get_replication_meta_drive_letter_cmd(is_mini_system):
    cmd_root = "cat /opt/dsware/service/dr/ccdb_server/config/ccdb_server.cfg " \
               "| grep \"ccdb_volume=\" |awk -F \"=\" {'print $2'}"
    cmd_mini = "ccdb.sh -c getRealDiskName -t dr"
    return get_cmd_by_ssh_type(cmd_root, cmd_mini, is_mini_system)


def get_raid_card_controller_mode_cmd(is_mini_system, raid_card_id):
    cmd_root = 'arcconf getconfig {} ad |grep -i "controller mode" |cat'.format(raid_card_id)
    cmd_mini = 'arcconf getconfig {} ad |grep -i "controller mode"'.format(raid_card_id)
    return get_cmd_by_ssh_type(cmd_root, cmd_mini, is_mini_system)


def get_raid_card_adaptec_cmd(is_mini_system):
    cmd_root = "lspci -m |grep -i Adaptec |cat"
    cmd_mini = "lspci -m |grep -i Adaptec"
    return get_cmd_by_ssh_type(cmd_root, cmd_mini, is_mini_system)


def get_raid_card_lsi_cmd(is_mini_system):
    cmd_root = "lspci | grep -i LSI |cat"
    cmd_mini = "lspci | grep -i LSI"
    return get_cmd_by_ssh_type(cmd_root, cmd_mini, is_mini_system)


def get_raid_card_version_cmd(is_mini_system):
    cmd_root = "lspci | grep -i RAID|cat"
    cmd_mini = "lspci | grep -i RAID"
    return get_cmd_by_ssh_type(cmd_root, cmd_mini, is_mini_system)


def get_has_soft_raid_cmd(is_mini_system):
    cmd_root = CustomEndingJudgeCmd("cat /proc/mdstat", [':/>', ':/', ']', '#', '$', '~>', ':~ #'])
    cmd_mini = CustomEndingJudgeCmd("comm_tool mdstat", ["minisystem>"])
    return get_cmd_by_ssh_type(cmd_root, cmd_mini, is_mini_system)


def get_control_replace_disk_cmd(is_mini_system, sandbox_open, os_node):
    password = get_root_user_pass(os_node)
    cmd_root = 'sh /opt/dsware/client/bin/dswareTool.sh --op ReplaceMediaDisk ' \
               '-controlClusterId {} -processType ccdb_server -processId {} -nodeIps {}'
    cmd_mini = 'dswareTool.sh --op ReplaceMediaDisk ' \
               '-controlClusterId {} -processType ccdb_server -processId {} -nodeIps {}'
    if not is_mini_system and sandbox_open:
        return [
            NoNeedReturnCmd("minisystem"),
            NoLogCmd(password),
            cmd_mini
        ]
    return [get_cmd_by_ssh_type(cmd_root, cmd_mini, is_mini_system)]


def get_replication_replace_disk_cmd(is_mini_system, sandbox_open, os_node):
    password = get_root_user_pass(os_node)
    cmd_root = 'sh /opt/dsware/client/bin/dswareTool.sh --op drCmd -subOp ReplaceMediaDisk ' \
               '-controlClusterId {} -processId {} -processType ccdb_server -nodeIps {}'
    cmd_mini = 'dswareTool.sh --op drCmd -subOp ReplaceMediaDisk ' \
               '-controlClusterId {} -processId {} -processType ccdb_server -nodeIps {}'
    if not is_mini_system and sandbox_open:
        return [
            NoNeedReturnCmd("minisystem"),
            NoLogCmd(password),
            cmd_mini
        ]
    return [get_cmd_by_ssh_type(cmd_root, cmd_mini, is_mini_system)]


def get_control_cluster_id_cmd(is_mini_system):
    cmd_root = "cat /opt/dsware/infrastructure/ccdb/ccdb_server/config/ccdb_server.cfg " \
               "| grep dr_cluster_id |awk -F \"=\" {'print $2'}"
    cmd_mini = "ccdb.sh -c getClusterId -t eds"
    return get_cmd_by_ssh_type(cmd_root, cmd_mini, is_mini_system)


def get_replication_cluster_id_cmd(is_mini_system):
    cmd_root = "cat /opt/dsware/service/dr/ccdb_server/config/ccdb_server.cfg " \
               "| grep dr_cluster_id |awk -F \"=\" {'print $2'}"
    cmd_mini = "ccdb.sh -c getClusterId -t dr"
    return get_cmd_by_ssh_type(cmd_root, cmd_mini, is_mini_system)


def get_control_process_id_cmd(is_mini_system):
    cmd_root = "cat /opt/dsware/infrastructure/ccdb/ccdb_server/config/ccdb_server.cfg " \
               "| grep local_ip |awk -F \"=|:\" {'print $2'}"
    cmd_mini = "ccdb.sh -c getLsid -t eds"
    return get_cmd_by_ssh_type(cmd_root, cmd_mini, is_mini_system)


def get_replication_process_id_cmd(is_mini_system):
    cmd_root = "cat /opt/dsware/service/dr/ccdb_server/config/ccdb_server.cfg " \
               "| grep local_ip |awk -F \"=|:\" {'print $2'}"
    cmd_mini = "ccdb.sh -c getLsid -t dr"
    return get_cmd_by_ssh_type(cmd_root, cmd_mini, is_mini_system)


def get_datapilot_replace_disk_cmd(is_mini_system, old_disk_esn, new_disk_esn):
    cmd_root = "sh /opt/dfv/obs_service_layer/object_safe/elasticsearch/safe/datapilot_replace_disk.sh {} {}"\
        .format(old_disk_esn, new_disk_esn)
    cmd_mini = "datapilot_replace_disk {} {}".format(old_disk_esn, new_disk_esn)
    return get_cmd_by_ssh_type(cmd_root, cmd_mini, is_mini_system)


def get_datapilot_update_esn_cmd(is_mini_system, mgr_ip, old_disk_esn, new_disk_esn):
    cmd_root = "sh /opt/dsware/manager/script/datapilot_update_esn.sh update_esn_in_db {} {} {}"\
        .format(mgr_ip, old_disk_esn, new_disk_esn)
    cmd_mini = "datapilot_update_esn update_esn_in_db {} {} {}".format(mgr_ip, old_disk_esn, new_disk_esn)
    return get_cmd_by_ssh_type(cmd_root, cmd_mini, is_mini_system)


def get_node_management_process_cmd(is_mini_system):
    cmd_root = "ps -ef|grep /opt/dfv/oam/oam-u/nma/bin/nmagent.bin|grep -v grep |wc -l"
    cmd_mini = "oam_tool_process nma status"
    return get_cmd_by_ssh_type(cmd_root, cmd_mini, is_mini_system)


def get_proprietary_hardware_system_disk_cmd(is_mini_system):
    cmd_root = [
        'ls /sys/devices/pci0000\:74/0000\:74\:03.0/ata1/host*/target*/*/block/',
        'ls /sys/devices/pci0000\:74/0000\:74\:03.0/ata2/host*/target*/*/block/'
    ]
    cmd_mini = [
        'query_system_disk specific_slot_m0',
        'query_system_disk specific_slot_m1'
    ]
    return get_cmd_by_ssh_type(cmd_root, cmd_mini, is_mini_system)


def get_a310_system_disk_cmd(is_mini_system):
    cmd_root = [
        'ls /sys/devices/pci0000\:38/0000\:38\:05.0/ata1/host*/target*/*/block/',
        'ls /sys/devices/pci0000\:38/0000\:38\:05.0/ata2/host*/target*/*/block/'
    ]
    cmd_mini = [
        'query_system_disk a310_slot_m0',
        'query_system_disk a310_slot_m1'
    ]
    return get_cmd_by_ssh_type(cmd_root, cmd_mini, is_mini_system)


def get_common_kunpeng_system_disk_cmd(is_mini_system):
    cmd_root = [
        'ls /sys/devices/pci0000\:74/0000\:74\:04.0/host*/phy-*\:4/port*/end_device-*/target*/*/block/',
        'ls /sys/devices/pci0000\:74/0000\:74\:04.0/host*/phy-*\:5/port*/end_device-*/target*/*/block/'
    ]
    cmd_mini = [
        'query_system_disk kunpeng_slot_40',
        'query_system_disk kunpeng_slot_41'
    ]
    return get_cmd_by_ssh_type(cmd_root, cmd_mini, is_mini_system)


def get_query_pilot_sync_cmd(is_mini_system):
    cmd_root = "sh /opt/dfv/obs_service_layer/objectwebservice/elasticsearch/script/elasticsearch_tool.sh health"
    cmd_mini = "datapilot_tool elasticsearch_tool.sh health"
    return get_cmd_by_ssh_type(cmd_root, cmd_mini, is_mini_system)


def get_mk_part_logical_cmd(is_mini_system):
    cmd_root = 'parted /dev/{} mkpart logical "{}s" "{}s" ; echo $?'
    cmd_mini = 'parted /dev/{} mkpart logical "{}s" "{}s"'
    return get_cmd_by_ssh_type(cmd_root, cmd_mini, is_mini_system)


def get_replace_sriov_cache_cmd(is_mini_system, sandbox_open, os_node):
    password = get_root_user_pass(os_node)
    cmd_root = 'sh /opt/dsware/tools/ops_tool/replace_sriov/replace_sriov_cache.sh -d {} -o {} -n {} -a {} -t sriov'
    cmd_mini = 'replace_sriov_cache.sh -d {} -o {} -n {} -a {} -t sriov'
    if not is_mini_system and sandbox_open:
        return [
            NoNeedReturnCmd("minisystem"),
            NoLogCmd(password),
            cmd_mini
        ]
    return [get_cmd_by_ssh_type(cmd_root, cmd_mini, is_mini_system)]


def get_switch_active_cmd(is_mini_system):
    cmd_root = '/opt/dfv/oam/oam-u/ha/ha/module/hacom/tools/ha_client_tool --switchover --name=forceswap'
    cmd_mini = 'ha_client_tool --switchover --name=forceswap'
    return get_cmd_by_ssh_type(cmd_root, cmd_mini, is_mini_system)


def get_check_active_cmd(is_mini_system):
    cmd_root = '/opt/dfv/oam/oam-u/ha/ha/module/hacom/script/get_harole.sh'
    cmd_mini = 'get_harole.sh'
    return get_cmd_by_ssh_type(cmd_root, cmd_mini, is_mini_system)


def get_check_hs_status_cmd(is_mini_system):
    cmd_root = '/opt/dfv/oam/oam-u/ha/ha/module/hacom/tools/ha_client_tool --gethastatusV2'
    cmd_mini = 'ha_client_tool --gethastatusV2'
    return get_cmd_by_ssh_type(cmd_root, cmd_mini, is_mini_system)


def get_check_disk_takeover_status_cmd(is_mini_system):
    cmd_root = '/opt/fusionstorage/agent/tool/dsware_agent_tool --op query_osd_failover_status'
    cmd_mini = 'dsware_agent_tool --op query_osd_failover_status'
    return get_cmd_by_ssh_type(cmd_root, cmd_mini, is_mini_system)


def get_fan_ctrl_cmd(is_mini_system, arg):
    cmd_root = '/OSM/script/pangea_fan_ctrl.sh {}'.format(arg)
    cmd_mini = 'pangea_fan_ctrl.sh {}'.format(arg)
    return get_cmd_by_ssh_type(cmd_root, cmd_mini, is_mini_system)


def get_temp_check_cmd(is_mini_system, arg):
    cmd_root = '/OSM/script/pangea_temp_check.sh {}'.format(arg)
    cmd_mini = 'pangea_temp_check.sh {}'.format(arg)
    return get_cmd_by_ssh_type(cmd_root, cmd_mini, is_mini_system)


def get_root_user_pass(os_node):
    if os_node.getRootUser():
        return java_adapter.get_base64_encode_util().decode(os_node.getRootUser().getPassword())
    return os_node.getLoginUser().getPassword()
