#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2021-2021. All rights reserved.

"""
@version: SmartKit V200R007C00
@time: 2021/07/13
@file: ssh_info_util.py
@function:
@modify:
"""
import re
DIVIDE_REG = re.compile("^ *-+( +-+)* *$")


def parse_horizontal_table_by_chars(origin_info, chars):
    """
    第一行必须是标题行，行内按传入的chars进行切割
    :param origin_info: 原始信息 str
    :param chars: 切割字符，例如|、双空格等等
    :return: [{key: value}...]每一行数据是个map
    """
    info_list = origin_info.splitlines()

    def remove_empty_str(infos):
        return list(filter(lambda x: x and x.strip(), infos))

    def strip_list(infos):
        return [info.strip() for info in infos]

    def split_line(line):
        # 通过空格切分解析，切分后需要remove空的字符串，因为按空格切若切分空格少于
        # 实际分隔空格，则会多出空字符串
        if bool(re.compile(r"^\s+$").findall(chars)):
            return strip_list(remove_empty_str(line.split(chars)))
        return strip_list(line.split(chars))

    def get_table_titles():
        title_line = info_list[0]
        return split_line(title_line)

    def parse_field_values(titles):
        field_values = list()
        for line in info_list[1:]:
            if DIVIDE_REG.search(line):
                continue
            field_value = dict()
            fields = split_line(line)
            for index in range(min(len(fields), len(titles))):
                field_value[titles[index]] = fields[index]
            field_values.append(field_value)
        return field_values

    table_titles = get_table_titles()
    return parse_field_values(table_titles)


def find_title_line_index(origin_info_lines, title_line_keys):
    def keys_in_line(line):
        for key in title_line_keys:
            if key not in line:
                return False
        return True

    for index, line in enumerate(origin_info_lines):
        if keys_in_line(line):
            return index
    raise Exception("not find title line")
