from py.common.service.connection.redfish_connection_service import RedfishService
from py.common.adapter.java_adapter import get_product_type

ProductTypeJudgments = get_product_type()

MANAGER = "/redfish/v1/Managers"


class RedfishUtil(object):
    def __init__(self, context, logger):
        self._context = context
        self._logger = logger
        self._redfish = RedfishService(context.getBmcNode())
        self._manager_resource = self._redfish.exec_get(MANAGER)
        self._logger.info('managers resource:{}'.format(self._manager_resource))

    def get_product_unique_id(self):
        uri = self._manager_resource.get('Members')[0].get("@odata.id")
        resource = self._redfish.exec_get(uri)
        self._logger.info('resource:{}'.format(resource))
        return resource.get("Oem").values()[0].get("ProductUniqueID")

    def is_x86(self):
        return ProductTypeJudgments.HardwareType.X86.equals(
            ProductTypeJudgments.getProductTypeByUid(self.get_product_unique_id()))

    def is_kunpeng(self):
        return ProductTypeJudgments.HardwareType.KUN_PENG.equals(
            ProductTypeJudgments.getProductTypeByUid(self.get_product_unique_id()))
