/*
 * Copyright (c) Huawei Technologies Co., Ltd. 2020-2020. All rights reserved.
 */

function isAbsPath(strPath) {
  const strUpper = strPath.toUpperCase();
  return (strUpper.indexOf(":") !== -1 || strUpper.indexOf("\\\\") === 0);
}

function isAbsPathToHost(path) {
  return (path.indexOf("/") === 0);
}

function getHost(path) {
  const pos = path.indexOf("//");
  if (pos > 0) {
    const posx = path.indexOf("/", pos + 2);
    if (posx > 0)
      return path.substring(0, posx);
    else
      return path;
  }
  return path;
}

function parseXML (data) {
  if (!data) {
    return null
  }
  let xmlDoc = null;
  const trimXmlStr = data.trim();
  if (window.DOMParser) {
    const parser = new DOMParser();
    xmlDoc = parser.parseFromString(trimXmlStr, "text/xml");
  } else {
    xmlDoc = new ActiveXObject("Microsoft.XMLDOM");
    xmlDoc.async = false;
    let index = trimXmlStr.indexOf("<?xml");
    if (index !== -1) {
      index = trimXmlStr.indexOf("?>", index);
      if (index !== -1) {
        const strXML = trimXmlStr.substr(index + 2);
        xmlDoc.loadXML(strXML);
      }
    } else {
      xmlDoc.loadXML(trimXmlStr);
    }
  }
  
  return xmlDoc;
}


function getFullPath(sPath, relPath) {
  if (isAbsPath(relPath)) {
    return relPath;
  } else if (isAbsPathToHost(relPath)) {
    return getHost(sPath) + relPath;
  }

  let fullPath = sPath;
  let pathPos = 0;
  while (pathPos !== -1) {
    pathPos = relPath.indexOf("../");
    if (pathPos !== -1) {
      relPath = relPath.substring(pathPos + 3);
      fullPath = fullPath.substring(0, fullPath.length - 1);
      const pos2 = fullPath.lastIndexOf("/");
      if (pos2 !== -1) {
        fullPath = fullPath.substring(0, pos2 + 1);
      } else {
        break;
      }
    }
  }
  fullPath += relPath;
  return fullPath;
  
}

function getPath(URL) {
  // remove the search and hash string
  let m = 0;
  const m1 = URL.indexOf('#');
  const m2 = URL.indexOf('?');
  if (m1 >= 0) {
    if (m2 >= 0)
      m = (m1 > m2) ? m2 : m1;
    else m = m1;
  } else {
    if (m2 >= 0)
      m = m2;
    else m = URL.length;
  }
  URL = URL.substring(0, m);

  const sPathPos = URL.lastIndexOf("/");
  if (sPathPos > 0)
    return URL.substring(0, sPathPos + 1);
  else
    return "";
}
String.prototype.startsWith = String.prototype.startsWith || function (str) {
  const reg = new RegExp("^" + str);
  return reg.test(this);
}
String.prototype.endsWith = String.prototype.endsWith || function (str) {
  const reg = new RegExp(str + "$");
  return reg.test(this);
}

function loadScript (relativePath, scriptLoadedCallback) {
  const head = document.getElementsByTagName('head')[0];
  const script = document.createElement('script');
  script.type = 'text/javascript';

  // IE 9/10
  if (script.readyState) {
    script.onreadystatechange = function () {
      if (script.readyState === 'loaded' ||
        script.readyState === 'complete') {
        script.onreadystatechange = null;
        scriptLoadedCallback();
      }
    };
    script.onerror = scriptLoadedCallback;
  }
  // Firefox file protocol compatibility
  else if (window.navigator.product === 'Gecko' &&
  window.navigator.userAgent.indexOf('KHTML') === -1 &&
  window.navigator.userAgent.indexOf('Trident') === -1 &&
    window.location.protocol === 'file:') {
    const request = new XMLHttpRequest();
    const sCurrentPath = getPath(decodeURI(document.location.href));
    const scriptURL = getFullPath(sCurrentPath, relativePath);
    request.open('GET', encodeURI(scriptURL), true);
    request.onreadystatechange = function ()
    {
      if (request.readyState === 4 && request.status !== 0 && request.status !== 200) {
        scriptLoadedCallback();
        // Script exists. For local files: Firefox < 35 returns 0 on every AJAX call. Firefox >= 35 returns 200 on success.
      }
      
    };
    try {
      request.send(null);
    } catch (e) {
      scriptLoadedCallback();
      return;
    }
    script.onload = scriptLoadedCallback;
  } else {
    script.onload = scriptLoadedCallback;
    script.onerror = scriptLoadedCallback;
  }

  script.src = relativePath;
  head.appendChild(script);
}
