#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2021-2021. All rights reserved.

"""
@version: SmartKit V200R007C00
@time: 2021/09/25
@file: common_context_util.py
@function: 上下文工具
@modify:
"""
from py.common.adapter import java_adapter
from py.common.service import logger_factory


def set_cur_task_suggestion(context, suggestion):
    context.getCurrentTask().updateSuggestion(suggestion)


def is_proprietary_hardware(context):
    """
    判断当前所在节点硬件是否为专有硬件
    :param context: 上下文
    :return: 是否是专有硬件
    """
    return context.getClusterNode().isProprietaryHardware()


def is_hg_server(context):
    """
    判断当前所在节点是否为海光服务器
    :param context: 上下文
    :return: 是否是海光服务器
    """
    return context.getClusterNode().isHGNode()


def get_cluster_all_node_ip(context):
    return [node.getManagementIp()
            for node in context.getCluster().getClusterNodes()]


def get_product_version(context):
    """
    获取产品软件版本
    :param context: 上下文
    :return: 产品软件版本
    """
    return context.getFruDevice().getBusinessDevice() \
        .getDevNode().getProductVersion()


def get_active_fsm_node(context):
    return java_adapter.get_dev_info_util_class() \
        .getActiveFsmNode(context.getFsmNodeList())


def get_task_auth_nodes_list(context):
    node_ids = context.getNodeIdList()
    if not node_ids:
        return list()
    bmc_nodes_map = java_adapter.get_device_util_instance().getAuthDevNodeByNodeIdList(context.getFruDevice(), node_ids)
    logger_factory.create_logger(__file__).info("get task auth node_ids: {}".format(node_ids))
    return bmc_nodes_map.values()


def get_proprietary_hardware_storage_ip_list(context):
    """
    获取两大洋的存储节点列表
    :param context: 上下文
    :return: IP列表
    """
    return [node.getManagementIp() for node in context.getCluster().getClusterNodes()
            if node.isProprietaryHardware() and is_node_has_storage_role(node)]


def is_node_has_storage_role(node):
    return node.getRoles().contains('storage')


def get_current_node_management_ip(context):
    return context.getClusterNode().getManagementIp()
