#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2022-2022. All rights reserved.

"""
@version: SmartKit V200R007C00
@time: 2021/05/25
@file: disk_context_util.py
@function: 硬盘更换的上下文
@modify:
"""
from py.common.adapter import java_adapter
from py.fusion_cube.common.constant import Module


def get_disk_type(context):
    media_type = context.getData().getMediaType()
    if media_type:
        return media_type.toString()
    return None


def get_disk_capacity(context):
    return context.getData().getCapacity()


def get_disk_slot(context):
    return context.getData().getSlotNo()


def get_disk_sn(context):
    return context.getData().getEsn()


def is_normal_disk(context):
    return context.getData().getStatus() == 0


def get_disk_belong_pool_ids(context):
    return context.getData().getBelongPoolIds()


def get_belong_mgmt_ip(context):
    return context.getData().getBelongNodeIp()


def get_replace_disk_type(context):
    media_type = context.getDataAfterReplace().getMediaType()
    if media_type:
        return media_type.toString()
    return None


def get_replace_disk_capacity(context):
    return context.getDataAfterReplace().getCapacity()


def get_replace_disk_slot(context):
    return context.getDataAfterReplace().getSlotNo()


def get_replace_disk_sn(context):
    return context.getDataAfterReplace().getEsn()


def get_data_after_replace_status(context):
    return context.getDataAfterReplace().getStatus()


def get_replace_belong_mgmt_ip(context):
    return context.getDataAfterReplace().getBelongNodeIp()


def is_nvme_disk(context):
    return java_adapter.get_media_type_class().SSD_CARD.toString() == get_disk_type(
        context)


def is_meta_module(context):
    return context.getModuleId() == Module.META_DISK


def is_cache_module(context):
    return context.getModuleId() == Module.CACHE_DISK


def is_main_module(context):
    return context.getModuleId() == Module.MAIN_DISK


def is_pilot_module(context):
    return context.getModuleId() == Module.PILOT_DISK


def is_sys_module(context):
    return context.getModuleId() == Module.SYS_DISK


def is_ar_card_module(context):
    return context.getModuleId() == Module.AR_CARD


def is_cascade_board_module(context):
    return context.getModuleId() == Module.CASCADE_BOARD


def get_work_path(context):
    return context.getWorkPath()


def is_health_main_disk(context):
    return is_main_module(context) and is_normal_disk(context)


def is_disk_exist(context):
    return context.getData().getDiskExist() == 0


def is_replace_disk_exist(context):
    return context.getDataAfterReplace().getDiskExist() == 0


def get_result_key(context):
    return context.getTaskResultKey()


def get_select_key(context):
    return context.getTaskSelectKey()


def get_disk_letter(context):
    return context.getData().getDiskLetter()
