#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2021-2021. All rights reserved.

"""
@version: SmartKit V200R007C00
@time: 2021/07/13
@file: cache_disk_match_main_disk.py
@function:
@modify:
"""
from py.common.service.connection.ssh_connection_service import SshService
from py.fusion_cube.common.context import disk_context_util
from py.fusion_cube.common.service.disk_init_factory.init_service_factory import \
    DiskInitServiceFactory
from py.fusion_cube.common.service.os_util import disk_info_util
from py.common.service import logger_factory
CACHE_DISK_MATCH_MAIN_DISKS = "cache_disk_match_main_disk"


def record(context):
    """
    通过mdc 101 + 界面选择的未加入存储池的盘
    :param context:
    :return:
    """
    logger = logger_factory.create_logger(__file__)
    disk_sn = disk_context_util.get_disk_sn(context)
    service = SshService(context.getNode())
    field_values = disk_info_util.get_mdc_cmd_101_infos(service)
    main_disk_sns = list()
    for field_value in field_values:
        if field_value.get("CACHE ESN") == disk_sn:
            main_disk_sns.append(field_value.get("OSD ESN"))
    # 从框架获取用户选择的，更换前被踢出存储池的主存盘
    manual_select_disk_sns = context.getEnv().get("cacheMatchMainDiskSns")
    if manual_select_disk_sns:
        main_disk_sns.extend(manual_select_disk_sns)
    logger.error("main_disk_sns: {}".format(main_disk_sns))
    disks = DiskInitServiceFactory(context)\
        .get_pool_init_service().query_all_disks()
    match_disks = list()
    for disk in disks:
        if disk.getEsn() in main_disk_sns:
            match_disks.append(disk)
    context.getEnv()[CACHE_DISK_MATCH_MAIN_DISKS] = match_disks


def get_recorded_cache_disk_match_main_disks(context):
    """
    获取记录的缓存盘对应的主存盘
    :param context: 业务上下文
    :return: list，包含多个java BaseDisk
    """
    return context.getEnv().get(CACHE_DISK_MATCH_MAIN_DISKS)
