#  coding=UTF-8
#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2021-2021. All rights reserved.

"""
@version: SmartKit V200R007C00
@time: 2021/07/20
@file: record_cache_disk_replace_type.py
@function:
@modify:
"""
from py.fusion_cube.common.service.os_util import disk_info_util
from py.fusion_cube.common.context import disk_context_util
from py.common.service.connection.ssh_connection_service import SshService
from py.common.service import logger_factory
CACHE_DISK_REPLACE_TYPE = "CACHE_DISK_REPLACE_TYPE"


class ReplaceType(object):
    ONLINE = "ONLINE"
    OFFLINE = "OFFLINE"


def record(context):
    ssh_service = SshService(context.getNode())
    if disk_info_util.is_osd_process_online(ssh_service):
        # 默认为离线，因为如果该缓存盘没有接管业务
        # 1、故障了对应主存盘被踢掉 2、扩容场景，没有接管任何主存盘
        # mdc看不到这块盘，这种都走离线
        replace_type = ReplaceType.OFFLINE
        disk_sn = disk_context_util.get_disk_sn(context)
        cache_disk_infos = disk_info_util.get_mdc_cmd_168_cache_disk_infos(
            ssh_service)
        for info in cache_disk_infos:
            if disk_sn == info.get("CACHE ESN"):
                replace_type = _judge_replace_type(info)
                break
    else:
        replace_type = ReplaceType.OFFLINE
    logger_factory.create_logger(__file__).info(
        "CACHE_DISK_REPLACE_TYPE: {}".format(replace_type))
    context.getEnv()[CACHE_DISK_REPLACE_TYPE] = replace_type
    if not replace_type:
        raise Exception("get replace type failed")


def _judge_replace_type(info):
    if info.get("STATUS") != "OK":
        replace_type = ReplaceType.OFFLINE
    else:
        replace_type = ReplaceType.ONLINE
    return replace_type


def get_recorded_cache_disk_replace_type(context):
    """
    获取记录的缓存盘更换类型
    :param context: 业务上下文
    :return: ReplaceType
    """
    return context.getEnv().get(CACHE_DISK_REPLACE_TYPE)


def is_online_replace_type(context):
    return get_recorded_cache_disk_replace_type(context) == ReplaceType.ONLINE
