#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2021-2021. All rights reserved.

"""
@version: SmartKit V200R007C00
@time: 2021/07/22
@file: record_all_disk.py
@function:
@modify:
"""
from py.fusion_cube.common.service.os_util import disk_info_util
from py.common.service.connection.ssh_connection_service import SshService

NODE_DISKS = "NODE_DISKS"


def record(context):
    # 刷新硬盘厂商信息，因为需要登录节点查，因此只刷新待更换硬盘的，用来做更换后检查
    disk_info = context.getData()
    if not disk_info:
        return
    ssh_service = SshService(context.getNode())
    disk_info.setManufacturer(
        disk_info_util.get_disk_manufacturer(ssh_service, disk_info.getEsn()))
