#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2021-2021. All rights reserved.

"""
@version: SmartKit V200R007C00
@time: 2021/07/29
@file: record_main_disk_out_pool.py
@function: 记录主存盘是否被踢盘
@modify:
"""
from py.common.service import logger_factory
from py.common.service.connection.ssh_connection_service import SshService
from py.fusion_cube.common.context import disk_context_util
from py.fusion_cube.common.service import disk_out_storage_pool_service
from py.fusion_cube.common.service.os_util import disk_info_util

MAIN_DISK_OUT_POOL = "MAIN_DISK_OUT_POOL"


def record(context):
    ssh_service = SshService(context.getNode())
    # ESN为空时, 通过槽位号查询是否踢盘
    if not disk_context_util.get_disk_sn(context):
        disk_slot = disk_context_util.get_disk_slot(context)
        pool_ids = disk_context_util.get_disk_belong_pool_ids(context)
        node_ip = disk_context_util.get_belong_mgmt_ip(context)
        context.getEnv()[MAIN_DISK_OUT_POOL] = \
            str(disk_slot) not in disk_info_util.query_node_main_disk_slots(
                context, pool_ids, node_ip)
        log_main_disk_out_record_result(context)
        return

    out_pool_main_disks = disk_out_storage_pool_service.get_out_pool_main_disk(
        ssh_service,
        [context.getData()])
    context.getEnv()[MAIN_DISK_OUT_POOL] = bool(out_pool_main_disks)
    log_main_disk_out_record_result(context)


def is_main_disk_out_pool(context):
    return context.getEnv().get(MAIN_DISK_OUT_POOL)


def log_main_disk_out_record_result(context):
    logger_factory.create_logger(__file__).info(
        'is old main disk out pool: {}'.format(is_main_disk_out_pool(context)))
